// services/on_device_model/public/mojom/on_device_model.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/on_device_model/public/mojom/on_device_model.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('onDeviceModel.mojom');
  var file$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file.mojom', '../../../../mojo/public/mojom/base/file.mojom.js');
  }
  var file_path$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file_path.mojom', '../../../../mojo/public/mojom/base/file_path.mojom.js');
  }
  var bitmap$ =
      mojo.internal.exposeNamespace('skia.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'skia/public/mojom/bitmap.mojom', '../../../../skia/public/mojom/bitmap.mojom.js');
  }


  var Token = {};
  Token.kSystem = 0;
  Token.kModel = 1;
  Token.kUser = 2;
  Token.kEnd = 3;
  Token.kToolCall = 4;
  Token.kToolResponse = 5;
  Token.MIN_VALUE = 0;
  Token.MAX_VALUE = 5;
  Token.DEFAULT_VALUE = 3;

  Token.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
      return true;
    }
    return false;
  };

  Token.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  Token.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var Priority = {};
  Priority.kForeground = 0;
  Priority.kBackground = 1;
  Priority.MIN_VALUE = 0;
  Priority.MAX_VALUE = 1;
  Priority.DEFAULT_VALUE = 0;

  Priority.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  Priority.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  Priority.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var PerformanceClass = {};
  PerformanceClass.kError = 0;
  PerformanceClass.kGpuBlocked = 1;
  PerformanceClass.kFailedToLoadLibrary = 2;
  PerformanceClass.kVeryLow = 3;
  PerformanceClass.kLow = 4;
  PerformanceClass.kMedium = 5;
  PerformanceClass.kHigh = 6;
  PerformanceClass.kVeryHigh = 7;
  PerformanceClass.MIN_VALUE = 0;
  PerformanceClass.MAX_VALUE = 7;
  PerformanceClass.DEFAULT_VALUE = 0;

  PerformanceClass.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
      return true;
    }
    return false;
  };

  PerformanceClass.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  PerformanceClass.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var LoadModelResult = {};
  LoadModelResult.kSuccess = 0;
  LoadModelResult.kGpuBlocked = 1;
  LoadModelResult.kFailedToLoadLibrary = 2;
  LoadModelResult.MIN_VALUE = 0;
  LoadModelResult.MAX_VALUE = 2;
  LoadModelResult.DEFAULT_VALUE = 2;

  LoadModelResult.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  LoadModelResult.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  LoadModelResult.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function AdaptationAssets(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AdaptationAssets.prototype.initDefaults_ = function() {
    this.weights = null;
    this.weightsPath = null;
  };
  AdaptationAssets.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AdaptationAssets.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AdaptationAssets.weights
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file$.File, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AdaptationAssets.weightsPath
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, file_path$.FilePath, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AdaptationAssets.encodedSize = codec.kStructHeaderSize + 16;

  AdaptationAssets.decode = function(decoder) {
    var packed;
    var val = new AdaptationAssets();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.weights =
        decoder.decodeStructPointer(file$.File);
    val.weightsPath =
        decoder.decodeStructPointer(file_path$.FilePath);
    return val;
  };

  AdaptationAssets.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AdaptationAssets.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file$.File, val.weights);
    encoder.encodeStructPointer(file_path$.FilePath, val.weightsPath);
  };
  function LanguageDetectionResult(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LanguageDetectionResult.prototype.initDefaults_ = function() {
    this.code = null;
    this.reliability = 0;
  };
  LanguageDetectionResult.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LanguageDetectionResult.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LanguageDetectionResult.code
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  LanguageDetectionResult.encodedSize = codec.kStructHeaderSize + 16;

  LanguageDetectionResult.decode = function(decoder) {
    var packed;
    var val = new LanguageDetectionResult();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.code =
        decoder.decodeStruct(codec.String);
    val.reliability =
        decoder.decodeStruct(codec.Float);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  LanguageDetectionResult.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LanguageDetectionResult.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.code);
    encoder.encodeStruct(codec.Float, val.reliability);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SafetyInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SafetyInfo.prototype.initDefaults_ = function() {
    this.classScores = null;
    this.language = null;
  };
  SafetyInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SafetyInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SafetyInfo.classScores
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 4, codec.Float, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SafetyInfo.language
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, LanguageDetectionResult, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SafetyInfo.encodedSize = codec.kStructHeaderSize + 16;

  SafetyInfo.decode = function(decoder) {
    var packed;
    var val = new SafetyInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.classScores =
        decoder.decodeArrayPointer(codec.Float);
    val.language =
        decoder.decodeStructPointer(LanguageDetectionResult);
    return val;
  };

  SafetyInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SafetyInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Float, val.classScores);
    encoder.encodeStructPointer(LanguageDetectionResult, val.language);
  };
  function ResponseChunk(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseChunk.prototype.initDefaults_ = function() {
    this.text = null;
    this.safetyInfo = null;
  };
  ResponseChunk.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseChunk.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResponseChunk.text
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResponseChunk.safetyInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, SafetyInfo, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseChunk.encodedSize = codec.kStructHeaderSize + 16;

  ResponseChunk.decode = function(decoder) {
    var packed;
    var val = new ResponseChunk();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeStruct(codec.String);
    val.safetyInfo =
        decoder.decodeStructPointer(SafetyInfo);
    return val;
  };

  ResponseChunk.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseChunk.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.text);
    encoder.encodeStructPointer(SafetyInfo, val.safetyInfo);
  };
  function ResponseSummary(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseSummary.prototype.initDefaults_ = function() {
    this.safetyInfo = null;
    this.outputTokenCount = 0;
  };
  ResponseSummary.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseSummary.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResponseSummary.safetyInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, SafetyInfo, true);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ResponseSummary.encodedSize = codec.kStructHeaderSize + 16;

  ResponseSummary.decode = function(decoder) {
    var packed;
    var val = new ResponseSummary();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.safetyInfo =
        decoder.decodeStructPointer(SafetyInfo);
    val.outputTokenCount =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ResponseSummary.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseSummary.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(SafetyInfo, val.safetyInfo);
    encoder.encodeStruct(codec.Uint32, val.outputTokenCount);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function LoadAdaptationParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LoadAdaptationParams.prototype.initDefaults_ = function() {
    this.assets = null;
  };
  LoadAdaptationParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LoadAdaptationParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoadAdaptationParams.assets
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, AdaptationAssets, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LoadAdaptationParams.encodedSize = codec.kStructHeaderSize + 8;

  LoadAdaptationParams.decode = function(decoder) {
    var packed;
    var val = new LoadAdaptationParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.assets =
        decoder.decodeStructPointer(AdaptationAssets);
    return val;
  };

  LoadAdaptationParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LoadAdaptationParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(AdaptationAssets, val.assets);
  };
  function Capabilities(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Capabilities.prototype.initDefaults_ = function() {
    this.imageInput = false;
    this.audioInput = false;
  };
  Capabilities.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Capabilities.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  Capabilities.encodedSize = codec.kStructHeaderSize + 8;

  Capabilities.decode = function(decoder) {
    var packed;
    var val = new Capabilities();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.imageInput = (packed >> 0) & 1 ? true : false;
    val.audioInput = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Capabilities.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Capabilities.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.imageInput & 1) << 0
    packed |= (val.audioInput & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SessionParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SessionParams.prototype.initDefaults_ = function() {
    this.maxTokens = 0;
    this.topK = 0;
    this.capabilities = null;
    this.temperature = 0;
  };
  SessionParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SessionParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24},
      {version: 1, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SessionParams.capabilities
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, Capabilities, false);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  SessionParams.encodedSize = codec.kStructHeaderSize + 24;

  SessionParams.decode = function(decoder) {
    var packed;
    var val = new SessionParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.maxTokens =
        decoder.decodeStruct(codec.Uint32);
    if (version >= 1) {
      val.topK =
          decoder.decodeStruct(codec.Uint32);
    } else {
      val.topK = null;
    }
    val.capabilities =
        decoder.decodeStructPointer(Capabilities);
    if (version >= 1) {
      val.temperature =
          decoder.decodeStruct(codec.Float);
    } else {
      val.temperature = null;
    }
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SessionParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SessionParams.encodedSize);
    encoder.writeUint32(1);
    encoder.encodeStruct(codec.Uint32, val.maxTokens);
    encoder.encodeStruct(codec.Uint32, val.topK);
    encoder.encodeStructPointer(Capabilities, val.capabilities);
    encoder.encodeStruct(codec.Float, val.temperature);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Input(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Input.prototype.initDefaults_ = function() {
    this.pieces = null;
  };
  Input.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Input.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Input.pieces
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 16, InputPiece, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Input.encodedSize = codec.kStructHeaderSize + 8;

  Input.decode = function(decoder) {
    var packed;
    var val = new Input();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.pieces =
        decoder.decodeArrayPointer(InputPiece);
    return val;
  };

  Input.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Input.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(InputPiece, val.pieces);
  };
  function AppendOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AppendOptions.prototype.initDefaults_ = function() {
    this.input = null;
    this.maxTokens = 0;
  };
  AppendOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AppendOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AppendOptions.input
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, Input, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  AppendOptions.encodedSize = codec.kStructHeaderSize + 16;

  AppendOptions.decode = function(decoder) {
    var packed;
    var val = new AppendOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.input =
        decoder.decodeStructPointer(Input);
    val.maxTokens =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AppendOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AppendOptions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(Input, val.input);
    encoder.encodeStruct(codec.Uint32, val.maxTokens);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function GenerateOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GenerateOptions.prototype.initDefaults_ = function() {
    this.maxOutputTokens = 0;
    this.constraint = null;
  };
  GenerateOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GenerateOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16},
      {version: 2, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // version check GenerateOptions.constraint
    if (!messageValidator.isFieldInStructVersion(offset, 2))
      return validator.validationError.NONE;
    // validate GenerateOptions.constraint
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 8, ResponseConstraint, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  GenerateOptions.encodedSize = codec.kStructHeaderSize + 24;

  GenerateOptions.decode = function(decoder) {
    var packed;
    var val = new GenerateOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.maxOutputTokens =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    if (version >= 2) {
      val.constraint =
          decoder.decodeStruct(ResponseConstraint);
    } else {
      val.constraint = null;
    }
    return val;
  };

  GenerateOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GenerateOptions.encodedSize);
    encoder.writeUint32(2);
    encoder.encodeStruct(codec.Uint32, val.maxOutputTokens);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(ResponseConstraint, val.constraint);
  };
  function AudioData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioData.prototype.initDefaults_ = function() {
    this.channelCount = 0;
    this.sampleRate = 0;
    this.frameCount = 0;
    this.data = null;
  };
  AudioData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;





    // validate AudioData.data
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 4, codec.Float, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioData.encodedSize = codec.kStructHeaderSize + 24;

  AudioData.decode = function(decoder) {
    var packed;
    var val = new AudioData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.channelCount =
        decoder.decodeStruct(codec.Int32);
    val.sampleRate =
        decoder.decodeStruct(codec.Int32);
    val.frameCount =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.data =
        decoder.decodeArrayPointer(codec.Float);
    return val;
  };

  AudioData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.channelCount);
    encoder.encodeStruct(codec.Int32, val.sampleRate);
    encoder.encodeStruct(codec.Int32, val.frameCount);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(codec.Float, val.data);
  };
  function SpeechRecognitionResult(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionResult.prototype.initDefaults_ = function() {
    this.transcript = null;
    this.isFinal = false;
  };
  SpeechRecognitionResult.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionResult.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechRecognitionResult.transcript
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SpeechRecognitionResult.encodedSize = codec.kStructHeaderSize + 16;

  SpeechRecognitionResult.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionResult();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.transcript =
        decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.isFinal = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SpeechRecognitionResult.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionResult.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.transcript);
    packed = 0;
    packed |= (val.isFinal & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AsrStreamOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AsrStreamOptions.prototype.initDefaults_ = function() {
    this.sampleRateHz = 0;
  };
  AsrStreamOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AsrStreamOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  AsrStreamOptions.encodedSize = codec.kStructHeaderSize + 8;

  AsrStreamOptions.decode = function(decoder) {
    var packed;
    var val = new AsrStreamOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sampleRateHz =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AsrStreamOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AsrStreamOptions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.sampleRateHz);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function DevicePerformanceInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DevicePerformanceInfo.prototype.initDefaults_ = function() {
    this.performanceClass = 0;
    this.vramMb = 0;
  };
  DevicePerformanceInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DevicePerformanceInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DevicePerformanceInfo.performanceClass
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, PerformanceClass);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  DevicePerformanceInfo.encodedSize = codec.kStructHeaderSize + 16;

  DevicePerformanceInfo.decode = function(decoder) {
    var packed;
    var val = new DevicePerformanceInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.performanceClass =
        decoder.decodeStruct(new codec.Enum(PerformanceClass));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.vramMb =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  DevicePerformanceInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DevicePerformanceInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.performanceClass);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint64, val.vramMb);
  };
  function DeviceInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DeviceInfo.prototype.initDefaults_ = function() {
    this.vendorId = 0;
    this.deviceId = 0;
    this.driverVersion = null;
    this.supportsFp16 = false;
  };
  DeviceInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DeviceInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate DeviceInfo.driverVersion
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  DeviceInfo.encodedSize = codec.kStructHeaderSize + 24;

  DeviceInfo.decode = function(decoder) {
    var packed;
    var val = new DeviceInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.vendorId =
        decoder.decodeStruct(codec.Int32);
    val.deviceId =
        decoder.decodeStruct(codec.Int32);
    val.driverVersion =
        decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.supportsFp16 = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  DeviceInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DeviceInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.vendorId);
    encoder.encodeStruct(codec.Int32, val.deviceId);
    encoder.encodeStruct(codec.String, val.driverVersion);
    packed = 0;
    packed |= (val.supportsFp16 & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function StreamingResponder_OnResponse_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  StreamingResponder_OnResponse_Params.prototype.initDefaults_ = function() {
    this.chunk = null;
  };
  StreamingResponder_OnResponse_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  StreamingResponder_OnResponse_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StreamingResponder_OnResponse_Params.chunk
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ResponseChunk, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  StreamingResponder_OnResponse_Params.encodedSize = codec.kStructHeaderSize + 8;

  StreamingResponder_OnResponse_Params.decode = function(decoder) {
    var packed;
    var val = new StreamingResponder_OnResponse_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.chunk =
        decoder.decodeStructPointer(ResponseChunk);
    return val;
  };

  StreamingResponder_OnResponse_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(StreamingResponder_OnResponse_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ResponseChunk, val.chunk);
  };
  function StreamingResponder_OnComplete_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  StreamingResponder_OnComplete_Params.prototype.initDefaults_ = function() {
    this.summary = null;
  };
  StreamingResponder_OnComplete_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  StreamingResponder_OnComplete_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StreamingResponder_OnComplete_Params.summary
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ResponseSummary, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  StreamingResponder_OnComplete_Params.encodedSize = codec.kStructHeaderSize + 8;

  StreamingResponder_OnComplete_Params.decode = function(decoder) {
    var packed;
    var val = new StreamingResponder_OnComplete_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.summary =
        decoder.decodeStructPointer(ResponseSummary);
    return val;
  };

  StreamingResponder_OnComplete_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(StreamingResponder_OnComplete_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ResponseSummary, val.summary);
  };
  function ContextClient_OnComplete_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ContextClient_OnComplete_Params.prototype.initDefaults_ = function() {
    this.tokensProcessed = 0;
  };
  ContextClient_OnComplete_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ContextClient_OnComplete_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ContextClient_OnComplete_Params.encodedSize = codec.kStructHeaderSize + 8;

  ContextClient_OnComplete_Params.decode = function(decoder) {
    var packed;
    var val = new ContextClient_OnComplete_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.tokensProcessed =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ContextClient_OnComplete_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ContextClient_OnComplete_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.tokensProcessed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Session_Append_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Session_Append_Params.prototype.initDefaults_ = function() {
    this.options = null;
    this.client = new ContextClientPtr();
  };
  Session_Append_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Session_Append_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Session_Append_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, AppendOptions, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Session_Append_Params.client
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 8, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Session_Append_Params.encodedSize = codec.kStructHeaderSize + 16;

  Session_Append_Params.decode = function(decoder) {
    var packed;
    var val = new Session_Append_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.options =
        decoder.decodeStructPointer(AppendOptions);
    val.client =
        decoder.decodeStruct(new codec.NullableInterface(ContextClientPtr));
    return val;
  };

  Session_Append_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Session_Append_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(AppendOptions, val.options);
    encoder.encodeStruct(new codec.NullableInterface(ContextClientPtr), val.client);
  };
  function Session_Generate_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Session_Generate_Params.prototype.initDefaults_ = function() {
    this.options = null;
    this.responder = new StreamingResponderPtr();
  };
  Session_Generate_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Session_Generate_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Session_Generate_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, GenerateOptions, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Session_Generate_Params.responder
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 8, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Session_Generate_Params.encodedSize = codec.kStructHeaderSize + 16;

  Session_Generate_Params.decode = function(decoder) {
    var packed;
    var val = new Session_Generate_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.options =
        decoder.decodeStructPointer(GenerateOptions);
    val.responder =
        decoder.decodeStruct(new codec.Interface(StreamingResponderPtr));
    return val;
  };

  Session_Generate_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Session_Generate_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(GenerateOptions, val.options);
    encoder.encodeStruct(new codec.Interface(StreamingResponderPtr), val.responder);
  };
  function Session_GetSizeInTokens_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Session_GetSizeInTokens_Params.prototype.initDefaults_ = function() {
    this.input = null;
  };
  Session_GetSizeInTokens_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Session_GetSizeInTokens_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Session_GetSizeInTokens_Params.input
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, Input, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Session_GetSizeInTokens_Params.encodedSize = codec.kStructHeaderSize + 8;

  Session_GetSizeInTokens_Params.decode = function(decoder) {
    var packed;
    var val = new Session_GetSizeInTokens_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.input =
        decoder.decodeStructPointer(Input);
    return val;
  };

  Session_GetSizeInTokens_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Session_GetSizeInTokens_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(Input, val.input);
  };
  function Session_GetSizeInTokens_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Session_GetSizeInTokens_ResponseParams.prototype.initDefaults_ = function() {
    this.size = 0;
  };
  Session_GetSizeInTokens_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Session_GetSizeInTokens_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  Session_GetSizeInTokens_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  Session_GetSizeInTokens_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Session_GetSizeInTokens_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.size =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Session_GetSizeInTokens_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Session_GetSizeInTokens_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.size);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Session_Score_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Session_Score_Params.prototype.initDefaults_ = function() {
    this.text = null;
  };
  Session_Score_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Session_Score_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Session_Score_Params.text
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Session_Score_Params.encodedSize = codec.kStructHeaderSize + 8;

  Session_Score_Params.decode = function(decoder) {
    var packed;
    var val = new Session_Score_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeStruct(codec.String);
    return val;
  };

  Session_Score_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Session_Score_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.text);
  };
  function Session_Score_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Session_Score_ResponseParams.prototype.initDefaults_ = function() {
    this.probability = 0;
  };
  Session_Score_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Session_Score_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  Session_Score_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  Session_Score_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Session_Score_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.probability =
        decoder.decodeStruct(codec.Float);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Session_Score_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Session_Score_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Float, val.probability);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Session_Clone_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Session_Clone_Params.prototype.initDefaults_ = function() {
    this.session = new bindings.InterfaceRequest();
  };
  Session_Clone_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Session_Clone_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Session_Clone_Params.session
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Session_Clone_Params.encodedSize = codec.kStructHeaderSize + 8;

  Session_Clone_Params.decode = function(decoder) {
    var packed;
    var val = new Session_Clone_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.session =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Session_Clone_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Session_Clone_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.session);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Session_GetProbabilitiesBlocking_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Session_GetProbabilitiesBlocking_Params.prototype.initDefaults_ = function() {
    this.text = null;
  };
  Session_GetProbabilitiesBlocking_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Session_GetProbabilitiesBlocking_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Session_GetProbabilitiesBlocking_Params.text
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Session_GetProbabilitiesBlocking_Params.encodedSize = codec.kStructHeaderSize + 8;

  Session_GetProbabilitiesBlocking_Params.decode = function(decoder) {
    var packed;
    var val = new Session_GetProbabilitiesBlocking_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeStruct(codec.String);
    return val;
  };

  Session_GetProbabilitiesBlocking_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Session_GetProbabilitiesBlocking_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.text);
  };
  function Session_GetProbabilitiesBlocking_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Session_GetProbabilitiesBlocking_ResponseParams.prototype.initDefaults_ = function() {
    this.probabilities = null;
  };
  Session_GetProbabilitiesBlocking_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Session_GetProbabilitiesBlocking_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Session_GetProbabilitiesBlocking_ResponseParams.probabilities
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 4, codec.Float, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Session_GetProbabilitiesBlocking_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  Session_GetProbabilitiesBlocking_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Session_GetProbabilitiesBlocking_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.probabilities =
        decoder.decodeArrayPointer(codec.Float);
    return val;
  };

  Session_GetProbabilitiesBlocking_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Session_GetProbabilitiesBlocking_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Float, val.probabilities);
  };
  function Session_SetPriority_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Session_SetPriority_Params.prototype.initDefaults_ = function() {
    this.priority = 0;
  };
  Session_SetPriority_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Session_SetPriority_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Session_SetPriority_Params.priority
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, Priority);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Session_SetPriority_Params.encodedSize = codec.kStructHeaderSize + 8;

  Session_SetPriority_Params.decode = function(decoder) {
    var packed;
    var val = new Session_SetPriority_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.priority =
        decoder.decodeStruct(new codec.Enum(Priority));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Session_SetPriority_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Session_SetPriority_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.priority);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Session_AsrStream_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Session_AsrStream_Params.prototype.initDefaults_ = function() {
    this.options = null;
    this.stream = new bindings.InterfaceRequest();
    this.responder = new AsrStreamResponderPtr();
  };
  Session_AsrStream_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Session_AsrStream_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Session_AsrStream_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, AsrStreamOptions, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Session_AsrStream_Params.stream
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate Session_AsrStream_Params.responder
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 12, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Session_AsrStream_Params.encodedSize = codec.kStructHeaderSize + 24;

  Session_AsrStream_Params.decode = function(decoder) {
    var packed;
    var val = new Session_AsrStream_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.options =
        decoder.decodeStructPointer(AsrStreamOptions);
    val.stream =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.responder =
        decoder.decodeStruct(new codec.Interface(AsrStreamResponderPtr));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Session_AsrStream_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Session_AsrStream_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(AsrStreamOptions, val.options);
    encoder.encodeStruct(codec.InterfaceRequest, val.stream);
    encoder.encodeStruct(new codec.Interface(AsrStreamResponderPtr), val.responder);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function OnDeviceModel_StartSession_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OnDeviceModel_StartSession_Params.prototype.initDefaults_ = function() {
    this.session = new bindings.InterfaceRequest();
    this.params = null;
  };
  OnDeviceModel_StartSession_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OnDeviceModel_StartSession_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16},
      {version: 1, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OnDeviceModel_StartSession_Params.session
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;



    // version check OnDeviceModel_StartSession_Params.params
    if (!messageValidator.isFieldInStructVersion(offset, 1))
      return validator.validationError.NONE;
    // validate OnDeviceModel_StartSession_Params.params
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, SessionParams, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OnDeviceModel_StartSession_Params.encodedSize = codec.kStructHeaderSize + 16;

  OnDeviceModel_StartSession_Params.decode = function(decoder) {
    var packed;
    var val = new OnDeviceModel_StartSession_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.session =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    if (version >= 1) {
      val.params =
          decoder.decodeStructPointer(SessionParams);
    } else {
      val.params = null;
    }
    return val;
  };

  OnDeviceModel_StartSession_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OnDeviceModel_StartSession_Params.encodedSize);
    encoder.writeUint32(1);
    encoder.encodeStruct(codec.InterfaceRequest, val.session);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(SessionParams, val.params);
  };
  function OnDeviceModel_ClassifyTextSafety_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OnDeviceModel_ClassifyTextSafety_Params.prototype.initDefaults_ = function() {
    this.text = null;
  };
  OnDeviceModel_ClassifyTextSafety_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OnDeviceModel_ClassifyTextSafety_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OnDeviceModel_ClassifyTextSafety_Params.text
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OnDeviceModel_ClassifyTextSafety_Params.encodedSize = codec.kStructHeaderSize + 8;

  OnDeviceModel_ClassifyTextSafety_Params.decode = function(decoder) {
    var packed;
    var val = new OnDeviceModel_ClassifyTextSafety_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeStruct(codec.String);
    return val;
  };

  OnDeviceModel_ClassifyTextSafety_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OnDeviceModel_ClassifyTextSafety_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.text);
  };
  function OnDeviceModel_ClassifyTextSafety_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OnDeviceModel_ClassifyTextSafety_ResponseParams.prototype.initDefaults_ = function() {
    this.safetyInfo = null;
  };
  OnDeviceModel_ClassifyTextSafety_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OnDeviceModel_ClassifyTextSafety_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OnDeviceModel_ClassifyTextSafety_ResponseParams.safetyInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, SafetyInfo, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OnDeviceModel_ClassifyTextSafety_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  OnDeviceModel_ClassifyTextSafety_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new OnDeviceModel_ClassifyTextSafety_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.safetyInfo =
        decoder.decodeStructPointer(SafetyInfo);
    return val;
  };

  OnDeviceModel_ClassifyTextSafety_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OnDeviceModel_ClassifyTextSafety_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(SafetyInfo, val.safetyInfo);
  };
  function OnDeviceModel_DetectLanguage_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OnDeviceModel_DetectLanguage_Params.prototype.initDefaults_ = function() {
    this.text = null;
  };
  OnDeviceModel_DetectLanguage_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OnDeviceModel_DetectLanguage_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OnDeviceModel_DetectLanguage_Params.text
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OnDeviceModel_DetectLanguage_Params.encodedSize = codec.kStructHeaderSize + 8;

  OnDeviceModel_DetectLanguage_Params.decode = function(decoder) {
    var packed;
    var val = new OnDeviceModel_DetectLanguage_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeStruct(codec.String);
    return val;
  };

  OnDeviceModel_DetectLanguage_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OnDeviceModel_DetectLanguage_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.text);
  };
  function OnDeviceModel_DetectLanguage_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OnDeviceModel_DetectLanguage_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  OnDeviceModel_DetectLanguage_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OnDeviceModel_DetectLanguage_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OnDeviceModel_DetectLanguage_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, LanguageDetectionResult, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OnDeviceModel_DetectLanguage_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  OnDeviceModel_DetectLanguage_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new OnDeviceModel_DetectLanguage_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(LanguageDetectionResult);
    return val;
  };

  OnDeviceModel_DetectLanguage_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OnDeviceModel_DetectLanguage_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(LanguageDetectionResult, val.result);
  };
  function OnDeviceModel_LoadAdaptation_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OnDeviceModel_LoadAdaptation_Params.prototype.initDefaults_ = function() {
    this.params = null;
    this.model = new bindings.InterfaceRequest();
  };
  OnDeviceModel_LoadAdaptation_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OnDeviceModel_LoadAdaptation_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OnDeviceModel_LoadAdaptation_Params.params
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, LoadAdaptationParams, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OnDeviceModel_LoadAdaptation_Params.model
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OnDeviceModel_LoadAdaptation_Params.encodedSize = codec.kStructHeaderSize + 16;

  OnDeviceModel_LoadAdaptation_Params.decode = function(decoder) {
    var packed;
    var val = new OnDeviceModel_LoadAdaptation_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.params =
        decoder.decodeStructPointer(LoadAdaptationParams);
    val.model =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  OnDeviceModel_LoadAdaptation_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OnDeviceModel_LoadAdaptation_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(LoadAdaptationParams, val.params);
    encoder.encodeStruct(codec.InterfaceRequest, val.model);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function OnDeviceModel_LoadAdaptation_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OnDeviceModel_LoadAdaptation_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  OnDeviceModel_LoadAdaptation_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OnDeviceModel_LoadAdaptation_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OnDeviceModel_LoadAdaptation_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, LoadModelResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OnDeviceModel_LoadAdaptation_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  OnDeviceModel_LoadAdaptation_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new OnDeviceModel_LoadAdaptation_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(LoadModelResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  OnDeviceModel_LoadAdaptation_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OnDeviceModel_LoadAdaptation_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function TextSafetySession_ClassifyTextSafety_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TextSafetySession_ClassifyTextSafety_Params.prototype.initDefaults_ = function() {
    this.text = null;
  };
  TextSafetySession_ClassifyTextSafety_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TextSafetySession_ClassifyTextSafety_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextSafetySession_ClassifyTextSafety_Params.text
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TextSafetySession_ClassifyTextSafety_Params.encodedSize = codec.kStructHeaderSize + 8;

  TextSafetySession_ClassifyTextSafety_Params.decode = function(decoder) {
    var packed;
    var val = new TextSafetySession_ClassifyTextSafety_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeStruct(codec.String);
    return val;
  };

  TextSafetySession_ClassifyTextSafety_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TextSafetySession_ClassifyTextSafety_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.text);
  };
  function TextSafetySession_ClassifyTextSafety_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TextSafetySession_ClassifyTextSafety_ResponseParams.prototype.initDefaults_ = function() {
    this.safetyInfo = null;
  };
  TextSafetySession_ClassifyTextSafety_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TextSafetySession_ClassifyTextSafety_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextSafetySession_ClassifyTextSafety_ResponseParams.safetyInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, SafetyInfo, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TextSafetySession_ClassifyTextSafety_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  TextSafetySession_ClassifyTextSafety_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new TextSafetySession_ClassifyTextSafety_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.safetyInfo =
        decoder.decodeStructPointer(SafetyInfo);
    return val;
  };

  TextSafetySession_ClassifyTextSafety_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TextSafetySession_ClassifyTextSafety_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(SafetyInfo, val.safetyInfo);
  };
  function TextSafetySession_DetectLanguage_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TextSafetySession_DetectLanguage_Params.prototype.initDefaults_ = function() {
    this.text = null;
  };
  TextSafetySession_DetectLanguage_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TextSafetySession_DetectLanguage_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextSafetySession_DetectLanguage_Params.text
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TextSafetySession_DetectLanguage_Params.encodedSize = codec.kStructHeaderSize + 8;

  TextSafetySession_DetectLanguage_Params.decode = function(decoder) {
    var packed;
    var val = new TextSafetySession_DetectLanguage_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeStruct(codec.String);
    return val;
  };

  TextSafetySession_DetectLanguage_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TextSafetySession_DetectLanguage_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.text);
  };
  function TextSafetySession_DetectLanguage_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TextSafetySession_DetectLanguage_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  TextSafetySession_DetectLanguage_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TextSafetySession_DetectLanguage_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextSafetySession_DetectLanguage_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, LanguageDetectionResult, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TextSafetySession_DetectLanguage_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  TextSafetySession_DetectLanguage_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new TextSafetySession_DetectLanguage_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(LanguageDetectionResult);
    return val;
  };

  TextSafetySession_DetectLanguage_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TextSafetySession_DetectLanguage_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(LanguageDetectionResult, val.result);
  };
  function TextSafetySession_Clone_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TextSafetySession_Clone_Params.prototype.initDefaults_ = function() {
    this.session = new bindings.InterfaceRequest();
  };
  TextSafetySession_Clone_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TextSafetySession_Clone_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextSafetySession_Clone_Params.session
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TextSafetySession_Clone_Params.encodedSize = codec.kStructHeaderSize + 8;

  TextSafetySession_Clone_Params.decode = function(decoder) {
    var packed;
    var val = new TextSafetySession_Clone_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.session =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  TextSafetySession_Clone_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TextSafetySession_Clone_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.session);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function TextSafetyModel_StartSession_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TextSafetyModel_StartSession_Params.prototype.initDefaults_ = function() {
    this.session = new bindings.InterfaceRequest();
  };
  TextSafetyModel_StartSession_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TextSafetyModel_StartSession_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextSafetyModel_StartSession_Params.session
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TextSafetyModel_StartSession_Params.encodedSize = codec.kStructHeaderSize + 8;

  TextSafetyModel_StartSession_Params.decode = function(decoder) {
    var packed;
    var val = new TextSafetyModel_StartSession_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.session =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  TextSafetyModel_StartSession_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TextSafetyModel_StartSession_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.session);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AsrStreamResponder_OnResponse_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AsrStreamResponder_OnResponse_Params.prototype.initDefaults_ = function() {
    this.result = null;
  };
  AsrStreamResponder_OnResponse_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AsrStreamResponder_OnResponse_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AsrStreamResponder_OnResponse_Params.result
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(SpeechRecognitionResult), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AsrStreamResponder_OnResponse_Params.encodedSize = codec.kStructHeaderSize + 8;

  AsrStreamResponder_OnResponse_Params.decode = function(decoder) {
    var packed;
    var val = new AsrStreamResponder_OnResponse_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeArrayPointer(new codec.PointerTo(SpeechRecognitionResult));
    return val;
  };

  AsrStreamResponder_OnResponse_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AsrStreamResponder_OnResponse_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(SpeechRecognitionResult), val.result);
  };
  function AsrStreamInput_AddAudioChunk_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AsrStreamInput_AddAudioChunk_Params.prototype.initDefaults_ = function() {
    this.data = null;
  };
  AsrStreamInput_AddAudioChunk_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AsrStreamInput_AddAudioChunk_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AsrStreamInput_AddAudioChunk_Params.data
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, AudioData, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AsrStreamInput_AddAudioChunk_Params.encodedSize = codec.kStructHeaderSize + 8;

  AsrStreamInput_AddAudioChunk_Params.decode = function(decoder) {
    var packed;
    var val = new AsrStreamInput_AddAudioChunk_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.data =
        decoder.decodeStructPointer(AudioData);
    return val;
  };

  AsrStreamInput_AddAudioChunk_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AsrStreamInput_AddAudioChunk_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(AudioData, val.data);
  };

  function InputPiece(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  InputPiece.Tags = {
    token: 0,
    text: 1,
    bitmap: 2,
    unknownType: 3,
    audio: 4,
  };

  InputPiece.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  InputPiece.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "token",
        "text",
        "bitmap",
        "unknownType",
        "audio",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a InputPiece member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(InputPiece.prototype, "token", {
    get: function() {
      if (this.$tag != InputPiece.Tags.token) {
        throw new ReferenceError(
            "InputPiece.token is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = InputPiece.Tags.token;
      this.$data = value;
    }
  });
  Object.defineProperty(InputPiece.prototype, "text", {
    get: function() {
      if (this.$tag != InputPiece.Tags.text) {
        throw new ReferenceError(
            "InputPiece.text is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = InputPiece.Tags.text;
      this.$data = value;
    }
  });
  Object.defineProperty(InputPiece.prototype, "bitmap", {
    get: function() {
      if (this.$tag != InputPiece.Tags.bitmap) {
        throw new ReferenceError(
            "InputPiece.bitmap is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = InputPiece.Tags.bitmap;
      this.$data = value;
    }
  });
  Object.defineProperty(InputPiece.prototype, "unknownType", {
    get: function() {
      if (this.$tag != InputPiece.Tags.unknownType) {
        throw new ReferenceError(
            "InputPiece.unknownType is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = InputPiece.Tags.unknownType;
      this.$data = value;
    }
  });
  Object.defineProperty(InputPiece.prototype, "audio", {
    get: function() {
      if (this.$tag != InputPiece.Tags.audio) {
        throw new ReferenceError(
            "InputPiece.audio is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = InputPiece.Tags.audio;
      this.$data = value;
    }
  });


    InputPiece.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case InputPiece.Tags.token:
          encoder.encodeStruct(codec.Int32, val.token);
          break;
        case InputPiece.Tags.text:
          encoder.encodeStruct(codec.String, val.text);
          break;
        case InputPiece.Tags.bitmap:
          encoder.encodeStructPointer(bitmap$.BitmapWithArbitraryBpp, val.bitmap);
          break;
        case InputPiece.Tags.unknownType:
          encoder.writeUint8(val.unknownType ? 1 : 0);
          break;
        case InputPiece.Tags.audio:
          encoder.encodeStructPointer(AudioData, val.audio);
          break;
      }
      encoder.align();
    };


    InputPiece.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new InputPiece();
      var tag = decoder.readUint32();
      switch (tag) {
        case InputPiece.Tags.token:
          result.token = decoder.decodeStruct(new codec.Enum(Token));
          break;
        case InputPiece.Tags.text:
          result.text = decoder.decodeStruct(codec.String);
          break;
        case InputPiece.Tags.bitmap:
          result.bitmap = decoder.decodeStructPointer(bitmap$.BitmapWithArbitraryBpp);
          break;
        case InputPiece.Tags.unknownType:
          result.unknownType = decoder.readUint8() ? true : false;
          break;
        case InputPiece.Tags.audio:
          result.audio = decoder.decodeStructPointer(AudioData);
          break;
      }
      decoder.align();

      return result;
    };


    InputPiece.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case InputPiece.Tags.token:
          

    // validate InputPiece.token
    err = messageValidator.validateEnum(data_offset, Token);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case InputPiece.Tags.text:
          

    // validate InputPiece.text
    err = messageValidator.validateStringPointer(data_offset, false)
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case InputPiece.Tags.bitmap:
          

    // validate InputPiece.bitmap
    err = messageValidator.validateStructPointer(data_offset, bitmap$.BitmapWithArbitraryBpp, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case InputPiece.Tags.unknownType:
          

          break;
        case InputPiece.Tags.audio:
          

    // validate InputPiece.audio
    err = messageValidator.validateStructPointer(data_offset, AudioData, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  InputPiece.encodedSize = 16;

  function ResponseConstraint(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  ResponseConstraint.Tags = {
    jsonSchema: 0,
    regex: 1,
    unknownType: 2,
  };

  ResponseConstraint.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  ResponseConstraint.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "jsonSchema",
        "regex",
        "unknownType",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a ResponseConstraint member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(ResponseConstraint.prototype, "jsonSchema", {
    get: function() {
      if (this.$tag != ResponseConstraint.Tags.jsonSchema) {
        throw new ReferenceError(
            "ResponseConstraint.jsonSchema is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = ResponseConstraint.Tags.jsonSchema;
      this.$data = value;
    }
  });
  Object.defineProperty(ResponseConstraint.prototype, "regex", {
    get: function() {
      if (this.$tag != ResponseConstraint.Tags.regex) {
        throw new ReferenceError(
            "ResponseConstraint.regex is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = ResponseConstraint.Tags.regex;
      this.$data = value;
    }
  });
  Object.defineProperty(ResponseConstraint.prototype, "unknownType", {
    get: function() {
      if (this.$tag != ResponseConstraint.Tags.unknownType) {
        throw new ReferenceError(
            "ResponseConstraint.unknownType is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = ResponseConstraint.Tags.unknownType;
      this.$data = value;
    }
  });


    ResponseConstraint.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case ResponseConstraint.Tags.jsonSchema:
          encoder.encodeStruct(codec.String, val.jsonSchema);
          break;
        case ResponseConstraint.Tags.regex:
          encoder.encodeStruct(codec.String, val.regex);
          break;
        case ResponseConstraint.Tags.unknownType:
          encoder.writeUint8(val.unknownType ? 1 : 0);
          break;
      }
      encoder.align();
    };


    ResponseConstraint.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new ResponseConstraint();
      var tag = decoder.readUint32();
      switch (tag) {
        case ResponseConstraint.Tags.jsonSchema:
          result.jsonSchema = decoder.decodeStruct(codec.String);
          break;
        case ResponseConstraint.Tags.regex:
          result.regex = decoder.decodeStruct(codec.String);
          break;
        case ResponseConstraint.Tags.unknownType:
          result.unknownType = decoder.readUint8() ? true : false;
          break;
      }
      decoder.align();

      return result;
    };


    ResponseConstraint.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case ResponseConstraint.Tags.jsonSchema:
          

    // validate ResponseConstraint.jsonSchema
    err = messageValidator.validateStringPointer(data_offset, false)
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case ResponseConstraint.Tags.regex:
          

    // validate ResponseConstraint.regex
    err = messageValidator.validateStringPointer(data_offset, false)
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case ResponseConstraint.Tags.unknownType:
          

          break;
      }

      return validator.validationError.NONE;
    };

  ResponseConstraint.encodedSize = 16;
  var kStreamingResponder_OnResponse_Name = 0;
  var kStreamingResponder_OnComplete_Name = 1;

  function StreamingResponderPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(StreamingResponder,
                                                   handleOrPtrInfo);
  }

  function StreamingResponderAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        StreamingResponder, associatedInterfacePtrInfo);
  }

  StreamingResponderAssociatedPtr.prototype =
      Object.create(StreamingResponderPtr.prototype);
  StreamingResponderAssociatedPtr.prototype.constructor =
      StreamingResponderAssociatedPtr;

  function StreamingResponderProxy(receiver) {
    this.receiver_ = receiver;
  }
  StreamingResponderPtr.prototype.onResponse = function() {
    return StreamingResponderProxy.prototype.onResponse
        .apply(this.ptr.getProxy(), arguments);
  };

  StreamingResponderProxy.prototype.onResponse = function(chunk) {
    var params_ = new StreamingResponder_OnResponse_Params();
    params_.chunk = chunk;
    var builder = new codec.MessageV0Builder(
        kStreamingResponder_OnResponse_Name,
        codec.align(StreamingResponder_OnResponse_Params.encodedSize));
    builder.encodeStruct(StreamingResponder_OnResponse_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  StreamingResponderPtr.prototype.onComplete = function() {
    return StreamingResponderProxy.prototype.onComplete
        .apply(this.ptr.getProxy(), arguments);
  };

  StreamingResponderProxy.prototype.onComplete = function(summary) {
    var params_ = new StreamingResponder_OnComplete_Params();
    params_.summary = summary;
    var builder = new codec.MessageV0Builder(
        kStreamingResponder_OnComplete_Name,
        codec.align(StreamingResponder_OnComplete_Params.encodedSize));
    builder.encodeStruct(StreamingResponder_OnComplete_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function StreamingResponderStub(delegate) {
    this.delegate_ = delegate;
  }
  StreamingResponderStub.prototype.onResponse = function(chunk) {
    return this.delegate_ && this.delegate_.onResponse && this.delegate_.onResponse(chunk);
  }
  StreamingResponderStub.prototype.onComplete = function(summary) {
    return this.delegate_ && this.delegate_.onComplete && this.delegate_.onComplete(summary);
  }

  StreamingResponderStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kStreamingResponder_OnResponse_Name:
      var params = reader.decodeStruct(StreamingResponder_OnResponse_Params);
      this.onResponse(params.chunk);
      return true;
    case kStreamingResponder_OnComplete_Name:
      var params = reader.decodeStruct(StreamingResponder_OnComplete_Params);
      this.onComplete(params.summary);
      return true;
    default:
      return false;
    }
  };

  StreamingResponderStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateStreamingResponderRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kStreamingResponder_OnResponse_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = StreamingResponder_OnResponse_Params;
      break;
      case kStreamingResponder_OnComplete_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = StreamingResponder_OnComplete_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateStreamingResponderResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var StreamingResponder = {
    name: 'on_device_model.mojom.StreamingResponder',
    kVersion: 0,
    ptrClass: StreamingResponderPtr,
    proxyClass: StreamingResponderProxy,
    stubClass: StreamingResponderStub,
    validateRequest: validateStreamingResponderRequest,
    validateResponse: null,
  };
  StreamingResponderStub.prototype.validator = validateStreamingResponderRequest;
  StreamingResponderProxy.prototype.validator = null;
  var kContextClient_OnComplete_Name = 0;

  function ContextClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ContextClient,
                                                   handleOrPtrInfo);
  }

  function ContextClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ContextClient, associatedInterfacePtrInfo);
  }

  ContextClientAssociatedPtr.prototype =
      Object.create(ContextClientPtr.prototype);
  ContextClientAssociatedPtr.prototype.constructor =
      ContextClientAssociatedPtr;

  function ContextClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  ContextClientPtr.prototype.onComplete = function() {
    return ContextClientProxy.prototype.onComplete
        .apply(this.ptr.getProxy(), arguments);
  };

  ContextClientProxy.prototype.onComplete = function(tokensProcessed) {
    var params_ = new ContextClient_OnComplete_Params();
    params_.tokensProcessed = tokensProcessed;
    var builder = new codec.MessageV0Builder(
        kContextClient_OnComplete_Name,
        codec.align(ContextClient_OnComplete_Params.encodedSize));
    builder.encodeStruct(ContextClient_OnComplete_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function ContextClientStub(delegate) {
    this.delegate_ = delegate;
  }
  ContextClientStub.prototype.onComplete = function(tokensProcessed) {
    return this.delegate_ && this.delegate_.onComplete && this.delegate_.onComplete(tokensProcessed);
  }

  ContextClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kContextClient_OnComplete_Name:
      var params = reader.decodeStruct(ContextClient_OnComplete_Params);
      this.onComplete(params.tokensProcessed);
      return true;
    default:
      return false;
    }
  };

  ContextClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateContextClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kContextClient_OnComplete_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ContextClient_OnComplete_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateContextClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var ContextClient = {
    name: 'on_device_model.mojom.ContextClient',
    kVersion: 0,
    ptrClass: ContextClientPtr,
    proxyClass: ContextClientProxy,
    stubClass: ContextClientStub,
    validateRequest: validateContextClientRequest,
    validateResponse: null,
  };
  ContextClientStub.prototype.validator = validateContextClientRequest;
  ContextClientProxy.prototype.validator = null;
  var kSession_Append_Name = 6;
  var kSession_Generate_Name = 7;
  var kSession_GetSizeInTokens_Name = 5;
  var kSession_Score_Name = 3;
  var kSession_Clone_Name = 4;
  var kSession_GetProbabilitiesBlocking_Name = 8;
  var kSession_SetPriority_Name = 9;
  var kSession_AsrStream_Name = 10;

  function SessionPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(Session,
                                                   handleOrPtrInfo);
  }

  function SessionAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        Session, associatedInterfacePtrInfo);
  }

  SessionAssociatedPtr.prototype =
      Object.create(SessionPtr.prototype);
  SessionAssociatedPtr.prototype.constructor =
      SessionAssociatedPtr;

  function SessionProxy(receiver) {
    this.receiver_ = receiver;
  }
  SessionPtr.prototype.append = function() {
    return SessionProxy.prototype.append
        .apply(this.ptr.getProxy(), arguments);
  };

  SessionProxy.prototype.append = function(options, client) {
    var params_ = new Session_Append_Params();
    params_.options = options;
    params_.client = client;
    var builder = new codec.MessageV0Builder(
        kSession_Append_Name,
        codec.align(Session_Append_Params.encodedSize));
    builder.encodeStruct(Session_Append_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SessionPtr.prototype.generate = function() {
    return SessionProxy.prototype.generate
        .apply(this.ptr.getProxy(), arguments);
  };

  SessionProxy.prototype.generate = function(options, responder) {
    var params_ = new Session_Generate_Params();
    params_.options = options;
    params_.responder = responder;
    var builder = new codec.MessageV0Builder(
        kSession_Generate_Name,
        codec.align(Session_Generate_Params.encodedSize));
    builder.encodeStruct(Session_Generate_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SessionPtr.prototype.getSizeInTokens = function() {
    return SessionProxy.prototype.getSizeInTokens
        .apply(this.ptr.getProxy(), arguments);
  };

  SessionProxy.prototype.getSizeInTokens = function(input) {
    var params_ = new Session_GetSizeInTokens_Params();
    params_.input = input;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSession_GetSizeInTokens_Name,
          codec.align(Session_GetSizeInTokens_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Session_GetSizeInTokens_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Session_GetSizeInTokens_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SessionPtr.prototype.score = function() {
    return SessionProxy.prototype.score
        .apply(this.ptr.getProxy(), arguments);
  };

  SessionProxy.prototype.score = function(text) {
    var params_ = new Session_Score_Params();
    params_.text = text;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSession_Score_Name,
          codec.align(Session_Score_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Session_Score_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Session_Score_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SessionPtr.prototype.clone = function() {
    return SessionProxy.prototype.clone
        .apply(this.ptr.getProxy(), arguments);
  };

  SessionProxy.prototype.clone = function(session) {
    var params_ = new Session_Clone_Params();
    params_.session = session;
    var builder = new codec.MessageV0Builder(
        kSession_Clone_Name,
        codec.align(Session_Clone_Params.encodedSize));
    builder.encodeStruct(Session_Clone_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SessionPtr.prototype.getProbabilitiesBlocking = function() {
    return SessionProxy.prototype.getProbabilitiesBlocking
        .apply(this.ptr.getProxy(), arguments);
  };

  SessionProxy.prototype.getProbabilitiesBlocking = function(text) {
    var params_ = new Session_GetProbabilitiesBlocking_Params();
    params_.text = text;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSession_GetProbabilitiesBlocking_Name,
          codec.align(Session_GetProbabilitiesBlocking_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Session_GetProbabilitiesBlocking_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Session_GetProbabilitiesBlocking_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SessionPtr.prototype.setPriority = function() {
    return SessionProxy.prototype.setPriority
        .apply(this.ptr.getProxy(), arguments);
  };

  SessionProxy.prototype.setPriority = function(priority) {
    var params_ = new Session_SetPriority_Params();
    params_.priority = priority;
    var builder = new codec.MessageV0Builder(
        kSession_SetPriority_Name,
        codec.align(Session_SetPriority_Params.encodedSize));
    builder.encodeStruct(Session_SetPriority_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SessionPtr.prototype.asrStream = function() {
    return SessionProxy.prototype.asrStream
        .apply(this.ptr.getProxy(), arguments);
  };

  SessionProxy.prototype.asrStream = function(options, stream, responder) {
    var params_ = new Session_AsrStream_Params();
    params_.options = options;
    params_.stream = stream;
    params_.responder = responder;
    var builder = new codec.MessageV0Builder(
        kSession_AsrStream_Name,
        codec.align(Session_AsrStream_Params.encodedSize));
    builder.encodeStruct(Session_AsrStream_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function SessionStub(delegate) {
    this.delegate_ = delegate;
  }
  SessionStub.prototype.append = function(options, client) {
    return this.delegate_ && this.delegate_.append && this.delegate_.append(options, client);
  }
  SessionStub.prototype.generate = function(options, responder) {
    return this.delegate_ && this.delegate_.generate && this.delegate_.generate(options, responder);
  }
  SessionStub.prototype.getSizeInTokens = function(input) {
    return this.delegate_ && this.delegate_.getSizeInTokens && this.delegate_.getSizeInTokens(input);
  }
  SessionStub.prototype.score = function(text) {
    return this.delegate_ && this.delegate_.score && this.delegate_.score(text);
  }
  SessionStub.prototype.clone = function(session) {
    return this.delegate_ && this.delegate_.clone && this.delegate_.clone(session);
  }
  SessionStub.prototype.getProbabilitiesBlocking = function(text) {
    return this.delegate_ && this.delegate_.getProbabilitiesBlocking && this.delegate_.getProbabilitiesBlocking(text);
  }
  SessionStub.prototype.setPriority = function(priority) {
    return this.delegate_ && this.delegate_.setPriority && this.delegate_.setPriority(priority);
  }
  SessionStub.prototype.asrStream = function(options, stream, responder) {
    return this.delegate_ && this.delegate_.asrStream && this.delegate_.asrStream(options, stream, responder);
  }

  SessionStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSession_Append_Name:
      var params = reader.decodeStruct(Session_Append_Params);
      this.append(params.options, params.client);
      return true;
    case kSession_Generate_Name:
      var params = reader.decodeStruct(Session_Generate_Params);
      this.generate(params.options, params.responder);
      return true;
    case kSession_Clone_Name:
      var params = reader.decodeStruct(Session_Clone_Params);
      this.clone(params.session);
      return true;
    case kSession_SetPriority_Name:
      var params = reader.decodeStruct(Session_SetPriority_Params);
      this.setPriority(params.priority);
      return true;
    case kSession_AsrStream_Name:
      var params = reader.decodeStruct(Session_AsrStream_Params);
      this.asrStream(params.options, params.stream, params.responder);
      return true;
    default:
      return false;
    }
  };

  SessionStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSession_GetSizeInTokens_Name:
      var params = reader.decodeStruct(Session_GetSizeInTokens_Params);
      this.getSizeInTokens(params.input).then(function(response) {
        var responseParams =
            new Session_GetSizeInTokens_ResponseParams();
        responseParams.size = response.size;
        var builder = new codec.MessageV1Builder(
            kSession_GetSizeInTokens_Name,
            codec.align(Session_GetSizeInTokens_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Session_GetSizeInTokens_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSession_Score_Name:
      var params = reader.decodeStruct(Session_Score_Params);
      this.score(params.text).then(function(response) {
        var responseParams =
            new Session_Score_ResponseParams();
        responseParams.probability = response.probability;
        var builder = new codec.MessageV1Builder(
            kSession_Score_Name,
            codec.align(Session_Score_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Session_Score_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSession_GetProbabilitiesBlocking_Name:
      var params = reader.decodeStruct(Session_GetProbabilitiesBlocking_Params);
      this.getProbabilitiesBlocking(params.text).then(function(response) {
        var responseParams =
            new Session_GetProbabilitiesBlocking_ResponseParams();
        responseParams.probabilities = response.probabilities;
        var builder = new codec.MessageV1Builder(
            kSession_GetProbabilitiesBlocking_Name,
            codec.align(Session_GetProbabilitiesBlocking_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Session_GetProbabilitiesBlocking_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateSessionRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSession_Append_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Session_Append_Params;
      break;
      case kSession_Generate_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Session_Generate_Params;
      break;
      case kSession_GetSizeInTokens_Name:
        if (message.expectsResponse())
          paramsClass = Session_GetSizeInTokens_Params;
      break;
      case kSession_Score_Name:
        if (message.expectsResponse())
          paramsClass = Session_Score_Params;
      break;
      case kSession_Clone_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Session_Clone_Params;
      break;
      case kSession_GetProbabilitiesBlocking_Name:
        if (message.expectsResponse())
          paramsClass = Session_GetProbabilitiesBlocking_Params;
      break;
      case kSession_SetPriority_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Session_SetPriority_Params;
      break;
      case kSession_AsrStream_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Session_AsrStream_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSessionResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kSession_GetSizeInTokens_Name:
        if (message.isResponse())
          paramsClass = Session_GetSizeInTokens_ResponseParams;
        break;
      case kSession_Score_Name:
        if (message.isResponse())
          paramsClass = Session_Score_ResponseParams;
        break;
      case kSession_GetProbabilitiesBlocking_Name:
        if (message.isResponse())
          paramsClass = Session_GetProbabilitiesBlocking_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var Session = {
    name: 'on_device_model.mojom.Session',
    kVersion: 5,
    ptrClass: SessionPtr,
    proxyClass: SessionProxy,
    stubClass: SessionStub,
    validateRequest: validateSessionRequest,
    validateResponse: validateSessionResponse,
  };
  SessionStub.prototype.validator = validateSessionRequest;
  SessionProxy.prototype.validator = validateSessionResponse;
  var kOnDeviceModel_StartSession_Name = 0;
  var kOnDeviceModel_ClassifyTextSafety_Name = 1;
  var kOnDeviceModel_DetectLanguage_Name = 2;
  var kOnDeviceModel_LoadAdaptation_Name = 3;

  function OnDeviceModelPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(OnDeviceModel,
                                                   handleOrPtrInfo);
  }

  function OnDeviceModelAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        OnDeviceModel, associatedInterfacePtrInfo);
  }

  OnDeviceModelAssociatedPtr.prototype =
      Object.create(OnDeviceModelPtr.prototype);
  OnDeviceModelAssociatedPtr.prototype.constructor =
      OnDeviceModelAssociatedPtr;

  function OnDeviceModelProxy(receiver) {
    this.receiver_ = receiver;
  }
  OnDeviceModelPtr.prototype.startSession = function() {
    return OnDeviceModelProxy.prototype.startSession
        .apply(this.ptr.getProxy(), arguments);
  };

  OnDeviceModelProxy.prototype.startSession = function(session, params) {
    var params_ = new OnDeviceModel_StartSession_Params();
    params_.session = session;
    params_.params = params;
    var builder = new codec.MessageV0Builder(
        kOnDeviceModel_StartSession_Name,
        codec.align(OnDeviceModel_StartSession_Params.encodedSize));
    builder.encodeStruct(OnDeviceModel_StartSession_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  OnDeviceModelPtr.prototype.classifyTextSafety = function() {
    return OnDeviceModelProxy.prototype.classifyTextSafety
        .apply(this.ptr.getProxy(), arguments);
  };

  OnDeviceModelProxy.prototype.classifyTextSafety = function(text) {
    var params_ = new OnDeviceModel_ClassifyTextSafety_Params();
    params_.text = text;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kOnDeviceModel_ClassifyTextSafety_Name,
          codec.align(OnDeviceModel_ClassifyTextSafety_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(OnDeviceModel_ClassifyTextSafety_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(OnDeviceModel_ClassifyTextSafety_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  OnDeviceModelPtr.prototype.detectLanguage = function() {
    return OnDeviceModelProxy.prototype.detectLanguage
        .apply(this.ptr.getProxy(), arguments);
  };

  OnDeviceModelProxy.prototype.detectLanguage = function(text) {
    var params_ = new OnDeviceModel_DetectLanguage_Params();
    params_.text = text;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kOnDeviceModel_DetectLanguage_Name,
          codec.align(OnDeviceModel_DetectLanguage_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(OnDeviceModel_DetectLanguage_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(OnDeviceModel_DetectLanguage_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  OnDeviceModelPtr.prototype.loadAdaptation = function() {
    return OnDeviceModelProxy.prototype.loadAdaptation
        .apply(this.ptr.getProxy(), arguments);
  };

  OnDeviceModelProxy.prototype.loadAdaptation = function(params, model) {
    var params_ = new OnDeviceModel_LoadAdaptation_Params();
    params_.params = params;
    params_.model = model;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kOnDeviceModel_LoadAdaptation_Name,
          codec.align(OnDeviceModel_LoadAdaptation_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(OnDeviceModel_LoadAdaptation_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(OnDeviceModel_LoadAdaptation_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function OnDeviceModelStub(delegate) {
    this.delegate_ = delegate;
  }
  OnDeviceModelStub.prototype.startSession = function(session, params) {
    return this.delegate_ && this.delegate_.startSession && this.delegate_.startSession(session, params);
  }
  OnDeviceModelStub.prototype.classifyTextSafety = function(text) {
    return this.delegate_ && this.delegate_.classifyTextSafety && this.delegate_.classifyTextSafety(text);
  }
  OnDeviceModelStub.prototype.detectLanguage = function(text) {
    return this.delegate_ && this.delegate_.detectLanguage && this.delegate_.detectLanguage(text);
  }
  OnDeviceModelStub.prototype.loadAdaptation = function(params, model) {
    return this.delegate_ && this.delegate_.loadAdaptation && this.delegate_.loadAdaptation(params, model);
  }

  OnDeviceModelStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kOnDeviceModel_StartSession_Name:
      var params = reader.decodeStruct(OnDeviceModel_StartSession_Params);
      this.startSession(params.session, params.params);
      return true;
    default:
      return false;
    }
  };

  OnDeviceModelStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kOnDeviceModel_ClassifyTextSafety_Name:
      var params = reader.decodeStruct(OnDeviceModel_ClassifyTextSafety_Params);
      this.classifyTextSafety(params.text).then(function(response) {
        var responseParams =
            new OnDeviceModel_ClassifyTextSafety_ResponseParams();
        responseParams.safetyInfo = response.safetyInfo;
        var builder = new codec.MessageV1Builder(
            kOnDeviceModel_ClassifyTextSafety_Name,
            codec.align(OnDeviceModel_ClassifyTextSafety_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(OnDeviceModel_ClassifyTextSafety_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kOnDeviceModel_DetectLanguage_Name:
      var params = reader.decodeStruct(OnDeviceModel_DetectLanguage_Params);
      this.detectLanguage(params.text).then(function(response) {
        var responseParams =
            new OnDeviceModel_DetectLanguage_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kOnDeviceModel_DetectLanguage_Name,
            codec.align(OnDeviceModel_DetectLanguage_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(OnDeviceModel_DetectLanguage_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kOnDeviceModel_LoadAdaptation_Name:
      var params = reader.decodeStruct(OnDeviceModel_LoadAdaptation_Params);
      this.loadAdaptation(params.params, params.model).then(function(response) {
        var responseParams =
            new OnDeviceModel_LoadAdaptation_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kOnDeviceModel_LoadAdaptation_Name,
            codec.align(OnDeviceModel_LoadAdaptation_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(OnDeviceModel_LoadAdaptation_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateOnDeviceModelRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kOnDeviceModel_StartSession_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = OnDeviceModel_StartSession_Params;
      break;
      case kOnDeviceModel_ClassifyTextSafety_Name:
        if (message.expectsResponse())
          paramsClass = OnDeviceModel_ClassifyTextSafety_Params;
      break;
      case kOnDeviceModel_DetectLanguage_Name:
        if (message.expectsResponse())
          paramsClass = OnDeviceModel_DetectLanguage_Params;
      break;
      case kOnDeviceModel_LoadAdaptation_Name:
        if (message.expectsResponse())
          paramsClass = OnDeviceModel_LoadAdaptation_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateOnDeviceModelResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kOnDeviceModel_ClassifyTextSafety_Name:
        if (message.isResponse())
          paramsClass = OnDeviceModel_ClassifyTextSafety_ResponseParams;
        break;
      case kOnDeviceModel_DetectLanguage_Name:
        if (message.isResponse())
          paramsClass = OnDeviceModel_DetectLanguage_ResponseParams;
        break;
      case kOnDeviceModel_LoadAdaptation_Name:
        if (message.isResponse())
          paramsClass = OnDeviceModel_LoadAdaptation_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var OnDeviceModel = {
    name: 'on_device_model.mojom.OnDeviceModel',
    kVersion: 1,
    ptrClass: OnDeviceModelPtr,
    proxyClass: OnDeviceModelProxy,
    stubClass: OnDeviceModelStub,
    validateRequest: validateOnDeviceModelRequest,
    validateResponse: validateOnDeviceModelResponse,
  };
  OnDeviceModelStub.prototype.validator = validateOnDeviceModelRequest;
  OnDeviceModelProxy.prototype.validator = validateOnDeviceModelResponse;
  var kTextSafetySession_ClassifyTextSafety_Name = 1;
  var kTextSafetySession_DetectLanguage_Name = 2;
  var kTextSafetySession_Clone_Name = 3;

  function TextSafetySessionPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(TextSafetySession,
                                                   handleOrPtrInfo);
  }

  function TextSafetySessionAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        TextSafetySession, associatedInterfacePtrInfo);
  }

  TextSafetySessionAssociatedPtr.prototype =
      Object.create(TextSafetySessionPtr.prototype);
  TextSafetySessionAssociatedPtr.prototype.constructor =
      TextSafetySessionAssociatedPtr;

  function TextSafetySessionProxy(receiver) {
    this.receiver_ = receiver;
  }
  TextSafetySessionPtr.prototype.classifyTextSafety = function() {
    return TextSafetySessionProxy.prototype.classifyTextSafety
        .apply(this.ptr.getProxy(), arguments);
  };

  TextSafetySessionProxy.prototype.classifyTextSafety = function(text) {
    var params_ = new TextSafetySession_ClassifyTextSafety_Params();
    params_.text = text;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kTextSafetySession_ClassifyTextSafety_Name,
          codec.align(TextSafetySession_ClassifyTextSafety_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(TextSafetySession_ClassifyTextSafety_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(TextSafetySession_ClassifyTextSafety_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  TextSafetySessionPtr.prototype.detectLanguage = function() {
    return TextSafetySessionProxy.prototype.detectLanguage
        .apply(this.ptr.getProxy(), arguments);
  };

  TextSafetySessionProxy.prototype.detectLanguage = function(text) {
    var params_ = new TextSafetySession_DetectLanguage_Params();
    params_.text = text;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kTextSafetySession_DetectLanguage_Name,
          codec.align(TextSafetySession_DetectLanguage_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(TextSafetySession_DetectLanguage_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(TextSafetySession_DetectLanguage_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  TextSafetySessionPtr.prototype.clone = function() {
    return TextSafetySessionProxy.prototype.clone
        .apply(this.ptr.getProxy(), arguments);
  };

  TextSafetySessionProxy.prototype.clone = function(session) {
    var params_ = new TextSafetySession_Clone_Params();
    params_.session = session;
    var builder = new codec.MessageV0Builder(
        kTextSafetySession_Clone_Name,
        codec.align(TextSafetySession_Clone_Params.encodedSize));
    builder.encodeStruct(TextSafetySession_Clone_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function TextSafetySessionStub(delegate) {
    this.delegate_ = delegate;
  }
  TextSafetySessionStub.prototype.classifyTextSafety = function(text) {
    return this.delegate_ && this.delegate_.classifyTextSafety && this.delegate_.classifyTextSafety(text);
  }
  TextSafetySessionStub.prototype.detectLanguage = function(text) {
    return this.delegate_ && this.delegate_.detectLanguage && this.delegate_.detectLanguage(text);
  }
  TextSafetySessionStub.prototype.clone = function(session) {
    return this.delegate_ && this.delegate_.clone && this.delegate_.clone(session);
  }

  TextSafetySessionStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kTextSafetySession_Clone_Name:
      var params = reader.decodeStruct(TextSafetySession_Clone_Params);
      this.clone(params.session);
      return true;
    default:
      return false;
    }
  };

  TextSafetySessionStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kTextSafetySession_ClassifyTextSafety_Name:
      var params = reader.decodeStruct(TextSafetySession_ClassifyTextSafety_Params);
      this.classifyTextSafety(params.text).then(function(response) {
        var responseParams =
            new TextSafetySession_ClassifyTextSafety_ResponseParams();
        responseParams.safetyInfo = response.safetyInfo;
        var builder = new codec.MessageV1Builder(
            kTextSafetySession_ClassifyTextSafety_Name,
            codec.align(TextSafetySession_ClassifyTextSafety_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(TextSafetySession_ClassifyTextSafety_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kTextSafetySession_DetectLanguage_Name:
      var params = reader.decodeStruct(TextSafetySession_DetectLanguage_Params);
      this.detectLanguage(params.text).then(function(response) {
        var responseParams =
            new TextSafetySession_DetectLanguage_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kTextSafetySession_DetectLanguage_Name,
            codec.align(TextSafetySession_DetectLanguage_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(TextSafetySession_DetectLanguage_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateTextSafetySessionRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kTextSafetySession_ClassifyTextSafety_Name:
        if (message.expectsResponse())
          paramsClass = TextSafetySession_ClassifyTextSafety_Params;
      break;
      case kTextSafetySession_DetectLanguage_Name:
        if (message.expectsResponse())
          paramsClass = TextSafetySession_DetectLanguage_Params;
      break;
      case kTextSafetySession_Clone_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = TextSafetySession_Clone_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateTextSafetySessionResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kTextSafetySession_ClassifyTextSafety_Name:
        if (message.isResponse())
          paramsClass = TextSafetySession_ClassifyTextSafety_ResponseParams;
        break;
      case kTextSafetySession_DetectLanguage_Name:
        if (message.isResponse())
          paramsClass = TextSafetySession_DetectLanguage_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var TextSafetySession = {
    name: 'on_device_model.mojom.TextSafetySession',
    kVersion: 0,
    ptrClass: TextSafetySessionPtr,
    proxyClass: TextSafetySessionProxy,
    stubClass: TextSafetySessionStub,
    validateRequest: validateTextSafetySessionRequest,
    validateResponse: validateTextSafetySessionResponse,
  };
  TextSafetySessionStub.prototype.validator = validateTextSafetySessionRequest;
  TextSafetySessionProxy.prototype.validator = validateTextSafetySessionResponse;
  var kTextSafetyModel_StartSession_Name = 0;

  function TextSafetyModelPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(TextSafetyModel,
                                                   handleOrPtrInfo);
  }

  function TextSafetyModelAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        TextSafetyModel, associatedInterfacePtrInfo);
  }

  TextSafetyModelAssociatedPtr.prototype =
      Object.create(TextSafetyModelPtr.prototype);
  TextSafetyModelAssociatedPtr.prototype.constructor =
      TextSafetyModelAssociatedPtr;

  function TextSafetyModelProxy(receiver) {
    this.receiver_ = receiver;
  }
  TextSafetyModelPtr.prototype.startSession = function() {
    return TextSafetyModelProxy.prototype.startSession
        .apply(this.ptr.getProxy(), arguments);
  };

  TextSafetyModelProxy.prototype.startSession = function(session) {
    var params_ = new TextSafetyModel_StartSession_Params();
    params_.session = session;
    var builder = new codec.MessageV0Builder(
        kTextSafetyModel_StartSession_Name,
        codec.align(TextSafetyModel_StartSession_Params.encodedSize));
    builder.encodeStruct(TextSafetyModel_StartSession_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function TextSafetyModelStub(delegate) {
    this.delegate_ = delegate;
  }
  TextSafetyModelStub.prototype.startSession = function(session) {
    return this.delegate_ && this.delegate_.startSession && this.delegate_.startSession(session);
  }

  TextSafetyModelStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kTextSafetyModel_StartSession_Name:
      var params = reader.decodeStruct(TextSafetyModel_StartSession_Params);
      this.startSession(params.session);
      return true;
    default:
      return false;
    }
  };

  TextSafetyModelStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateTextSafetyModelRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kTextSafetyModel_StartSession_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = TextSafetyModel_StartSession_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateTextSafetyModelResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var TextSafetyModel = {
    name: 'on_device_model.mojom.TextSafetyModel',
    kVersion: 0,
    ptrClass: TextSafetyModelPtr,
    proxyClass: TextSafetyModelProxy,
    stubClass: TextSafetyModelStub,
    validateRequest: validateTextSafetyModelRequest,
    validateResponse: null,
  };
  TextSafetyModelStub.prototype.validator = validateTextSafetyModelRequest;
  TextSafetyModelProxy.prototype.validator = null;
  var kAsrStreamResponder_OnResponse_Name = 0;

  function AsrStreamResponderPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(AsrStreamResponder,
                                                   handleOrPtrInfo);
  }

  function AsrStreamResponderAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        AsrStreamResponder, associatedInterfacePtrInfo);
  }

  AsrStreamResponderAssociatedPtr.prototype =
      Object.create(AsrStreamResponderPtr.prototype);
  AsrStreamResponderAssociatedPtr.prototype.constructor =
      AsrStreamResponderAssociatedPtr;

  function AsrStreamResponderProxy(receiver) {
    this.receiver_ = receiver;
  }
  AsrStreamResponderPtr.prototype.onResponse = function() {
    return AsrStreamResponderProxy.prototype.onResponse
        .apply(this.ptr.getProxy(), arguments);
  };

  AsrStreamResponderProxy.prototype.onResponse = function(result) {
    var params_ = new AsrStreamResponder_OnResponse_Params();
    params_.result = result;
    var builder = new codec.MessageV0Builder(
        kAsrStreamResponder_OnResponse_Name,
        codec.align(AsrStreamResponder_OnResponse_Params.encodedSize));
    builder.encodeStruct(AsrStreamResponder_OnResponse_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function AsrStreamResponderStub(delegate) {
    this.delegate_ = delegate;
  }
  AsrStreamResponderStub.prototype.onResponse = function(result) {
    return this.delegate_ && this.delegate_.onResponse && this.delegate_.onResponse(result);
  }

  AsrStreamResponderStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAsrStreamResponder_OnResponse_Name:
      var params = reader.decodeStruct(AsrStreamResponder_OnResponse_Params);
      this.onResponse(params.result);
      return true;
    default:
      return false;
    }
  };

  AsrStreamResponderStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateAsrStreamResponderRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kAsrStreamResponder_OnResponse_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AsrStreamResponder_OnResponse_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateAsrStreamResponderResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var AsrStreamResponder = {
    name: 'on_device_model.mojom.AsrStreamResponder',
    kVersion: 0,
    ptrClass: AsrStreamResponderPtr,
    proxyClass: AsrStreamResponderProxy,
    stubClass: AsrStreamResponderStub,
    validateRequest: validateAsrStreamResponderRequest,
    validateResponse: null,
  };
  AsrStreamResponderStub.prototype.validator = validateAsrStreamResponderRequest;
  AsrStreamResponderProxy.prototype.validator = null;
  var kAsrStreamInput_AddAudioChunk_Name = 0;

  function AsrStreamInputPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(AsrStreamInput,
                                                   handleOrPtrInfo);
  }

  function AsrStreamInputAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        AsrStreamInput, associatedInterfacePtrInfo);
  }

  AsrStreamInputAssociatedPtr.prototype =
      Object.create(AsrStreamInputPtr.prototype);
  AsrStreamInputAssociatedPtr.prototype.constructor =
      AsrStreamInputAssociatedPtr;

  function AsrStreamInputProxy(receiver) {
    this.receiver_ = receiver;
  }
  AsrStreamInputPtr.prototype.addAudioChunk = function() {
    return AsrStreamInputProxy.prototype.addAudioChunk
        .apply(this.ptr.getProxy(), arguments);
  };

  AsrStreamInputProxy.prototype.addAudioChunk = function(data) {
    var params_ = new AsrStreamInput_AddAudioChunk_Params();
    params_.data = data;
    var builder = new codec.MessageV0Builder(
        kAsrStreamInput_AddAudioChunk_Name,
        codec.align(AsrStreamInput_AddAudioChunk_Params.encodedSize));
    builder.encodeStruct(AsrStreamInput_AddAudioChunk_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function AsrStreamInputStub(delegate) {
    this.delegate_ = delegate;
  }
  AsrStreamInputStub.prototype.addAudioChunk = function(data) {
    return this.delegate_ && this.delegate_.addAudioChunk && this.delegate_.addAudioChunk(data);
  }

  AsrStreamInputStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAsrStreamInput_AddAudioChunk_Name:
      var params = reader.decodeStruct(AsrStreamInput_AddAudioChunk_Params);
      this.addAudioChunk(params.data);
      return true;
    default:
      return false;
    }
  };

  AsrStreamInputStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateAsrStreamInputRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kAsrStreamInput_AddAudioChunk_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AsrStreamInput_AddAudioChunk_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateAsrStreamInputResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var AsrStreamInput = {
    name: 'on_device_model.mojom.AsrStreamInput',
    kVersion: 0,
    ptrClass: AsrStreamInputPtr,
    proxyClass: AsrStreamInputProxy,
    stubClass: AsrStreamInputStub,
    validateRequest: validateAsrStreamInputRequest,
    validateResponse: null,
  };
  AsrStreamInputStub.prototype.validator = validateAsrStreamInputRequest;
  AsrStreamInputProxy.prototype.validator = null;
  exports.Token = Token;
  exports.Priority = Priority;
  exports.PerformanceClass = PerformanceClass;
  exports.LoadModelResult = LoadModelResult;
  exports.AdaptationAssets = AdaptationAssets;
  exports.LanguageDetectionResult = LanguageDetectionResult;
  exports.SafetyInfo = SafetyInfo;
  exports.ResponseChunk = ResponseChunk;
  exports.ResponseSummary = ResponseSummary;
  exports.LoadAdaptationParams = LoadAdaptationParams;
  exports.Capabilities = Capabilities;
  exports.SessionParams = SessionParams;
  exports.Input = Input;
  exports.AppendOptions = AppendOptions;
  exports.GenerateOptions = GenerateOptions;
  exports.AudioData = AudioData;
  exports.SpeechRecognitionResult = SpeechRecognitionResult;
  exports.AsrStreamOptions = AsrStreamOptions;
  exports.DevicePerformanceInfo = DevicePerformanceInfo;
  exports.DeviceInfo = DeviceInfo;
  exports.InputPiece = InputPiece;
  exports.ResponseConstraint = ResponseConstraint;
  exports.StreamingResponder = StreamingResponder;
  exports.StreamingResponderPtr = StreamingResponderPtr;
  exports.StreamingResponderAssociatedPtr = StreamingResponderAssociatedPtr;
  exports.ContextClient = ContextClient;
  exports.ContextClientPtr = ContextClientPtr;
  exports.ContextClientAssociatedPtr = ContextClientAssociatedPtr;
  exports.Session = Session;
  exports.SessionPtr = SessionPtr;
  exports.SessionAssociatedPtr = SessionAssociatedPtr;
  exports.OnDeviceModel = OnDeviceModel;
  exports.OnDeviceModelPtr = OnDeviceModelPtr;
  exports.OnDeviceModelAssociatedPtr = OnDeviceModelAssociatedPtr;
  exports.TextSafetySession = TextSafetySession;
  exports.TextSafetySessionPtr = TextSafetySessionPtr;
  exports.TextSafetySessionAssociatedPtr = TextSafetySessionAssociatedPtr;
  exports.TextSafetyModel = TextSafetyModel;
  exports.TextSafetyModelPtr = TextSafetyModelPtr;
  exports.TextSafetyModelAssociatedPtr = TextSafetyModelAssociatedPtr;
  exports.AsrStreamResponder = AsrStreamResponder;
  exports.AsrStreamResponderPtr = AsrStreamResponderPtr;
  exports.AsrStreamResponderAssociatedPtr = AsrStreamResponderAssociatedPtr;
  exports.AsrStreamInput = AsrStreamInput;
  exports.AsrStreamInputPtr = AsrStreamInputPtr;
  exports.AsrStreamInputAssociatedPtr = AsrStreamInputAssociatedPtr;
})();