// services/on_device_model/public/mojom/on_device_model.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_ON_DEVICE_MODEL_PUBLIC_MOJOM_ON_DEVICE_MODEL_MOJOM_SHARED_H_
#define SERVICES_ON_DEVICE_MODEL_PUBLIC_MOJOM_ON_DEVICE_MODEL_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/on_device_model/public/mojom/on_device_model.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/on_device_model/public/mojom/on_device_model.mojom-data-view.h"




namespace std {

template <>
struct hash<::on_device_model::mojom::Token>
    : public mojo::internal::EnumHashImpl<::on_device_model::mojom::Token> {};

template <>
struct hash<::on_device_model::mojom::Priority>
    : public mojo::internal::EnumHashImpl<::on_device_model::mojom::Priority> {};

template <>
struct hash<::on_device_model::mojom::PerformanceClass>
    : public mojo::internal::EnumHashImpl<::on_device_model::mojom::PerformanceClass> {};

template <>
struct hash<::on_device_model::mojom::LoadModelResult>
    : public mojo::internal::EnumHashImpl<::on_device_model::mojom::LoadModelResult> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::on_device_model::mojom::Token, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::on_device_model::mojom::Token, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::on_device_model::mojom::Token>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::on_device_model::mojom::Priority, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::on_device_model::mojom::Priority, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::on_device_model::mojom::Priority>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::on_device_model::mojom::PerformanceClass, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::on_device_model::mojom::PerformanceClass, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::on_device_model::mojom::PerformanceClass>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::on_device_model::mojom::LoadModelResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::on_device_model::mojom::LoadModelResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::on_device_model::mojom::LoadModelResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::on_device_model::mojom::AdaptationAssetsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::on_device_model::mojom::AdaptationAssetsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::on_device_model::mojom::internal::AdaptationAssets_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::weights(input)) in_weights = Traits::weights(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->weights)::BaseType> weights_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
      in_weights,
      weights_fragment);

    fragment->weights.Set(
        weights_fragment.is_null() ? nullptr : weights_fragment.data());

    decltype(Traits::weights_path(input)) in_weights_path = Traits::weights_path(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->weights_path)::BaseType> weights_path_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_weights_path,
      weights_path_fragment);

    fragment->weights_path.Set(
        weights_path_fragment.is_null() ? nullptr : weights_path_fragment.data());
  }

  static bool Deserialize(::on_device_model::mojom::internal::AdaptationAssets_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::on_device_model::mojom::AdaptationAssetsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::on_device_model::mojom::LanguageDetectionResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::on_device_model::mojom::LanguageDetectionResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::on_device_model::mojom::internal::LanguageDetectionResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::code(input)) in_code = Traits::code(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->code)::BaseType> code_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_code,
      code_fragment);

    fragment->code.Set(
        code_fragment.is_null() ? nullptr : code_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->code.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null code in LanguageDetectionResult struct");

    fragment->reliability = Traits::reliability(input);
  }

  static bool Deserialize(::on_device_model::mojom::internal::LanguageDetectionResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::on_device_model::mojom::LanguageDetectionResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::on_device_model::mojom::SafetyInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::on_device_model::mojom::SafetyInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::on_device_model::mojom::internal::SafetyInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::class_scores(input)) in_class_scores = Traits::class_scores(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->class_scores)::BaseType>
        class_scores_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& class_scores_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<float>>(
      in_class_scores,
      class_scores_fragment,
      &class_scores_validate_params);

    fragment->class_scores.Set(
        class_scores_fragment.is_null() ? nullptr : class_scores_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->class_scores.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null class_scores in SafetyInfo struct");

    decltype(Traits::language(input)) in_language = Traits::language(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->language)::BaseType> language_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::on_device_model::mojom::LanguageDetectionResultDataView>(
      in_language,
      language_fragment);

    fragment->language.Set(
        language_fragment.is_null() ? nullptr : language_fragment.data());
  }

  static bool Deserialize(::on_device_model::mojom::internal::SafetyInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::on_device_model::mojom::SafetyInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::on_device_model::mojom::ResponseChunkDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::on_device_model::mojom::ResponseChunkDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::on_device_model::mojom::internal::ResponseChunk_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::text(input)) in_text = Traits::text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text)::BaseType> text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_text,
      text_fragment);

    fragment->text.Set(
        text_fragment.is_null() ? nullptr : text_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->text.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text in ResponseChunk struct");

    decltype(Traits::safety_info(input)) in_safety_info = Traits::safety_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->safety_info)::BaseType> safety_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::on_device_model::mojom::SafetyInfoDataView>(
      in_safety_info,
      safety_info_fragment);

    fragment->safety_info.Set(
        safety_info_fragment.is_null() ? nullptr : safety_info_fragment.data());
  }

  static bool Deserialize(::on_device_model::mojom::internal::ResponseChunk_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::on_device_model::mojom::ResponseChunkDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::on_device_model::mojom::ResponseSummaryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::on_device_model::mojom::ResponseSummaryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::on_device_model::mojom::internal::ResponseSummary_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::safety_info(input)) in_safety_info = Traits::safety_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->safety_info)::BaseType> safety_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::on_device_model::mojom::SafetyInfoDataView>(
      in_safety_info,
      safety_info_fragment);

    fragment->safety_info.Set(
        safety_info_fragment.is_null() ? nullptr : safety_info_fragment.data());

    fragment->output_token_count = Traits::output_token_count(input);
  }

  static bool Deserialize(::on_device_model::mojom::internal::ResponseSummary_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::on_device_model::mojom::ResponseSummaryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::on_device_model::mojom::LoadAdaptationParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::on_device_model::mojom::LoadAdaptationParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::on_device_model::mojom::internal::LoadAdaptationParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::assets(input)) in_assets = Traits::assets(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->assets)::BaseType> assets_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::on_device_model::mojom::AdaptationAssetsDataView>(
      in_assets,
      assets_fragment);

    fragment->assets.Set(
        assets_fragment.is_null() ? nullptr : assets_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->assets.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null assets in LoadAdaptationParams struct");
  }

  static bool Deserialize(::on_device_model::mojom::internal::LoadAdaptationParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::on_device_model::mojom::LoadAdaptationParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::on_device_model::mojom::CapabilitiesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::on_device_model::mojom::CapabilitiesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::on_device_model::mojom::internal::Capabilities_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->image_input = Traits::image_input(input);

    fragment->audio_input = Traits::audio_input(input);
  }

  static bool Deserialize(::on_device_model::mojom::internal::Capabilities_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::on_device_model::mojom::CapabilitiesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::on_device_model::mojom::SessionParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::on_device_model::mojom::SessionParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::on_device_model::mojom::internal::SessionParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->max_tokens = Traits::max_tokens(input);

    decltype(Traits::capabilities(input)) in_capabilities = Traits::capabilities(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->capabilities)::BaseType> capabilities_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::on_device_model::mojom::CapabilitiesDataView>(
      in_capabilities,
      capabilities_fragment);

    fragment->capabilities.Set(
        capabilities_fragment.is_null() ? nullptr : capabilities_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->capabilities.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null capabilities in SessionParams struct");

    fragment->top_k = Traits::top_k(input);

    fragment->temperature = Traits::temperature(input);
  }

  static bool Deserialize(::on_device_model::mojom::internal::SessionParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::on_device_model::mojom::SessionParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::on_device_model::mojom::InputDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::on_device_model::mojom::InputDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::on_device_model::mojom::internal::Input_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::pieces(input)) in_pieces = Traits::pieces(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pieces)::BaseType>
        pieces_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& pieces_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::on_device_model::mojom::InputPieceDataView>>(
      in_pieces,
      pieces_fragment,
      &pieces_validate_params);

    fragment->pieces.Set(
        pieces_fragment.is_null() ? nullptr : pieces_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->pieces.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null pieces in Input struct");
  }

  static bool Deserialize(::on_device_model::mojom::internal::Input_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::on_device_model::mojom::InputDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::on_device_model::mojom::AppendOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::on_device_model::mojom::AppendOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::on_device_model::mojom::internal::AppendOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input(input)) in_input = Traits::input(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input)::BaseType> input_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::on_device_model::mojom::InputDataView>(
      in_input,
      input_fragment);

    fragment->input.Set(
        input_fragment.is_null() ? nullptr : input_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input in AppendOptions struct");

    fragment->max_tokens = Traits::max_tokens(input);
  }

  static bool Deserialize(::on_device_model::mojom::internal::AppendOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::on_device_model::mojom::AppendOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::on_device_model::mojom::GenerateOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::on_device_model::mojom::GenerateOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::on_device_model::mojom::internal::GenerateOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->max_output_tokens = Traits::max_output_tokens(input);

    decltype(Traits::constraint(input)) in_constraint = Traits::constraint(input);
    mojo::internal::MessageFragment<decltype(fragment->constraint)>
        constraint_fragment(fragment.message());
    constraint_fragment.Claim(&fragment->constraint);
    
    mojo::internal::Serialize<::on_device_model::mojom::ResponseConstraintDataView>(
      in_constraint,
      constraint_fragment,
      true);
  }

  static bool Deserialize(::on_device_model::mojom::internal::GenerateOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::on_device_model::mojom::GenerateOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::on_device_model::mojom::AudioDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::on_device_model::mojom::AudioDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::on_device_model::mojom::internal::AudioData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->channel_count = Traits::channel_count(input);

    fragment->sample_rate = Traits::sample_rate(input);

    fragment->frame_count = Traits::frame_count(input);

    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->data)::BaseType>
        data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<float>>(
      in_data,
      data_fragment,
      &data_validate_params);

    fragment->data.Set(
        data_fragment.is_null() ? nullptr : data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in AudioData struct");
  }

  static bool Deserialize(::on_device_model::mojom::internal::AudioData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::on_device_model::mojom::AudioDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::on_device_model::mojom::SpeechRecognitionResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::on_device_model::mojom::SpeechRecognitionResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::on_device_model::mojom::internal::SpeechRecognitionResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::transcript(input)) in_transcript = Traits::transcript(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->transcript)::BaseType> transcript_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_transcript,
      transcript_fragment);

    fragment->transcript.Set(
        transcript_fragment.is_null() ? nullptr : transcript_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->transcript.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null transcript in SpeechRecognitionResult struct");

    fragment->is_final = Traits::is_final(input);
  }

  static bool Deserialize(::on_device_model::mojom::internal::SpeechRecognitionResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::on_device_model::mojom::SpeechRecognitionResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::on_device_model::mojom::AsrStreamOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::on_device_model::mojom::AsrStreamOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::on_device_model::mojom::internal::AsrStreamOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->sample_rate_hz = Traits::sample_rate_hz(input);
  }

  static bool Deserialize(::on_device_model::mojom::internal::AsrStreamOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::on_device_model::mojom::AsrStreamOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::on_device_model::mojom::DevicePerformanceInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::on_device_model::mojom::DevicePerformanceInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::on_device_model::mojom::internal::DevicePerformanceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::on_device_model::mojom::PerformanceClass>(
      Traits::performance_class(input),
      &fragment->performance_class);

    fragment->vram_mb = Traits::vram_mb(input);
  }

  static bool Deserialize(::on_device_model::mojom::internal::DevicePerformanceInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::on_device_model::mojom::DevicePerformanceInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::on_device_model::mojom::DeviceInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::on_device_model::mojom::DeviceInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::on_device_model::mojom::internal::DeviceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->vendor_id = Traits::vendor_id(input);

    fragment->device_id = Traits::device_id(input);

    decltype(Traits::driver_version(input)) in_driver_version = Traits::driver_version(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->driver_version)::BaseType> driver_version_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_driver_version,
      driver_version_fragment);

    fragment->driver_version.Set(
        driver_version_fragment.is_null() ? nullptr : driver_version_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->driver_version.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null driver_version in DeviceInfo struct");

    fragment->supports_fp16 = Traits::supports_fp16(input);
  }

  static bool Deserialize(::on_device_model::mojom::internal::DeviceInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::on_device_model::mojom::DeviceInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::on_device_model::mojom::InputPieceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::on_device_model::mojom::InputPieceDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::on_device_model::mojom::internal::InputPiece_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::on_device_model::mojom::InputPieceDataView::Tag::kToken: {
    decltype(Traits::token(input))
    in_token = Traits::token(input);
        
mojo::internal::Serialize<::on_device_model::mojom::Token>(
  in_token,
  &fragment->data.f_token);
    break;
  }
  case ::on_device_model::mojom::InputPieceDataView::Tag::kText: {
    decltype(Traits::text(input))
    in_text = Traits::text(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_text)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView>(
  in_text,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null text in InputPiece union");
    fragment->data.f_text.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::on_device_model::mojom::InputPieceDataView::Tag::kBitmap: {
    decltype(Traits::bitmap(input))
    in_bitmap = Traits::bitmap(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_bitmap)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::skia::mojom::BitmapWithArbitraryBppDataView>(
  in_bitmap,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null bitmap in InputPiece union");
    fragment->data.f_bitmap.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::on_device_model::mojom::InputPieceDataView::Tag::kUnknownType: {
    decltype(Traits::unknown_type(input))
    in_unknown_type = Traits::unknown_type(input);
    fragment->data.f_unknown_type = in_unknown_type;
    break;
  }
  case ::on_device_model::mojom::InputPieceDataView::Tag::kAudio: {
    decltype(Traits::audio(input))
    in_audio = Traits::audio(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_audio)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::on_device_model::mojom::AudioDataDataView>(
  in_audio,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null audio in InputPiece union");
    fragment->data.f_audio.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::on_device_model::mojom::internal::InputPiece_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::on_device_model::mojom::InputPieceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::on_device_model::mojom::ResponseConstraintDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::on_device_model::mojom::ResponseConstraintDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::on_device_model::mojom::internal::ResponseConstraint_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::on_device_model::mojom::ResponseConstraintDataView::Tag::kJsonSchema: {
    decltype(Traits::json_schema(input))
    in_json_schema = Traits::json_schema(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_json_schema)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView>(
  in_json_schema,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null json_schema in ResponseConstraint union");
    fragment->data.f_json_schema.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::on_device_model::mojom::ResponseConstraintDataView::Tag::kRegex: {
    decltype(Traits::regex(input))
    in_regex = Traits::regex(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_regex)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView>(
  in_regex,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null regex in ResponseConstraint union");
    fragment->data.f_regex.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::on_device_model::mojom::ResponseConstraintDataView::Tag::kUnknownType: {
    decltype(Traits::unknown_type(input))
    in_unknown_type = Traits::unknown_type(input);
    fragment->data.f_unknown_type = in_unknown_type;
    break;
  }
}
  }

  static bool Deserialize(::on_device_model::mojom::internal::ResponseConstraint_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::on_device_model::mojom::ResponseConstraintDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace on_device_model::mojom {

inline void AdaptationAssetsDataView::GetWeightsDataView(
    ::mojo_base::mojom::FileDataView* output) {
  auto pointer = data_->weights.Get();
  *output = ::mojo_base::mojom::FileDataView(pointer, message_);
}
inline void AdaptationAssetsDataView::GetWeightsPathDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->weights_path.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}


inline void LanguageDetectionResultDataView::GetCodeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->code.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void SafetyInfoDataView::GetClassScoresDataView(
    mojo::ArrayDataView<float>* output) {
  auto pointer = data_->class_scores.Get();
  *output = mojo::ArrayDataView<float>(pointer, message_);
}
inline void SafetyInfoDataView::GetLanguageDataView(
    LanguageDetectionResultDataView* output) {
  auto pointer = data_->language.Get();
  *output = LanguageDetectionResultDataView(pointer, message_);
}


inline void ResponseChunkDataView::GetTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ResponseChunkDataView::GetSafetyInfoDataView(
    SafetyInfoDataView* output) {
  auto pointer = data_->safety_info.Get();
  *output = SafetyInfoDataView(pointer, message_);
}


inline void ResponseSummaryDataView::GetSafetyInfoDataView(
    SafetyInfoDataView* output) {
  auto pointer = data_->safety_info.Get();
  *output = SafetyInfoDataView(pointer, message_);
}


inline void LoadAdaptationParamsDataView::GetAssetsDataView(
    AdaptationAssetsDataView* output) {
  auto pointer = data_->assets.Get();
  *output = AdaptationAssetsDataView(pointer, message_);
}




inline void SessionParamsDataView::GetCapabilitiesDataView(
    CapabilitiesDataView* output) {
  auto pointer = data_->capabilities.Get();
  *output = CapabilitiesDataView(pointer, message_);
}


inline void InputDataView::GetPiecesDataView(
    mojo::ArrayDataView<InputPieceDataView>* output) {
  auto pointer = data_->pieces.Get();
  *output = mojo::ArrayDataView<InputPieceDataView>(pointer, message_);
}


inline void AppendOptionsDataView::GetInputDataView(
    InputDataView* output) {
  auto pointer = data_->input.Get();
  *output = InputDataView(pointer, message_);
}


inline void GenerateOptionsDataView::GetConstraintDataView(
    ResponseConstraintDataView* output) {
  auto pointer = data_->header_.version >= 2
                 ? &data_->constraint : nullptr;
  *output = ResponseConstraintDataView(pointer, message_);
}


inline void AudioDataDataView::GetDataDataView(
    mojo::ArrayDataView<float>* output) {
  auto pointer = data_->data.Get();
  *output = mojo::ArrayDataView<float>(pointer, message_);
}


inline void SpeechRecognitionResultDataView::GetTranscriptDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->transcript.Get();
  *output = mojo::StringDataView(pointer, message_);
}






inline void DeviceInfoDataView::GetDriverVersionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->driver_version.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void InputPieceDataView::GetTextDataView(
    mojo::StringDataView* output) const {
  CHECK(is_text());
  *output = mojo::StringDataView(data_->data.f_text.Get(), message_);
}
inline void InputPieceDataView::GetBitmapDataView(
    ::skia::mojom::BitmapWithArbitraryBppDataView* output) const {
  CHECK(is_bitmap());
  *output = ::skia::mojom::BitmapWithArbitraryBppDataView(data_->data.f_bitmap.Get(), message_);
}
inline void InputPieceDataView::GetAudioDataView(
    AudioDataDataView* output) const {
  CHECK(is_audio());
  *output = AudioDataDataView(data_->data.f_audio.Get(), message_);
}

inline void ResponseConstraintDataView::GetJsonSchemaDataView(
    mojo::StringDataView* output) const {
  CHECK(is_json_schema());
  *output = mojo::StringDataView(data_->data.f_json_schema.Get(), message_);
}
inline void ResponseConstraintDataView::GetRegexDataView(
    mojo::StringDataView* output) const {
  CHECK(is_regex());
  *output = mojo::StringDataView(data_->data.f_regex.Get(), message_);
}


}  // on_device_model::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::on_device_model::mojom::Token> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::on_device_model::mojom::Token value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::on_device_model::mojom::Priority> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::on_device_model::mojom::Priority value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::on_device_model::mojom::PerformanceClass> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::on_device_model::mojom::PerformanceClass value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::on_device_model::mojom::LoadModelResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::on_device_model::mojom::LoadModelResult value);
};

} // namespace perfetto

#endif  // SERVICES_ON_DEVICE_MODEL_PUBLIC_MOJOM_ON_DEVICE_MODEL_MOJOM_SHARED_H_