// services/on_device_model/public/mojom/on_device_model.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('skia.mojom.BitmapWithArbitraryBpp');
goog.require('mojoBase.mojom.File');
goog.require('mojoBase.mojom.FilePath');




goog.provide('onDeviceModel.mojom.Token');
goog.provide('onDeviceModel.mojom.TokenSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
onDeviceModel.mojom.TokenSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
onDeviceModel.mojom.Token = {
  
  kSystem: 0,
  kModel: 1,
  kUser: 2,
  kEnd: 3,
  kToolCall: 4,
  kToolResponse: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};

goog.provide('onDeviceModel.mojom.Priority');
goog.provide('onDeviceModel.mojom.PrioritySpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
onDeviceModel.mojom.PrioritySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
onDeviceModel.mojom.Priority = {
  
  kForeground: 0,
  kBackground: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

goog.provide('onDeviceModel.mojom.PerformanceClass');
goog.provide('onDeviceModel.mojom.PerformanceClassSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
onDeviceModel.mojom.PerformanceClassSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
onDeviceModel.mojom.PerformanceClass = {
  
  kError: 0,
  kGpuBlocked: 1,
  kFailedToLoadLibrary: 2,
  kVeryLow: 3,
  kLow: 4,
  kMedium: 5,
  kHigh: 6,
  kVeryHigh: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};

goog.provide('onDeviceModel.mojom.LoadModelResult');
goog.provide('onDeviceModel.mojom.LoadModelResultSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
onDeviceModel.mojom.LoadModelResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
onDeviceModel.mojom.LoadModelResult = {
  
  kSuccess: 0,
  kGpuBlocked: 1,
  kFailedToLoadLibrary: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



goog.provide('onDeviceModel.mojom.StreamingResponder');
goog.provide('onDeviceModel.mojom.StreamingResponderReceiver');
goog.provide('onDeviceModel.mojom.StreamingResponderCallbackRouter');
goog.provide('onDeviceModel.mojom.StreamingResponderInterface');
goog.provide('onDeviceModel.mojom.StreamingResponderRemote');
goog.provide('onDeviceModel.mojom.StreamingResponderPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
onDeviceModel.mojom.StreamingResponderPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        onDeviceModel.mojom.StreamingResponder.$interfaceName,
        scope);
  }
};

/** @interface */
onDeviceModel.mojom.StreamingResponderInterface = class {
  
  /**
   * @param { !onDeviceModel.mojom.ResponseChunk } chunk
   */

  onResponse(chunk) {}
  
  /**
   * @param { !onDeviceModel.mojom.ResponseSummary } summary
   */

  onComplete(summary) {}
};

/**
 * @export
 * @implements { onDeviceModel.mojom.StreamingResponderInterface }
 */
onDeviceModel.mojom.StreamingResponderRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!onDeviceModel.mojom.StreamingResponderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          onDeviceModel.mojom.StreamingResponderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!onDeviceModel.mojom.StreamingResponderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !onDeviceModel.mojom.ResponseChunk } chunk
   */

  onResponse(
      chunk) {
    this.proxy.sendMessage(
        0,
        onDeviceModel.mojom.StreamingResponder_OnResponse_ParamsSpec.$,
        null,
        [
          chunk
        ],
        false);
  }

  
  /**
   * @param { !onDeviceModel.mojom.ResponseSummary } summary
   */

  onComplete(
      summary) {
    this.proxy.sendMessage(
        1,
        onDeviceModel.mojom.StreamingResponder_OnComplete_ParamsSpec.$,
        null,
        [
          summary
        ],
        false);
  }
};

/**
 * An object which receives request messages for the StreamingResponder
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
onDeviceModel.mojom.StreamingResponderReceiver = class {
  /**
   * @param {!onDeviceModel.mojom.StreamingResponderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!onDeviceModel.mojom.StreamingResponderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        onDeviceModel.mojom.StreamingResponderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!onDeviceModel.mojom.StreamingResponderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        onDeviceModel.mojom.StreamingResponder_OnResponse_ParamsSpec.$,
        null,
        impl.onResponse.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        onDeviceModel.mojom.StreamingResponder_OnComplete_ParamsSpec.$,
        null,
        impl.onComplete.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
onDeviceModel.mojom.StreamingResponder = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "on_device_model.mojom.StreamingResponder";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!onDeviceModel.mojom.StreamingResponderRemote}
   * @export
   */
  static getRemote() {
    let remote = new onDeviceModel.mojom.StreamingResponderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the StreamingResponder
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
onDeviceModel.mojom.StreamingResponderCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      onDeviceModel.mojom.StreamingResponderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!onDeviceModel.mojom.StreamingResponderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onResponse =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        onDeviceModel.mojom.StreamingResponder_OnResponse_ParamsSpec.$,
        null,
        this.onResponse.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onComplete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        onDeviceModel.mojom.StreamingResponder_OnComplete_ParamsSpec.$,
        null,
        this.onComplete.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('onDeviceModel.mojom.ContextClient');
goog.provide('onDeviceModel.mojom.ContextClientReceiver');
goog.provide('onDeviceModel.mojom.ContextClientCallbackRouter');
goog.provide('onDeviceModel.mojom.ContextClientInterface');
goog.provide('onDeviceModel.mojom.ContextClientRemote');
goog.provide('onDeviceModel.mojom.ContextClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
onDeviceModel.mojom.ContextClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        onDeviceModel.mojom.ContextClient.$interfaceName,
        scope);
  }
};

/** @interface */
onDeviceModel.mojom.ContextClientInterface = class {
  
  /**
   * @param { !number } tokensProcessed
   */

  onComplete(tokensProcessed) {}
};

/**
 * @export
 * @implements { onDeviceModel.mojom.ContextClientInterface }
 */
onDeviceModel.mojom.ContextClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!onDeviceModel.mojom.ContextClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          onDeviceModel.mojom.ContextClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!onDeviceModel.mojom.ContextClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } tokensProcessed
   */

  onComplete(
      tokensProcessed) {
    this.proxy.sendMessage(
        0,
        onDeviceModel.mojom.ContextClient_OnComplete_ParamsSpec.$,
        null,
        [
          tokensProcessed
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ContextClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
onDeviceModel.mojom.ContextClientReceiver = class {
  /**
   * @param {!onDeviceModel.mojom.ContextClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!onDeviceModel.mojom.ContextClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        onDeviceModel.mojom.ContextClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!onDeviceModel.mojom.ContextClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        onDeviceModel.mojom.ContextClient_OnComplete_ParamsSpec.$,
        null,
        impl.onComplete.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
onDeviceModel.mojom.ContextClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "on_device_model.mojom.ContextClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!onDeviceModel.mojom.ContextClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new onDeviceModel.mojom.ContextClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ContextClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
onDeviceModel.mojom.ContextClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      onDeviceModel.mojom.ContextClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!onDeviceModel.mojom.ContextClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onComplete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        onDeviceModel.mojom.ContextClient_OnComplete_ParamsSpec.$,
        null,
        this.onComplete.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('onDeviceModel.mojom.Session');
goog.provide('onDeviceModel.mojom.SessionReceiver');
goog.provide('onDeviceModel.mojom.SessionCallbackRouter');
goog.provide('onDeviceModel.mojom.SessionInterface');
goog.provide('onDeviceModel.mojom.SessionRemote');
goog.provide('onDeviceModel.mojom.SessionPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
onDeviceModel.mojom.SessionPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        onDeviceModel.mojom.Session.$interfaceName,
        scope);
  }
};

/** @interface */
onDeviceModel.mojom.SessionInterface = class {
  
  /**
   * @param { !onDeviceModel.mojom.AppendOptions } options
   * @param { ?onDeviceModel.mojom.ContextClientRemote } client
   */

  append(options, client) {}
  
  /**
   * @param { !onDeviceModel.mojom.GenerateOptions } options
   * @param { !onDeviceModel.mojom.StreamingResponderRemote } responder
   */

  generate(options, responder) {}
  
  /**
   * @param { !onDeviceModel.mojom.Input } input
   * @return {!Promise<{
        size: !number,
   *  }>}
   */

  getSizeInTokens(input) {}
  
  /**
   * @param { !string } text
   * @return {!Promise<{
        probability: !number,
   *  }>}
   */

  score(text) {}
  
  /**
   * @param { !onDeviceModel.mojom.SessionPendingReceiver } session
   */

  clone(session) {}
  
  /**
   * @param { !string } text
   * @return {!Promise<{
        probabilities: !Array<!number>,
   *  }>}
   */

  getProbabilitiesBlocking(text) {}
  
  /**
   * @param { !onDeviceModel.mojom.Priority } priority
   */

  setPriority(priority) {}
  
  /**
   * @param { !onDeviceModel.mojom.AsrStreamOptions } options
   * @param { !onDeviceModel.mojom.AsrStreamInputPendingReceiver } stream
   * @param { !onDeviceModel.mojom.AsrStreamResponderRemote } responder
   */

  asrStream(options, stream, responder) {}
};

/**
 * @export
 * @implements { onDeviceModel.mojom.SessionInterface }
 */
onDeviceModel.mojom.SessionRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!onDeviceModel.mojom.SessionPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          onDeviceModel.mojom.SessionPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!onDeviceModel.mojom.SessionPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !onDeviceModel.mojom.AppendOptions } options
   * @param { ?onDeviceModel.mojom.ContextClientRemote } client
   */

  append(
      options,
      client) {
    this.proxy.sendMessage(
        6,
        onDeviceModel.mojom.Session_Append_ParamsSpec.$,
        null,
        [
          options,
          client
        ],
        false);
  }

  
  /**
   * @param { !onDeviceModel.mojom.GenerateOptions } options
   * @param { !onDeviceModel.mojom.StreamingResponderRemote } responder
   */

  generate(
      options,
      responder) {
    this.proxy.sendMessage(
        7,
        onDeviceModel.mojom.Session_Generate_ParamsSpec.$,
        null,
        [
          options,
          responder
        ],
        false);
  }

  
  /**
   * @param { !onDeviceModel.mojom.Input } input
   * @return {!Promise<{
        size: !number,
   *  }>}
   */

  getSizeInTokens(
      input) {
    return this.proxy.sendMessage(
        5,
        onDeviceModel.mojom.Session_GetSizeInTokens_ParamsSpec.$,
        onDeviceModel.mojom.Session_GetSizeInTokens_ResponseParamsSpec.$,
        [
          input
        ],
        false);
  }

  
  /**
   * @param { !string } text
   * @return {!Promise<{
        probability: !number,
   *  }>}
   */

  score(
      text) {
    return this.proxy.sendMessage(
        3,
        onDeviceModel.mojom.Session_Score_ParamsSpec.$,
        onDeviceModel.mojom.Session_Score_ResponseParamsSpec.$,
        [
          text
        ],
        false);
  }

  
  /**
   * @param { !onDeviceModel.mojom.SessionPendingReceiver } session
   */

  clone(
      session) {
    this.proxy.sendMessage(
        4,
        onDeviceModel.mojom.Session_Clone_ParamsSpec.$,
        null,
        [
          session
        ],
        false);
  }

  
  /**
   * @param { !string } text
   * @return {!Promise<{
        probabilities: !Array<!number>,
   *  }>}
   */

  getProbabilitiesBlocking(
      text) {
    return this.proxy.sendMessage(
        8,
        onDeviceModel.mojom.Session_GetProbabilitiesBlocking_ParamsSpec.$,
        onDeviceModel.mojom.Session_GetProbabilitiesBlocking_ResponseParamsSpec.$,
        [
          text
        ],
        false);
  }

  
  /**
   * @param { !onDeviceModel.mojom.Priority } priority
   */

  setPriority(
      priority) {
    this.proxy.sendMessage(
        9,
        onDeviceModel.mojom.Session_SetPriority_ParamsSpec.$,
        null,
        [
          priority
        ],
        false);
  }

  
  /**
   * @param { !onDeviceModel.mojom.AsrStreamOptions } options
   * @param { !onDeviceModel.mojom.AsrStreamInputPendingReceiver } stream
   * @param { !onDeviceModel.mojom.AsrStreamResponderRemote } responder
   */

  asrStream(
      options,
      stream,
      responder) {
    this.proxy.sendMessage(
        10,
        onDeviceModel.mojom.Session_AsrStream_ParamsSpec.$,
        null,
        [
          options,
          stream,
          responder
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Session
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
onDeviceModel.mojom.SessionReceiver = class {
  /**
   * @param {!onDeviceModel.mojom.SessionInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!onDeviceModel.mojom.SessionRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        onDeviceModel.mojom.SessionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!onDeviceModel.mojom.SessionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        6,
        onDeviceModel.mojom.Session_Append_ParamsSpec.$,
        null,
        impl.append.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        onDeviceModel.mojom.Session_Generate_ParamsSpec.$,
        null,
        impl.generate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        onDeviceModel.mojom.Session_GetSizeInTokens_ParamsSpec.$,
        onDeviceModel.mojom.Session_GetSizeInTokens_ResponseParamsSpec.$,
        impl.getSizeInTokens.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        onDeviceModel.mojom.Session_Score_ParamsSpec.$,
        onDeviceModel.mojom.Session_Score_ResponseParamsSpec.$,
        impl.score.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        onDeviceModel.mojom.Session_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        onDeviceModel.mojom.Session_GetProbabilitiesBlocking_ParamsSpec.$,
        onDeviceModel.mojom.Session_GetProbabilitiesBlocking_ResponseParamsSpec.$,
        impl.getProbabilitiesBlocking.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        onDeviceModel.mojom.Session_SetPriority_ParamsSpec.$,
        null,
        impl.setPriority.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        onDeviceModel.mojom.Session_AsrStream_ParamsSpec.$,
        null,
        impl.asrStream.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
onDeviceModel.mojom.Session = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "on_device_model.mojom.Session";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!onDeviceModel.mojom.SessionRemote}
   * @export
   */
  static getRemote() {
    let remote = new onDeviceModel.mojom.SessionRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the Session
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
onDeviceModel.mojom.SessionCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      onDeviceModel.mojom.SessionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!onDeviceModel.mojom.SessionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.append =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        onDeviceModel.mojom.Session_Append_ParamsSpec.$,
        null,
        this.append.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.generate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        onDeviceModel.mojom.Session_Generate_ParamsSpec.$,
        null,
        this.generate.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getSizeInTokens =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        onDeviceModel.mojom.Session_GetSizeInTokens_ParamsSpec.$,
        onDeviceModel.mojom.Session_GetSizeInTokens_ResponseParamsSpec.$,
        this.getSizeInTokens.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.score =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        onDeviceModel.mojom.Session_Score_ParamsSpec.$,
        onDeviceModel.mojom.Session_Score_ResponseParamsSpec.$,
        this.score.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        onDeviceModel.mojom.Session_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getProbabilitiesBlocking =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        onDeviceModel.mojom.Session_GetProbabilitiesBlocking_ParamsSpec.$,
        onDeviceModel.mojom.Session_GetProbabilitiesBlocking_ResponseParamsSpec.$,
        this.getProbabilitiesBlocking.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPriority =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        onDeviceModel.mojom.Session_SetPriority_ParamsSpec.$,
        null,
        this.setPriority.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.asrStream =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        onDeviceModel.mojom.Session_AsrStream_ParamsSpec.$,
        null,
        this.asrStream.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('onDeviceModel.mojom.OnDeviceModel');
goog.provide('onDeviceModel.mojom.OnDeviceModelReceiver');
goog.provide('onDeviceModel.mojom.OnDeviceModelCallbackRouter');
goog.provide('onDeviceModel.mojom.OnDeviceModelInterface');
goog.provide('onDeviceModel.mojom.OnDeviceModelRemote');
goog.provide('onDeviceModel.mojom.OnDeviceModelPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
onDeviceModel.mojom.OnDeviceModelPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        onDeviceModel.mojom.OnDeviceModel.$interfaceName,
        scope);
  }
};

/** @interface */
onDeviceModel.mojom.OnDeviceModelInterface = class {
  
  /**
   * @param { !onDeviceModel.mojom.SessionPendingReceiver } session
   * @param { ?onDeviceModel.mojom.SessionParams } params
   */

  startSession(session, params) {}
  
  /**
   * @param { !string } text
   * @return {!Promise<{
        safetyInfo: ?onDeviceModel.mojom.SafetyInfo,
   *  }>}
   */

  classifyTextSafety(text) {}
  
  /**
   * @param { !string } text
   * @return {!Promise<{
        result: ?onDeviceModel.mojom.LanguageDetectionResult,
   *  }>}
   */

  detectLanguage(text) {}
  
  /**
   * @param { !onDeviceModel.mojom.LoadAdaptationParams } params
   * @param { !onDeviceModel.mojom.OnDeviceModelPendingReceiver } model
   * @return {!Promise<{
        result: !onDeviceModel.mojom.LoadModelResult,
   *  }>}
   */

  loadAdaptation(params, model) {}
};

/**
 * @export
 * @implements { onDeviceModel.mojom.OnDeviceModelInterface }
 */
onDeviceModel.mojom.OnDeviceModelRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!onDeviceModel.mojom.OnDeviceModelPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          onDeviceModel.mojom.OnDeviceModelPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!onDeviceModel.mojom.OnDeviceModelPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !onDeviceModel.mojom.SessionPendingReceiver } session
   * @param { ?onDeviceModel.mojom.SessionParams } params
   */

  startSession(
      session,
      params) {
    this.proxy.sendMessage(
        0,
        onDeviceModel.mojom.OnDeviceModel_StartSession_ParamsSpec.$,
        null,
        [
          session,
          params
        ],
        false);
  }

  
  /**
   * @param { !string } text
   * @return {!Promise<{
        safetyInfo: ?onDeviceModel.mojom.SafetyInfo,
   *  }>}
   */

  classifyTextSafety(
      text) {
    return this.proxy.sendMessage(
        1,
        onDeviceModel.mojom.OnDeviceModel_ClassifyTextSafety_ParamsSpec.$,
        onDeviceModel.mojom.OnDeviceModel_ClassifyTextSafety_ResponseParamsSpec.$,
        [
          text
        ],
        false);
  }

  
  /**
   * @param { !string } text
   * @return {!Promise<{
        result: ?onDeviceModel.mojom.LanguageDetectionResult,
   *  }>}
   */

  detectLanguage(
      text) {
    return this.proxy.sendMessage(
        2,
        onDeviceModel.mojom.OnDeviceModel_DetectLanguage_ParamsSpec.$,
        onDeviceModel.mojom.OnDeviceModel_DetectLanguage_ResponseParamsSpec.$,
        [
          text
        ],
        false);
  }

  
  /**
   * @param { !onDeviceModel.mojom.LoadAdaptationParams } params
   * @param { !onDeviceModel.mojom.OnDeviceModelPendingReceiver } model
   * @return {!Promise<{
        result: !onDeviceModel.mojom.LoadModelResult,
   *  }>}
   */

  loadAdaptation(
      params,
      model) {
    return this.proxy.sendMessage(
        3,
        onDeviceModel.mojom.OnDeviceModel_LoadAdaptation_ParamsSpec.$,
        onDeviceModel.mojom.OnDeviceModel_LoadAdaptation_ResponseParamsSpec.$,
        [
          params,
          model
        ],
        false);
  }
};

/**
 * An object which receives request messages for the OnDeviceModel
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
onDeviceModel.mojom.OnDeviceModelReceiver = class {
  /**
   * @param {!onDeviceModel.mojom.OnDeviceModelInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!onDeviceModel.mojom.OnDeviceModelRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        onDeviceModel.mojom.OnDeviceModelRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!onDeviceModel.mojom.OnDeviceModelRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        onDeviceModel.mojom.OnDeviceModel_StartSession_ParamsSpec.$,
        null,
        impl.startSession.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        onDeviceModel.mojom.OnDeviceModel_ClassifyTextSafety_ParamsSpec.$,
        onDeviceModel.mojom.OnDeviceModel_ClassifyTextSafety_ResponseParamsSpec.$,
        impl.classifyTextSafety.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        onDeviceModel.mojom.OnDeviceModel_DetectLanguage_ParamsSpec.$,
        onDeviceModel.mojom.OnDeviceModel_DetectLanguage_ResponseParamsSpec.$,
        impl.detectLanguage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        onDeviceModel.mojom.OnDeviceModel_LoadAdaptation_ParamsSpec.$,
        onDeviceModel.mojom.OnDeviceModel_LoadAdaptation_ResponseParamsSpec.$,
        impl.loadAdaptation.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
onDeviceModel.mojom.OnDeviceModel = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "on_device_model.mojom.OnDeviceModel";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!onDeviceModel.mojom.OnDeviceModelRemote}
   * @export
   */
  static getRemote() {
    let remote = new onDeviceModel.mojom.OnDeviceModelRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the OnDeviceModel
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
onDeviceModel.mojom.OnDeviceModelCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      onDeviceModel.mojom.OnDeviceModelRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!onDeviceModel.mojom.OnDeviceModelRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        onDeviceModel.mojom.OnDeviceModel_StartSession_ParamsSpec.$,
        null,
        this.startSession.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.classifyTextSafety =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        onDeviceModel.mojom.OnDeviceModel_ClassifyTextSafety_ParamsSpec.$,
        onDeviceModel.mojom.OnDeviceModel_ClassifyTextSafety_ResponseParamsSpec.$,
        this.classifyTextSafety.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.detectLanguage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        onDeviceModel.mojom.OnDeviceModel_DetectLanguage_ParamsSpec.$,
        onDeviceModel.mojom.OnDeviceModel_DetectLanguage_ResponseParamsSpec.$,
        this.detectLanguage.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadAdaptation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        onDeviceModel.mojom.OnDeviceModel_LoadAdaptation_ParamsSpec.$,
        onDeviceModel.mojom.OnDeviceModel_LoadAdaptation_ResponseParamsSpec.$,
        this.loadAdaptation.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('onDeviceModel.mojom.TextSafetySession');
goog.provide('onDeviceModel.mojom.TextSafetySessionReceiver');
goog.provide('onDeviceModel.mojom.TextSafetySessionCallbackRouter');
goog.provide('onDeviceModel.mojom.TextSafetySessionInterface');
goog.provide('onDeviceModel.mojom.TextSafetySessionRemote');
goog.provide('onDeviceModel.mojom.TextSafetySessionPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
onDeviceModel.mojom.TextSafetySessionPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        onDeviceModel.mojom.TextSafetySession.$interfaceName,
        scope);
  }
};

/** @interface */
onDeviceModel.mojom.TextSafetySessionInterface = class {
  
  /**
   * @param { !string } text
   * @return {!Promise<{
        safetyInfo: ?onDeviceModel.mojom.SafetyInfo,
   *  }>}
   */

  classifyTextSafety(text) {}
  
  /**
   * @param { !string } text
   * @return {!Promise<{
        result: ?onDeviceModel.mojom.LanguageDetectionResult,
   *  }>}
   */

  detectLanguage(text) {}
  
  /**
   * @param { !onDeviceModel.mojom.TextSafetySessionPendingReceiver } session
   */

  clone(session) {}
};

/**
 * @export
 * @implements { onDeviceModel.mojom.TextSafetySessionInterface }
 */
onDeviceModel.mojom.TextSafetySessionRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!onDeviceModel.mojom.TextSafetySessionPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          onDeviceModel.mojom.TextSafetySessionPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!onDeviceModel.mojom.TextSafetySessionPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } text
   * @return {!Promise<{
        safetyInfo: ?onDeviceModel.mojom.SafetyInfo,
   *  }>}
   */

  classifyTextSafety(
      text) {
    return this.proxy.sendMessage(
        1,
        onDeviceModel.mojom.TextSafetySession_ClassifyTextSafety_ParamsSpec.$,
        onDeviceModel.mojom.TextSafetySession_ClassifyTextSafety_ResponseParamsSpec.$,
        [
          text
        ],
        false);
  }

  
  /**
   * @param { !string } text
   * @return {!Promise<{
        result: ?onDeviceModel.mojom.LanguageDetectionResult,
   *  }>}
   */

  detectLanguage(
      text) {
    return this.proxy.sendMessage(
        2,
        onDeviceModel.mojom.TextSafetySession_DetectLanguage_ParamsSpec.$,
        onDeviceModel.mojom.TextSafetySession_DetectLanguage_ResponseParamsSpec.$,
        [
          text
        ],
        false);
  }

  
  /**
   * @param { !onDeviceModel.mojom.TextSafetySessionPendingReceiver } session
   */

  clone(
      session) {
    this.proxy.sendMessage(
        3,
        onDeviceModel.mojom.TextSafetySession_Clone_ParamsSpec.$,
        null,
        [
          session
        ],
        false);
  }
};

/**
 * An object which receives request messages for the TextSafetySession
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
onDeviceModel.mojom.TextSafetySessionReceiver = class {
  /**
   * @param {!onDeviceModel.mojom.TextSafetySessionInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!onDeviceModel.mojom.TextSafetySessionRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        onDeviceModel.mojom.TextSafetySessionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!onDeviceModel.mojom.TextSafetySessionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        1,
        onDeviceModel.mojom.TextSafetySession_ClassifyTextSafety_ParamsSpec.$,
        onDeviceModel.mojom.TextSafetySession_ClassifyTextSafety_ResponseParamsSpec.$,
        impl.classifyTextSafety.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        onDeviceModel.mojom.TextSafetySession_DetectLanguage_ParamsSpec.$,
        onDeviceModel.mojom.TextSafetySession_DetectLanguage_ResponseParamsSpec.$,
        impl.detectLanguage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        onDeviceModel.mojom.TextSafetySession_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
onDeviceModel.mojom.TextSafetySession = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "on_device_model.mojom.TextSafetySession";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!onDeviceModel.mojom.TextSafetySessionRemote}
   * @export
   */
  static getRemote() {
    let remote = new onDeviceModel.mojom.TextSafetySessionRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the TextSafetySession
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
onDeviceModel.mojom.TextSafetySessionCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      onDeviceModel.mojom.TextSafetySessionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!onDeviceModel.mojom.TextSafetySessionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.classifyTextSafety =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        onDeviceModel.mojom.TextSafetySession_ClassifyTextSafety_ParamsSpec.$,
        onDeviceModel.mojom.TextSafetySession_ClassifyTextSafety_ResponseParamsSpec.$,
        this.classifyTextSafety.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.detectLanguage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        onDeviceModel.mojom.TextSafetySession_DetectLanguage_ParamsSpec.$,
        onDeviceModel.mojom.TextSafetySession_DetectLanguage_ResponseParamsSpec.$,
        this.detectLanguage.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        onDeviceModel.mojom.TextSafetySession_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('onDeviceModel.mojom.TextSafetyModel');
goog.provide('onDeviceModel.mojom.TextSafetyModelReceiver');
goog.provide('onDeviceModel.mojom.TextSafetyModelCallbackRouter');
goog.provide('onDeviceModel.mojom.TextSafetyModelInterface');
goog.provide('onDeviceModel.mojom.TextSafetyModelRemote');
goog.provide('onDeviceModel.mojom.TextSafetyModelPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
onDeviceModel.mojom.TextSafetyModelPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        onDeviceModel.mojom.TextSafetyModel.$interfaceName,
        scope);
  }
};

/** @interface */
onDeviceModel.mojom.TextSafetyModelInterface = class {
  
  /**
   * @param { !onDeviceModel.mojom.TextSafetySessionPendingReceiver } session
   */

  startSession(session) {}
};

/**
 * @export
 * @implements { onDeviceModel.mojom.TextSafetyModelInterface }
 */
onDeviceModel.mojom.TextSafetyModelRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!onDeviceModel.mojom.TextSafetyModelPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          onDeviceModel.mojom.TextSafetyModelPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!onDeviceModel.mojom.TextSafetyModelPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !onDeviceModel.mojom.TextSafetySessionPendingReceiver } session
   */

  startSession(
      session) {
    this.proxy.sendMessage(
        0,
        onDeviceModel.mojom.TextSafetyModel_StartSession_ParamsSpec.$,
        null,
        [
          session
        ],
        false);
  }
};

/**
 * An object which receives request messages for the TextSafetyModel
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
onDeviceModel.mojom.TextSafetyModelReceiver = class {
  /**
   * @param {!onDeviceModel.mojom.TextSafetyModelInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!onDeviceModel.mojom.TextSafetyModelRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        onDeviceModel.mojom.TextSafetyModelRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!onDeviceModel.mojom.TextSafetyModelRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        onDeviceModel.mojom.TextSafetyModel_StartSession_ParamsSpec.$,
        null,
        impl.startSession.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
onDeviceModel.mojom.TextSafetyModel = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "on_device_model.mojom.TextSafetyModel";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!onDeviceModel.mojom.TextSafetyModelRemote}
   * @export
   */
  static getRemote() {
    let remote = new onDeviceModel.mojom.TextSafetyModelRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the TextSafetyModel
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
onDeviceModel.mojom.TextSafetyModelCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      onDeviceModel.mojom.TextSafetyModelRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!onDeviceModel.mojom.TextSafetyModelRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        onDeviceModel.mojom.TextSafetyModel_StartSession_ParamsSpec.$,
        null,
        this.startSession.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('onDeviceModel.mojom.AsrStreamResponder');
goog.provide('onDeviceModel.mojom.AsrStreamResponderReceiver');
goog.provide('onDeviceModel.mojom.AsrStreamResponderCallbackRouter');
goog.provide('onDeviceModel.mojom.AsrStreamResponderInterface');
goog.provide('onDeviceModel.mojom.AsrStreamResponderRemote');
goog.provide('onDeviceModel.mojom.AsrStreamResponderPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
onDeviceModel.mojom.AsrStreamResponderPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        onDeviceModel.mojom.AsrStreamResponder.$interfaceName,
        scope);
  }
};

/** @interface */
onDeviceModel.mojom.AsrStreamResponderInterface = class {
  
  /**
   * @param { !Array<!onDeviceModel.mojom.SpeechRecognitionResult> } result
   */

  onResponse(result) {}
};

/**
 * @export
 * @implements { onDeviceModel.mojom.AsrStreamResponderInterface }
 */
onDeviceModel.mojom.AsrStreamResponderRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!onDeviceModel.mojom.AsrStreamResponderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          onDeviceModel.mojom.AsrStreamResponderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!onDeviceModel.mojom.AsrStreamResponderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!onDeviceModel.mojom.SpeechRecognitionResult> } result
   */

  onResponse(
      result) {
    this.proxy.sendMessage(
        0,
        onDeviceModel.mojom.AsrStreamResponder_OnResponse_ParamsSpec.$,
        null,
        [
          result
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AsrStreamResponder
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
onDeviceModel.mojom.AsrStreamResponderReceiver = class {
  /**
   * @param {!onDeviceModel.mojom.AsrStreamResponderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!onDeviceModel.mojom.AsrStreamResponderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        onDeviceModel.mojom.AsrStreamResponderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!onDeviceModel.mojom.AsrStreamResponderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        onDeviceModel.mojom.AsrStreamResponder_OnResponse_ParamsSpec.$,
        null,
        impl.onResponse.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
onDeviceModel.mojom.AsrStreamResponder = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "on_device_model.mojom.AsrStreamResponder";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!onDeviceModel.mojom.AsrStreamResponderRemote}
   * @export
   */
  static getRemote() {
    let remote = new onDeviceModel.mojom.AsrStreamResponderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AsrStreamResponder
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
onDeviceModel.mojom.AsrStreamResponderCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      onDeviceModel.mojom.AsrStreamResponderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!onDeviceModel.mojom.AsrStreamResponderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onResponse =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        onDeviceModel.mojom.AsrStreamResponder_OnResponse_ParamsSpec.$,
        null,
        this.onResponse.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('onDeviceModel.mojom.AsrStreamInput');
goog.provide('onDeviceModel.mojom.AsrStreamInputReceiver');
goog.provide('onDeviceModel.mojom.AsrStreamInputCallbackRouter');
goog.provide('onDeviceModel.mojom.AsrStreamInputInterface');
goog.provide('onDeviceModel.mojom.AsrStreamInputRemote');
goog.provide('onDeviceModel.mojom.AsrStreamInputPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
onDeviceModel.mojom.AsrStreamInputPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        onDeviceModel.mojom.AsrStreamInput.$interfaceName,
        scope);
  }
};

/** @interface */
onDeviceModel.mojom.AsrStreamInputInterface = class {
  
  /**
   * @param { !onDeviceModel.mojom.AudioData } data
   */

  addAudioChunk(data) {}
};

/**
 * @export
 * @implements { onDeviceModel.mojom.AsrStreamInputInterface }
 */
onDeviceModel.mojom.AsrStreamInputRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!onDeviceModel.mojom.AsrStreamInputPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          onDeviceModel.mojom.AsrStreamInputPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!onDeviceModel.mojom.AsrStreamInputPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !onDeviceModel.mojom.AudioData } data
   */

  addAudioChunk(
      data) {
    this.proxy.sendMessage(
        0,
        onDeviceModel.mojom.AsrStreamInput_AddAudioChunk_ParamsSpec.$,
        null,
        [
          data
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AsrStreamInput
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
onDeviceModel.mojom.AsrStreamInputReceiver = class {
  /**
   * @param {!onDeviceModel.mojom.AsrStreamInputInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!onDeviceModel.mojom.AsrStreamInputRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        onDeviceModel.mojom.AsrStreamInputRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!onDeviceModel.mojom.AsrStreamInputRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        onDeviceModel.mojom.AsrStreamInput_AddAudioChunk_ParamsSpec.$,
        null,
        impl.addAudioChunk.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
onDeviceModel.mojom.AsrStreamInput = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "on_device_model.mojom.AsrStreamInput";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!onDeviceModel.mojom.AsrStreamInputRemote}
   * @export
   */
  static getRemote() {
    let remote = new onDeviceModel.mojom.AsrStreamInputRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AsrStreamInput
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
onDeviceModel.mojom.AsrStreamInputCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      onDeviceModel.mojom.AsrStreamInputRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!onDeviceModel.mojom.AsrStreamInputRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addAudioChunk =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        onDeviceModel.mojom.AsrStreamInput_AddAudioChunk_ParamsSpec.$,
        null,
        this.addAudioChunk.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('onDeviceModel.mojom.AdaptationAssetsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.AdaptationAssetsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.LanguageDetectionResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.LanguageDetectionResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.SafetyInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.SafetyInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.ResponseChunkSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.ResponseChunkSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.ResponseSummarySpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.ResponseSummarySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.LoadAdaptationParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.LoadAdaptationParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.CapabilitiesSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.CapabilitiesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.SessionParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.SessionParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.InputSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.InputSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.AppendOptionsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.AppendOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.GenerateOptionsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.GenerateOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.AudioDataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.AudioDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.SpeechRecognitionResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.SpeechRecognitionResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.AsrStreamOptionsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.AsrStreamOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.DevicePerformanceInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.DevicePerformanceInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.DeviceInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.DeviceInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.StreamingResponder_OnResponse_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.StreamingResponder_OnResponse_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.StreamingResponder_OnComplete_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.StreamingResponder_OnComplete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.ContextClient_OnComplete_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.ContextClient_OnComplete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.Session_Append_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.Session_Append_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.Session_Generate_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.Session_Generate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.Session_GetSizeInTokens_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.Session_GetSizeInTokens_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.Session_GetSizeInTokens_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.Session_GetSizeInTokens_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.Session_Score_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.Session_Score_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.Session_Score_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.Session_Score_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.Session_Clone_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.Session_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.Session_GetProbabilitiesBlocking_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.Session_GetProbabilitiesBlocking_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.Session_GetProbabilitiesBlocking_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.Session_GetProbabilitiesBlocking_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.Session_SetPriority_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.Session_SetPriority_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.Session_AsrStream_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.Session_AsrStream_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.OnDeviceModel_StartSession_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.OnDeviceModel_StartSession_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.OnDeviceModel_ClassifyTextSafety_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.OnDeviceModel_ClassifyTextSafety_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.OnDeviceModel_ClassifyTextSafety_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.OnDeviceModel_ClassifyTextSafety_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.OnDeviceModel_DetectLanguage_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.OnDeviceModel_DetectLanguage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.OnDeviceModel_DetectLanguage_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.OnDeviceModel_DetectLanguage_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.OnDeviceModel_LoadAdaptation_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.OnDeviceModel_LoadAdaptation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.OnDeviceModel_LoadAdaptation_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.OnDeviceModel_LoadAdaptation_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.TextSafetySession_ClassifyTextSafety_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.TextSafetySession_ClassifyTextSafety_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.TextSafetySession_ClassifyTextSafety_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.TextSafetySession_ClassifyTextSafety_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.TextSafetySession_DetectLanguage_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.TextSafetySession_DetectLanguage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.TextSafetySession_DetectLanguage_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.TextSafetySession_DetectLanguage_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.TextSafetySession_Clone_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.TextSafetySession_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.TextSafetyModel_StartSession_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.TextSafetyModel_StartSession_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.AsrStreamResponder_OnResponse_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.AsrStreamResponder_OnResponse_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.AsrStreamInput_AddAudioChunk_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.AsrStreamInput_AddAudioChunk_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.InputPieceSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
onDeviceModel.mojom.InputPieceSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.ResponseConstraintSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
onDeviceModel.mojom.ResponseConstraintSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    onDeviceModel.mojom.AdaptationAssetsSpec.$,
    'AdaptationAssets',
    [
      mojo.internal.StructField(
        'weights', 0,
        0,
        mojoBase.mojom.FileSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'weightsPath', 8,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('onDeviceModel.mojom.AdaptationAssets');

/** @record */
onDeviceModel.mojom.AdaptationAssets = class {
  constructor() {
    /** @export { (mojoBase.mojom.File|undefined) } */
    this.weights;
    /** @export { (mojoBase.mojom.FilePath|undefined) } */
    this.weightsPath;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.LanguageDetectionResultSpec.$,
    'LanguageDetectionResult',
    [
      mojo.internal.StructField(
        'code', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reliability', 8,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('onDeviceModel.mojom.LanguageDetectionResult');

/** @record */
onDeviceModel.mojom.LanguageDetectionResult = class {
  constructor() {
    /** @export { !string } */
    this.code;
    /** @export { !number } */
    this.reliability;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.SafetyInfoSpec.$,
    'SafetyInfo',
    [
      mojo.internal.StructField(
        'classScores', 0,
        0,
        mojo.internal.Array(mojo.internal.Float, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'language', 8,
        0,
        onDeviceModel.mojom.LanguageDetectionResultSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('onDeviceModel.mojom.SafetyInfo');

/** @record */
onDeviceModel.mojom.SafetyInfo = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.classScores;
    /** @export { (onDeviceModel.mojom.LanguageDetectionResult|undefined) } */
    this.language;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.ResponseChunkSpec.$,
    'ResponseChunk',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'safetyInfo', 8,
        0,
        onDeviceModel.mojom.SafetyInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('onDeviceModel.mojom.ResponseChunk');

/** @record */
onDeviceModel.mojom.ResponseChunk = class {
  constructor() {
    /** @export { !string } */
    this.text;
    /** @export { (onDeviceModel.mojom.SafetyInfo|undefined) } */
    this.safetyInfo;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.ResponseSummarySpec.$,
    'ResponseSummary',
    [
      mojo.internal.StructField(
        'safetyInfo', 0,
        0,
        onDeviceModel.mojom.SafetyInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'outputTokenCount', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('onDeviceModel.mojom.ResponseSummary');

/** @record */
onDeviceModel.mojom.ResponseSummary = class {
  constructor() {
    /** @export { (onDeviceModel.mojom.SafetyInfo|undefined) } */
    this.safetyInfo;
    /** @export { !number } */
    this.outputTokenCount;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.LoadAdaptationParamsSpec.$,
    'LoadAdaptationParams',
    [
      mojo.internal.StructField(
        'assets', 0,
        0,
        onDeviceModel.mojom.AdaptationAssetsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.LoadAdaptationParams');

/** @record */
onDeviceModel.mojom.LoadAdaptationParams = class {
  constructor() {
    /** @export { !onDeviceModel.mojom.AdaptationAssets } */
    this.assets;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.CapabilitiesSpec.$,
    'Capabilities',
    [
      mojo.internal.StructField(
        'imageInput', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'audioInput', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.Capabilities');

/** @record */
onDeviceModel.mojom.Capabilities = class {
  constructor() {
    /** @export { !boolean } */
    this.imageInput;
    /** @export { !boolean } */
    this.audioInput;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.SessionParamsSpec.$,
    'SessionParams',
    [
      mojo.internal.StructField(
        'maxTokens', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'capabilities', 8,
        0,
        onDeviceModel.mojom.CapabilitiesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'topK', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'temperature', 16,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],[1, 32],]);



goog.provide('onDeviceModel.mojom.SessionParams');

/** @record */
onDeviceModel.mojom.SessionParams = class {
  constructor() {
    /** @export { !number } */
    this.maxTokens;
    /** @export { !onDeviceModel.mojom.Capabilities } */
    this.capabilities;
    /** @export { !number } */
    this.topK;
    /** @export { !number } */
    this.temperature;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.InputSpec.$,
    'Input',
    [
      mojo.internal.StructField(
        'pieces', 0,
        0,
        mojo.internal.Array(onDeviceModel.mojom.InputPieceSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.Input');

/** @record */
onDeviceModel.mojom.Input = class {
  constructor() {
    /** @export { !Array<!onDeviceModel.mojom.InputPiece> } */
    this.pieces;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.AppendOptionsSpec.$,
    'AppendOptions',
    [
      mojo.internal.StructField(
        'input', 0,
        0,
        onDeviceModel.mojom.InputSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maxTokens', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('onDeviceModel.mojom.AppendOptions');

/** @record */
onDeviceModel.mojom.AppendOptions = class {
  constructor() {
    /** @export { !onDeviceModel.mojom.Input } */
    this.input;
    /** @export { !number } */
    this.maxTokens;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.GenerateOptionsSpec.$,
    'GenerateOptions',
    [
      mojo.internal.StructField(
        'maxOutputTokens', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'constraint', 8,
        0,
        onDeviceModel.mojom.ResponseConstraintSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],[2, 32],]);



goog.provide('onDeviceModel.mojom.GenerateOptions');

/** @record */
onDeviceModel.mojom.GenerateOptions = class {
  constructor() {
    /** @export { !number } */
    this.maxOutputTokens;
    /** @export { (onDeviceModel.mojom.ResponseConstraint|undefined) } */
    this.constraint;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.AudioDataSpec.$,
    'AudioData',
    [
      mojo.internal.StructField(
        'channelCount', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sampleRate', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'frameCount', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'data', 16,
        0,
        mojo.internal.Array(mojo.internal.Float, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('onDeviceModel.mojom.AudioData');

/** @record */
onDeviceModel.mojom.AudioData = class {
  constructor() {
    /** @export { !number } */
    this.channelCount;
    /** @export { !number } */
    this.sampleRate;
    /** @export { !number } */
    this.frameCount;
    /** @export { !Array<!number> } */
    this.data;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.SpeechRecognitionResultSpec.$,
    'SpeechRecognitionResult',
    [
      mojo.internal.StructField(
        'transcript', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isFinal', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('onDeviceModel.mojom.SpeechRecognitionResult');

/** @record */
onDeviceModel.mojom.SpeechRecognitionResult = class {
  constructor() {
    /** @export { !string } */
    this.transcript;
    /** @export { !boolean } */
    this.isFinal;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.AsrStreamOptionsSpec.$,
    'AsrStreamOptions',
    [
      mojo.internal.StructField(
        'sampleRateHz', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.AsrStreamOptions');

/** @record */
onDeviceModel.mojom.AsrStreamOptions = class {
  constructor() {
    /** @export { !number } */
    this.sampleRateHz;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.DevicePerformanceInfoSpec.$,
    'DevicePerformanceInfo',
    [
      mojo.internal.StructField(
        'performanceClass', 0,
        0,
        onDeviceModel.mojom.PerformanceClassSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'vramMb', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('onDeviceModel.mojom.DevicePerformanceInfo');

/** @record */
onDeviceModel.mojom.DevicePerformanceInfo = class {
  constructor() {
    /** @export { !onDeviceModel.mojom.PerformanceClass } */
    this.performanceClass;
    /** @export { !bigint } */
    this.vramMb;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.DeviceInfoSpec.$,
    'DeviceInfo',
    [
      mojo.internal.StructField(
        'vendorId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'deviceId', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'driverVersion', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'supportsFp16', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('onDeviceModel.mojom.DeviceInfo');

/** @record */
onDeviceModel.mojom.DeviceInfo = class {
  constructor() {
    /** @export { !number } */
    this.vendorId;
    /** @export { !number } */
    this.deviceId;
    /** @export { !string } */
    this.driverVersion;
    /** @export { !boolean } */
    this.supportsFp16;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.StreamingResponder_OnResponse_ParamsSpec.$,
    'StreamingResponder_OnResponse_Params',
    [
      mojo.internal.StructField(
        'chunk', 0,
        0,
        onDeviceModel.mojom.ResponseChunkSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.StreamingResponder_OnResponse_Params');

/** @record */
onDeviceModel.mojom.StreamingResponder_OnResponse_Params = class {
  constructor() {
    /** @export { !onDeviceModel.mojom.ResponseChunk } */
    this.chunk;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.StreamingResponder_OnComplete_ParamsSpec.$,
    'StreamingResponder_OnComplete_Params',
    [
      mojo.internal.StructField(
        'summary', 0,
        0,
        onDeviceModel.mojom.ResponseSummarySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.StreamingResponder_OnComplete_Params');

/** @record */
onDeviceModel.mojom.StreamingResponder_OnComplete_Params = class {
  constructor() {
    /** @export { !onDeviceModel.mojom.ResponseSummary } */
    this.summary;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.ContextClient_OnComplete_ParamsSpec.$,
    'ContextClient_OnComplete_Params',
    [
      mojo.internal.StructField(
        'tokensProcessed', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.ContextClient_OnComplete_Params');

/** @record */
onDeviceModel.mojom.ContextClient_OnComplete_Params = class {
  constructor() {
    /** @export { !number } */
    this.tokensProcessed;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.Session_Append_ParamsSpec.$,
    'Session_Append_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        onDeviceModel.mojom.AppendOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'client', 8,
        0,
        mojo.internal.InterfaceProxy(onDeviceModel.mojom.ContextClientRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('onDeviceModel.mojom.Session_Append_Params');

/** @record */
onDeviceModel.mojom.Session_Append_Params = class {
  constructor() {
    /** @export { !onDeviceModel.mojom.AppendOptions } */
    this.options;
    /** @export { (onDeviceModel.mojom.ContextClientRemote|undefined) } */
    this.client;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.Session_Generate_ParamsSpec.$,
    'Session_Generate_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        onDeviceModel.mojom.GenerateOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'responder', 8,
        0,
        mojo.internal.InterfaceProxy(onDeviceModel.mojom.StreamingResponderRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('onDeviceModel.mojom.Session_Generate_Params');

/** @record */
onDeviceModel.mojom.Session_Generate_Params = class {
  constructor() {
    /** @export { !onDeviceModel.mojom.GenerateOptions } */
    this.options;
    /** @export { !onDeviceModel.mojom.StreamingResponderRemote } */
    this.responder;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.Session_GetSizeInTokens_ParamsSpec.$,
    'Session_GetSizeInTokens_Params',
    [
      mojo.internal.StructField(
        'input', 0,
        0,
        onDeviceModel.mojom.InputSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.Session_GetSizeInTokens_Params');

/** @record */
onDeviceModel.mojom.Session_GetSizeInTokens_Params = class {
  constructor() {
    /** @export { !onDeviceModel.mojom.Input } */
    this.input;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.Session_GetSizeInTokens_ResponseParamsSpec.$,
    'Session_GetSizeInTokens_ResponseParams',
    [
      mojo.internal.StructField(
        'size', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.Session_GetSizeInTokens_ResponseParams');

/** @record */
onDeviceModel.mojom.Session_GetSizeInTokens_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.size;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.Session_Score_ParamsSpec.$,
    'Session_Score_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.Session_Score_Params');

/** @record */
onDeviceModel.mojom.Session_Score_Params = class {
  constructor() {
    /** @export { !string } */
    this.text;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.Session_Score_ResponseParamsSpec.$,
    'Session_Score_ResponseParams',
    [
      mojo.internal.StructField(
        'probability', 0,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.Session_Score_ResponseParams');

/** @record */
onDeviceModel.mojom.Session_Score_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.probability;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.Session_Clone_ParamsSpec.$,
    'Session_Clone_Params',
    [
      mojo.internal.StructField(
        'session', 0,
        0,
        mojo.internal.InterfaceRequest(onDeviceModel.mojom.SessionPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.Session_Clone_Params');

/** @record */
onDeviceModel.mojom.Session_Clone_Params = class {
  constructor() {
    /** @export { !onDeviceModel.mojom.SessionPendingReceiver } */
    this.session;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.Session_GetProbabilitiesBlocking_ParamsSpec.$,
    'Session_GetProbabilitiesBlocking_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.Session_GetProbabilitiesBlocking_Params');

/** @record */
onDeviceModel.mojom.Session_GetProbabilitiesBlocking_Params = class {
  constructor() {
    /** @export { !string } */
    this.text;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.Session_GetProbabilitiesBlocking_ResponseParamsSpec.$,
    'Session_GetProbabilitiesBlocking_ResponseParams',
    [
      mojo.internal.StructField(
        'probabilities', 0,
        0,
        mojo.internal.Array(mojo.internal.Float, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.Session_GetProbabilitiesBlocking_ResponseParams');

/** @record */
onDeviceModel.mojom.Session_GetProbabilitiesBlocking_ResponseParams = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.probabilities;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.Session_SetPriority_ParamsSpec.$,
    'Session_SetPriority_Params',
    [
      mojo.internal.StructField(
        'priority', 0,
        0,
        onDeviceModel.mojom.PrioritySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.Session_SetPriority_Params');

/** @record */
onDeviceModel.mojom.Session_SetPriority_Params = class {
  constructor() {
    /** @export { !onDeviceModel.mojom.Priority } */
    this.priority;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.Session_AsrStream_ParamsSpec.$,
    'Session_AsrStream_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        onDeviceModel.mojom.AsrStreamOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'stream', 8,
        0,
        mojo.internal.InterfaceRequest(onDeviceModel.mojom.AsrStreamInputPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'responder', 12,
        0,
        mojo.internal.InterfaceProxy(onDeviceModel.mojom.AsrStreamResponderRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('onDeviceModel.mojom.Session_AsrStream_Params');

/** @record */
onDeviceModel.mojom.Session_AsrStream_Params = class {
  constructor() {
    /** @export { !onDeviceModel.mojom.AsrStreamOptions } */
    this.options;
    /** @export { !onDeviceModel.mojom.AsrStreamInputPendingReceiver } */
    this.stream;
    /** @export { !onDeviceModel.mojom.AsrStreamResponderRemote } */
    this.responder;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.OnDeviceModel_StartSession_ParamsSpec.$,
    'OnDeviceModel_StartSession_Params',
    [
      mojo.internal.StructField(
        'session', 0,
        0,
        mojo.internal.InterfaceRequest(onDeviceModel.mojom.SessionPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'params', 8,
        0,
        onDeviceModel.mojom.SessionParamsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],[1, 24],]);



goog.provide('onDeviceModel.mojom.OnDeviceModel_StartSession_Params');

/** @record */
onDeviceModel.mojom.OnDeviceModel_StartSession_Params = class {
  constructor() {
    /** @export { !onDeviceModel.mojom.SessionPendingReceiver } */
    this.session;
    /** @export { (onDeviceModel.mojom.SessionParams|undefined) } */
    this.params;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.OnDeviceModel_ClassifyTextSafety_ParamsSpec.$,
    'OnDeviceModel_ClassifyTextSafety_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.OnDeviceModel_ClassifyTextSafety_Params');

/** @record */
onDeviceModel.mojom.OnDeviceModel_ClassifyTextSafety_Params = class {
  constructor() {
    /** @export { !string } */
    this.text;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.OnDeviceModel_ClassifyTextSafety_ResponseParamsSpec.$,
    'OnDeviceModel_ClassifyTextSafety_ResponseParams',
    [
      mojo.internal.StructField(
        'safetyInfo', 0,
        0,
        onDeviceModel.mojom.SafetyInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.OnDeviceModel_ClassifyTextSafety_ResponseParams');

/** @record */
onDeviceModel.mojom.OnDeviceModel_ClassifyTextSafety_ResponseParams = class {
  constructor() {
    /** @export { (onDeviceModel.mojom.SafetyInfo|undefined) } */
    this.safetyInfo;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.OnDeviceModel_DetectLanguage_ParamsSpec.$,
    'OnDeviceModel_DetectLanguage_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.OnDeviceModel_DetectLanguage_Params');

/** @record */
onDeviceModel.mojom.OnDeviceModel_DetectLanguage_Params = class {
  constructor() {
    /** @export { !string } */
    this.text;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.OnDeviceModel_DetectLanguage_ResponseParamsSpec.$,
    'OnDeviceModel_DetectLanguage_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        onDeviceModel.mojom.LanguageDetectionResultSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.OnDeviceModel_DetectLanguage_ResponseParams');

/** @record */
onDeviceModel.mojom.OnDeviceModel_DetectLanguage_ResponseParams = class {
  constructor() {
    /** @export { (onDeviceModel.mojom.LanguageDetectionResult|undefined) } */
    this.result;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.OnDeviceModel_LoadAdaptation_ParamsSpec.$,
    'OnDeviceModel_LoadAdaptation_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        onDeviceModel.mojom.LoadAdaptationParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'model', 8,
        0,
        mojo.internal.InterfaceRequest(onDeviceModel.mojom.OnDeviceModelPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('onDeviceModel.mojom.OnDeviceModel_LoadAdaptation_Params');

/** @record */
onDeviceModel.mojom.OnDeviceModel_LoadAdaptation_Params = class {
  constructor() {
    /** @export { !onDeviceModel.mojom.LoadAdaptationParams } */
    this.params;
    /** @export { !onDeviceModel.mojom.OnDeviceModelPendingReceiver } */
    this.model;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.OnDeviceModel_LoadAdaptation_ResponseParamsSpec.$,
    'OnDeviceModel_LoadAdaptation_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        onDeviceModel.mojom.LoadModelResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.OnDeviceModel_LoadAdaptation_ResponseParams');

/** @record */
onDeviceModel.mojom.OnDeviceModel_LoadAdaptation_ResponseParams = class {
  constructor() {
    /** @export { !onDeviceModel.mojom.LoadModelResult } */
    this.result;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.TextSafetySession_ClassifyTextSafety_ParamsSpec.$,
    'TextSafetySession_ClassifyTextSafety_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.TextSafetySession_ClassifyTextSafety_Params');

/** @record */
onDeviceModel.mojom.TextSafetySession_ClassifyTextSafety_Params = class {
  constructor() {
    /** @export { !string } */
    this.text;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.TextSafetySession_ClassifyTextSafety_ResponseParamsSpec.$,
    'TextSafetySession_ClassifyTextSafety_ResponseParams',
    [
      mojo.internal.StructField(
        'safetyInfo', 0,
        0,
        onDeviceModel.mojom.SafetyInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.TextSafetySession_ClassifyTextSafety_ResponseParams');

/** @record */
onDeviceModel.mojom.TextSafetySession_ClassifyTextSafety_ResponseParams = class {
  constructor() {
    /** @export { (onDeviceModel.mojom.SafetyInfo|undefined) } */
    this.safetyInfo;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.TextSafetySession_DetectLanguage_ParamsSpec.$,
    'TextSafetySession_DetectLanguage_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.TextSafetySession_DetectLanguage_Params');

/** @record */
onDeviceModel.mojom.TextSafetySession_DetectLanguage_Params = class {
  constructor() {
    /** @export { !string } */
    this.text;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.TextSafetySession_DetectLanguage_ResponseParamsSpec.$,
    'TextSafetySession_DetectLanguage_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        onDeviceModel.mojom.LanguageDetectionResultSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.TextSafetySession_DetectLanguage_ResponseParams');

/** @record */
onDeviceModel.mojom.TextSafetySession_DetectLanguage_ResponseParams = class {
  constructor() {
    /** @export { (onDeviceModel.mojom.LanguageDetectionResult|undefined) } */
    this.result;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.TextSafetySession_Clone_ParamsSpec.$,
    'TextSafetySession_Clone_Params',
    [
      mojo.internal.StructField(
        'session', 0,
        0,
        mojo.internal.InterfaceRequest(onDeviceModel.mojom.TextSafetySessionPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.TextSafetySession_Clone_Params');

/** @record */
onDeviceModel.mojom.TextSafetySession_Clone_Params = class {
  constructor() {
    /** @export { !onDeviceModel.mojom.TextSafetySessionPendingReceiver } */
    this.session;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.TextSafetyModel_StartSession_ParamsSpec.$,
    'TextSafetyModel_StartSession_Params',
    [
      mojo.internal.StructField(
        'session', 0,
        0,
        mojo.internal.InterfaceRequest(onDeviceModel.mojom.TextSafetySessionPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.TextSafetyModel_StartSession_Params');

/** @record */
onDeviceModel.mojom.TextSafetyModel_StartSession_Params = class {
  constructor() {
    /** @export { !onDeviceModel.mojom.TextSafetySessionPendingReceiver } */
    this.session;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.AsrStreamResponder_OnResponse_ParamsSpec.$,
    'AsrStreamResponder_OnResponse_Params',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Array(onDeviceModel.mojom.SpeechRecognitionResultSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.AsrStreamResponder_OnResponse_Params');

/** @record */
onDeviceModel.mojom.AsrStreamResponder_OnResponse_Params = class {
  constructor() {
    /** @export { !Array<!onDeviceModel.mojom.SpeechRecognitionResult> } */
    this.result;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.AsrStreamInput_AddAudioChunk_ParamsSpec.$,
    'AsrStreamInput_AddAudioChunk_Params',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        onDeviceModel.mojom.AudioDataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.AsrStreamInput_AddAudioChunk_Params');

/** @record */
onDeviceModel.mojom.AsrStreamInput_AddAudioChunk_Params = class {
  constructor() {
    /** @export { !onDeviceModel.mojom.AudioData } */
    this.data;
  }
};

goog.provide('onDeviceModel.mojom.InputPiece');


mojo.internal.Union(
    onDeviceModel.mojom.InputPieceSpec.$, 'InputPiece',
    {
      'token': {
        'ordinal': 0,
        'type': onDeviceModel.mojom.TokenSpec.$,
      },
      'text': {
        'ordinal': 1,
        'type': mojo.internal.String,
      },
      'bitmap': {
        'ordinal': 2,
        'type': skia.mojom.BitmapWithArbitraryBppSpec.$,
      },
      'unknownType': {
        'ordinal': 3,
        'type': mojo.internal.Bool,
      },
      'audio': {
        'ordinal': 4,
        'type': onDeviceModel.mojom.AudioDataSpec.$,
      },
    });

/**
 * @typedef { {
 *   token: (!onDeviceModel.mojom.Token|undefined),
 *   text: (!string|undefined),
 *   bitmap: (!skia.mojom.BitmapWithArbitraryBpp|undefined),
 *   unknownType: (!boolean|undefined),
 *   audio: (!onDeviceModel.mojom.AudioData|undefined),
 * } }
 */
onDeviceModel.mojom.InputPiece;
goog.provide('onDeviceModel.mojom.ResponseConstraint');


mojo.internal.Union(
    onDeviceModel.mojom.ResponseConstraintSpec.$, 'ResponseConstraint',
    {
      'jsonSchema': {
        'ordinal': 0,
        'type': mojo.internal.String,
      },
      'regex': {
        'ordinal': 1,
        'type': mojo.internal.String,
      },
      'unknownType': {
        'ordinal': 2,
        'type': mojo.internal.Bool,
      },
    });

/**
 * @typedef { {
 *   jsonSchema: (!string|undefined),
 *   regex: (!string|undefined),
 *   unknownType: (!boolean|undefined),
 * } }
 */
onDeviceModel.mojom.ResponseConstraint;
