// services/on_device_model/public/mojom/on_device_model.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_ON_DEVICE_MODEL_PUBLIC_MOJOM_ON_DEVICE_MODEL_MOJOM_DATA_VIEW_H_
#define SERVICES_ON_DEVICE_MODEL_PUBLIC_MOJOM_ON_DEVICE_MODEL_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/on_device_model/public/mojom/on_device_model.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"


namespace on_device_model::mojom {
class AdaptationAssetsDataView;

class LanguageDetectionResultDataView;

class SafetyInfoDataView;

class ResponseChunkDataView;

class ResponseSummaryDataView;

class LoadAdaptationParamsDataView;

class CapabilitiesDataView;

class SessionParamsDataView;

class InputDataView;

class AppendOptionsDataView;

class GenerateOptionsDataView;

class AudioDataDataView;

class SpeechRecognitionResultDataView;

class AsrStreamOptionsDataView;

class DevicePerformanceInfoDataView;

class DeviceInfoDataView;

class InputPieceDataView;
class ResponseConstraintDataView;


}  // on_device_model::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::on_device_model::mojom::AdaptationAssetsDataView> {
  using Data = ::on_device_model::mojom::internal::AdaptationAssets_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::on_device_model::mojom::LanguageDetectionResultDataView> {
  using Data = ::on_device_model::mojom::internal::LanguageDetectionResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::on_device_model::mojom::SafetyInfoDataView> {
  using Data = ::on_device_model::mojom::internal::SafetyInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::on_device_model::mojom::ResponseChunkDataView> {
  using Data = ::on_device_model::mojom::internal::ResponseChunk_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::on_device_model::mojom::ResponseSummaryDataView> {
  using Data = ::on_device_model::mojom::internal::ResponseSummary_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::on_device_model::mojom::LoadAdaptationParamsDataView> {
  using Data = ::on_device_model::mojom::internal::LoadAdaptationParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::on_device_model::mojom::CapabilitiesDataView> {
  using Data = ::on_device_model::mojom::internal::Capabilities_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::on_device_model::mojom::SessionParamsDataView> {
  using Data = ::on_device_model::mojom::internal::SessionParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::on_device_model::mojom::InputDataView> {
  using Data = ::on_device_model::mojom::internal::Input_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::on_device_model::mojom::AppendOptionsDataView> {
  using Data = ::on_device_model::mojom::internal::AppendOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::on_device_model::mojom::GenerateOptionsDataView> {
  using Data = ::on_device_model::mojom::internal::GenerateOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::on_device_model::mojom::AudioDataDataView> {
  using Data = ::on_device_model::mojom::internal::AudioData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::on_device_model::mojom::SpeechRecognitionResultDataView> {
  using Data = ::on_device_model::mojom::internal::SpeechRecognitionResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::on_device_model::mojom::AsrStreamOptionsDataView> {
  using Data = ::on_device_model::mojom::internal::AsrStreamOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::on_device_model::mojom::DevicePerformanceInfoDataView> {
  using Data = ::on_device_model::mojom::internal::DevicePerformanceInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::on_device_model::mojom::DeviceInfoDataView> {
  using Data = ::on_device_model::mojom::internal::DeviceInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::on_device_model::mojom::InputPieceDataView> {
  using Data = ::on_device_model::mojom::internal::InputPiece_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::on_device_model::mojom::ResponseConstraintDataView> {
  using Data = ::on_device_model::mojom::internal::ResponseConstraint_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace on_device_model::mojom {


enum class Token : int32_t {
  
  kSystem = 0,
  
  kModel = 1,
  
  kUser = 2,
  
  kEnd = 3,
  
  kToolCall = 4,
  
  kToolResponse = 5,
  kMinValue = 0,
  kMaxValue = 5,
  kDefaultValue = 3
};

 std::ostream& operator<<(std::ostream& os, Token value);
inline bool IsKnownEnumValue(Token value) {
  return internal::Token_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline Token ToKnownEnumValue(Token value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return Token::kDefaultValue;
}


enum class Priority : int32_t {
  
  kForeground = 0,
  
  kBackground = 1,
  kMinValue = 0,
  kMaxValue = 1,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, Priority value);
inline bool IsKnownEnumValue(Priority value) {
  return internal::Priority_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline Priority ToKnownEnumValue(Priority value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return Priority::kDefaultValue;
}


enum class PerformanceClass : int32_t {
  
  kError = 0,
  
  kGpuBlocked = 1,
  
  kFailedToLoadLibrary = 2,
  
  kVeryLow = 3,
  
  kLow = 4,
  
  kMedium = 5,
  
  kHigh = 6,
  
  kVeryHigh = 7,
  kMinValue = 0,
  kMaxValue = 7,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, PerformanceClass value);
inline bool IsKnownEnumValue(PerformanceClass value) {
  return internal::PerformanceClass_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline PerformanceClass ToKnownEnumValue(PerformanceClass value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return PerformanceClass::kDefaultValue;
}


enum class LoadModelResult : int32_t {
  
  kSuccess = 0,
  
  kGpuBlocked = 1,
  
  kFailedToLoadLibrary = 2,
  kMinValue = 0,
  kMaxValue = 2,
  kDefaultValue = 2
};

 std::ostream& operator<<(std::ostream& os, LoadModelResult value);
inline bool IsKnownEnumValue(LoadModelResult value) {
  return internal::LoadModelResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline LoadModelResult ToKnownEnumValue(LoadModelResult value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return LoadModelResult::kDefaultValue;
}
// Interface base classes. They are used for type safety check.
class StreamingResponderInterfaceBase {};

using StreamingResponderPtrDataView =
    mojo::InterfacePtrDataView<StreamingResponderInterfaceBase>;
using StreamingResponderRequestDataView =
    mojo::InterfaceRequestDataView<StreamingResponderInterfaceBase>;
using StreamingResponderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<StreamingResponderInterfaceBase>;
using StreamingResponderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<StreamingResponderInterfaceBase>;
class ContextClientInterfaceBase {};

using ContextClientPtrDataView =
    mojo::InterfacePtrDataView<ContextClientInterfaceBase>;
using ContextClientRequestDataView =
    mojo::InterfaceRequestDataView<ContextClientInterfaceBase>;
using ContextClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ContextClientInterfaceBase>;
using ContextClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ContextClientInterfaceBase>;
class SessionInterfaceBase {};

using SessionPtrDataView =
    mojo::InterfacePtrDataView<SessionInterfaceBase>;
using SessionRequestDataView =
    mojo::InterfaceRequestDataView<SessionInterfaceBase>;
using SessionAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SessionInterfaceBase>;
using SessionAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SessionInterfaceBase>;
class OnDeviceModelInterfaceBase {};

using OnDeviceModelPtrDataView =
    mojo::InterfacePtrDataView<OnDeviceModelInterfaceBase>;
using OnDeviceModelRequestDataView =
    mojo::InterfaceRequestDataView<OnDeviceModelInterfaceBase>;
using OnDeviceModelAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<OnDeviceModelInterfaceBase>;
using OnDeviceModelAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<OnDeviceModelInterfaceBase>;
class TextSafetySessionInterfaceBase {};

using TextSafetySessionPtrDataView =
    mojo::InterfacePtrDataView<TextSafetySessionInterfaceBase>;
using TextSafetySessionRequestDataView =
    mojo::InterfaceRequestDataView<TextSafetySessionInterfaceBase>;
using TextSafetySessionAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<TextSafetySessionInterfaceBase>;
using TextSafetySessionAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<TextSafetySessionInterfaceBase>;
class TextSafetyModelInterfaceBase {};

using TextSafetyModelPtrDataView =
    mojo::InterfacePtrDataView<TextSafetyModelInterfaceBase>;
using TextSafetyModelRequestDataView =
    mojo::InterfaceRequestDataView<TextSafetyModelInterfaceBase>;
using TextSafetyModelAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<TextSafetyModelInterfaceBase>;
using TextSafetyModelAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<TextSafetyModelInterfaceBase>;
class AsrStreamResponderInterfaceBase {};

using AsrStreamResponderPtrDataView =
    mojo::InterfacePtrDataView<AsrStreamResponderInterfaceBase>;
using AsrStreamResponderRequestDataView =
    mojo::InterfaceRequestDataView<AsrStreamResponderInterfaceBase>;
using AsrStreamResponderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AsrStreamResponderInterfaceBase>;
using AsrStreamResponderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AsrStreamResponderInterfaceBase>;
class AsrStreamInputInterfaceBase {};

using AsrStreamInputPtrDataView =
    mojo::InterfacePtrDataView<AsrStreamInputInterfaceBase>;
using AsrStreamInputRequestDataView =
    mojo::InterfaceRequestDataView<AsrStreamInputInterfaceBase>;
using AsrStreamInputAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AsrStreamInputInterfaceBase>;
using AsrStreamInputAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AsrStreamInputInterfaceBase>;


class AdaptationAssetsDataView {
 public:
  AdaptationAssetsDataView() = default;

  AdaptationAssetsDataView(
      internal::AdaptationAssets_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetWeightsDataView(
      ::mojo_base::mojom::FileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWeights(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FileDataView, UserType>(),
    "Attempting to read the optional `weights` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWeights` instead "
    "of `ReadWeights if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->weights.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FileDataView>(
        pointer, output, message_);
  }
  inline void GetWeightsPathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWeightsPath(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FilePathDataView, UserType>(),
    "Attempting to read the optional `weights_path` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWeightsPath` instead "
    "of `ReadWeightsPath if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->weights_path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
 private:
  internal::AdaptationAssets_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LanguageDetectionResultDataView {
 public:
  LanguageDetectionResultDataView() = default;

  LanguageDetectionResultDataView(
      internal::LanguageDetectionResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCodeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCode(UserType* output) {
    
    auto* pointer = data_->code.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  float reliability() const {
    return data_->reliability;
  }
 private:
  internal::LanguageDetectionResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SafetyInfoDataView {
 public:
  SafetyInfoDataView() = default;

  SafetyInfoDataView(
      internal::SafetyInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetClassScoresDataView(
      mojo::ArrayDataView<float>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClassScores(UserType* output) {
    
    auto* pointer = data_->class_scores.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<float>>(
        pointer, output, message_);
  }
  inline void GetLanguageDataView(
      LanguageDetectionResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLanguage(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::on_device_model::mojom::LanguageDetectionResultDataView, UserType>(),
    "Attempting to read the optional `language` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLanguage` instead "
    "of `ReadLanguage if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->language.Get();
    return mojo::internal::Deserialize<::on_device_model::mojom::LanguageDetectionResultDataView>(
        pointer, output, message_);
  }
 private:
  internal::SafetyInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ResponseChunkDataView {
 public:
  ResponseChunkDataView() = default;

  ResponseChunkDataView(
      internal::ResponseChunk_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadText(UserType* output) {
    
    auto* pointer = data_->text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSafetyInfoDataView(
      SafetyInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSafetyInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::on_device_model::mojom::SafetyInfoDataView, UserType>(),
    "Attempting to read the optional `safety_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSafetyInfo` instead "
    "of `ReadSafetyInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->safety_info.Get();
    return mojo::internal::Deserialize<::on_device_model::mojom::SafetyInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::ResponseChunk_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ResponseSummaryDataView {
 public:
  ResponseSummaryDataView() = default;

  ResponseSummaryDataView(
      internal::ResponseSummary_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSafetyInfoDataView(
      SafetyInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSafetyInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::on_device_model::mojom::SafetyInfoDataView, UserType>(),
    "Attempting to read the optional `safety_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSafetyInfo` instead "
    "of `ReadSafetyInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->safety_info.Get();
    return mojo::internal::Deserialize<::on_device_model::mojom::SafetyInfoDataView>(
        pointer, output, message_);
  }
  uint32_t output_token_count() const {
    return data_->output_token_count;
  }
 private:
  internal::ResponseSummary_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LoadAdaptationParamsDataView {
 public:
  LoadAdaptationParamsDataView() = default;

  LoadAdaptationParamsDataView(
      internal::LoadAdaptationParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAssetsDataView(
      AdaptationAssetsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAssets(UserType* output) {
    
    auto* pointer = data_->assets.Get();
    return mojo::internal::Deserialize<::on_device_model::mojom::AdaptationAssetsDataView>(
        pointer, output, message_);
  }
 private:
  internal::LoadAdaptationParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CapabilitiesDataView {
 public:
  CapabilitiesDataView() = default;

  CapabilitiesDataView(
      internal::Capabilities_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool image_input() const {
    return data_->image_input;
  }
  bool audio_input() const {
    return data_->audio_input;
  }
 private:
  internal::Capabilities_Data* data_ = nullptr;
};


class SessionParamsDataView {
 public:
  SessionParamsDataView() = default;

  SessionParamsDataView(
      internal::SessionParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t max_tokens() const {
    return data_->max_tokens;
  }
  inline void GetCapabilitiesDataView(
      CapabilitiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCapabilities(UserType* output) {
    
    auto* pointer = data_->capabilities.Get();
    return mojo::internal::Deserialize<::on_device_model::mojom::CapabilitiesDataView>(
        pointer, output, message_);
  }
  uint32_t top_k() const {
    if (data_->header_.version < 1)
      return uint32_t{};
    return data_->top_k;
  }
  float temperature() const {
    if (data_->header_.version < 1)
      return float{};
    return data_->temperature;
  }
 private:
  internal::SessionParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class InputDataView {
 public:
  InputDataView() = default;

  InputDataView(
      internal::Input_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPiecesDataView(
      mojo::ArrayDataView<InputPieceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPieces(UserType* output) {
    
    auto* pointer = data_->pieces.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::on_device_model::mojom::InputPieceDataView>>(
        pointer, output, message_);
  }
 private:
  internal::Input_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AppendOptionsDataView {
 public:
  AppendOptionsDataView() = default;

  AppendOptionsDataView(
      internal::AppendOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputDataView(
      InputDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInput(UserType* output) {
    
    auto* pointer = data_->input.Get();
    return mojo::internal::Deserialize<::on_device_model::mojom::InputDataView>(
        pointer, output, message_);
  }
  uint32_t max_tokens() const {
    return data_->max_tokens;
  }
 private:
  internal::AppendOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GenerateOptionsDataView {
 public:
  GenerateOptionsDataView() = default;

  GenerateOptionsDataView(
      internal::GenerateOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t max_output_tokens() const {
    return data_->max_output_tokens;
  }
  inline void GetConstraintDataView(
      ResponseConstraintDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConstraint(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::on_device_model::mojom::ResponseConstraintDataView, UserType>(),
    "Attempting to read the optional `constraint` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadConstraint` instead "
    "of `ReadConstraint if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 2 && !data_->constraint.is_null()
                    ? &data_->constraint : nullptr;
    return mojo::internal::Deserialize<::on_device_model::mojom::ResponseConstraintDataView>(
        pointer, output, message_);
  }
 private:
  internal::GenerateOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AudioDataDataView {
 public:
  AudioDataDataView() = default;

  AudioDataDataView(
      internal::AudioData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t channel_count() const {
    return data_->channel_count;
  }
  int32_t sample_rate() const {
    return data_->sample_rate;
  }
  int32_t frame_count() const {
    return data_->frame_count;
  }
  inline void GetDataDataView(
      mojo::ArrayDataView<float>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<float>>(
        pointer, output, message_);
  }
 private:
  internal::AudioData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SpeechRecognitionResultDataView {
 public:
  SpeechRecognitionResultDataView() = default;

  SpeechRecognitionResultDataView(
      internal::SpeechRecognitionResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTranscriptDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTranscript(UserType* output) {
    
    auto* pointer = data_->transcript.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_final() const {
    return data_->is_final;
  }
 private:
  internal::SpeechRecognitionResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AsrStreamOptionsDataView {
 public:
  AsrStreamOptionsDataView() = default;

  AsrStreamOptionsDataView(
      internal::AsrStreamOptions_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t sample_rate_hz() const {
    return data_->sample_rate_hz;
  }
 private:
  internal::AsrStreamOptions_Data* data_ = nullptr;
};


class DevicePerformanceInfoDataView {
 public:
  DevicePerformanceInfoDataView() = default;

  DevicePerformanceInfoDataView(
      internal::DevicePerformanceInfo_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadPerformanceClass(UserType* output) const {
    auto data_value = data_->performance_class;
    return mojo::internal::Deserialize<::on_device_model::mojom::PerformanceClass>(
        data_value, output);
  }
  PerformanceClass performance_class() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::on_device_model::mojom::PerformanceClass>(data_->performance_class));
  }
  uint64_t vram_mb() const {
    return data_->vram_mb;
  }
 private:
  internal::DevicePerformanceInfo_Data* data_ = nullptr;
};


class DeviceInfoDataView {
 public:
  DeviceInfoDataView() = default;

  DeviceInfoDataView(
      internal::DeviceInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t vendor_id() const {
    return data_->vendor_id;
  }
  int32_t device_id() const {
    return data_->device_id;
  }
  inline void GetDriverVersionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDriverVersion(UserType* output) {
    
    auto* pointer = data_->driver_version.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool supports_fp16() const {
    return data_->supports_fp16;
  }
 private:
  internal::DeviceInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class InputPieceDataView {
 public:
  using Tag = internal::InputPiece_Data::InputPiece_Tag;

  InputPieceDataView() = default;

  InputPieceDataView(
      internal::InputPiece_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_token() const { return data_->tag == Tag::kToken; }
  template <typename UserType>
  [[nodiscard]] bool ReadToken(UserType* output) const {
    CHECK(is_token());
    return mojo::internal::Deserialize<::on_device_model::mojom::Token>(
        data_->data.f_token, output);
  }
  Token token() const {
    CHECK(is_token());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::on_device_model::mojom::Token>(data_->data.f_token));
  }
  bool is_text() const { return data_->tag == Tag::kText; }
  inline void GetTextDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadText(UserType* output) const {
    
    CHECK(is_text());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_text.Get(), output, message_);
  }
  bool is_bitmap() const { return data_->tag == Tag::kBitmap; }
  inline void GetBitmapDataView(
      ::skia::mojom::BitmapWithArbitraryBppDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadBitmap(UserType* output) const {
    
    CHECK(is_bitmap());
    return mojo::internal::Deserialize<::skia::mojom::BitmapWithArbitraryBppDataView>(
        data_->data.f_bitmap.Get(), output, message_);
  }
  bool is_unknown_type() const { return data_->tag == Tag::kUnknownType; }
  bool unknown_type() const {
    CHECK(is_unknown_type());
    return data_->data.f_unknown_type;
  }
  bool is_audio() const { return data_->tag == Tag::kAudio; }
  inline void GetAudioDataView(
      AudioDataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadAudio(UserType* output) const {
    
    CHECK(is_audio());
    return mojo::internal::Deserialize<::on_device_model::mojom::AudioDataDataView>(
        data_->data.f_audio.Get(), output, message_);
  }

 private:
  internal::InputPiece_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class ResponseConstraintDataView {
 public:
  using Tag = internal::ResponseConstraint_Data::ResponseConstraint_Tag;

  ResponseConstraintDataView() = default;

  ResponseConstraintDataView(
      internal::ResponseConstraint_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_json_schema() const { return data_->tag == Tag::kJsonSchema; }
  inline void GetJsonSchemaDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadJsonSchema(UserType* output) const {
    
    CHECK(is_json_schema());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_json_schema.Get(), output, message_);
  }
  bool is_regex() const { return data_->tag == Tag::kRegex; }
  inline void GetRegexDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadRegex(UserType* output) const {
    
    CHECK(is_regex());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_regex.Get(), output, message_);
  }
  bool is_unknown_type() const { return data_->tag == Tag::kUnknownType; }
  bool unknown_type() const {
    CHECK(is_unknown_type());
    return data_->data.f_unknown_type;
  }

 private:
  internal::ResponseConstraint_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // on_device_model::mojom

#endif  // SERVICES_ON_DEVICE_MODEL_PUBLIC_MOJOM_ON_DEVICE_MODEL_MOJOM_DATA_VIEW_H_