// services/on_device_model/public/mojom/on_device_model.mojom-blink-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_ON_DEVICE_MODEL_PUBLIC_MOJOM_ON_DEVICE_MODEL_MOJOM_BLINK_TEST_UTILS_H_
#define SERVICES_ON_DEVICE_MODEL_PUBLIC_MOJOM_ON_DEVICE_MODEL_MOJOM_BLINK_TEST_UTILS_H_

#include "services/on_device_model/public/mojom/on_device_model.mojom-blink.h"
#include "third_party/blink/renderer/platform/platform_export.h"


namespace on_device_model::mojom::blink {


class PLATFORM_EXPORT StreamingResponderInterceptorForTesting : public StreamingResponder {
  virtual StreamingResponder* GetForwardingInterface() = 0;
  void OnResponse(ResponseChunkPtr chunk) override;
  void OnComplete(ResponseSummaryPtr summary) override;
};
class PLATFORM_EXPORT StreamingResponderAsyncWaiter {
 public:
  explicit StreamingResponderAsyncWaiter(StreamingResponder* proxy);

  StreamingResponderAsyncWaiter(const StreamingResponderAsyncWaiter&) = delete;
  StreamingResponderAsyncWaiter& operator=(const StreamingResponderAsyncWaiter&) = delete;

  ~StreamingResponderAsyncWaiter();

 private:
  StreamingResponder* const proxy_;
};


class PLATFORM_EXPORT ContextClientInterceptorForTesting : public ContextClient {
  virtual ContextClient* GetForwardingInterface() = 0;
  void OnComplete(uint32_t tokens_processed) override;
};
class PLATFORM_EXPORT ContextClientAsyncWaiter {
 public:
  explicit ContextClientAsyncWaiter(ContextClient* proxy);

  ContextClientAsyncWaiter(const ContextClientAsyncWaiter&) = delete;
  ContextClientAsyncWaiter& operator=(const ContextClientAsyncWaiter&) = delete;

  ~ContextClientAsyncWaiter();

 private:
  ContextClient* const proxy_;
};


class PLATFORM_EXPORT SessionInterceptorForTesting : public Session {
  virtual Session* GetForwardingInterface() = 0;
  void Append(AppendOptionsPtr options, ::mojo::PendingRemote<ContextClient> client) override;
  void Generate(GenerateOptionsPtr options, ::mojo::PendingRemote<StreamingResponder> responder) override;
  void GetSizeInTokens(InputPtr input, GetSizeInTokensCallback callback) override;
  void Score(const ::blink::String& text, ScoreCallback callback) override;
  void Clone(::mojo::PendingReceiver<Session> session) override;
  void GetProbabilitiesBlocking(const ::blink::String& text, GetProbabilitiesBlockingCallback callback) override;
  void SetPriority(Priority priority) override;
  void AsrStream(AsrStreamOptionsPtr options, ::mojo::PendingReceiver<AsrStreamInput> stream, ::mojo::PendingRemote<AsrStreamResponder> responder) override;
};
class PLATFORM_EXPORT SessionAsyncWaiter {
 public:
  explicit SessionAsyncWaiter(Session* proxy);

  SessionAsyncWaiter(const SessionAsyncWaiter&) = delete;
  SessionAsyncWaiter& operator=(const SessionAsyncWaiter&) = delete;

  ~SessionAsyncWaiter();
  void GetSizeInTokens(
      InputPtr input, uint32_t* out_size);
  uint32_t GetSizeInTokens(InputPtr input);
  void Score(
      const ::blink::String& text, float* out_probability);
  float Score(const ::blink::String& text);
  void GetProbabilitiesBlocking(
      const ::blink::String& text, ::blink::Vector<float>* out_probabilities);
  ::blink::Vector<float> GetProbabilitiesBlocking(const ::blink::String& text);

 private:
  Session* const proxy_;
};


class PLATFORM_EXPORT OnDeviceModelInterceptorForTesting : public OnDeviceModel {
  virtual OnDeviceModel* GetForwardingInterface() = 0;
  void StartSession(::mojo::PendingReceiver<Session> session, SessionParamsPtr params) override;
  void ClassifyTextSafety(const ::blink::String& text, ClassifyTextSafetyCallback callback) override;
  void DetectLanguage(const ::blink::String& text, DetectLanguageCallback callback) override;
  void LoadAdaptation(LoadAdaptationParamsPtr params, ::mojo::PendingReceiver<OnDeviceModel> model, LoadAdaptationCallback callback) override;
};
class PLATFORM_EXPORT OnDeviceModelAsyncWaiter {
 public:
  explicit OnDeviceModelAsyncWaiter(OnDeviceModel* proxy);

  OnDeviceModelAsyncWaiter(const OnDeviceModelAsyncWaiter&) = delete;
  OnDeviceModelAsyncWaiter& operator=(const OnDeviceModelAsyncWaiter&) = delete;

  ~OnDeviceModelAsyncWaiter();
  void ClassifyTextSafety(
      const ::blink::String& text, SafetyInfoPtr* out_safety_info);
  SafetyInfoPtr ClassifyTextSafety(const ::blink::String& text);
  void DetectLanguage(
      const ::blink::String& text, LanguageDetectionResultPtr* out_result);
  LanguageDetectionResultPtr DetectLanguage(const ::blink::String& text);
  void LoadAdaptation(
      LoadAdaptationParamsPtr params, ::mojo::PendingReceiver<OnDeviceModel> model, LoadModelResult* out_result);
  LoadModelResult LoadAdaptation(LoadAdaptationParamsPtr params, ::mojo::PendingReceiver<OnDeviceModel> model);

 private:
  OnDeviceModel* const proxy_;
};


class PLATFORM_EXPORT TextSafetySessionInterceptorForTesting : public TextSafetySession {
  virtual TextSafetySession* GetForwardingInterface() = 0;
  void ClassifyTextSafety(const ::blink::String& text, ClassifyTextSafetyCallback callback) override;
  void DetectLanguage(const ::blink::String& text, DetectLanguageCallback callback) override;
  void Clone(::mojo::PendingReceiver<TextSafetySession> session) override;
};
class PLATFORM_EXPORT TextSafetySessionAsyncWaiter {
 public:
  explicit TextSafetySessionAsyncWaiter(TextSafetySession* proxy);

  TextSafetySessionAsyncWaiter(const TextSafetySessionAsyncWaiter&) = delete;
  TextSafetySessionAsyncWaiter& operator=(const TextSafetySessionAsyncWaiter&) = delete;

  ~TextSafetySessionAsyncWaiter();
  void ClassifyTextSafety(
      const ::blink::String& text, SafetyInfoPtr* out_safety_info);
  SafetyInfoPtr ClassifyTextSafety(const ::blink::String& text);
  void DetectLanguage(
      const ::blink::String& text, LanguageDetectionResultPtr* out_result);
  LanguageDetectionResultPtr DetectLanguage(const ::blink::String& text);

 private:
  TextSafetySession* const proxy_;
};


class PLATFORM_EXPORT TextSafetyModelInterceptorForTesting : public TextSafetyModel {
  virtual TextSafetyModel* GetForwardingInterface() = 0;
  void StartSession(::mojo::PendingReceiver<TextSafetySession> session) override;
};
class PLATFORM_EXPORT TextSafetyModelAsyncWaiter {
 public:
  explicit TextSafetyModelAsyncWaiter(TextSafetyModel* proxy);

  TextSafetyModelAsyncWaiter(const TextSafetyModelAsyncWaiter&) = delete;
  TextSafetyModelAsyncWaiter& operator=(const TextSafetyModelAsyncWaiter&) = delete;

  ~TextSafetyModelAsyncWaiter();

 private:
  TextSafetyModel* const proxy_;
};


class PLATFORM_EXPORT AsrStreamResponderInterceptorForTesting : public AsrStreamResponder {
  virtual AsrStreamResponder* GetForwardingInterface() = 0;
  void OnResponse(::blink::Vector<SpeechRecognitionResultPtr> result) override;
};
class PLATFORM_EXPORT AsrStreamResponderAsyncWaiter {
 public:
  explicit AsrStreamResponderAsyncWaiter(AsrStreamResponder* proxy);

  AsrStreamResponderAsyncWaiter(const AsrStreamResponderAsyncWaiter&) = delete;
  AsrStreamResponderAsyncWaiter& operator=(const AsrStreamResponderAsyncWaiter&) = delete;

  ~AsrStreamResponderAsyncWaiter();

 private:
  AsrStreamResponder* const proxy_;
};


class PLATFORM_EXPORT AsrStreamInputInterceptorForTesting : public AsrStreamInput {
  virtual AsrStreamInput* GetForwardingInterface() = 0;
  void AddAudioChunk(AudioDataPtr data) override;
};
class PLATFORM_EXPORT AsrStreamInputAsyncWaiter {
 public:
  explicit AsrStreamInputAsyncWaiter(AsrStreamInput* proxy);

  AsrStreamInputAsyncWaiter(const AsrStreamInputAsyncWaiter&) = delete;
  AsrStreamInputAsyncWaiter& operator=(const AsrStreamInputAsyncWaiter&) = delete;

  ~AsrStreamInputAsyncWaiter();

 private:
  AsrStreamInput* const proxy_;
};




}  // on_device_model::mojom::blink

#endif  // SERVICES_ON_DEVICE_MODEL_PUBLIC_MOJOM_ON_DEVICE_MODEL_MOJOM_BLINK_TEST_UTILS_H_