// services/network/public/mojom/websocket.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_WEBSOCKET_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_WEBSOCKET_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/network/public/mojom/websocket.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"


namespace network::mojom {
class HttpHeaderDataView;

class WebSocketHandshakeRequestDataView;

class WebSocketHandshakeResponseDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::HttpHeaderDataView> {
  using Data = ::network::mojom::internal::HttpHeader_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::WebSocketHandshakeRequestDataView> {
  using Data = ::network::mojom::internal::WebSocketHandshakeRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::WebSocketHandshakeResponseDataView> {
  using Data = ::network::mojom::internal::WebSocketHandshakeResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class WebSocketMessageType : int32_t {
  
  CONTINUATION = 0,
  
  TEXT = 1,
  
  BINARY = 2,
  
  LAST = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, WebSocketMessageType value);
inline bool IsKnownEnumValue(WebSocketMessageType value) {
  return internal::WebSocketMessageType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class WebSocketAuthenticationHandlerInterfaceBase {};

using WebSocketAuthenticationHandlerPtrDataView =
    mojo::InterfacePtrDataView<WebSocketAuthenticationHandlerInterfaceBase>;
using WebSocketAuthenticationHandlerRequestDataView =
    mojo::InterfaceRequestDataView<WebSocketAuthenticationHandlerInterfaceBase>;
using WebSocketAuthenticationHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebSocketAuthenticationHandlerInterfaceBase>;
using WebSocketAuthenticationHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebSocketAuthenticationHandlerInterfaceBase>;
class WebSocketHandshakeClientInterfaceBase {};

using WebSocketHandshakeClientPtrDataView =
    mojo::InterfacePtrDataView<WebSocketHandshakeClientInterfaceBase>;
using WebSocketHandshakeClientRequestDataView =
    mojo::InterfaceRequestDataView<WebSocketHandshakeClientInterfaceBase>;
using WebSocketHandshakeClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebSocketHandshakeClientInterfaceBase>;
using WebSocketHandshakeClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebSocketHandshakeClientInterfaceBase>;
class WebSocketClientInterfaceBase {};

using WebSocketClientPtrDataView =
    mojo::InterfacePtrDataView<WebSocketClientInterfaceBase>;
using WebSocketClientRequestDataView =
    mojo::InterfaceRequestDataView<WebSocketClientInterfaceBase>;
using WebSocketClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebSocketClientInterfaceBase>;
using WebSocketClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebSocketClientInterfaceBase>;
class WebSocketInterfaceBase {};

using WebSocketPtrDataView =
    mojo::InterfacePtrDataView<WebSocketInterfaceBase>;
using WebSocketRequestDataView =
    mojo::InterfaceRequestDataView<WebSocketInterfaceBase>;
using WebSocketAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebSocketInterfaceBase>;
using WebSocketAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebSocketInterfaceBase>;


class HttpHeaderDataView {
 public:
  HttpHeaderDataView() = default;

  HttpHeaderDataView(
      internal::HttpHeader_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::HttpHeader_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebSocketHandshakeRequestDataView {
 public:
  WebSocketHandshakeRequestDataView() = default;

  WebSocketHandshakeRequestDataView(
      internal::WebSocketHandshakeRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetHeadersDataView(
      mojo::ArrayDataView<HttpHeaderDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeaders(UserType* output) {
    
    auto* pointer = data_->headers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::HttpHeaderDataView>>(
        pointer, output, message_);
  }
  inline void GetHeadersTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeadersText(UserType* output) {
    
    auto* pointer = data_->headers_text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebSocketHandshakeRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebSocketHandshakeResponseDataView {
 public:
  WebSocketHandshakeResponseDataView() = default;

  WebSocketHandshakeResponseDataView(
      internal::WebSocketHandshakeResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetHttpVersionDataView(
      ::network::mojom::HttpVersionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHttpVersion(UserType* output) {
    
    auto* pointer = data_->http_version.Get();
    return mojo::internal::Deserialize<::network::mojom::HttpVersionDataView>(
        pointer, output, message_);
  }
  int32_t status_code() const {
    return data_->status_code;
  }
  inline void GetStatusTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStatusText(UserType* output) {
    
    auto* pointer = data_->status_text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetRemoteEndpointDataView(
      ::network::mojom::IPEndPointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRemoteEndpoint(UserType* output) {
    
    auto* pointer = data_->remote_endpoint.Get();
    return mojo::internal::Deserialize<::network::mojom::IPEndPointDataView>(
        pointer, output, message_);
  }
  inline void GetHeadersDataView(
      mojo::ArrayDataView<HttpHeaderDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeaders(UserType* output) {
    
    auto* pointer = data_->headers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::HttpHeaderDataView>>(
        pointer, output, message_);
  }
  inline void GetHeadersTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeadersText(UserType* output) {
    
    auto* pointer = data_->headers_text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSelectedProtocolDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelectedProtocol(UserType* output) {
    
    auto* pointer = data_->selected_protocol.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetExtensionsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtensions(UserType* output) {
    
    auto* pointer = data_->extensions.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebSocketHandshakeResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_WEBSOCKET_MOJOM_DATA_VIEW_H_