// services/network/public/mojom/websocket.mojom-blink-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_WEBSOCKET_MOJOM_BLINK_TEST_UTILS_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_WEBSOCKET_MOJOM_BLINK_TEST_UTILS_H_

#include "services/network/public/mojom/websocket.mojom-blink.h"
#include "third_party/blink/public/platform/web_common.h"


namespace network::mojom::blink {


class BLINK_PLATFORM_EXPORT WebSocketAuthenticationHandlerInterceptorForTesting : public WebSocketAuthenticationHandler {
  virtual WebSocketAuthenticationHandler* GetForwardingInterface() = 0;
  void OnAuthRequired(const ::net::AuthChallengeInfo& info, ::network::mojom::blink::HttpResponseHeadersPtr headers, const ::net::IPEndPoint& remote_endpoint, OnAuthRequiredCallback callback) override;
};
class BLINK_PLATFORM_EXPORT WebSocketAuthenticationHandlerAsyncWaiter {
 public:
  explicit WebSocketAuthenticationHandlerAsyncWaiter(WebSocketAuthenticationHandler* proxy);

  WebSocketAuthenticationHandlerAsyncWaiter(const WebSocketAuthenticationHandlerAsyncWaiter&) = delete;
  WebSocketAuthenticationHandlerAsyncWaiter& operator=(const WebSocketAuthenticationHandlerAsyncWaiter&) = delete;

  ~WebSocketAuthenticationHandlerAsyncWaiter();
  void OnAuthRequired(
      const ::net::AuthChallengeInfo& info, ::network::mojom::blink::HttpResponseHeadersPtr headers, const ::net::IPEndPoint& remote_endpoint, ::network::mojom::blink::AuthCredentialsPtr* out_credentials);
  ::network::mojom::blink::AuthCredentialsPtr OnAuthRequired(const ::net::AuthChallengeInfo& info, ::network::mojom::blink::HttpResponseHeadersPtr headers, const ::net::IPEndPoint& remote_endpoint);

 private:
  WebSocketAuthenticationHandler* const proxy_;
};


class BLINK_PLATFORM_EXPORT WebSocketHandshakeClientInterceptorForTesting : public WebSocketHandshakeClient {
  virtual WebSocketHandshakeClient* GetForwardingInterface() = 0;
  void OnOpeningHandshakeStarted(WebSocketHandshakeRequestPtr request) override;
  void OnFailure(const ::blink::String& message, int32_t net_error, int32_t response_code) override;
  void OnConnectionEstablished(::mojo::PendingRemote<WebSocket> socket, ::mojo::PendingReceiver<WebSocketClient> client_receiver, WebSocketHandshakeResponsePtr response, ::mojo::ScopedDataPipeConsumerHandle readable, ::mojo::ScopedDataPipeProducerHandle writable) override;
};
class BLINK_PLATFORM_EXPORT WebSocketHandshakeClientAsyncWaiter {
 public:
  explicit WebSocketHandshakeClientAsyncWaiter(WebSocketHandshakeClient* proxy);

  WebSocketHandshakeClientAsyncWaiter(const WebSocketHandshakeClientAsyncWaiter&) = delete;
  WebSocketHandshakeClientAsyncWaiter& operator=(const WebSocketHandshakeClientAsyncWaiter&) = delete;

  ~WebSocketHandshakeClientAsyncWaiter();

 private:
  WebSocketHandshakeClient* const proxy_;
};


class BLINK_PLATFORM_EXPORT WebSocketClientInterceptorForTesting : public WebSocketClient {
  virtual WebSocketClient* GetForwardingInterface() = 0;
  void OnDataFrame(bool fin, WebSocketMessageType type, uint64_t data_length) override;
  void OnDropChannel(bool was_clean, uint16_t code, const ::blink::String& reason) override;
  void OnClosingHandshake() override;
};
class BLINK_PLATFORM_EXPORT WebSocketClientAsyncWaiter {
 public:
  explicit WebSocketClientAsyncWaiter(WebSocketClient* proxy);

  WebSocketClientAsyncWaiter(const WebSocketClientAsyncWaiter&) = delete;
  WebSocketClientAsyncWaiter& operator=(const WebSocketClientAsyncWaiter&) = delete;

  ~WebSocketClientAsyncWaiter();

 private:
  WebSocketClient* const proxy_;
};


class BLINK_PLATFORM_EXPORT WebSocketInterceptorForTesting : public WebSocket {
  virtual WebSocket* GetForwardingInterface() = 0;
  void SendMessage(WebSocketMessageType type, uint64_t data_length) override;
  void StartReceiving() override;
  void StartClosingHandshake(uint16_t code, const ::blink::String& reason) override;
};
class BLINK_PLATFORM_EXPORT WebSocketAsyncWaiter {
 public:
  explicit WebSocketAsyncWaiter(WebSocket* proxy);

  WebSocketAsyncWaiter(const WebSocketAsyncWaiter&) = delete;
  WebSocketAsyncWaiter& operator=(const WebSocketAsyncWaiter&) = delete;

  ~WebSocketAsyncWaiter();

 private:
  WebSocket* const proxy_;
};




}  // network::mojom::blink

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_WEBSOCKET_MOJOM_BLINK_TEST_UTILS_H_