// services/network/public/mojom/web_transport.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_WEB_TRANSPORT_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_WEB_TRANSPORT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/web_transport.mojom-shared-internal.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/network/public/mojom/web_transport.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::WebTransportErrorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::WebTransportErrorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::WebTransportError_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->net_error = Traits::net_error(input);

    fragment->quic_error = Traits::quic_error(input);

    decltype(Traits::details(input)) in_details = Traits::details(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->details)::BaseType> details_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_details,
      details_fragment);

    fragment->details.Set(
        details_fragment.is_null() ? nullptr : details_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->details.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null details in WebTransportError struct");

    fragment->safe_to_report_details = Traits::safe_to_report_details(input);
  }

  static bool Deserialize(::network::mojom::internal::WebTransportError_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::WebTransportErrorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::WebTransportCertificateFingerprintDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::WebTransportCertificateFingerprintDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::WebTransportCertificateFingerprint_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::algorithm(input)) in_algorithm = Traits::algorithm(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->algorithm)::BaseType> algorithm_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_algorithm,
      algorithm_fragment);

    fragment->algorithm.Set(
        algorithm_fragment.is_null() ? nullptr : algorithm_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->algorithm.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null algorithm in WebTransportCertificateFingerprint struct");

    decltype(Traits::fingerprint(input)) in_fingerprint = Traits::fingerprint(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->fingerprint)::BaseType> fingerprint_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_fingerprint,
      fingerprint_fragment);

    fragment->fingerprint.Set(
        fingerprint_fragment.is_null() ? nullptr : fingerprint_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->fingerprint.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null fingerprint in WebTransportCertificateFingerprint struct");
  }

  static bool Deserialize(::network::mojom::internal::WebTransportCertificateFingerprint_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::WebTransportCertificateFingerprintDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::WebTransportCloseInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::WebTransportCloseInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::WebTransportCloseInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->code = Traits::code(input);

    decltype(Traits::reason(input)) in_reason = Traits::reason(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->reason)::BaseType> reason_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_reason,
      reason_fragment);

    fragment->reason.Set(
        reason_fragment.is_null() ? nullptr : reason_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->reason.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null reason in WebTransportCloseInfo struct");
  }

  static bool Deserialize(::network::mojom::internal::WebTransportCloseInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::WebTransportCloseInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::WebTransportStatsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::WebTransportStatsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::WebTransportStats_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->timestamp)::BaseType> timestamp_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_timestamp,
      timestamp_fragment);

    fragment->timestamp.Set(
        timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->timestamp.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null timestamp in WebTransportStats struct");

    decltype(Traits::min_rtt(input)) in_min_rtt = Traits::min_rtt(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->min_rtt)::BaseType> min_rtt_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_min_rtt,
      min_rtt_fragment);

    fragment->min_rtt.Set(
        min_rtt_fragment.is_null() ? nullptr : min_rtt_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->min_rtt.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null min_rtt in WebTransportStats struct");

    decltype(Traits::smoothed_rtt(input)) in_smoothed_rtt = Traits::smoothed_rtt(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->smoothed_rtt)::BaseType> smoothed_rtt_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_smoothed_rtt,
      smoothed_rtt_fragment);

    fragment->smoothed_rtt.Set(
        smoothed_rtt_fragment.is_null() ? nullptr : smoothed_rtt_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->smoothed_rtt.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null smoothed_rtt in WebTransportStats struct");

    decltype(Traits::rtt_variation(input)) in_rtt_variation = Traits::rtt_variation(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->rtt_variation)::BaseType> rtt_variation_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_rtt_variation,
      rtt_variation_fragment);

    fragment->rtt_variation.Set(
        rtt_variation_fragment.is_null() ? nullptr : rtt_variation_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->rtt_variation.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null rtt_variation in WebTransportStats struct");

    fragment->estimated_send_rate_bps = Traits::estimated_send_rate_bps(input);

    fragment->datagrams_expired_outgoing = Traits::datagrams_expired_outgoing(input);

    fragment->datagrams_lost_outgoing = Traits::datagrams_lost_outgoing(input);
  }

  static bool Deserialize(::network::mojom::internal::WebTransportStats_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::WebTransportStatsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void WebTransportErrorDataView::GetDetailsDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->details.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void WebTransportCertificateFingerprintDataView::GetAlgorithmDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->algorithm.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebTransportCertificateFingerprintDataView::GetFingerprintDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->fingerprint.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void WebTransportCloseInfoDataView::GetReasonDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->reason.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void WebTransportStatsDataView::GetTimestampDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->timestamp.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void WebTransportStatsDataView::GetMinRttDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->min_rtt.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void WebTransportStatsDataView::GetSmoothedRttDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->smoothed_rtt.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void WebTransportStatsDataView::GetRttVariationDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->rtt_variation.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_WEB_TRANSPORT_MOJOM_SHARED_H_