// services/network/public/mojom/web_transport.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_WEB_TRANSPORT_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_WEB_TRANSPORT_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/web_transport.mojom-shared-internal.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"

#include "services/network/public/mojom/web_transport.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::WebTransportErrorDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::WebTransportErrorDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::WebTransportError_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->net_error = Traits::net_error(input);

      fragment->quic_error = Traits::quic_error(input);

      decltype(Traits::details(input)) in_details = Traits::details(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->details)::BaseType> details_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_details,
        details_fragment);

      fragment->details.Set(
          details_fragment.is_null() ? nullptr : details_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->details.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null details in WebTransportError struct");

      fragment->safe_to_report_details = Traits::safe_to_report_details(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::WebTransportCertificateFingerprintDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::WebTransportCertificateFingerprintDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::WebTransportCertificateFingerprint_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::algorithm(input)) in_algorithm = Traits::algorithm(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->algorithm)::BaseType> algorithm_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_algorithm,
        algorithm_fragment);

      fragment->algorithm.Set(
          algorithm_fragment.is_null() ? nullptr : algorithm_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->algorithm.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null algorithm in WebTransportCertificateFingerprint struct");

      decltype(Traits::fingerprint(input)) in_fingerprint = Traits::fingerprint(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->fingerprint)::BaseType> fingerprint_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_fingerprint,
        fingerprint_fragment);

      fragment->fingerprint.Set(
          fingerprint_fragment.is_null() ? nullptr : fingerprint_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->fingerprint.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null fingerprint in WebTransportCertificateFingerprint struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::WebTransportCloseInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::WebTransportCloseInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::WebTransportCloseInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->code = Traits::code(input);

      decltype(Traits::reason(input)) in_reason = Traits::reason(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->reason)::BaseType> reason_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_reason,
        reason_fragment);

      fragment->reason.Set(
          reason_fragment.is_null() ? nullptr : reason_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->reason.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null reason in WebTransportCloseInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::WebTransportStatsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::WebTransportStatsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::WebTransportStats_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->timestamp)::BaseType> timestamp_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_timestamp,
        timestamp_fragment);

      fragment->timestamp.Set(
          timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->timestamp.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null timestamp in WebTransportStats struct");

      decltype(Traits::min_rtt(input)) in_min_rtt = Traits::min_rtt(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->min_rtt)::BaseType> min_rtt_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_min_rtt,
        min_rtt_fragment);

      fragment->min_rtt.Set(
          min_rtt_fragment.is_null() ? nullptr : min_rtt_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->min_rtt.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null min_rtt in WebTransportStats struct");

      decltype(Traits::smoothed_rtt(input)) in_smoothed_rtt = Traits::smoothed_rtt(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->smoothed_rtt)::BaseType> smoothed_rtt_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_smoothed_rtt,
        smoothed_rtt_fragment);

      fragment->smoothed_rtt.Set(
          smoothed_rtt_fragment.is_null() ? nullptr : smoothed_rtt_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->smoothed_rtt.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null smoothed_rtt in WebTransportStats struct");

      decltype(Traits::rtt_variation(input)) in_rtt_variation = Traits::rtt_variation(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->rtt_variation)::BaseType> rtt_variation_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_rtt_variation,
        rtt_variation_fragment);

      fragment->rtt_variation.Set(
          rtt_variation_fragment.is_null() ? nullptr : rtt_variation_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->rtt_variation.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null rtt_variation in WebTransportStats struct");

      fragment->estimated_send_rate_bps = Traits::estimated_send_rate_bps(input);

      fragment->datagrams_expired_outgoing = Traits::datagrams_expired_outgoing(input);

      fragment->datagrams_lost_outgoing = Traits::datagrams_lost_outgoing(input);
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_WEB_TRANSPORT_MOJOM_SEND_VALIDATION_H_