// services/network/public/mojom/web_transport.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('network.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.WebTransportPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.WebTransport.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.WebTransportInterface }
 */
network.mojom.WebTransportRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.WebTransportPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.WebTransportPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.WebTransportPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase.mojom.ReadOnlyBuffer } data
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  sendDatagram(
      data) {
    return this.proxy.sendMessage(
        0,
        network.mojom.WebTransport_SendDatagram_ParamsSpec.$,
        network.mojom.WebTransport_SendDatagram_ResponseParamsSpec.$,
        [
          data
        ],
        false);
  }

  
  /**
   * @param { !MojoHandle } readable
   * @param { ?MojoHandle } writable
   * @return {!Promise<{
        succeeded: !boolean,
        streamId: !number,
   *  }>}
   */

  createStream(
      readable,
      writable) {
    return this.proxy.sendMessage(
        1,
        network.mojom.WebTransport_CreateStream_ParamsSpec.$,
        network.mojom.WebTransport_CreateStream_ResponseParamsSpec.$,
        [
          readable,
          writable
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        streamId: !number,
        readable: !MojoHandle,
        writable: !MojoHandle,
   *  }>}
   */

  acceptBidirectionalStream() {
    return this.proxy.sendMessage(
        2,
        network.mojom.WebTransport_AcceptBidirectionalStream_ParamsSpec.$,
        network.mojom.WebTransport_AcceptBidirectionalStream_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        streamId: !number,
        readable: !MojoHandle,
   *  }>}
   */

  acceptUnidirectionalStream() {
    return this.proxy.sendMessage(
        3,
        network.mojom.WebTransport_AcceptUnidirectionalStream_ParamsSpec.$,
        network.mojom.WebTransport_AcceptUnidirectionalStream_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } streamId
   */

  sendFin(
      streamId) {
    this.proxy.sendMessage(
        4,
        network.mojom.WebTransport_SendFin_ParamsSpec.$,
        null,
        [
          streamId
        ],
        false);
  }

  
  /**
   * @param { !number } streamId
   * @param { !number } code
   */

  abortStream(
      streamId,
      code) {
    this.proxy.sendMessage(
        5,
        network.mojom.WebTransport_AbortStream_ParamsSpec.$,
        null,
        [
          streamId,
          code
        ],
        false);
  }

  
  /**
   * @param { !number } streamId
   * @param { !number } code
   */

  stopSending(
      streamId,
      code) {
    this.proxy.sendMessage(
        6,
        network.mojom.WebTransport_StopSending_ParamsSpec.$,
        null,
        [
          streamId,
          code
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.TimeDelta } duration
   */

  setOutgoingDatagramExpirationDuration(
      duration) {
    this.proxy.sendMessage(
        7,
        network.mojom.WebTransport_SetOutgoingDatagramExpirationDuration_ParamsSpec.$,
        null,
        [
          duration
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        stats: ?network.mojom.WebTransportStats,
   *  }>}
   */

  getStats() {
    return this.proxy.sendMessage(
        8,
        network.mojom.WebTransport_GetStats_ParamsSpec.$,
        network.mojom.WebTransport_GetStats_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { ?network.mojom.WebTransportCloseInfo } closeInfo
   */

  close(
      closeInfo) {
    this.proxy.sendMessage(
        9,
        network.mojom.WebTransport_Close_ParamsSpec.$,
        null,
        [
          closeInfo
        ],
        false);
  }
};

/**
 * An object which receives request messages for the WebTransport
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.WebTransportReceiver = class {
  /**
   * @param {!network.mojom.WebTransportInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.WebTransportRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.WebTransportRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.WebTransportRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.WebTransport_SendDatagram_ParamsSpec.$,
        network.mojom.WebTransport_SendDatagram_ResponseParamsSpec.$,
        impl.sendDatagram.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.WebTransport_CreateStream_ParamsSpec.$,
        network.mojom.WebTransport_CreateStream_ResponseParamsSpec.$,
        impl.createStream.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        network.mojom.WebTransport_AcceptBidirectionalStream_ParamsSpec.$,
        network.mojom.WebTransport_AcceptBidirectionalStream_ResponseParamsSpec.$,
        impl.acceptBidirectionalStream.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        network.mojom.WebTransport_AcceptUnidirectionalStream_ParamsSpec.$,
        network.mojom.WebTransport_AcceptUnidirectionalStream_ResponseParamsSpec.$,
        impl.acceptUnidirectionalStream.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        network.mojom.WebTransport_SendFin_ParamsSpec.$,
        null,
        impl.sendFin.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        network.mojom.WebTransport_AbortStream_ParamsSpec.$,
        null,
        impl.abortStream.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        network.mojom.WebTransport_StopSending_ParamsSpec.$,
        null,
        impl.stopSending.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        network.mojom.WebTransport_SetOutgoingDatagramExpirationDuration_ParamsSpec.$,
        null,
        impl.setOutgoingDatagramExpirationDuration.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        network.mojom.WebTransport_GetStats_ParamsSpec.$,
        network.mojom.WebTransport_GetStats_ResponseParamsSpec.$,
        impl.getStats.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        network.mojom.WebTransport_Close_ParamsSpec.$,
        null,
        impl.close.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.WebTransport = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.WebTransport";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.WebTransportRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.WebTransportRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the WebTransport
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.WebTransportCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.WebTransportRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.WebTransportRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendDatagram =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.WebTransport_SendDatagram_ParamsSpec.$,
        network.mojom.WebTransport_SendDatagram_ResponseParamsSpec.$,
        this.sendDatagram.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createStream =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.WebTransport_CreateStream_ParamsSpec.$,
        network.mojom.WebTransport_CreateStream_ResponseParamsSpec.$,
        this.createStream.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.acceptBidirectionalStream =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        network.mojom.WebTransport_AcceptBidirectionalStream_ParamsSpec.$,
        network.mojom.WebTransport_AcceptBidirectionalStream_ResponseParamsSpec.$,
        this.acceptBidirectionalStream.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.acceptUnidirectionalStream =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        network.mojom.WebTransport_AcceptUnidirectionalStream_ParamsSpec.$,
        network.mojom.WebTransport_AcceptUnidirectionalStream_ResponseParamsSpec.$,
        this.acceptUnidirectionalStream.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendFin =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        network.mojom.WebTransport_SendFin_ParamsSpec.$,
        null,
        this.sendFin.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.abortStream =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        network.mojom.WebTransport_AbortStream_ParamsSpec.$,
        null,
        this.abortStream.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stopSending =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        network.mojom.WebTransport_StopSending_ParamsSpec.$,
        null,
        this.stopSending.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setOutgoingDatagramExpirationDuration =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        network.mojom.WebTransport_SetOutgoingDatagramExpirationDuration_ParamsSpec.$,
        null,
        this.setOutgoingDatagramExpirationDuration.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getStats =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        network.mojom.WebTransport_GetStats_ParamsSpec.$,
        network.mojom.WebTransport_GetStats_ResponseParamsSpec.$,
        this.getStats.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.close =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        network.mojom.WebTransport_Close_ParamsSpec.$,
        null,
        this.close.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.WebTransportClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.WebTransportClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.WebTransportClientInterface }
 */
network.mojom.WebTransportClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.WebTransportClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.WebTransportClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.WebTransportClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase.mojom.ReadOnlyBuffer } data
   */

  onDatagramReceived(
      data) {
    this.proxy.sendMessage(
        0,
        network.mojom.WebTransportClient_OnDatagramReceived_ParamsSpec.$,
        null,
        [
          data
        ],
        false);
  }

  
  /**
   * @param { !number } streamId
   * @param { !boolean } finReceived
   */

  onIncomingStreamClosed(
      streamId,
      finReceived) {
    this.proxy.sendMessage(
        1,
        network.mojom.WebTransportClient_OnIncomingStreamClosed_ParamsSpec.$,
        null,
        [
          streamId,
          finReceived
        ],
        false);
  }

  
  /**
   * @param { !number } streamId
   */

  onOutgoingStreamClosed(
      streamId) {
    this.proxy.sendMessage(
        2,
        network.mojom.WebTransportClient_OnOutgoingStreamClosed_ParamsSpec.$,
        null,
        [
          streamId
        ],
        false);
  }

  
  /**
   * @param { !number } streamId
   * @param { !number } streamErrorCode
   */

  onReceivedStopSending(
      streamId,
      streamErrorCode) {
    this.proxy.sendMessage(
        3,
        network.mojom.WebTransportClient_OnReceivedStopSending_ParamsSpec.$,
        null,
        [
          streamId,
          streamErrorCode
        ],
        false);
  }

  
  /**
   * @param { !number } streamId
   * @param { !number } streamErrorCode
   */

  onReceivedResetStream(
      streamId,
      streamErrorCode) {
    this.proxy.sendMessage(
        4,
        network.mojom.WebTransportClient_OnReceivedResetStream_ParamsSpec.$,
        null,
        [
          streamId,
          streamErrorCode
        ],
        false);
  }

  
  /**
   * @param { ?network.mojom.WebTransportCloseInfo } closeInfo
   * @param { !network.mojom.WebTransportStats } finalStats
   */

  onClosed(
      closeInfo,
      finalStats) {
    this.proxy.sendMessage(
        5,
        network.mojom.WebTransportClient_OnClosed_ParamsSpec.$,
        null,
        [
          closeInfo,
          finalStats
        ],
        false);
  }
};

/**
 * An object which receives request messages for the WebTransportClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.WebTransportClientReceiver = class {
  /**
   * @param {!network.mojom.WebTransportClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.WebTransportClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.WebTransportClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.WebTransportClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.WebTransportClient_OnDatagramReceived_ParamsSpec.$,
        null,
        impl.onDatagramReceived.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.WebTransportClient_OnIncomingStreamClosed_ParamsSpec.$,
        null,
        impl.onIncomingStreamClosed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        network.mojom.WebTransportClient_OnOutgoingStreamClosed_ParamsSpec.$,
        null,
        impl.onOutgoingStreamClosed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        network.mojom.WebTransportClient_OnReceivedStopSending_ParamsSpec.$,
        null,
        impl.onReceivedStopSending.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        network.mojom.WebTransportClient_OnReceivedResetStream_ParamsSpec.$,
        null,
        impl.onReceivedResetStream.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        network.mojom.WebTransportClient_OnClosed_ParamsSpec.$,
        null,
        impl.onClosed.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.WebTransportClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.WebTransportClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.WebTransportClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.WebTransportClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the WebTransportClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.WebTransportClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.WebTransportClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.WebTransportClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDatagramReceived =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.WebTransportClient_OnDatagramReceived_ParamsSpec.$,
        null,
        this.onDatagramReceived.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onIncomingStreamClosed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.WebTransportClient_OnIncomingStreamClosed_ParamsSpec.$,
        null,
        this.onIncomingStreamClosed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onOutgoingStreamClosed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        network.mojom.WebTransportClient_OnOutgoingStreamClosed_ParamsSpec.$,
        null,
        this.onOutgoingStreamClosed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReceivedStopSending =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        network.mojom.WebTransportClient_OnReceivedStopSending_ParamsSpec.$,
        null,
        this.onReceivedStopSending.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReceivedResetStream =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        network.mojom.WebTransportClient_OnReceivedResetStream_ParamsSpec.$,
        null,
        this.onReceivedResetStream.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onClosed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        network.mojom.WebTransportClient_OnClosed_ParamsSpec.$,
        null,
        this.onClosed.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.WebTransportHandshakeClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.WebTransportHandshakeClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.WebTransportHandshakeClientInterface }
 */
network.mojom.WebTransportHandshakeClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.WebTransportHandshakeClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.WebTransportHandshakeClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.WebTransportHandshakeClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.IPEndPoint } serverAddress
   */

  onBeforeConnect(
      serverAddress) {
    this.proxy.sendMessage(
        0,
        network.mojom.WebTransportHandshakeClient_OnBeforeConnect_ParamsSpec.$,
        null,
        [
          serverAddress
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.WebTransportRemote } transport
   * @param { !network.mojom.WebTransportClientPendingReceiver } client
   * @param { !network.mojom.HttpResponseHeaders } responseHeaders
   * @param { ?string } selectedApplicationProtocol
   * @param { !network.mojom.WebTransportStats } initialStats
   */

  onConnectionEstablished(
      transport,
      client,
      responseHeaders,
      selectedApplicationProtocol,
      initialStats) {
    this.proxy.sendMessage(
        1,
        network.mojom.WebTransportHandshakeClient_OnConnectionEstablished_ParamsSpec.$,
        null,
        [
          transport,
          client,
          responseHeaders,
          selectedApplicationProtocol,
          initialStats
        ],
        false);
  }

  
  /**
   * @param { ?network.mojom.WebTransportError } error
   */

  onHandshakeFailed(
      error) {
    this.proxy.sendMessage(
        2,
        network.mojom.WebTransportHandshakeClient_OnHandshakeFailed_ParamsSpec.$,
        null,
        [
          error
        ],
        false);
  }
};

/**
 * An object which receives request messages for the WebTransportHandshakeClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.WebTransportHandshakeClientReceiver = class {
  /**
   * @param {!network.mojom.WebTransportHandshakeClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.WebTransportHandshakeClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.WebTransportHandshakeClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.WebTransportHandshakeClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.WebTransportHandshakeClient_OnBeforeConnect_ParamsSpec.$,
        null,
        impl.onBeforeConnect.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.WebTransportHandshakeClient_OnConnectionEstablished_ParamsSpec.$,
        null,
        impl.onConnectionEstablished.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        network.mojom.WebTransportHandshakeClient_OnHandshakeFailed_ParamsSpec.$,
        null,
        impl.onHandshakeFailed.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.WebTransportHandshakeClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.WebTransportHandshakeClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.WebTransportHandshakeClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.WebTransportHandshakeClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the WebTransportHandshakeClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.WebTransportHandshakeClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.WebTransportHandshakeClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.WebTransportHandshakeClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onBeforeConnect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.WebTransportHandshakeClient_OnBeforeConnect_ParamsSpec.$,
        null,
        this.onBeforeConnect.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onConnectionEstablished =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.WebTransportHandshakeClient_OnConnectionEstablished_ParamsSpec.$,
        null,
        this.onConnectionEstablished.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onHandshakeFailed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        network.mojom.WebTransportHandshakeClient_OnHandshakeFailed_ParamsSpec.$,
        null,
        this.onHandshakeFailed.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebTransportErrorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebTransportCertificateFingerprintSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebTransportCloseInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebTransportStatsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebTransport_SendDatagram_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebTransport_SendDatagram_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebTransport_CreateStream_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebTransport_CreateStream_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebTransport_AcceptBidirectionalStream_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebTransport_AcceptBidirectionalStream_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebTransport_AcceptUnidirectionalStream_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebTransport_AcceptUnidirectionalStream_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebTransport_SendFin_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebTransport_AbortStream_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebTransport_StopSending_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebTransport_SetOutgoingDatagramExpirationDuration_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebTransport_GetStats_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebTransport_GetStats_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebTransport_Close_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebTransportClient_OnDatagramReceived_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebTransportClient_OnIncomingStreamClosed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebTransportClient_OnOutgoingStreamClosed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebTransportClient_OnReceivedStopSending_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebTransportClient_OnReceivedResetStream_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebTransportClient_OnClosed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebTransportHandshakeClient_OnBeforeConnect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebTransportHandshakeClient_OnConnectionEstablished_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebTransportHandshakeClient_OnHandshakeFailed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.WebTransportErrorSpec.$,
    'WebTransportError',
    [
      mojo.internal.StructField(
        'netError', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'quicError', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'details', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'safeToReportDetails', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
network.mojom.WebTransportError = class {
  constructor() {
    /** @export { !number } */
    this.netError;
    /** @export { !number } */
    this.quicError;
    /** @export { !string } */
    this.details;
    /** @export { !boolean } */
    this.safeToReportDetails;
  }
};



mojo.internal.Struct(
    network.mojom.WebTransportCertificateFingerprintSpec.$,
    'WebTransportCertificateFingerprint',
    [
      mojo.internal.StructField(
        'algorithm', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fingerprint', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.WebTransportCertificateFingerprint = class {
  constructor() {
    /** @export { !string } */
    this.algorithm;
    /** @export { !string } */
    this.fingerprint;
  }
};



mojo.internal.Struct(
    network.mojom.WebTransportCloseInfoSpec.$,
    'WebTransportCloseInfo',
    [
      mojo.internal.StructField(
        'code', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reason', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.WebTransportCloseInfo = class {
  constructor() {
    /** @export { !number } */
    this.code;
    /** @export { !string } */
    this.reason;
  }
};



mojo.internal.Struct(
    network.mojom.WebTransportStatsSpec.$,
    'WebTransportStats',
    [
      mojo.internal.StructField(
        'timestamp', 0,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'minRtt', 8,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'smoothedRtt', 16,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'rttVariation', 24,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'estimatedSendRateBps', 32,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'datagramsExpiredOutgoing', 40,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'datagramsLostOutgoing', 48,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 64],]);





/** @record */
network.mojom.WebTransportStats = class {
  constructor() {
    /** @export { !mojoBase.mojom.Time } */
    this.timestamp;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.minRtt;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.smoothedRtt;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.rttVariation;
    /** @export { !bigint } */
    this.estimatedSendRateBps;
    /** @export { !bigint } */
    this.datagramsExpiredOutgoing;
    /** @export { !bigint } */
    this.datagramsLostOutgoing;
  }
};



mojo.internal.Struct(
    network.mojom.WebTransport_SendDatagram_ParamsSpec.$,
    'WebTransport_SendDatagram_Params',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojoBase.mojom.ReadOnlyBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.WebTransport_SendDatagram_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.ReadOnlyBuffer } */
    this.data;
  }
};



mojo.internal.Struct(
    network.mojom.WebTransport_SendDatagram_ResponseParamsSpec.$,
    'WebTransport_SendDatagram_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.WebTransport_SendDatagram_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.result;
  }
};



mojo.internal.Struct(
    network.mojom.WebTransport_CreateStream_ParamsSpec.$,
    'WebTransport_CreateStream_Params',
    [
      mojo.internal.StructField(
        'readable', 0,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'writable', 4,
        0,
        mojo.internal.Handle,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.WebTransport_CreateStream_Params = class {
  constructor() {
    /** @export { !MojoHandle } */
    this.readable;
    /** @export { (MojoHandle|undefined) } */
    this.writable;
  }
};



mojo.internal.Struct(
    network.mojom.WebTransport_CreateStream_ResponseParamsSpec.$,
    'WebTransport_CreateStream_ResponseParams',
    [
      mojo.internal.StructField(
        'succeeded', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'streamId', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.WebTransport_CreateStream_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.succeeded;
    /** @export { !number } */
    this.streamId;
  }
};



mojo.internal.Struct(
    network.mojom.WebTransport_AcceptBidirectionalStream_ParamsSpec.$,
    'WebTransport_AcceptBidirectionalStream_Params',
    [
    ],
    [[0, 8],]);





/** @record */
network.mojom.WebTransport_AcceptBidirectionalStream_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.WebTransport_AcceptBidirectionalStream_ResponseParamsSpec.$,
    'WebTransport_AcceptBidirectionalStream_ResponseParams',
    [
      mojo.internal.StructField(
        'streamId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'readable', 4,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'writable', 8,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.WebTransport_AcceptBidirectionalStream_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.streamId;
    /** @export { !MojoHandle } */
    this.readable;
    /** @export { !MojoHandle } */
    this.writable;
  }
};



mojo.internal.Struct(
    network.mojom.WebTransport_AcceptUnidirectionalStream_ParamsSpec.$,
    'WebTransport_AcceptUnidirectionalStream_Params',
    [
    ],
    [[0, 8],]);





/** @record */
network.mojom.WebTransport_AcceptUnidirectionalStream_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.WebTransport_AcceptUnidirectionalStream_ResponseParamsSpec.$,
    'WebTransport_AcceptUnidirectionalStream_ResponseParams',
    [
      mojo.internal.StructField(
        'streamId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'readable', 4,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.WebTransport_AcceptUnidirectionalStream_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.streamId;
    /** @export { !MojoHandle } */
    this.readable;
  }
};



mojo.internal.Struct(
    network.mojom.WebTransport_SendFin_ParamsSpec.$,
    'WebTransport_SendFin_Params',
    [
      mojo.internal.StructField(
        'streamId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.WebTransport_SendFin_Params = class {
  constructor() {
    /** @export { !number } */
    this.streamId;
  }
};



mojo.internal.Struct(
    network.mojom.WebTransport_AbortStream_ParamsSpec.$,
    'WebTransport_AbortStream_Params',
    [
      mojo.internal.StructField(
        'streamId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'code', 4,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.WebTransport_AbortStream_Params = class {
  constructor() {
    /** @export { !number } */
    this.streamId;
    /** @export { !number } */
    this.code;
  }
};



mojo.internal.Struct(
    network.mojom.WebTransport_StopSending_ParamsSpec.$,
    'WebTransport_StopSending_Params',
    [
      mojo.internal.StructField(
        'streamId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'code', 4,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.WebTransport_StopSending_Params = class {
  constructor() {
    /** @export { !number } */
    this.streamId;
    /** @export { !number } */
    this.code;
  }
};



mojo.internal.Struct(
    network.mojom.WebTransport_SetOutgoingDatagramExpirationDuration_ParamsSpec.$,
    'WebTransport_SetOutgoingDatagramExpirationDuration_Params',
    [
      mojo.internal.StructField(
        'duration', 0,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.WebTransport_SetOutgoingDatagramExpirationDuration_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.duration;
  }
};



mojo.internal.Struct(
    network.mojom.WebTransport_GetStats_ParamsSpec.$,
    'WebTransport_GetStats_Params',
    [
    ],
    [[0, 8],]);





/** @record */
network.mojom.WebTransport_GetStats_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.WebTransport_GetStats_ResponseParamsSpec.$,
    'WebTransport_GetStats_ResponseParams',
    [
      mojo.internal.StructField(
        'stats', 0,
        0,
        network.mojom.WebTransportStatsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.WebTransport_GetStats_ResponseParams = class {
  constructor() {
    /** @export { (network.mojom.WebTransportStats|undefined) } */
    this.stats;
  }
};



mojo.internal.Struct(
    network.mojom.WebTransport_Close_ParamsSpec.$,
    'WebTransport_Close_Params',
    [
      mojo.internal.StructField(
        'closeInfo', 0,
        0,
        network.mojom.WebTransportCloseInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.WebTransport_Close_Params = class {
  constructor() {
    /** @export { (network.mojom.WebTransportCloseInfo|undefined) } */
    this.closeInfo;
  }
};



mojo.internal.Struct(
    network.mojom.WebTransportClient_OnDatagramReceived_ParamsSpec.$,
    'WebTransportClient_OnDatagramReceived_Params',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojoBase.mojom.ReadOnlyBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.WebTransportClient_OnDatagramReceived_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.ReadOnlyBuffer } */
    this.data;
  }
};



mojo.internal.Struct(
    network.mojom.WebTransportClient_OnIncomingStreamClosed_ParamsSpec.$,
    'WebTransportClient_OnIncomingStreamClosed_Params',
    [
      mojo.internal.StructField(
        'streamId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'finReceived', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.WebTransportClient_OnIncomingStreamClosed_Params = class {
  constructor() {
    /** @export { !number } */
    this.streamId;
    /** @export { !boolean } */
    this.finReceived;
  }
};



mojo.internal.Struct(
    network.mojom.WebTransportClient_OnOutgoingStreamClosed_ParamsSpec.$,
    'WebTransportClient_OnOutgoingStreamClosed_Params',
    [
      mojo.internal.StructField(
        'streamId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.WebTransportClient_OnOutgoingStreamClosed_Params = class {
  constructor() {
    /** @export { !number } */
    this.streamId;
  }
};



mojo.internal.Struct(
    network.mojom.WebTransportClient_OnReceivedStopSending_ParamsSpec.$,
    'WebTransportClient_OnReceivedStopSending_Params',
    [
      mojo.internal.StructField(
        'streamId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'streamErrorCode', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.WebTransportClient_OnReceivedStopSending_Params = class {
  constructor() {
    /** @export { !number } */
    this.streamId;
    /** @export { !number } */
    this.streamErrorCode;
  }
};



mojo.internal.Struct(
    network.mojom.WebTransportClient_OnReceivedResetStream_ParamsSpec.$,
    'WebTransportClient_OnReceivedResetStream_Params',
    [
      mojo.internal.StructField(
        'streamId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'streamErrorCode', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.WebTransportClient_OnReceivedResetStream_Params = class {
  constructor() {
    /** @export { !number } */
    this.streamId;
    /** @export { !number } */
    this.streamErrorCode;
  }
};



mojo.internal.Struct(
    network.mojom.WebTransportClient_OnClosed_ParamsSpec.$,
    'WebTransportClient_OnClosed_Params',
    [
      mojo.internal.StructField(
        'closeInfo', 0,
        0,
        network.mojom.WebTransportCloseInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'finalStats', 8,
        0,
        network.mojom.WebTransportStatsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.WebTransportClient_OnClosed_Params = class {
  constructor() {
    /** @export { (network.mojom.WebTransportCloseInfo|undefined) } */
    this.closeInfo;
    /** @export { !network.mojom.WebTransportStats } */
    this.finalStats;
  }
};



mojo.internal.Struct(
    network.mojom.WebTransportHandshakeClient_OnBeforeConnect_ParamsSpec.$,
    'WebTransportHandshakeClient_OnBeforeConnect_Params',
    [
      mojo.internal.StructField(
        'serverAddress', 0,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.WebTransportHandshakeClient_OnBeforeConnect_Params = class {
  constructor() {
    /** @export { !network.mojom.IPEndPoint } */
    this.serverAddress;
  }
};



mojo.internal.Struct(
    network.mojom.WebTransportHandshakeClient_OnConnectionEstablished_ParamsSpec.$,
    'WebTransportHandshakeClient_OnConnectionEstablished_Params',
    [
      mojo.internal.StructField(
        'transport', 0,
        0,
        mojo.internal.InterfaceProxy(network.mojom.WebTransportRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'client', 8,
        0,
        mojo.internal.InterfaceRequest(network.mojom.WebTransportClientPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'responseHeaders', 16,
        0,
        network.mojom.HttpResponseHeadersSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'selectedApplicationProtocol', 24,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'initialStats', 32,
        0,
        network.mojom.WebTransportStatsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
network.mojom.WebTransportHandshakeClient_OnConnectionEstablished_Params = class {
  constructor() {
    /** @export { !network.mojom.WebTransportRemote } */
    this.transport;
    /** @export { !network.mojom.WebTransportClientPendingReceiver } */
    this.client;
    /** @export { !network.mojom.HttpResponseHeaders } */
    this.responseHeaders;
    /** @export { (string|undefined) } */
    this.selectedApplicationProtocol;
    /** @export { !network.mojom.WebTransportStats } */
    this.initialStats;
  }
};



mojo.internal.Struct(
    network.mojom.WebTransportHandshakeClient_OnHandshakeFailed_ParamsSpec.$,
    'WebTransportHandshakeClient_OnHandshakeFailed_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        network.mojom.WebTransportErrorSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.WebTransportHandshakeClient_OnHandshakeFailed_Params = class {
  constructor() {
    /** @export { (network.mojom.WebTransportError|undefined) } */
    this.error;
  }
};

