// services/network/public/mojom/web_transport.mojom-blink-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_WEB_TRANSPORT_MOJOM_BLINK_TEST_UTILS_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_WEB_TRANSPORT_MOJOM_BLINK_TEST_UTILS_H_

#include "services/network/public/mojom/web_transport.mojom-blink.h"
#include "third_party/blink/public/platform/web_common.h"


namespace network::mojom::blink {


class BLINK_PLATFORM_EXPORT WebTransportInterceptorForTesting : public WebTransport {
  virtual WebTransport* GetForwardingInterface() = 0;
  void SendDatagram(::base::span<const ::uint8_t> data, SendDatagramCallback callback) override;
  void CreateStream(::mojo::ScopedDataPipeConsumerHandle readable, ::mojo::ScopedDataPipeProducerHandle writable, CreateStreamCallback callback) override;
  void AcceptBidirectionalStream(AcceptBidirectionalStreamCallback callback) override;
  void AcceptUnidirectionalStream(AcceptUnidirectionalStreamCallback callback) override;
  void SendFin(uint32_t stream_id) override;
  void AbortStream(uint32_t stream_id, uint8_t code) override;
  void StopSending(uint32_t stream_id, uint8_t code) override;
  void SetOutgoingDatagramExpirationDuration(::base::TimeDelta duration) override;
  void GetStats(GetStatsCallback callback) override;
  void Close(WebTransportCloseInfoPtr close_info) override;
};
class BLINK_PLATFORM_EXPORT WebTransportAsyncWaiter {
 public:
  explicit WebTransportAsyncWaiter(WebTransport* proxy);

  WebTransportAsyncWaiter(const WebTransportAsyncWaiter&) = delete;
  WebTransportAsyncWaiter& operator=(const WebTransportAsyncWaiter&) = delete;

  ~WebTransportAsyncWaiter();
  void SendDatagram(
      ::base::span<const ::uint8_t> data, bool* out_result);
  bool SendDatagram(::base::span<const ::uint8_t> data);
  void CreateStream(
      ::mojo::ScopedDataPipeConsumerHandle readable, ::mojo::ScopedDataPipeProducerHandle writable, bool* out_succeeded, uint32_t* out_stream_id);
  
  void AcceptBidirectionalStream(
      uint32_t* out_stream_id, ::mojo::ScopedDataPipeConsumerHandle* out_readable, ::mojo::ScopedDataPipeProducerHandle* out_writable);
  
  void AcceptUnidirectionalStream(
      uint32_t* out_stream_id, ::mojo::ScopedDataPipeConsumerHandle* out_readable);
  
  void GetStats(
      WebTransportStatsPtr* out_stats);
  WebTransportStatsPtr GetStats();

 private:
  WebTransport* const proxy_;
};


class BLINK_PLATFORM_EXPORT WebTransportClientInterceptorForTesting : public WebTransportClient {
  virtual WebTransportClient* GetForwardingInterface() = 0;
  void OnDatagramReceived(::base::span<const ::uint8_t> data) override;
  void OnIncomingStreamClosed(uint32_t stream_id, bool fin_received) override;
  void OnOutgoingStreamClosed(uint32_t stream_id) override;
  void OnReceivedStopSending(uint32_t stream_id, uint32_t stream_error_code) override;
  void OnReceivedResetStream(uint32_t stream_id, uint32_t stream_error_code) override;
  void OnClosed(WebTransportCloseInfoPtr close_info, WebTransportStatsPtr final_stats) override;
};
class BLINK_PLATFORM_EXPORT WebTransportClientAsyncWaiter {
 public:
  explicit WebTransportClientAsyncWaiter(WebTransportClient* proxy);

  WebTransportClientAsyncWaiter(const WebTransportClientAsyncWaiter&) = delete;
  WebTransportClientAsyncWaiter& operator=(const WebTransportClientAsyncWaiter&) = delete;

  ~WebTransportClientAsyncWaiter();

 private:
  WebTransportClient* const proxy_;
};


class BLINK_PLATFORM_EXPORT WebTransportHandshakeClientInterceptorForTesting : public WebTransportHandshakeClient {
  virtual WebTransportHandshakeClient* GetForwardingInterface() = 0;
  void OnBeforeConnect(const ::net::IPEndPoint& server_address) override;
  void OnConnectionEstablished(::mojo::PendingRemote<WebTransport> transport, ::mojo::PendingReceiver<WebTransportClient> client, ::network::mojom::blink::HttpResponseHeadersPtr response_headers, const ::blink::String& selected_application_protocol, WebTransportStatsPtr initial_stats) override;
  void OnHandshakeFailed(WebTransportErrorPtr error) override;
};
class BLINK_PLATFORM_EXPORT WebTransportHandshakeClientAsyncWaiter {
 public:
  explicit WebTransportHandshakeClientAsyncWaiter(WebTransportHandshakeClient* proxy);

  WebTransportHandshakeClientAsyncWaiter(const WebTransportHandshakeClientAsyncWaiter&) = delete;
  WebTransportHandshakeClientAsyncWaiter& operator=(const WebTransportHandshakeClientAsyncWaiter&) = delete;

  ~WebTransportHandshakeClientAsyncWaiter();

 private:
  WebTransportHandshakeClient* const proxy_;
};




}  // network::mojom::blink

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_WEB_TRANSPORT_MOJOM_BLINK_TEST_UTILS_H_