// services/network/public/mojom/web_bundle_handle.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/web_bundle_handle.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/web_bundle_handle.mojom-params-data.h"
#include "services/network/public/mojom/web_bundle_handle.mojom-shared-message-ids.h"

#include "services/network/public/mojom/web_bundle_handle.mojom-blink-import-headers.h"
#include "services/network/public/mojom/web_bundle_handle.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace network::mojom::blink {
// The declaration includes the definition on other builds.

WebBundleHandle::IPCStableHashFunction WebBundleHandle::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebBundleHandle>(message.name())) {
    case messages::WebBundleHandle::kClone: {
      return &WebBundleHandle::Clone_Sym::IPCStableHash;
    }
    case messages::WebBundleHandle::kOnWebBundleError: {
      return &WebBundleHandle::OnWebBundleError_Sym::IPCStableHash;
    }
    case messages::WebBundleHandle::kOnWebBundleLoadFinished: {
      return &WebBundleHandle::OnWebBundleLoadFinished_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebBundleHandle::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebBundleHandle>(message.name())) {
      case messages::WebBundleHandle::kClone:
            return "Receive network::mojom::WebBundleHandle::Clone";
      case messages::WebBundleHandle::kOnWebBundleError:
            return "Receive network::mojom::WebBundleHandle::OnWebBundleError";
      case messages::WebBundleHandle::kOnWebBundleLoadFinished:
            return "Receive network::mojom::WebBundleHandle::OnWebBundleLoadFinished";
    }
  } else {
    switch (static_cast<messages::WebBundleHandle>(message.name())) {
      case messages::WebBundleHandle::kClone:
            return "Receive reply network::mojom::WebBundleHandle::Clone";
      case messages::WebBundleHandle::kOnWebBundleError:
            return "Receive reply network::mojom::WebBundleHandle::OnWebBundleError";
      case messages::WebBundleHandle::kOnWebBundleLoadFinished:
            return "Receive reply network::mojom::WebBundleHandle::OnWebBundleLoadFinished";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebBundleHandle::Clone_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x62d726a5;  // IPCStableHash for network::mojom::WebBundleHandle::Clone
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebBundleHandle::OnWebBundleError_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfc0c9796;  // IPCStableHash for network::mojom::WebBundleHandle::OnWebBundleError
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebBundleHandle::OnWebBundleLoadFinished_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9d08978a;  // IPCStableHash for network::mojom::WebBundleHandle::OnWebBundleLoadFinished
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

WebBundleHandleProxy::WebBundleHandleProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebBundleHandleProxy::Clone(
    ::mojo::PendingReceiver<WebBundleHandle> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::WebBundleHandle::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<WebBundleHandle>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBundleHandle::kClone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebBundleHandle_Clone_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::WebBundleHandleInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in WebBundleHandle.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBundleHandle::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebBundleHandleProxy::OnWebBundleError(
    WebBundleErrorType in_type, const ::blink::String& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::WebBundleHandle::OnWebBundleError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type WebBundleErrorType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBundleHandle::kOnWebBundleError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebBundleHandle_OnWebBundleError_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::network::mojom::WebBundleErrorType>(
    in_type,
    &params->type);
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in WebBundleHandle.OnWebBundleError request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBundleHandle::Name_);
  message.set_method_name("OnWebBundleError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebBundleHandleProxy::OnWebBundleLoadFinished(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::WebBundleHandle::OnWebBundleLoadFinished", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBundleHandle::kOnWebBundleLoadFinished), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebBundleHandle_OnWebBundleLoadFinished_Params_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBundleHandle::Name_);
  message.set_method_name("OnWebBundleLoadFinished");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool WebBundleHandleStubDispatch::Accept(
    WebBundleHandle* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebBundleHandle>(message->header()->name)) {
    case messages::WebBundleHandle::kClone: {
      DCHECK(message->is_serialized());
      internal::WebBundleHandle_Clone_Params_Data* params =
          reinterpret_cast<internal::WebBundleHandle_Clone_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebBundleHandle.0
      bool success = true;
      ::mojo::PendingReceiver<WebBundleHandle> p_receiver{};
      WebBundleHandle_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBundleHandle::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(        
        std::move(p_receiver));
      return true;
    }
    case messages::WebBundleHandle::kOnWebBundleError: {
      DCHECK(message->is_serialized());
      internal::WebBundleHandle_OnWebBundleError_Params_Data* params =
          reinterpret_cast<internal::WebBundleHandle_OnWebBundleError_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebBundleHandle.1
      bool success = true;
      WebBundleErrorType p_type{};
      ::blink::String p_message{};
      WebBundleHandle_OnWebBundleError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBundleHandle::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnWebBundleError(        
        std::move(p_type), 
        std::move(p_message));
      return true;
    }
    case messages::WebBundleHandle::kOnWebBundleLoadFinished: {
      DCHECK(message->is_serialized());
      internal::WebBundleHandle_OnWebBundleLoadFinished_Params_Data* params =
          reinterpret_cast<internal::WebBundleHandle_OnWebBundleLoadFinished_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebBundleHandle.2
      bool success = true;
      bool p_success{};
      WebBundleHandle_OnWebBundleLoadFinished_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_success = input_data_view.success();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBundleHandle::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnWebBundleLoadFinished(        
        std::move(p_success));
      return true;
    }
  }
  return false;
}

// static
bool WebBundleHandleStubDispatch::AcceptWithResponder(
    WebBundleHandle* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebBundleHandle>(message->header()->name)) {
    case messages::WebBundleHandle::kClone: {
      break;
    }
    case messages::WebBundleHandle::kOnWebBundleError: {
      break;
    }
    case messages::WebBundleHandle::kOnWebBundleLoadFinished: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebBundleHandleValidationInfo[] = {
    { &internal::WebBundleHandle_Clone_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebBundleHandle_OnWebBundleError_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebBundleHandle_OnWebBundleLoadFinished_Params_Data::Validate,
     nullptr /* no response */},
};

bool WebBundleHandleRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::network::mojom::blink::WebBundleHandle::Name_,
    kWebBundleHandleValidationInfo);
}



}  // network::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom::blink {


void WebBundleHandleInterceptorForTesting::Clone(::mojo::PendingReceiver<WebBundleHandle> receiver) {
  GetForwardingInterface()->Clone(
    std::move(receiver)
    );
}
void WebBundleHandleInterceptorForTesting::OnWebBundleError(WebBundleErrorType type, const ::blink::String& message) {
  GetForwardingInterface()->OnWebBundleError(
    std::move(type)
    , 
    std::move(message)
    );
}
void WebBundleHandleInterceptorForTesting::OnWebBundleLoadFinished(bool success) {
  GetForwardingInterface()->OnWebBundleLoadFinished(
    std::move(success)
    );
}
WebBundleHandleAsyncWaiter::WebBundleHandleAsyncWaiter(
    WebBundleHandle* proxy) : proxy_(proxy) {}

WebBundleHandleAsyncWaiter::~WebBundleHandleAsyncWaiter() = default;







}  // network::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif