// services/network/public/mojom/url_response_head.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_URL_RESPONSE_HEAD_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_URL_RESPONSE_HEAD_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/url_response_head.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/alternate_protocol_usage.mojom-shared.h"
#include "services/network/public/mojom/attribution.mojom-shared.h"
#include "services/network/public/mojom/cors.mojom-shared.h"
#include "services/network/public/mojom/device_bound_sessions.mojom-shared.h"
#include "services/network/public/mojom/encoded_body_length.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "services/network/public/mojom/http_request_headers.mojom-shared.h"
#include "services/network/public/mojom/ip_address_space.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/load_timing_info.mojom-shared.h"
#include "services/network/public/mojom/load_timing_internal_info.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/network_types.mojom-shared.h"
#include "services/network/public/mojom/parsed_headers.mojom-shared.h"
#include "services/network/public/mojom/parsed_request_cookie.mojom-shared.h"
#include "services/network/public/mojom/service_worker_router_info.mojom-shared.h"
#include "services/network/public/mojom/source_type.mojom-shared.h"
#include "services/network/public/mojom/unencoded_digest.mojom-shared.h"
#include "services/proxy_resolver/public/mojom/proxy_resolver.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"



#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"

#include "services/network/public/mojom/url_response_head.mojom-data-view.h"




namespace std {

template <>
struct hash<::network::mojom::NavigationDeliveryType>
    : public mojo::internal::EnumHashImpl<::network::mojom::NavigationDeliveryType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::NavigationDeliveryType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::NavigationDeliveryType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::NavigationDeliveryType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::URLResponseHeadDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::URLResponseHeadDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::URLResponseHead_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::request_time(input)) in_request_time = Traits::request_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->request_time)::BaseType> request_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_request_time,
      request_time_fragment);

    fragment->request_time.Set(
        request_time_fragment.is_null() ? nullptr : request_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->request_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request_time in URLResponseHead struct");

    decltype(Traits::response_time(input)) in_response_time = Traits::response_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->response_time)::BaseType> response_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_response_time,
      response_time_fragment);

    fragment->response_time.Set(
        response_time_fragment.is_null() ? nullptr : response_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->response_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null response_time in URLResponseHead struct");

    decltype(Traits::original_response_time(input)) in_original_response_time = Traits::original_response_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->original_response_time)::BaseType> original_response_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_original_response_time,
      original_response_time_fragment);

    fragment->original_response_time.Set(
        original_response_time_fragment.is_null() ? nullptr : original_response_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->original_response_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null original_response_time in URLResponseHead struct");

    decltype(Traits::headers(input)) in_headers = Traits::headers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->headers)::BaseType> headers_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::HttpResponseHeadersDataView>(
      in_headers,
      headers_fragment);

    fragment->headers.Set(
        headers_fragment.is_null() ? nullptr : headers_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->headers.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null headers in URLResponseHead struct");

    decltype(Traits::mime_type(input)) in_mime_type = Traits::mime_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mime_type)::BaseType> mime_type_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_mime_type,
      mime_type_fragment);

    fragment->mime_type.Set(
        mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->mime_type.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null mime_type in URLResponseHead struct");

    decltype(Traits::charset(input)) in_charset = Traits::charset(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->charset)::BaseType> charset_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_charset,
      charset_fragment);

    fragment->charset.Set(
        charset_fragment.is_null() ? nullptr : charset_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->charset.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null charset in URLResponseHead struct");

    fragment->content_length = Traits::content_length(input);

    fragment->encoded_data_length = Traits::encoded_data_length(input);

    decltype(Traits::encoded_body_length(input)) in_encoded_body_length = Traits::encoded_body_length(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->encoded_body_length)::BaseType> encoded_body_length_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::EncodedBodyLengthDataView>(
      in_encoded_body_length,
      encoded_body_length_fragment);

    fragment->encoded_body_length.Set(
        encoded_body_length_fragment.is_null() ? nullptr : encoded_body_length_fragment.data());

    fragment->network_accessed = Traits::network_accessed(input);

    decltype(Traits::load_timing(input)) in_load_timing = Traits::load_timing(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->load_timing)::BaseType> load_timing_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::LoadTimingInfoDataView>(
      in_load_timing,
      load_timing_fragment);

    fragment->load_timing.Set(
        load_timing_fragment.is_null() ? nullptr : load_timing_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->load_timing.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null load_timing in URLResponseHead struct");

    decltype(Traits::load_timing_internal_info(input)) in_load_timing_internal_info = Traits::load_timing_internal_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->load_timing_internal_info)::BaseType> load_timing_internal_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::LoadTimingInternalInfoDataView>(
      in_load_timing_internal_info,
      load_timing_internal_info_fragment);

    fragment->load_timing_internal_info.Set(
        load_timing_internal_info_fragment.is_null() ? nullptr : load_timing_internal_info_fragment.data());

    fragment->emitted_extra_info = Traits::emitted_extra_info(input);

    fragment->was_fetched_via_spdy = Traits::was_fetched_via_spdy(input);

    fragment->was_alpn_negotiated = Traits::was_alpn_negotiated(input);

    fragment->was_alternate_protocol_available = Traits::was_alternate_protocol_available(input);

    
    mojo::internal::Serialize<::network::mojom::ConnectionInfo>(
      Traits::connection_info(input),
      &fragment->connection_info);

    decltype(Traits::alpn_negotiated_protocol(input)) in_alpn_negotiated_protocol = Traits::alpn_negotiated_protocol(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->alpn_negotiated_protocol)::BaseType> alpn_negotiated_protocol_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_alpn_negotiated_protocol,
      alpn_negotiated_protocol_fragment);

    fragment->alpn_negotiated_protocol.Set(
        alpn_negotiated_protocol_fragment.is_null() ? nullptr : alpn_negotiated_protocol_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->alpn_negotiated_protocol.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null alpn_negotiated_protocol in URLResponseHead struct");

    
    mojo::internal::Serialize<::network::mojom::AlternateProtocolUsage>(
      Traits::alternate_protocol_usage(input),
      &fragment->alternate_protocol_usage);

    decltype(Traits::remote_endpoint(input)) in_remote_endpoint = Traits::remote_endpoint(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->remote_endpoint)::BaseType> remote_endpoint_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_remote_endpoint,
      remote_endpoint_fragment);

    fragment->remote_endpoint.Set(
        remote_endpoint_fragment.is_null() ? nullptr : remote_endpoint_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->remote_endpoint.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null remote_endpoint in URLResponseHead struct");

    
    mojo::internal::Serialize<::network::mojom::IPAddressSpace>(
      Traits::client_address_space(input),
      &fragment->client_address_space);

    
    mojo::internal::Serialize<::network::mojom::IPAddressSpace>(
      Traits::response_address_space(input),
      &fragment->response_address_space);

    fragment->is_validated = Traits::is_validated(input);

    fragment->was_fetched_via_cache = Traits::was_fetched_via_cache(input);

    
    mojo::internal::Serialize<::network::mojom::NavigationDeliveryType>(
      Traits::navigation_delivery_type(input),
      &fragment->navigation_delivery_type);

    decltype(Traits::proxy_chain(input)) in_proxy_chain = Traits::proxy_chain(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->proxy_chain)::BaseType> proxy_chain_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::ProxyChainDataView>(
      in_proxy_chain,
      proxy_chain_fragment);

    fragment->proxy_chain.Set(
        proxy_chain_fragment.is_null() ? nullptr : proxy_chain_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->proxy_chain.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null proxy_chain in URLResponseHead struct");

    fragment->was_fetched_via_service_worker = Traits::was_fetched_via_service_worker(input);

    
    mojo::internal::Serialize<::network::mojom::FetchResponseSource>(
      Traits::service_worker_response_source(input),
      &fragment->service_worker_response_source);

    decltype(Traits::url_list_via_service_worker(input)) in_url_list_via_service_worker = Traits::url_list_via_service_worker(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url_list_via_service_worker)::BaseType>
        url_list_via_service_worker_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& url_list_via_service_worker_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
      in_url_list_via_service_worker,
      url_list_via_service_worker_fragment,
      &url_list_via_service_worker_validate_params);

    fragment->url_list_via_service_worker.Set(
        url_list_via_service_worker_fragment.is_null() ? nullptr : url_list_via_service_worker_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url_list_via_service_worker.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url_list_via_service_worker in URLResponseHead struct");
    fragment->initial_service_worker_status_$flag = Traits::initial_service_worker_status(input).has_value();
    if (Traits::initial_service_worker_status(input).has_value()) {
      
      mojo::internal::Serialize<::network::mojom::ServiceWorkerStatus>(
        Traits::initial_service_worker_status(input).value(),
        &fragment->initial_service_worker_status_$value);
    } else {
      fragment->initial_service_worker_status_$value =
          static_cast<int32_t>(::network::mojom::ServiceWorkerStatus::kMinValue);
    }

    decltype(Traits::service_worker_router_info(input)) in_service_worker_router_info = Traits::service_worker_router_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->service_worker_router_info)::BaseType> service_worker_router_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::ServiceWorkerRouterInfoDataView>(
      in_service_worker_router_info,
      service_worker_router_info_fragment);

    fragment->service_worker_router_info.Set(
        service_worker_router_info_fragment.is_null() ? nullptr : service_worker_router_info_fragment.data());

    
    mojo::internal::Serialize<::network::mojom::FetchResponseType>(
      Traits::response_type(input),
      &fragment->response_type);

    fragment->padding = Traits::padding(input);

    decltype(Traits::cache_storage_cache_name(input)) in_cache_storage_cache_name = Traits::cache_storage_cache_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cache_storage_cache_name)::BaseType> cache_storage_cache_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_cache_storage_cache_name,
      cache_storage_cache_name_fragment);

    fragment->cache_storage_cache_name.Set(
        cache_storage_cache_name_fragment.is_null() ? nullptr : cache_storage_cache_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->cache_storage_cache_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cache_storage_cache_name in URLResponseHead struct");

    fragment->cert_status = Traits::cert_status(input);

    decltype(Traits::ssl_info(input)) in_ssl_info = Traits::ssl_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ssl_info)::BaseType> ssl_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::SSLInfoDataView>(
      in_ssl_info,
      ssl_info_fragment);

    fragment->ssl_info.Set(
        ssl_info_fragment.is_null() ? nullptr : ssl_info_fragment.data());

    decltype(Traits::request_cookies(input)) in_request_cookies = Traits::request_cookies(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->request_cookies)::BaseType>
        request_cookies_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& request_cookies_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::ParsedRequestCookieDataView>>(
      in_request_cookies,
      request_cookies_fragment,
      &request_cookies_validate_params);

    fragment->request_cookies.Set(
        request_cookies_fragment.is_null() ? nullptr : request_cookies_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->request_cookies.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request_cookies in URLResponseHead struct");

    decltype(Traits::cors_exposed_header_names(input)) in_cors_exposed_header_names = Traits::cors_exposed_header_names(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cors_exposed_header_names)::BaseType>
        cors_exposed_header_names_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& cors_exposed_header_names_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_cors_exposed_header_names,
      cors_exposed_header_names_fragment,
      &cors_exposed_header_names_validate_params);

    fragment->cors_exposed_header_names.Set(
        cors_exposed_header_names_fragment.is_null() ? nullptr : cors_exposed_header_names_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->cors_exposed_header_names.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cors_exposed_header_names in URLResponseHead struct");

    fragment->did_service_worker_navigation_preload = Traits::did_service_worker_navigation_preload(input);

    fragment->async_revalidation_requested = Traits::async_revalidation_requested(input);

    fragment->did_mime_sniff = Traits::did_mime_sniff(input);

    fragment->is_signed_exchange_inner_response = Traits::is_signed_exchange_inner_response(input);

    fragment->is_web_bundle_inner_response = Traits::is_web_bundle_inner_response(input);

    fragment->was_in_prefetch_cache = Traits::was_in_prefetch_cache(input);

    fragment->is_prefetch_with_cross_site_contamination = Traits::is_prefetch_with_cross_site_contamination(input);

    fragment->was_cookie_in_request = Traits::was_cookie_in_request(input);

    fragment->intercepted_by_plugin = Traits::intercepted_by_plugin(input);

    fragment->has_range_requested = Traits::has_range_requested(input);

    fragment->timing_allow_passed = Traits::timing_allow_passed(input);

    decltype(Traits::auth_challenge_info(input)) in_auth_challenge_info = Traits::auth_challenge_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->auth_challenge_info)::BaseType> auth_challenge_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::AuthChallengeInfoDataView>(
      in_auth_challenge_info,
      auth_challenge_info_fragment);

    fragment->auth_challenge_info.Set(
        auth_challenge_info_fragment.is_null() ? nullptr : auth_challenge_info_fragment.data());

    decltype(Traits::request_start(input)) in_request_start = Traits::request_start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->request_start)::BaseType> request_start_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_request_start,
      request_start_fragment);

    fragment->request_start.Set(
        request_start_fragment.is_null() ? nullptr : request_start_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->request_start.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request_start in URLResponseHead struct");

    decltype(Traits::response_start(input)) in_response_start = Traits::response_start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->response_start)::BaseType> response_start_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_response_start,
      response_start_fragment);

    fragment->response_start.Set(
        response_start_fragment.is_null() ? nullptr : response_start_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->response_start.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null response_start in URLResponseHead struct");

    decltype(Traits::parsed_headers(input)) in_parsed_headers = Traits::parsed_headers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->parsed_headers)::BaseType> parsed_headers_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::ParsedHeadersDataView>(
      in_parsed_headers,
      parsed_headers_fragment);

    fragment->parsed_headers.Set(
        parsed_headers_fragment.is_null() ? nullptr : parsed_headers_fragment.data());

    decltype(Traits::recursive_prefetch_token(input)) in_recursive_prefetch_token = Traits::recursive_prefetch_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->recursive_prefetch_token)::BaseType> recursive_prefetch_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_recursive_prefetch_token,
      recursive_prefetch_token_fragment);

    fragment->recursive_prefetch_token.Set(
        recursive_prefetch_token_fragment.is_null() ? nullptr : recursive_prefetch_token_fragment.data());

    decltype(Traits::dns_aliases(input)) in_dns_aliases = Traits::dns_aliases(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->dns_aliases)::BaseType>
        dns_aliases_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& dns_aliases_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_dns_aliases,
      dns_aliases_fragment,
      &dns_aliases_validate_params);

    fragment->dns_aliases.Set(
        dns_aliases_fragment.is_null() ? nullptr : dns_aliases_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->dns_aliases.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null dns_aliases in URLResponseHead struct");

    fragment->has_authorization_covered_by_wildcard_on_preflight = Traits::has_authorization_covered_by_wildcard_on_preflight(input);

    fragment->request_include_credentials = Traits::request_include_credentials(input);

    fragment->should_use_source_hash_for_js_code_cache = Traits::should_use_source_hash_for_js_code_cache(input);

    fragment->did_use_shared_dictionary = Traits::did_use_shared_dictionary(input);

    fragment->load_with_storage_access = Traits::load_with_storage_access(input);

    decltype(Traits::client_side_content_decoding_types(input)) in_client_side_content_decoding_types = Traits::client_side_content_decoding_types(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->client_side_content_decoding_types)::BaseType>
        client_side_content_decoding_types_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& client_side_content_decoding_types_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::SourceType_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::SourceType>>(
      in_client_side_content_decoding_types,
      client_side_content_decoding_types_fragment,
      &client_side_content_decoding_types_validate_params);

    fragment->client_side_content_decoding_types.Set(
        client_side_content_decoding_types_fragment.is_null() ? nullptr : client_side_content_decoding_types_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->client_side_content_decoding_types.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null client_side_content_decoding_types in URLResponseHead struct");

    
    mojo::internal::Serialize<::network::mojom::DeviceBoundSessionUsage>(
      Traits::device_bound_session_usage(input),
      &fragment->device_bound_session_usage);

    fragment->from_synthetic_response = Traits::from_synthetic_response(input);

    fragment->bypass_redirect_checks = Traits::bypass_redirect_checks(input);

    decltype(Traits::unencoded_digests(input)) in_unencoded_digests = Traits::unencoded_digests(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->unencoded_digests)::BaseType> unencoded_digests_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::UnencodedDigestsDataView>(
      in_unencoded_digests,
      unencoded_digests_fragment);

    fragment->unencoded_digests.Set(
        unencoded_digests_fragment.is_null() ? nullptr : unencoded_digests_fragment.data());

    fragment->did_use_server_http_auth = Traits::did_use_server_http_auth(input);
  }

  static bool Deserialize(::network::mojom::internal::URLResponseHead_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::URLResponseHeadDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void URLResponseHeadDataView::GetRequestTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->request_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void URLResponseHeadDataView::GetResponseTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->response_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void URLResponseHeadDataView::GetOriginalResponseTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->original_response_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void URLResponseHeadDataView::GetHeadersDataView(
    ::network::mojom::HttpResponseHeadersDataView* output) {
  auto pointer = data_->headers.Get();
  *output = ::network::mojom::HttpResponseHeadersDataView(pointer, message_);
}
inline void URLResponseHeadDataView::GetMimeTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->mime_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void URLResponseHeadDataView::GetCharsetDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->charset.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void URLResponseHeadDataView::GetEncodedBodyLengthDataView(
    ::network::mojom::EncodedBodyLengthDataView* output) {
  auto pointer = data_->encoded_body_length.Get();
  *output = ::network::mojom::EncodedBodyLengthDataView(pointer, message_);
}
inline void URLResponseHeadDataView::GetLoadTimingDataView(
    ::network::mojom::LoadTimingInfoDataView* output) {
  auto pointer = data_->load_timing.Get();
  *output = ::network::mojom::LoadTimingInfoDataView(pointer, message_);
}
inline void URLResponseHeadDataView::GetLoadTimingInternalInfoDataView(
    ::network::mojom::LoadTimingInternalInfoDataView* output) {
  auto pointer = data_->load_timing_internal_info.Get();
  *output = ::network::mojom::LoadTimingInternalInfoDataView(pointer, message_);
}
inline void URLResponseHeadDataView::GetAlpnNegotiatedProtocolDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->alpn_negotiated_protocol.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void URLResponseHeadDataView::GetRemoteEndpointDataView(
    ::network::mojom::IPEndPointDataView* output) {
  auto pointer = data_->remote_endpoint.Get();
  *output = ::network::mojom::IPEndPointDataView(pointer, message_);
}
inline void URLResponseHeadDataView::GetProxyChainDataView(
    ::network::mojom::ProxyChainDataView* output) {
  auto pointer = data_->proxy_chain.Get();
  *output = ::network::mojom::ProxyChainDataView(pointer, message_);
}
inline void URLResponseHeadDataView::GetUrlListViaServiceWorkerDataView(
    mojo::ArrayDataView<::url::mojom::UrlDataView>* output) {
  auto pointer = data_->url_list_via_service_worker.Get();
  *output = mojo::ArrayDataView<::url::mojom::UrlDataView>(pointer, message_);
}
inline void URLResponseHeadDataView::GetServiceWorkerRouterInfoDataView(
    ::network::mojom::ServiceWorkerRouterInfoDataView* output) {
  auto pointer = data_->service_worker_router_info.Get();
  *output = ::network::mojom::ServiceWorkerRouterInfoDataView(pointer, message_);
}
inline void URLResponseHeadDataView::GetCacheStorageCacheNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->cache_storage_cache_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void URLResponseHeadDataView::GetSslInfoDataView(
    ::network::mojom::SSLInfoDataView* output) {
  auto pointer = data_->ssl_info.Get();
  *output = ::network::mojom::SSLInfoDataView(pointer, message_);
}
inline void URLResponseHeadDataView::GetRequestCookiesDataView(
    mojo::ArrayDataView<::network::mojom::ParsedRequestCookieDataView>* output) {
  auto pointer = data_->request_cookies.Get();
  *output = mojo::ArrayDataView<::network::mojom::ParsedRequestCookieDataView>(pointer, message_);
}
inline void URLResponseHeadDataView::GetCorsExposedHeaderNamesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->cors_exposed_header_names.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void URLResponseHeadDataView::GetAuthChallengeInfoDataView(
    ::network::mojom::AuthChallengeInfoDataView* output) {
  auto pointer = data_->auth_challenge_info.Get();
  *output = ::network::mojom::AuthChallengeInfoDataView(pointer, message_);
}
inline void URLResponseHeadDataView::GetRequestStartDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->request_start.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void URLResponseHeadDataView::GetResponseStartDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->response_start.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void URLResponseHeadDataView::GetParsedHeadersDataView(
    ::network::mojom::ParsedHeadersDataView* output) {
  auto pointer = data_->parsed_headers.Get();
  *output = ::network::mojom::ParsedHeadersDataView(pointer, message_);
}
inline void URLResponseHeadDataView::GetRecursivePrefetchTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->recursive_prefetch_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void URLResponseHeadDataView::GetDnsAliasesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->dns_aliases.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void URLResponseHeadDataView::GetClientSideContentDecodingTypesDataView(
    mojo::ArrayDataView<::network::mojom::SourceType>* output) {
  auto pointer = data_->client_side_content_decoding_types.Get();
  *output = mojo::ArrayDataView<::network::mojom::SourceType>(pointer, message_);
}
inline void URLResponseHeadDataView::GetUnencodedDigestsDataView(
    ::network::mojom::UnencodedDigestsDataView* output) {
  auto pointer = data_->unencoded_digests.Get();
  *output = ::network::mojom::UnencodedDigestsDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::NavigationDeliveryType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::NavigationDeliveryType value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_URL_RESPONSE_HEAD_MOJOM_SHARED_H_