// services/network/public/mojom/url_response_head.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');

goog.require('network.mojom.AlternateProtocolUsage');
goog.require('network.mojom.ConnectionInfo');
goog.require('network.mojom.DeviceBoundSessionUsage');
goog.require('network.mojom.FetchResponseSource');
goog.require('network.mojom.FetchResponseType');
goog.require('network.mojom.IPAddressSpace');
goog.require('network.mojom.ServiceWorkerStatus');
goog.require('network.mojom.SourceType');
goog.require('network.mojom.AuthChallengeInfo');
goog.require('network.mojom.EncodedBodyLength');
goog.require('network.mojom.HttpResponseHeaders');
goog.require('network.mojom.IPEndPoint');
goog.require('network.mojom.LoadTimingInfo');
goog.require('network.mojom.LoadTimingInternalInfo');
goog.require('network.mojom.ParsedHeaders');
goog.require('network.mojom.ParsedRequestCookie');
goog.require('network.mojom.ProxyChain');
goog.require('network.mojom.SSLInfo');
goog.require('network.mojom.ServiceWorkerRouterInfo');
goog.require('mojoBase.mojom.Time');
goog.require('mojoBase.mojom.TimeTicks');
goog.require('network.mojom.UnencodedDigests');
goog.require('mojoBase.mojom.UnguessableToken');
goog.require('url.mojom.Url');




goog.provide('network.mojom.NavigationDeliveryType');
goog.provide('network.mojom.NavigationDeliveryTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.NavigationDeliveryTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.NavigationDeliveryType = {
  
  kDefault: 0,
  kNavigationalPrefetch: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



goog.provide('network.mojom.URLResponseHeadSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.URLResponseHeadSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.URLResponseHeadSpec.$,
    'URLResponseHead',
    [
      mojo.internal.StructField(
        'requestTime', 0,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'responseTime', 8,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'originalResponseTime', 16,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'headers', 24,
        0,
        network.mojom.HttpResponseHeadersSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mimeType', 32,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'charset', 40,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'contentLength', 48,
        0,
        mojo.internal.Int64,
        BigInt('-1'),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'encodedDataLength', 56,
        0,
        mojo.internal.Int64,
        BigInt('-1'),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'encodedBodyLength', 64,
        0,
        network.mojom.EncodedBodyLengthSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'networkAccessed', 72,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'loadTiming', 80,
        0,
        network.mojom.LoadTimingInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'loadTimingInternalInfo', 88,
        0,
        network.mojom.LoadTimingInternalInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'emittedExtraInfo', 72,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wasFetchedViaSpdy', 72,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wasAlpnNegotiated', 72,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wasAlternateProtocolAvailable', 72,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'connectionInfo', 76,
        0,
        network.mojom.ConnectionInfoSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'alpnNegotiatedProtocol', 96,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'alternateProtocolUsage', 104,
        0,
        network.mojom.AlternateProtocolUsageSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'remoteEndpoint', 112,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'clientAddressSpace', 108,
        0,
        network.mojom.IPAddressSpaceSpec.$,
        network.mojom.IPAddressSpace.kUnknown,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'responseAddressSpace', 120,
        0,
        network.mojom.IPAddressSpaceSpec.$,
        network.mojom.IPAddressSpace.kUnknown,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isValidated', 72,
        5,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wasFetchedViaCache', 72,
        6,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'navigationDeliveryType', 124,
        0,
        network.mojom.NavigationDeliveryTypeSpec.$,
        network.mojom.NavigationDeliveryType.kDefault,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'proxyChain', 128,
        0,
        network.mojom.ProxyChainSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wasFetchedViaServiceWorker', 72,
        7,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'serviceWorkerResponseSource', 136,
        0,
        network.mojom.FetchResponseSourceSpec.$,
        network.mojom.FetchResponseSource.kUnspecified,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'urlListViaServiceWorker', 144,
        0,
        mojo.internal.Array(url.mojom.UrlSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'initial_service_worker_status_$flag', 73,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "initial_service_worker_status_$value",
          originalFieldName: "initialServiceWorkerStatus",
        }
      ),
      mojo.internal.StructField(
        'initial_service_worker_status_$value', 140,
        0,
        network.mojom.ServiceWorkerStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "initialServiceWorkerStatus",
        }
      ),
      mojo.internal.StructField(
        'serviceWorkerRouterInfo', 152,
        0,
        network.mojom.ServiceWorkerRouterInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'responseType', 160,
        0,
        network.mojom.FetchResponseTypeSpec.$,
        network.mojom.FetchResponseType.kDefault,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'padding', 168,
        0,
        mojo.internal.Int64,
        BigInt('0'),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cacheStorageCacheName', 176,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'certStatus', 164,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sslInfo', 184,
        0,
        network.mojom.SSLInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestCookies', 192,
        0,
        mojo.internal.Array(network.mojom.ParsedRequestCookieSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'corsExposedHeaderNames', 200,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'didServiceWorkerNavigationPreload', 73,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'asyncRevalidationRequested', 73,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'didMimeSniff', 73,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isSignedExchangeInnerResponse', 73,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isWebBundleInnerResponse', 73,
        5,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wasInPrefetchCache', 73,
        6,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isPrefetchWithCrossSiteContamination', 73,
        7,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wasCookieInRequest', 74,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'interceptedByPlugin', 74,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasRangeRequested', 74,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'timingAllowPassed', 74,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'authChallengeInfo', 208,
        0,
        network.mojom.AuthChallengeInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestStart', 216,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'responseStart', 224,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'parsedHeaders', 232,
        0,
        network.mojom.ParsedHeadersSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'recursivePrefetchToken', 240,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dnsAliases', 248,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasAuthorizationCoveredByWildcardOnPreflight', 74,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestIncludeCredentials', 74,
        5,
        mojo.internal.Bool,
        true,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'shouldUseSourceHashForJsCodeCache', 74,
        6,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'didUseSharedDictionary', 74,
        7,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'loadWithStorageAccess', 75,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'clientSideContentDecodingTypes', 256,
        0,
        mojo.internal.Array(network.mojom.SourceTypeSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'deviceBoundSessionUsage', 264,
        0,
        network.mojom.DeviceBoundSessionUsageSpec.$,
        network.mojom.DeviceBoundSessionUsage.kUnknown,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fromSyntheticResponse', 75,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'bypassRedirectChecks', 75,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'unencodedDigests', 272,
        0,
        network.mojom.UnencodedDigestsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'didUseServerHttpAuth', 75,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 288],]);



goog.provide('network.mojom.URLResponseHead');

/** @record */
network.mojom.URLResponseHead = class {
  constructor() {
    /** @export { !mojoBase.mojom.Time } */
    this.requestTime;
    /** @export { !mojoBase.mojom.Time } */
    this.responseTime;
    /** @export { !mojoBase.mojom.Time } */
    this.originalResponseTime;
    /** @export { !network.mojom.HttpResponseHeaders } */
    this.headers;
    /** @export { !string } */
    this.mimeType;
    /** @export { !string } */
    this.charset;
    /** @export { !bigint } */
    this.contentLength;
    /** @export { !bigint } */
    this.encodedDataLength;
    /** @export { (network.mojom.EncodedBodyLength|undefined) } */
    this.encodedBodyLength;
    /** @export { !boolean } */
    this.networkAccessed;
    /** @export { !network.mojom.LoadTimingInfo } */
    this.loadTiming;
    /** @export { (network.mojom.LoadTimingInternalInfo|undefined) } */
    this.loadTimingInternalInfo;
    /** @export { !boolean } */
    this.emittedExtraInfo;
    /** @export { !boolean } */
    this.wasFetchedViaSpdy;
    /** @export { !boolean } */
    this.wasAlpnNegotiated;
    /** @export { !boolean } */
    this.wasAlternateProtocolAvailable;
    /** @export { !network.mojom.ConnectionInfo } */
    this.connectionInfo;
    /** @export { !string } */
    this.alpnNegotiatedProtocol;
    /** @export { !network.mojom.AlternateProtocolUsage } */
    this.alternateProtocolUsage;
    /** @export { !network.mojom.IPEndPoint } */
    this.remoteEndpoint;
    /** @export { !network.mojom.IPAddressSpace } */
    this.clientAddressSpace;
    /** @export { !network.mojom.IPAddressSpace } */
    this.responseAddressSpace;
    /** @export { !boolean } */
    this.isValidated;
    /** @export { !boolean } */
    this.wasFetchedViaCache;
    /** @export { !network.mojom.NavigationDeliveryType } */
    this.navigationDeliveryType;
    /** @export { !network.mojom.ProxyChain } */
    this.proxyChain;
    /** @export { !boolean } */
    this.wasFetchedViaServiceWorker;
    /** @export { !network.mojom.FetchResponseSource } */
    this.serviceWorkerResponseSource;
    /** @export { !Array<!url.mojom.Url> } */
    this.urlListViaServiceWorker;
    /** @export { (network.mojom.ServiceWorkerStatus|undefined) } */
    this.initialServiceWorkerStatus;
    /** @export { (network.mojom.ServiceWorkerRouterInfo|undefined) } */
    this.serviceWorkerRouterInfo;
    /** @export { !network.mojom.FetchResponseType } */
    this.responseType;
    /** @export { !bigint } */
    this.padding;
    /** @export { !string } */
    this.cacheStorageCacheName;
    /** @export { !number } */
    this.certStatus;
    /** @export { (network.mojom.SSLInfo|undefined) } */
    this.sslInfo;
    /** @export { !Array<!network.mojom.ParsedRequestCookie> } */
    this.requestCookies;
    /** @export { !Array<!string> } */
    this.corsExposedHeaderNames;
    /** @export { !boolean } */
    this.didServiceWorkerNavigationPreload;
    /** @export { !boolean } */
    this.asyncRevalidationRequested;
    /** @export { !boolean } */
    this.didMimeSniff;
    /** @export { !boolean } */
    this.isSignedExchangeInnerResponse;
    /** @export { !boolean } */
    this.isWebBundleInnerResponse;
    /** @export { !boolean } */
    this.wasInPrefetchCache;
    /** @export { !boolean } */
    this.isPrefetchWithCrossSiteContamination;
    /** @export { !boolean } */
    this.wasCookieInRequest;
    /** @export { !boolean } */
    this.interceptedByPlugin;
    /** @export { !boolean } */
    this.hasRangeRequested;
    /** @export { !boolean } */
    this.timingAllowPassed;
    /** @export { (network.mojom.AuthChallengeInfo|undefined) } */
    this.authChallengeInfo;
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.requestStart;
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.responseStart;
    /** @export { (network.mojom.ParsedHeaders|undefined) } */
    this.parsedHeaders;
    /** @export { (mojoBase.mojom.UnguessableToken|undefined) } */
    this.recursivePrefetchToken;
    /** @export { !Array<!string> } */
    this.dnsAliases;
    /** @export { !boolean } */
    this.hasAuthorizationCoveredByWildcardOnPreflight;
    /** @export { !boolean } */
    this.requestIncludeCredentials;
    /** @export { !boolean } */
    this.shouldUseSourceHashForJsCodeCache;
    /** @export { !boolean } */
    this.didUseSharedDictionary;
    /** @export { !boolean } */
    this.loadWithStorageAccess;
    /** @export { !Array<!network.mojom.SourceType> } */
    this.clientSideContentDecodingTypes;
    /** @export { !network.mojom.DeviceBoundSessionUsage } */
    this.deviceBoundSessionUsage;
    /** @export { !boolean } */
    this.fromSyntheticResponse;
    /** @export { !boolean } */
    this.bypassRedirectChecks;
    /** @export { (network.mojom.UnencodedDigests|undefined) } */
    this.unencodedDigests;
    /** @export { !boolean } */
    this.didUseServerHttpAuth;
  }
};

