// services/network/public/mojom/url_request.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/url_request.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var big_buffer$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/big_buffer.mojom', '../../../../mojo/public/mojom/base/big_buffer.mojom.js');
  }
  var file_path$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file_path.mojom', '../../../../mojo/public/mojom/base/file_path.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }
  var accept_ch_frame_observer$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/accept_ch_frame_observer.mojom', 'accept_ch_frame_observer.mojom.js');
  }
  var attribution$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/attribution.mojom', 'attribution.mojom.js');
  }
  var chunked_data_pipe_getter$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/chunked_data_pipe_getter.mojom', 'chunked_data_pipe_getter.mojom.js');
  }
  var client_security_state$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/client_security_state.mojom', 'client_security_state.mojom.js');
  }
  var cookie_access_observer$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/cookie_access_observer.mojom', 'cookie_access_observer.mojom.js');
  }
  var cookie_manager$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/cookie_manager.mojom', 'cookie_manager.mojom.js');
  }
  var cors$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/cors.mojom', 'cors.mojom.js');
  }
  var data_pipe_getter$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/data_pipe_getter.mojom', 'data_pipe_getter.mojom.js');
  }
  var device_bound_sessions$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/device_bound_sessions.mojom', 'device_bound_sessions.mojom.js');
  }
  var devtools_observer$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/devtools_observer.mojom', 'devtools_observer.mojom.js');
  }
  var fetch_api$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/fetch_api.mojom', 'fetch_api.mojom.js');
  }
  var fetch_retry_options$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/fetch_retry_options.mojom', 'fetch_retry_options.mojom.js');
  }
  var http_raw_headers$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/http_raw_headers.mojom', 'http_raw_headers.mojom.js');
  }
  var http_request_headers$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/http_request_headers.mojom', 'http_request_headers.mojom.js');
  }
  var ip_address_space$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/ip_address_space.mojom', 'ip_address_space.mojom.js');
  }
  var isolation_info$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/isolation_info.mojom', 'isolation_info.mojom.js');
  }
  var network_param$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/network_param.mojom', 'network_param.mojom.js');
  }
  var permissions_policy$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/permissions_policy/permissions_policy.mojom', 'permissions_policy/permissions_policy.mojom.js');
  }
  var referrer_policy$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/referrer_policy.mojom', 'referrer_policy.mojom.js');
  }
  var request_priority$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/request_priority.mojom', 'request_priority.mojom.js');
  }
  var shared_dictionary_access_observer$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/shared_dictionary_access_observer.mojom', 'shared_dictionary_access_observer.mojom.js');
  }
  var site_for_cookies$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/site_for_cookies.mojom', 'site_for_cookies.mojom.js');
  }
  var source_type$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/source_type.mojom', 'source_type.mojom.js');
  }
  var storage_access_api$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/storage_access_api.mojom', 'storage_access_api.mojom.js');
  }
  var trust_token_access_observer$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/trust_token_access_observer.mojom', 'trust_token_access_observer.mojom.js');
  }
  var trust_tokens$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/trust_tokens.mojom', 'trust_tokens.mojom.js');
  }
  var url_loader_network_service_observer$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/url_loader_network_service_observer.mojom', 'url_loader_network_service_observer.mojom.js');
  }
  var url_response_head$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/url_response_head.mojom', 'url_response_head.mojom.js');
  }
  var web_bundle_handle$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/web_bundle_handle.mojom', 'web_bundle_handle.mojom.js');
  }
  var web_client_hints_types$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/web_client_hints_types.mojom', 'web_client_hints_types.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../url/mojom/origin.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../url/mojom/url.mojom.js');
  }



  function EnabledClientHints(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EnabledClientHints.prototype.initDefaults_ = function() {
    this.origin = null;
    this.isOutermostMainFrame = false;
    this.hints = null;
    this.notAllowedHints = null;
  };
  EnabledClientHints.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EnabledClientHints.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EnabledClientHints.origin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate EnabledClientHints.hints
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 4, new codec.Enum(web_client_hints_types$.WebClientHintsType), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EnabledClientHints.notAllowedHints
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 4, new codec.Enum(web_client_hints_types$.WebClientHintsType), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EnabledClientHints.encodedSize = codec.kStructHeaderSize + 32;

  EnabledClientHints.decode = function(decoder) {
    var packed;
    var val = new EnabledClientHints();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.origin =
        decoder.decodeStructPointer(origin$.Origin);
    packed = decoder.readUint8();
    val.isOutermostMainFrame = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.hints =
        decoder.decodeArrayPointer(new codec.Enum(web_client_hints_types$.WebClientHintsType));
    val.notAllowedHints =
        decoder.decodeArrayPointer(new codec.Enum(web_client_hints_types$.WebClientHintsType));
    return val;
  };

  EnabledClientHints.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EnabledClientHints.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(origin$.Origin, val.origin);
    packed = 0;
    packed |= (val.isOutermostMainFrame & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.Enum(web_client_hints_types$.WebClientHintsType), val.hints);
    encoder.encodeArrayPointer(new codec.Enum(web_client_hints_types$.WebClientHintsType), val.notAllowedHints);
  };
  function TrustedUrlRequestParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TrustedUrlRequestParams.prototype.initDefaults_ = function() {
    this.isolationInfo = null;
    this.disableSecureDns = false;
    this.hasUserActivation = false;
    this.allowCookiesFromBrowser = false;
    this.includeRequestCookiesWithResponse = false;
    this.enabledClientHints = null;
    this.cookieObserver = new cookie_access_observer$.CookieAccessObserverPtr();
    this.trustTokenObserver = new trust_token_access_observer$.TrustTokenAccessObserverPtr();
    this.urlLoaderNetworkObserver = new url_loader_network_service_observer$.URLLoaderNetworkServiceObserverPtr();
    this.devtoolsObserver = new devtools_observer$.DevToolsObserverPtr();
    this.deviceBoundSessionObserver = new device_bound_sessions$.DeviceBoundSessionAccessObserverPtr();
    this.clientSecurityState = null;
    this.acceptChFrameObserver = new accept_ch_frame_observer$.AcceptCHFrameObserverPtr();
    this.sharedDictionaryObserver = new shared_dictionary_access_observer$.SharedDictionaryAccessObserverPtr();
  };
  TrustedUrlRequestParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TrustedUrlRequestParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 96}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TrustedUrlRequestParams.isolationInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, isolation_info$.IsolationInfo, false);
    if (err !== validator.validationError.NONE)
        return err;






    // validate TrustedUrlRequestParams.enabledClientHints
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, EnabledClientHints, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TrustedUrlRequestParams.cookieObserver
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 24, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TrustedUrlRequestParams.trustTokenObserver
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 32, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TrustedUrlRequestParams.urlLoaderNetworkObserver
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 40, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TrustedUrlRequestParams.devtoolsObserver
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 48, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TrustedUrlRequestParams.deviceBoundSessionObserver
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 56, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TrustedUrlRequestParams.clientSecurityState
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, client_security_state$.ClientSecurityState, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TrustedUrlRequestParams.acceptChFrameObserver
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 72, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TrustedUrlRequestParams.sharedDictionaryObserver
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 80, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TrustedUrlRequestParams.encodedSize = codec.kStructHeaderSize + 88;

  TrustedUrlRequestParams.decode = function(decoder) {
    var packed;
    var val = new TrustedUrlRequestParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.isolationInfo =
        decoder.decodeStructPointer(isolation_info$.IsolationInfo);
    packed = decoder.readUint8();
    val.disableSecureDns = (packed >> 0) & 1 ? true : false;
    val.hasUserActivation = (packed >> 1) & 1 ? true : false;
    val.allowCookiesFromBrowser = (packed >> 2) & 1 ? true : false;
    val.includeRequestCookiesWithResponse = (packed >> 3) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.enabledClientHints =
        decoder.decodeStructPointer(EnabledClientHints);
    val.cookieObserver =
        decoder.decodeStruct(new codec.NullableInterface(cookie_access_observer$.CookieAccessObserverPtr));
    val.trustTokenObserver =
        decoder.decodeStruct(new codec.NullableInterface(trust_token_access_observer$.TrustTokenAccessObserverPtr));
    val.urlLoaderNetworkObserver =
        decoder.decodeStruct(new codec.NullableInterface(url_loader_network_service_observer$.URLLoaderNetworkServiceObserverPtr));
    val.devtoolsObserver =
        decoder.decodeStruct(new codec.NullableInterface(devtools_observer$.DevToolsObserverPtr));
    val.deviceBoundSessionObserver =
        decoder.decodeStruct(new codec.NullableInterface(device_bound_sessions$.DeviceBoundSessionAccessObserverPtr));
    val.clientSecurityState =
        decoder.decodeStructPointer(client_security_state$.ClientSecurityState);
    val.acceptChFrameObserver =
        decoder.decodeStruct(new codec.NullableInterface(accept_ch_frame_observer$.AcceptCHFrameObserverPtr));
    val.sharedDictionaryObserver =
        decoder.decodeStruct(new codec.NullableInterface(shared_dictionary_access_observer$.SharedDictionaryAccessObserverPtr));
    return val;
  };

  TrustedUrlRequestParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TrustedUrlRequestParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(isolation_info$.IsolationInfo, val.isolationInfo);
    packed = 0;
    packed |= (val.disableSecureDns & 1) << 0
    packed |= (val.hasUserActivation & 1) << 1
    packed |= (val.allowCookiesFromBrowser & 1) << 2
    packed |= (val.includeRequestCookiesWithResponse & 1) << 3
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(EnabledClientHints, val.enabledClientHints);
    encoder.encodeStruct(new codec.NullableInterface(cookie_access_observer$.CookieAccessObserverPtr), val.cookieObserver);
    encoder.encodeStruct(new codec.NullableInterface(trust_token_access_observer$.TrustTokenAccessObserverPtr), val.trustTokenObserver);
    encoder.encodeStruct(new codec.NullableInterface(url_loader_network_service_observer$.URLLoaderNetworkServiceObserverPtr), val.urlLoaderNetworkObserver);
    encoder.encodeStruct(new codec.NullableInterface(devtools_observer$.DevToolsObserverPtr), val.devtoolsObserver);
    encoder.encodeStruct(new codec.NullableInterface(device_bound_sessions$.DeviceBoundSessionAccessObserverPtr), val.deviceBoundSessionObserver);
    encoder.encodeStructPointer(client_security_state$.ClientSecurityState, val.clientSecurityState);
    encoder.encodeStruct(new codec.NullableInterface(accept_ch_frame_observer$.AcceptCHFrameObserverPtr), val.acceptChFrameObserver);
    encoder.encodeStruct(new codec.NullableInterface(shared_dictionary_access_observer$.SharedDictionaryAccessObserverPtr), val.sharedDictionaryObserver);
  };
  function WebBundleTokenParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebBundleTokenParams.prototype.initDefaults_ = function() {
    this.bundleUrl = null;
    this.token = null;
    this.webBundleHandle = new web_bundle_handle$.WebBundleHandlePtr();
    this.renderProcessId = 0;
  };
  WebBundleTokenParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebBundleTokenParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebBundleTokenParams.bundleUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebBundleTokenParams.token
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebBundleTokenParams.webBundleHandle
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 16, true);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  WebBundleTokenParams.encodedSize = codec.kStructHeaderSize + 32;

  WebBundleTokenParams.decode = function(decoder) {
    var packed;
    var val = new WebBundleTokenParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.bundleUrl =
        decoder.decodeStructPointer(url$.Url);
    val.token =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.webBundleHandle =
        decoder.decodeStruct(new codec.NullableInterface(web_bundle_handle$.WebBundleHandlePtr));
    val.renderProcessId =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WebBundleTokenParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebBundleTokenParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.bundleUrl);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.token);
    encoder.encodeStruct(new codec.NullableInterface(web_bundle_handle$.WebBundleHandlePtr), val.webBundleHandle);
    encoder.encodeStruct(codec.Int32, val.renderProcessId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function URLRequest(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLRequest.prototype.initDefaults_ = function() {
    this.method = null;
    this.url = null;
    this.siteForCookies = null;
    this.updateFirstPartyUrlOnRedirect = false;
    this.priorityIncremental = false;
    this.originatedFromServiceWorker = false;
    this.skipServiceWorker = false;
    this.keepalive = false;
    this.browsingTopics = false;
    this.adAuctionHeaders = false;
    this.sharedStorageWritableEligible = false;
    this.hasUserGesture = false;
    this.enableLoadTiming = false;
    this.enableUploadProgress = false;
    this.doNotPromptForLogin = false;
    this.isOutermostMainFrame = false;
    this.upgradeIfInsecure = false;
    this.isRevalidating = false;
    this.isFetchLikeApi = false;
    this.isFetchLaterApi = false;
    this.isFavicon = false;
    this.isAdTagged = false;
    this.sharedDictionaryWriterEnabled = false;
    this.clientSideContentDecodingEnabled = false;
    this.allowsDeviceBoundSessionRegistration = false;
    this.referrerPolicy = 0;
    this.requestInitiator = null;
    this.navigationRedirectChain = null;
    this.isolatedWorldOrigin = null;
    this.referrer = null;
    this.headers = null;
    this.corsExemptHeaders = null;
    this.loadFlags = 0;
    this.resourceType = 0;
    this.priority = 0;
    this.corsPreflightPolicy = 0;
    this.mode = 0;
    this.credentialsMode = 0;
    this.redirectMode = 0;
    this.destination = 0;
    this.fetchIntegrity = null;
    this.expectedPublicKeys = null;
    this.requestBody = null;
    this.transitionType = 0;
    this.previewsState = 0;
    this.throttlingProfileId = null;
    this.fetchWindowId = null;
    this.devtoolsRequestId = null;
    this.devtoolsStackId = null;
    this.originalDestination = 0;
    this.requiredIpAddressSpace = 0;
    this.trustedParams = null;
    this.recursivePrefetchToken = null;
    this.trustTokenParams = null;
    this.webBundleTokenParams = null;
    this.devtoolsAcceptedStreamTypes = null;
    this.netLogCreateInfo = null;
    this.netLogReferenceInfo = null;
    this.storageAccessApiStatus = 0;
    this.attributionReportingSupport = 0;
    this.attributionReportingEligibility = attribution$.AttributionReportingEligibility.kUnset;
    this.attributionReportingSrcToken = null;
    this.keepaliveToken = null;
    this.socketTag = null;
    this.permissionsPolicy = null;
    this.fetchRetryOptions = null;
  };
  URLRequest.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLRequest.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 304}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequest.method
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequest.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequest.siteForCookies
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, site_for_cookies$.SiteForCookies, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate URLRequest.requestInitiator
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, origin$.Origin, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequest.navigationRedirectChain
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 40, 8, new codec.PointerTo(url$.Url), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequest.isolatedWorldOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, origin$.Origin, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequest.referrer
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequest.referrerPolicy
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 28, referrer_policy$.URLRequestReferrerPolicy);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequest.headers
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, http_request_headers$.HttpRequestHeaders, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequest.corsExemptHeaders
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 72, http_request_headers$.HttpRequestHeaders, false);
    if (err !== validator.validationError.NONE)
        return err;




    // validate URLRequest.priority
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 88, request_priority$.RequestPriority);
    if (err !== validator.validationError.NONE)
        return err;



    // validate URLRequest.corsPreflightPolicy
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 92, cors$.CorsPreflightPolicy);
    if (err !== validator.validationError.NONE)
        return err;




    // validate URLRequest.mode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 96, fetch_api$.RequestMode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequest.credentialsMode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 100, fetch_api$.CredentialsMode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequest.redirectMode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 104, fetch_api$.RedirectMode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequest.fetchIntegrity
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 112, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequest.expectedPublicKeys
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 120, 8, new codec.ArrayOf(codec.Uint8), false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequest.destination
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 108, fetch_api$.RequestDestination);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequest.requestBody
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 128, URLRequestBody, true);
    if (err !== validator.validationError.NONE)
        return err;















    // validate URLRequest.throttlingProfileId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 144, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequest.fetchWindowId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 152, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequest.devtoolsRequestId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 160, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequest.devtoolsStackId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 168, true)
    if (err !== validator.validationError.NONE)
        return err;





    // validate URLRequest.originalDestination
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 176, fetch_api$.RequestDestination);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequest.trustedParams
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 184, TrustedUrlRequestParams, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequest.recursivePrefetchToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 192, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequest.trustTokenParams
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 200, trust_tokens$.TrustTokenParams, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequest.webBundleTokenParams
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 208, WebBundleTokenParams, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequest.devtoolsAcceptedStreamTypes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 216, 4, new codec.Enum(source_type$.SourceType), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequest.netLogCreateInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 224, network_param$.NetLogSource, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequest.netLogReferenceInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 232, network_param$.NetLogSource, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequest.requiredIpAddressSpace
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 180, ip_address_space$.IPAddressSpace);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequest.storageAccessApiStatus
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 240, storage_access_api$.StorageAccessApiStatus);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequest.attributionReportingSupport
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 244, attribution$.AttributionSupport);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequest.attributionReportingEligibility
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 248, attribution$.AttributionReportingEligibility);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequest.attributionReportingSrcToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 256, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequest.keepaliveToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 264, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;





    // validate URLRequest.socketTag
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 272, SocketTag, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate URLRequest.permissionsPolicy
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 280, permissions_policy$.PermissionsPolicy, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequest.fetchRetryOptions
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 288, fetch_retry_options$.FetchRetryOptions, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  URLRequest.encodedSize = codec.kStructHeaderSize + 296;

  URLRequest.decode = function(decoder) {
    var packed;
    var val = new URLRequest();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.method =
        decoder.decodeStruct(codec.String);
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.siteForCookies =
        decoder.decodeStructPointer(site_for_cookies$.SiteForCookies);
    packed = decoder.readUint8();
    val.updateFirstPartyUrlOnRedirect = (packed >> 0) & 1 ? true : false;
    val.priorityIncremental = (packed >> 1) & 1 ? true : false;
    val.originatedFromServiceWorker = (packed >> 2) & 1 ? true : false;
    val.skipServiceWorker = (packed >> 3) & 1 ? true : false;
    val.keepalive = (packed >> 4) & 1 ? true : false;
    val.browsingTopics = (packed >> 5) & 1 ? true : false;
    val.adAuctionHeaders = (packed >> 6) & 1 ? true : false;
    val.sharedStorageWritableEligible = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.hasUserGesture = (packed >> 0) & 1 ? true : false;
    val.enableLoadTiming = (packed >> 1) & 1 ? true : false;
    val.enableUploadProgress = (packed >> 2) & 1 ? true : false;
    val.doNotPromptForLogin = (packed >> 3) & 1 ? true : false;
    val.isOutermostMainFrame = (packed >> 4) & 1 ? true : false;
    val.upgradeIfInsecure = (packed >> 5) & 1 ? true : false;
    val.isRevalidating = (packed >> 6) & 1 ? true : false;
    val.isFetchLikeApi = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.isFetchLaterApi = (packed >> 0) & 1 ? true : false;
    val.isFavicon = (packed >> 1) & 1 ? true : false;
    val.isAdTagged = (packed >> 2) & 1 ? true : false;
    val.sharedDictionaryWriterEnabled = (packed >> 3) & 1 ? true : false;
    val.clientSideContentDecodingEnabled = (packed >> 4) & 1 ? true : false;
    val.allowsDeviceBoundSessionRegistration = (packed >> 5) & 1 ? true : false;
    decoder.skip(1);
    val.referrerPolicy =
        decoder.decodeStruct(new codec.Enum(referrer_policy$.URLRequestReferrerPolicy));
    val.requestInitiator =
        decoder.decodeStructPointer(origin$.Origin);
    val.navigationRedirectChain =
        decoder.decodeArrayPointer(new codec.PointerTo(url$.Url));
    val.isolatedWorldOrigin =
        decoder.decodeStructPointer(origin$.Origin);
    val.referrer =
        decoder.decodeStructPointer(url$.Url);
    val.headers =
        decoder.decodeStructPointer(http_request_headers$.HttpRequestHeaders);
    val.corsExemptHeaders =
        decoder.decodeStructPointer(http_request_headers$.HttpRequestHeaders);
    val.loadFlags =
        decoder.decodeStruct(codec.Int32);
    val.resourceType =
        decoder.decodeStruct(codec.Int32);
    val.priority =
        decoder.decodeStruct(new codec.Enum(request_priority$.RequestPriority));
    val.corsPreflightPolicy =
        decoder.decodeStruct(new codec.Enum(cors$.CorsPreflightPolicy));
    val.mode =
        decoder.decodeStruct(new codec.Enum(fetch_api$.RequestMode));
    val.credentialsMode =
        decoder.decodeStruct(new codec.Enum(fetch_api$.CredentialsMode));
    val.redirectMode =
        decoder.decodeStruct(new codec.Enum(fetch_api$.RedirectMode));
    val.destination =
        decoder.decodeStruct(new codec.Enum(fetch_api$.RequestDestination));
    val.fetchIntegrity =
        decoder.decodeStruct(codec.String);
    val.expectedPublicKeys =
        decoder.decodeArrayPointer(new codec.ArrayOf(codec.Uint8));
    val.requestBody =
        decoder.decodeStructPointer(URLRequestBody);
    val.transitionType =
        decoder.decodeStruct(codec.Int32);
    val.previewsState =
        decoder.decodeStruct(codec.Int32);
    val.throttlingProfileId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.fetchWindowId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.devtoolsRequestId =
        decoder.decodeStruct(codec.String);
    val.devtoolsStackId =
        decoder.decodeStruct(codec.String);
    val.originalDestination =
        decoder.decodeStruct(new codec.Enum(fetch_api$.RequestDestination));
    val.requiredIpAddressSpace =
        decoder.decodeStruct(new codec.Enum(ip_address_space$.IPAddressSpace));
    val.trustedParams =
        decoder.decodeStructPointer(TrustedUrlRequestParams);
    val.recursivePrefetchToken =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.trustTokenParams =
        decoder.decodeStructPointer(trust_tokens$.TrustTokenParams);
    val.webBundleTokenParams =
        decoder.decodeStructPointer(WebBundleTokenParams);
    val.devtoolsAcceptedStreamTypes =
        decoder.decodeArrayPointer(new codec.Enum(source_type$.SourceType));
    val.netLogCreateInfo =
        decoder.decodeStructPointer(network_param$.NetLogSource);
    val.netLogReferenceInfo =
        decoder.decodeStructPointer(network_param$.NetLogSource);
    val.storageAccessApiStatus =
        decoder.decodeStruct(new codec.Enum(storage_access_api$.StorageAccessApiStatus));
    val.attributionReportingSupport =
        decoder.decodeStruct(new codec.Enum(attribution$.AttributionSupport));
    val.attributionReportingEligibility =
        decoder.decodeStruct(new codec.Enum(attribution$.AttributionReportingEligibility));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.attributionReportingSrcToken =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.keepaliveToken =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.socketTag =
        decoder.decodeStructPointer(SocketTag);
    val.permissionsPolicy =
        decoder.decodeStructPointer(permissions_policy$.PermissionsPolicy);
    val.fetchRetryOptions =
        decoder.decodeStructPointer(fetch_retry_options$.FetchRetryOptions);
    return val;
  };

  URLRequest.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLRequest.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.method);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStructPointer(site_for_cookies$.SiteForCookies, val.siteForCookies);
    packed = 0;
    packed |= (val.updateFirstPartyUrlOnRedirect & 1) << 0
    packed |= (val.priorityIncremental & 1) << 1
    packed |= (val.originatedFromServiceWorker & 1) << 2
    packed |= (val.skipServiceWorker & 1) << 3
    packed |= (val.keepalive & 1) << 4
    packed |= (val.browsingTopics & 1) << 5
    packed |= (val.adAuctionHeaders & 1) << 6
    packed |= (val.sharedStorageWritableEligible & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.hasUserGesture & 1) << 0
    packed |= (val.enableLoadTiming & 1) << 1
    packed |= (val.enableUploadProgress & 1) << 2
    packed |= (val.doNotPromptForLogin & 1) << 3
    packed |= (val.isOutermostMainFrame & 1) << 4
    packed |= (val.upgradeIfInsecure & 1) << 5
    packed |= (val.isRevalidating & 1) << 6
    packed |= (val.isFetchLikeApi & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.isFetchLaterApi & 1) << 0
    packed |= (val.isFavicon & 1) << 1
    packed |= (val.isAdTagged & 1) << 2
    packed |= (val.sharedDictionaryWriterEnabled & 1) << 3
    packed |= (val.clientSideContentDecodingEnabled & 1) << 4
    packed |= (val.allowsDeviceBoundSessionRegistration & 1) << 5
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.referrerPolicy);
    encoder.encodeStructPointer(origin$.Origin, val.requestInitiator);
    encoder.encodeArrayPointer(new codec.PointerTo(url$.Url), val.navigationRedirectChain);
    encoder.encodeStructPointer(origin$.Origin, val.isolatedWorldOrigin);
    encoder.encodeStructPointer(url$.Url, val.referrer);
    encoder.encodeStructPointer(http_request_headers$.HttpRequestHeaders, val.headers);
    encoder.encodeStructPointer(http_request_headers$.HttpRequestHeaders, val.corsExemptHeaders);
    encoder.encodeStruct(codec.Int32, val.loadFlags);
    encoder.encodeStruct(codec.Int32, val.resourceType);
    encoder.encodeStruct(codec.Int32, val.priority);
    encoder.encodeStruct(codec.Int32, val.corsPreflightPolicy);
    encoder.encodeStruct(codec.Int32, val.mode);
    encoder.encodeStruct(codec.Int32, val.credentialsMode);
    encoder.encodeStruct(codec.Int32, val.redirectMode);
    encoder.encodeStruct(codec.Int32, val.destination);
    encoder.encodeStruct(codec.String, val.fetchIntegrity);
    encoder.encodeArrayPointer(new codec.ArrayOf(codec.Uint8), val.expectedPublicKeys);
    encoder.encodeStructPointer(URLRequestBody, val.requestBody);
    encoder.encodeStruct(codec.Int32, val.transitionType);
    encoder.encodeStruct(codec.Int32, val.previewsState);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.throttlingProfileId);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.fetchWindowId);
    encoder.encodeStruct(codec.String, val.devtoolsRequestId);
    encoder.encodeStruct(codec.String, val.devtoolsStackId);
    encoder.encodeStruct(codec.Int32, val.originalDestination);
    encoder.encodeStruct(codec.Int32, val.requiredIpAddressSpace);
    encoder.encodeStructPointer(TrustedUrlRequestParams, val.trustedParams);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.recursivePrefetchToken);
    encoder.encodeStructPointer(trust_tokens$.TrustTokenParams, val.trustTokenParams);
    encoder.encodeStructPointer(WebBundleTokenParams, val.webBundleTokenParams);
    encoder.encodeArrayPointer(new codec.Enum(source_type$.SourceType), val.devtoolsAcceptedStreamTypes);
    encoder.encodeStructPointer(network_param$.NetLogSource, val.netLogCreateInfo);
    encoder.encodeStructPointer(network_param$.NetLogSource, val.netLogReferenceInfo);
    encoder.encodeStruct(codec.Int32, val.storageAccessApiStatus);
    encoder.encodeStruct(codec.Int32, val.attributionReportingSupport);
    encoder.encodeStruct(codec.Int32, val.attributionReportingEligibility);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.attributionReportingSrcToken);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.keepaliveToken);
    encoder.encodeStructPointer(SocketTag, val.socketTag);
    encoder.encodeStructPointer(permissions_policy$.PermissionsPolicy, val.permissionsPolicy);
    encoder.encodeStructPointer(fetch_retry_options$.FetchRetryOptions, val.fetchRetryOptions);
  };
  function URLRequestBody(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLRequestBody.prototype.initDefaults_ = function() {
    this.elements = null;
    this.identifier = 0;
    this.containsSensitiveInfo = false;
    this.allowHttp1ForStreamingUpload = false;
  };
  URLRequestBody.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLRequestBody.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLRequestBody.elements
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 16, DataElement, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  URLRequestBody.encodedSize = codec.kStructHeaderSize + 24;

  URLRequestBody.decode = function(decoder) {
    var packed;
    var val = new URLRequestBody();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.elements =
        decoder.decodeArrayPointer(DataElement);
    val.identifier =
        decoder.decodeStruct(codec.Uint64);
    packed = decoder.readUint8();
    val.containsSensitiveInfo = (packed >> 0) & 1 ? true : false;
    val.allowHttp1ForStreamingUpload = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  URLRequestBody.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLRequestBody.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(DataElement, val.elements);
    encoder.encodeStruct(codec.Uint64, val.identifier);
    packed = 0;
    packed |= (val.containsSensitiveInfo & 1) << 0
    packed |= (val.allowHttp1ForStreamingUpload & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function DataElementBytes(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DataElementBytes.prototype.initDefaults_ = function() {
    this.data = null;
  };
  DataElementBytes.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DataElementBytes.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DataElementBytes.data
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, big_buffer$.BigBuffer, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DataElementBytes.encodedSize = codec.kStructHeaderSize + 16;

  DataElementBytes.decode = function(decoder) {
    var packed;
    var val = new DataElementBytes();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.data =
        decoder.decodeStruct(big_buffer$.BigBuffer);
    return val;
  };

  DataElementBytes.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DataElementBytes.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(big_buffer$.BigBuffer, val.data);
  };
  function DataElementFile(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DataElementFile.prototype.initDefaults_ = function() {
    this.path = null;
    this.offset = 0;
    this.length = 0;
    this.expectedModificationTime = null;
  };
  DataElementFile.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DataElementFile.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DataElementFile.path
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_path$.FilePath, false);
    if (err !== validator.validationError.NONE)
        return err;




    // validate DataElementFile.expectedModificationTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DataElementFile.encodedSize = codec.kStructHeaderSize + 32;

  DataElementFile.decode = function(decoder) {
    var packed;
    var val = new DataElementFile();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.path =
        decoder.decodeStructPointer(file_path$.FilePath);
    val.offset =
        decoder.decodeStruct(codec.Uint64);
    val.length =
        decoder.decodeStruct(codec.Uint64);
    val.expectedModificationTime =
        decoder.decodeStructPointer(time$.Time);
    return val;
  };

  DataElementFile.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DataElementFile.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_path$.FilePath, val.path);
    encoder.encodeStruct(codec.Uint64, val.offset);
    encoder.encodeStruct(codec.Uint64, val.length);
    encoder.encodeStructPointer(time$.Time, val.expectedModificationTime);
  };
  function DataElementDataPipe(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DataElementDataPipe.prototype.initDefaults_ = function() {
    this.dataPipeGetter = new data_pipe_getter$.DataPipeGetterPtr();
  };
  DataElementDataPipe.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DataElementDataPipe.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DataElementDataPipe.dataPipeGetter
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DataElementDataPipe.encodedSize = codec.kStructHeaderSize + 8;

  DataElementDataPipe.decode = function(decoder) {
    var packed;
    var val = new DataElementDataPipe();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.dataPipeGetter =
        decoder.decodeStruct(new codec.Interface(data_pipe_getter$.DataPipeGetterPtr));
    return val;
  };

  DataElementDataPipe.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DataElementDataPipe.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(data_pipe_getter$.DataPipeGetterPtr), val.dataPipeGetter);
  };
  function DataElementChunkedDataPipe(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DataElementChunkedDataPipe.prototype.initDefaults_ = function() {
    this.dataPipeGetter = new chunked_data_pipe_getter$.ChunkedDataPipeGetterPtr();
    this.readOnlyOnce = false;
  };
  DataElementChunkedDataPipe.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DataElementChunkedDataPipe.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DataElementChunkedDataPipe.dataPipeGetter
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  DataElementChunkedDataPipe.encodedSize = codec.kStructHeaderSize + 16;

  DataElementChunkedDataPipe.decode = function(decoder) {
    var packed;
    var val = new DataElementChunkedDataPipe();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.dataPipeGetter =
        decoder.decodeStruct(new codec.Interface(chunked_data_pipe_getter$.ChunkedDataPipeGetterPtr));
    packed = decoder.readUint8();
    val.readOnlyOnce = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  DataElementChunkedDataPipe.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DataElementChunkedDataPipe.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(chunked_data_pipe_getter$.ChunkedDataPipeGetterPtr), val.dataPipeGetter);
    packed = 0;
    packed |= (val.readOnlyOnce & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SocketTag(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SocketTag.prototype.initDefaults_ = function() {
  };
  SocketTag.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SocketTag.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SocketTag.encodedSize = codec.kStructHeaderSize + 0;

  SocketTag.decode = function(decoder) {
    var packed;
    var val = new SocketTag();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SocketTag.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SocketTag.encodedSize);
    encoder.writeUint32(0);
  };

  function DataElement(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  DataElement.Tags = {
    bytes: 0,
    file: 1,
    dataPipe: 2,
    chunkedDataPipe: 3,
  };

  DataElement.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  DataElement.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "bytes",
        "file",
        "dataPipe",
        "chunkedDataPipe",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a DataElement member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(DataElement.prototype, "bytes", {
    get: function() {
      if (this.$tag != DataElement.Tags.bytes) {
        throw new ReferenceError(
            "DataElement.bytes is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = DataElement.Tags.bytes;
      this.$data = value;
    }
  });
  Object.defineProperty(DataElement.prototype, "file", {
    get: function() {
      if (this.$tag != DataElement.Tags.file) {
        throw new ReferenceError(
            "DataElement.file is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = DataElement.Tags.file;
      this.$data = value;
    }
  });
  Object.defineProperty(DataElement.prototype, "dataPipe", {
    get: function() {
      if (this.$tag != DataElement.Tags.dataPipe) {
        throw new ReferenceError(
            "DataElement.dataPipe is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = DataElement.Tags.dataPipe;
      this.$data = value;
    }
  });
  Object.defineProperty(DataElement.prototype, "chunkedDataPipe", {
    get: function() {
      if (this.$tag != DataElement.Tags.chunkedDataPipe) {
        throw new ReferenceError(
            "DataElement.chunkedDataPipe is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = DataElement.Tags.chunkedDataPipe;
      this.$data = value;
    }
  });


    DataElement.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case DataElement.Tags.bytes:
          encoder.encodeStructPointer(DataElementBytes, val.bytes);
          break;
        case DataElement.Tags.file:
          encoder.encodeStructPointer(DataElementFile, val.file);
          break;
        case DataElement.Tags.dataPipe:
          encoder.encodeStructPointer(DataElementDataPipe, val.dataPipe);
          break;
        case DataElement.Tags.chunkedDataPipe:
          encoder.encodeStructPointer(DataElementChunkedDataPipe, val.chunkedDataPipe);
          break;
      }
      encoder.align();
    };


    DataElement.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new DataElement();
      var tag = decoder.readUint32();
      switch (tag) {
        case DataElement.Tags.bytes:
          result.bytes = decoder.decodeStructPointer(DataElementBytes);
          break;
        case DataElement.Tags.file:
          result.file = decoder.decodeStructPointer(DataElementFile);
          break;
        case DataElement.Tags.dataPipe:
          result.dataPipe = decoder.decodeStructPointer(DataElementDataPipe);
          break;
        case DataElement.Tags.chunkedDataPipe:
          result.chunkedDataPipe = decoder.decodeStructPointer(DataElementChunkedDataPipe);
          break;
      }
      decoder.align();

      return result;
    };


    DataElement.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case DataElement.Tags.bytes:
          

    // validate DataElement.bytes
    err = messageValidator.validateStructPointer(data_offset, DataElementBytes, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case DataElement.Tags.file:
          

    // validate DataElement.file
    err = messageValidator.validateStructPointer(data_offset, DataElementFile, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case DataElement.Tags.dataPipe:
          

    // validate DataElement.dataPipe
    err = messageValidator.validateStructPointer(data_offset, DataElementDataPipe, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case DataElement.Tags.chunkedDataPipe:
          

    // validate DataElement.chunkedDataPipe
    err = messageValidator.validateStructPointer(data_offset, DataElementChunkedDataPipe, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  DataElement.encodedSize = 16;
  exports.EnabledClientHints = EnabledClientHints;
  exports.TrustedUrlRequestParams = TrustedUrlRequestParams;
  exports.WebBundleTokenParams = WebBundleTokenParams;
  exports.URLRequest = URLRequest;
  exports.URLRequestBody = URLRequestBody;
  exports.DataElementBytes = DataElementBytes;
  exports.DataElementFile = DataElementFile;
  exports.DataElementDataPipe = DataElementDataPipe;
  exports.DataElementChunkedDataPipe = DataElementChunkedDataPipe;
  exports.SocketTag = SocketTag;
  exports.DataElement = DataElement;
})();