// services/network/public/mojom/url_request.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_URL_REQUEST_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_URL_REQUEST_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/url_request.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/accept_ch_frame_observer.mojom-shared.h"
#include "services/network/public/mojom/attribution.mojom-shared.h"
#include "services/network/public/mojom/chunked_data_pipe_getter.mojom-shared.h"
#include "services/network/public/mojom/client_security_state.mojom-shared.h"
#include "services/network/public/mojom/cookie_access_observer.mojom-shared.h"
#include "services/network/public/mojom/cookie_manager.mojom-shared.h"
#include "services/network/public/mojom/cors.mojom-shared.h"
#include "services/network/public/mojom/data_pipe_getter.mojom-shared.h"
#include "services/network/public/mojom/device_bound_sessions.mojom-shared.h"
#include "services/network/public/mojom/devtools_observer.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "services/network/public/mojom/fetch_retry_options.mojom-shared.h"
#include "services/network/public/mojom/http_raw_headers.mojom-shared.h"
#include "services/network/public/mojom/http_request_headers.mojom-shared.h"
#include "services/network/public/mojom/ip_address_space.mojom-shared.h"
#include "services/network/public/mojom/isolation_info.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/permissions_policy/permissions_policy.mojom-shared.h"
#include "services/network/public/mojom/referrer_policy.mojom-shared.h"
#include "services/network/public/mojom/request_priority.mojom-shared.h"
#include "services/network/public/mojom/shared_dictionary_access_observer.mojom-shared.h"
#include "services/network/public/mojom/site_for_cookies.mojom-shared.h"
#include "services/network/public/mojom/source_type.mojom-shared.h"
#include "services/network/public/mojom/storage_access_api.mojom-shared.h"
#include "services/network/public/mojom/trust_token_access_observer.mojom-shared.h"
#include "services/network/public/mojom/trust_tokens.mojom-shared.h"
#include "services/network/public/mojom/url_loader_network_service_observer.mojom-shared.h"
#include "services/network/public/mojom/url_response_head.mojom-shared.h"
#include "services/network/public/mojom/web_bundle_handle.mojom-shared.h"
#include "services/network/public/mojom/web_client_hints_types.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/network/public/mojom/url_request.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::EnabledClientHintsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::EnabledClientHintsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::EnabledClientHints_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::origin(input)) in_origin = Traits::origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origin)::BaseType> origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin,
      origin_fragment);

    fragment->origin.Set(
        origin_fragment.is_null() ? nullptr : origin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->origin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in EnabledClientHints struct");

    fragment->is_outermost_main_frame = Traits::is_outermost_main_frame(input);

    decltype(Traits::hints(input)) in_hints = Traits::hints(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hints)::BaseType>
        hints_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& hints_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::WebClientHintsType_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::WebClientHintsType>>(
      in_hints,
      hints_fragment,
      &hints_validate_params);

    fragment->hints.Set(
        hints_fragment.is_null() ? nullptr : hints_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->hints.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null hints in EnabledClientHints struct");

    decltype(Traits::not_allowed_hints(input)) in_not_allowed_hints = Traits::not_allowed_hints(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->not_allowed_hints)::BaseType>
        not_allowed_hints_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& not_allowed_hints_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::WebClientHintsType_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::WebClientHintsType>>(
      in_not_allowed_hints,
      not_allowed_hints_fragment,
      &not_allowed_hints_validate_params);

    fragment->not_allowed_hints.Set(
        not_allowed_hints_fragment.is_null() ? nullptr : not_allowed_hints_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->not_allowed_hints.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null not_allowed_hints in EnabledClientHints struct");
  }

  static bool Deserialize(::network::mojom::internal::EnabledClientHints_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::EnabledClientHintsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::TrustedUrlRequestParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::TrustedUrlRequestParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::TrustedUrlRequestParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::isolation_info(input)) in_isolation_info = Traits::isolation_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->isolation_info)::BaseType> isolation_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::IsolationInfoDataView>(
      in_isolation_info,
      isolation_info_fragment);

    fragment->isolation_info.Set(
        isolation_info_fragment.is_null() ? nullptr : isolation_info_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->isolation_info.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null isolation_info in TrustedUrlRequestParams struct");

    fragment->disable_secure_dns = Traits::disable_secure_dns(input);

    fragment->has_user_activation = Traits::has_user_activation(input);

    fragment->allow_cookies_from_browser = Traits::allow_cookies_from_browser(input);

    fragment->include_request_cookies_with_response = Traits::include_request_cookies_with_response(input);

    decltype(Traits::enabled_client_hints(input)) in_enabled_client_hints = Traits::enabled_client_hints(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->enabled_client_hints)::BaseType> enabled_client_hints_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::EnabledClientHintsDataView>(
      in_enabled_client_hints,
      enabled_client_hints_fragment);

    fragment->enabled_client_hints.Set(
        enabled_client_hints_fragment.is_null() ? nullptr : enabled_client_hints_fragment.data());

    decltype(Traits::cookie_observer(input)) in_cookie_observer = Traits::cookie_observer(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::CookieAccessObserverInterfaceBase>>(
      in_cookie_observer,
      &fragment->cookie_observer,
      &fragment.message());

    decltype(Traits::trust_token_observer(input)) in_trust_token_observer = Traits::trust_token_observer(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::TrustTokenAccessObserverInterfaceBase>>(
      in_trust_token_observer,
      &fragment->trust_token_observer,
      &fragment.message());

    decltype(Traits::url_loader_network_observer(input)) in_url_loader_network_observer = Traits::url_loader_network_observer(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderNetworkServiceObserverInterfaceBase>>(
      in_url_loader_network_observer,
      &fragment->url_loader_network_observer,
      &fragment.message());

    decltype(Traits::devtools_observer(input)) in_devtools_observer = Traits::devtools_observer(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::DevToolsObserverInterfaceBase>>(
      in_devtools_observer,
      &fragment->devtools_observer,
      &fragment.message());

    decltype(Traits::device_bound_session_observer(input)) in_device_bound_session_observer = Traits::device_bound_session_observer(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::DeviceBoundSessionAccessObserverInterfaceBase>>(
      in_device_bound_session_observer,
      &fragment->device_bound_session_observer,
      &fragment.message());

    decltype(Traits::client_security_state(input)) in_client_security_state = Traits::client_security_state(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->client_security_state)::BaseType> client_security_state_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::ClientSecurityStateDataView>(
      in_client_security_state,
      client_security_state_fragment);

    fragment->client_security_state.Set(
        client_security_state_fragment.is_null() ? nullptr : client_security_state_fragment.data());

    decltype(Traits::accept_ch_frame_observer(input)) in_accept_ch_frame_observer = Traits::accept_ch_frame_observer(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::AcceptCHFrameObserverInterfaceBase>>(
      in_accept_ch_frame_observer,
      &fragment->accept_ch_frame_observer,
      &fragment.message());

    decltype(Traits::shared_dictionary_observer(input)) in_shared_dictionary_observer = Traits::shared_dictionary_observer(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::SharedDictionaryAccessObserverInterfaceBase>>(
      in_shared_dictionary_observer,
      &fragment->shared_dictionary_observer,
      &fragment.message());
  }

  static bool Deserialize(::network::mojom::internal::TrustedUrlRequestParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::TrustedUrlRequestParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::WebBundleTokenParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::WebBundleTokenParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::WebBundleTokenParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::bundle_url(input)) in_bundle_url = Traits::bundle_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bundle_url)::BaseType> bundle_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_bundle_url,
      bundle_url_fragment);

    fragment->bundle_url.Set(
        bundle_url_fragment.is_null() ? nullptr : bundle_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->bundle_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bundle_url in WebBundleTokenParams struct");

    decltype(Traits::token(input)) in_token = Traits::token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->token)::BaseType> token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_token,
      token_fragment);

    fragment->token.Set(
        token_fragment.is_null() ? nullptr : token_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null token in WebBundleTokenParams struct");

    decltype(Traits::web_bundle_handle(input)) in_web_bundle_handle = Traits::web_bundle_handle(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::WebBundleHandleInterfaceBase>>(
      in_web_bundle_handle,
      &fragment->web_bundle_handle,
      &fragment.message());

    fragment->render_process_id = Traits::render_process_id(input);
  }

  static bool Deserialize(::network::mojom::internal::WebBundleTokenParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::WebBundleTokenParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::URLRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::URLRequestDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::URLRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::method(input)) in_method = Traits::method(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->method)::BaseType> method_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_method,
      method_fragment);

    fragment->method.Set(
        method_fragment.is_null() ? nullptr : method_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->method.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null method in URLRequest struct");

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in URLRequest struct");

    decltype(Traits::site_for_cookies(input)) in_site_for_cookies = Traits::site_for_cookies(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->site_for_cookies)::BaseType> site_for_cookies_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
      in_site_for_cookies,
      site_for_cookies_fragment);

    fragment->site_for_cookies.Set(
        site_for_cookies_fragment.is_null() ? nullptr : site_for_cookies_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->site_for_cookies.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null site_for_cookies in URLRequest struct");

    fragment->update_first_party_url_on_redirect = Traits::update_first_party_url_on_redirect(input);

    decltype(Traits::request_initiator(input)) in_request_initiator = Traits::request_initiator(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->request_initiator)::BaseType> request_initiator_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_request_initiator,
      request_initiator_fragment);

    fragment->request_initiator.Set(
        request_initiator_fragment.is_null() ? nullptr : request_initiator_fragment.data());

    decltype(Traits::navigation_redirect_chain(input)) in_navigation_redirect_chain = Traits::navigation_redirect_chain(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->navigation_redirect_chain)::BaseType>
        navigation_redirect_chain_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& navigation_redirect_chain_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
      in_navigation_redirect_chain,
      navigation_redirect_chain_fragment,
      &navigation_redirect_chain_validate_params);

    fragment->navigation_redirect_chain.Set(
        navigation_redirect_chain_fragment.is_null() ? nullptr : navigation_redirect_chain_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->navigation_redirect_chain.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null navigation_redirect_chain in URLRequest struct");

    decltype(Traits::isolated_world_origin(input)) in_isolated_world_origin = Traits::isolated_world_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->isolated_world_origin)::BaseType> isolated_world_origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_isolated_world_origin,
      isolated_world_origin_fragment);

    fragment->isolated_world_origin.Set(
        isolated_world_origin_fragment.is_null() ? nullptr : isolated_world_origin_fragment.data());

    decltype(Traits::referrer(input)) in_referrer = Traits::referrer(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->referrer)::BaseType> referrer_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_referrer,
      referrer_fragment);

    fragment->referrer.Set(
        referrer_fragment.is_null() ? nullptr : referrer_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->referrer.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null referrer in URLRequest struct");

    
    mojo::internal::Serialize<::network::mojom::URLRequestReferrerPolicy>(
      Traits::referrer_policy(input),
      &fragment->referrer_policy);

    decltype(Traits::headers(input)) in_headers = Traits::headers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->headers)::BaseType> headers_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::HttpRequestHeadersDataView>(
      in_headers,
      headers_fragment);

    fragment->headers.Set(
        headers_fragment.is_null() ? nullptr : headers_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->headers.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null headers in URLRequest struct");

    decltype(Traits::cors_exempt_headers(input)) in_cors_exempt_headers = Traits::cors_exempt_headers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cors_exempt_headers)::BaseType> cors_exempt_headers_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::HttpRequestHeadersDataView>(
      in_cors_exempt_headers,
      cors_exempt_headers_fragment);

    fragment->cors_exempt_headers.Set(
        cors_exempt_headers_fragment.is_null() ? nullptr : cors_exempt_headers_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->cors_exempt_headers.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cors_exempt_headers in URLRequest struct");

    fragment->load_flags = Traits::load_flags(input);

    fragment->resource_type = Traits::resource_type(input);

    
    mojo::internal::Serialize<::network::mojom::RequestPriority>(
      Traits::priority(input),
      &fragment->priority);

    fragment->priority_incremental = Traits::priority_incremental(input);

    
    mojo::internal::Serialize<::network::mojom::CorsPreflightPolicy>(
      Traits::cors_preflight_policy(input),
      &fragment->cors_preflight_policy);

    fragment->originated_from_service_worker = Traits::originated_from_service_worker(input);

    fragment->skip_service_worker = Traits::skip_service_worker(input);

    
    mojo::internal::Serialize<::network::mojom::RequestMode>(
      Traits::mode(input),
      &fragment->mode);

    
    mojo::internal::Serialize<::network::mojom::CredentialsMode>(
      Traits::credentials_mode(input),
      &fragment->credentials_mode);

    
    mojo::internal::Serialize<::network::mojom::RedirectMode>(
      Traits::redirect_mode(input),
      &fragment->redirect_mode);

    decltype(Traits::fetch_integrity(input)) in_fetch_integrity = Traits::fetch_integrity(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->fetch_integrity)::BaseType> fetch_integrity_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_fetch_integrity,
      fetch_integrity_fragment);

    fragment->fetch_integrity.Set(
        fetch_integrity_fragment.is_null() ? nullptr : fetch_integrity_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->fetch_integrity.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null fetch_integrity in URLRequest struct");

    decltype(Traits::expected_public_keys(input)) in_expected_public_keys = Traits::expected_public_keys(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->expected_public_keys)::BaseType>
        expected_public_keys_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& expected_public_keys_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>>(
      in_expected_public_keys,
      expected_public_keys_fragment,
      &expected_public_keys_validate_params);

    fragment->expected_public_keys.Set(
        expected_public_keys_fragment.is_null() ? nullptr : expected_public_keys_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->expected_public_keys.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null expected_public_keys in URLRequest struct");

    
    mojo::internal::Serialize<::network::mojom::RequestDestination>(
      Traits::destination(input),
      &fragment->destination);

    decltype(Traits::request_body(input)) in_request_body = Traits::request_body(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->request_body)::BaseType> request_body_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::URLRequestBodyDataView>(
      in_request_body,
      request_body_fragment);

    fragment->request_body.Set(
        request_body_fragment.is_null() ? nullptr : request_body_fragment.data());

    fragment->keepalive = Traits::keepalive(input);

    fragment->browsing_topics = Traits::browsing_topics(input);

    fragment->ad_auction_headers = Traits::ad_auction_headers(input);

    fragment->shared_storage_writable_eligible = Traits::shared_storage_writable_eligible(input);

    fragment->has_user_gesture = Traits::has_user_gesture(input);

    fragment->enable_load_timing = Traits::enable_load_timing(input);

    fragment->enable_upload_progress = Traits::enable_upload_progress(input);

    fragment->do_not_prompt_for_login = Traits::do_not_prompt_for_login(input);

    fragment->is_outermost_main_frame = Traits::is_outermost_main_frame(input);

    fragment->transition_type = Traits::transition_type(input);

    fragment->previews_state = Traits::previews_state(input);

    fragment->upgrade_if_insecure = Traits::upgrade_if_insecure(input);

    fragment->is_revalidating = Traits::is_revalidating(input);

    decltype(Traits::throttling_profile_id(input)) in_throttling_profile_id = Traits::throttling_profile_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->throttling_profile_id)::BaseType> throttling_profile_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_throttling_profile_id,
      throttling_profile_id_fragment);

    fragment->throttling_profile_id.Set(
        throttling_profile_id_fragment.is_null() ? nullptr : throttling_profile_id_fragment.data());

    decltype(Traits::fetch_window_id(input)) in_fetch_window_id = Traits::fetch_window_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->fetch_window_id)::BaseType> fetch_window_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_fetch_window_id,
      fetch_window_id_fragment);

    fragment->fetch_window_id.Set(
        fetch_window_id_fragment.is_null() ? nullptr : fetch_window_id_fragment.data());

    decltype(Traits::devtools_request_id(input)) in_devtools_request_id = Traits::devtools_request_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->devtools_request_id)::BaseType> devtools_request_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_devtools_request_id,
      devtools_request_id_fragment);

    fragment->devtools_request_id.Set(
        devtools_request_id_fragment.is_null() ? nullptr : devtools_request_id_fragment.data());

    decltype(Traits::devtools_stack_id(input)) in_devtools_stack_id = Traits::devtools_stack_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->devtools_stack_id)::BaseType> devtools_stack_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_devtools_stack_id,
      devtools_stack_id_fragment);

    fragment->devtools_stack_id.Set(
        devtools_stack_id_fragment.is_null() ? nullptr : devtools_stack_id_fragment.data());

    fragment->is_fetch_like_api = Traits::is_fetch_like_api(input);

    fragment->is_fetch_later_api = Traits::is_fetch_later_api(input);

    fragment->is_favicon = Traits::is_favicon(input);

    
    mojo::internal::Serialize<::network::mojom::RequestDestination>(
      Traits::original_destination(input),
      &fragment->original_destination);

    decltype(Traits::trusted_params(input)) in_trusted_params = Traits::trusted_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->trusted_params)::BaseType> trusted_params_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::TrustedUrlRequestParamsDataView>(
      in_trusted_params,
      trusted_params_fragment);

    fragment->trusted_params.Set(
        trusted_params_fragment.is_null() ? nullptr : trusted_params_fragment.data());

    decltype(Traits::recursive_prefetch_token(input)) in_recursive_prefetch_token = Traits::recursive_prefetch_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->recursive_prefetch_token)::BaseType> recursive_prefetch_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_recursive_prefetch_token,
      recursive_prefetch_token_fragment);

    fragment->recursive_prefetch_token.Set(
        recursive_prefetch_token_fragment.is_null() ? nullptr : recursive_prefetch_token_fragment.data());

    decltype(Traits::trust_token_params(input)) in_trust_token_params = Traits::trust_token_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->trust_token_params)::BaseType> trust_token_params_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::TrustTokenParamsDataView>(
      in_trust_token_params,
      trust_token_params_fragment);

    fragment->trust_token_params.Set(
        trust_token_params_fragment.is_null() ? nullptr : trust_token_params_fragment.data());

    decltype(Traits::web_bundle_token_params(input)) in_web_bundle_token_params = Traits::web_bundle_token_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->web_bundle_token_params)::BaseType> web_bundle_token_params_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::WebBundleTokenParamsDataView>(
      in_web_bundle_token_params,
      web_bundle_token_params_fragment);

    fragment->web_bundle_token_params.Set(
        web_bundle_token_params_fragment.is_null() ? nullptr : web_bundle_token_params_fragment.data());

    decltype(Traits::devtools_accepted_stream_types(input)) in_devtools_accepted_stream_types = Traits::devtools_accepted_stream_types(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->devtools_accepted_stream_types)::BaseType>
        devtools_accepted_stream_types_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& devtools_accepted_stream_types_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::SourceType_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::SourceType>>(
      in_devtools_accepted_stream_types,
      devtools_accepted_stream_types_fragment,
      &devtools_accepted_stream_types_validate_params);

    fragment->devtools_accepted_stream_types.Set(
        devtools_accepted_stream_types_fragment.is_null() ? nullptr : devtools_accepted_stream_types_fragment.data());

    decltype(Traits::net_log_create_info(input)) in_net_log_create_info = Traits::net_log_create_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->net_log_create_info)::BaseType> net_log_create_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::NetLogSourceDataView>(
      in_net_log_create_info,
      net_log_create_info_fragment);

    fragment->net_log_create_info.Set(
        net_log_create_info_fragment.is_null() ? nullptr : net_log_create_info_fragment.data());

    decltype(Traits::net_log_reference_info(input)) in_net_log_reference_info = Traits::net_log_reference_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->net_log_reference_info)::BaseType> net_log_reference_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::NetLogSourceDataView>(
      in_net_log_reference_info,
      net_log_reference_info_fragment);

    fragment->net_log_reference_info.Set(
        net_log_reference_info_fragment.is_null() ? nullptr : net_log_reference_info_fragment.data());

    
    mojo::internal::Serialize<::network::mojom::IPAddressSpace>(
      Traits::required_ip_address_space(input),
      &fragment->required_ip_address_space);

    
    mojo::internal::Serialize<::network::mojom::StorageAccessApiStatus>(
      Traits::storage_access_api_status(input),
      &fragment->storage_access_api_status);

    
    mojo::internal::Serialize<::network::mojom::AttributionSupport>(
      Traits::attribution_reporting_support(input),
      &fragment->attribution_reporting_support);

    
    mojo::internal::Serialize<::network::mojom::AttributionReportingEligibility>(
      Traits::attribution_reporting_eligibility(input),
      &fragment->attribution_reporting_eligibility);

    decltype(Traits::attribution_reporting_src_token(input)) in_attribution_reporting_src_token = Traits::attribution_reporting_src_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->attribution_reporting_src_token)::BaseType> attribution_reporting_src_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_attribution_reporting_src_token,
      attribution_reporting_src_token_fragment);

    fragment->attribution_reporting_src_token.Set(
        attribution_reporting_src_token_fragment.is_null() ? nullptr : attribution_reporting_src_token_fragment.data());

    decltype(Traits::keepalive_token(input)) in_keepalive_token = Traits::keepalive_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->keepalive_token)::BaseType> keepalive_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_keepalive_token,
      keepalive_token_fragment);

    fragment->keepalive_token.Set(
        keepalive_token_fragment.is_null() ? nullptr : keepalive_token_fragment.data());

    fragment->is_ad_tagged = Traits::is_ad_tagged(input);

    fragment->shared_dictionary_writer_enabled = Traits::shared_dictionary_writer_enabled(input);

    fragment->client_side_content_decoding_enabled = Traits::client_side_content_decoding_enabled(input);

    decltype(Traits::socket_tag(input)) in_socket_tag = Traits::socket_tag(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->socket_tag)::BaseType> socket_tag_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::SocketTagDataView>(
      in_socket_tag,
      socket_tag_fragment);

    fragment->socket_tag.Set(
        socket_tag_fragment.is_null() ? nullptr : socket_tag_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->socket_tag.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null socket_tag in URLRequest struct");

    fragment->allows_device_bound_session_registration = Traits::allows_device_bound_session_registration(input);

    decltype(Traits::permissions_policy(input)) in_permissions_policy = Traits::permissions_policy(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->permissions_policy)::BaseType> permissions_policy_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::PermissionsPolicyDataView>(
      in_permissions_policy,
      permissions_policy_fragment);

    fragment->permissions_policy.Set(
        permissions_policy_fragment.is_null() ? nullptr : permissions_policy_fragment.data());

    decltype(Traits::fetch_retry_options(input)) in_fetch_retry_options = Traits::fetch_retry_options(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->fetch_retry_options)::BaseType> fetch_retry_options_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::FetchRetryOptionsDataView>(
      in_fetch_retry_options,
      fetch_retry_options_fragment);

    fragment->fetch_retry_options.Set(
        fetch_retry_options_fragment.is_null() ? nullptr : fetch_retry_options_fragment.data());
  }

  static bool Deserialize(::network::mojom::internal::URLRequest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::URLRequestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::URLRequestBodyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::URLRequestBodyDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::URLRequestBody_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::elements(input)) in_elements = Traits::elements(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->elements)::BaseType>
        elements_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& elements_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::DataElementDataView>>(
      in_elements,
      elements_fragment,
      &elements_validate_params);

    fragment->elements.Set(
        elements_fragment.is_null() ? nullptr : elements_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->elements.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null elements in URLRequestBody struct");

    fragment->identifier = Traits::identifier(input);

    fragment->contains_sensitive_info = Traits::contains_sensitive_info(input);

    fragment->allow_http1_for_streaming_upload = Traits::allow_http1_for_streaming_upload(input);
  }

  static bool Deserialize(::network::mojom::internal::URLRequestBody_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::URLRequestBodyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DataElementBytesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DataElementBytesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DataElementBytes_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<decltype(fragment->data)>
        data_fragment(fragment.message());
    data_fragment.Claim(&fragment->data);
    
    mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
      in_data,
      data_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in DataElementBytes struct");
  }

  static bool Deserialize(::network::mojom::internal::DataElementBytes_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::DataElementBytesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DataElementFileDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DataElementFileDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DataElementFile_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::path(input)) in_path = Traits::path(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->path)::BaseType> path_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_path,
      path_fragment);

    fragment->path.Set(
        path_fragment.is_null() ? nullptr : path_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->path.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in DataElementFile struct");

    fragment->offset = Traits::offset(input);

    fragment->length = Traits::length(input);

    decltype(Traits::expected_modification_time(input)) in_expected_modification_time = Traits::expected_modification_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->expected_modification_time)::BaseType> expected_modification_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_expected_modification_time,
      expected_modification_time_fragment);

    fragment->expected_modification_time.Set(
        expected_modification_time_fragment.is_null() ? nullptr : expected_modification_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->expected_modification_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null expected_modification_time in DataElementFile struct");
  }

  static bool Deserialize(::network::mojom::internal::DataElementFile_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::DataElementFileDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DataElementDataPipeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DataElementDataPipeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DataElementDataPipe_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::data_pipe_getter(input)) in_data_pipe_getter = Traits::data_pipe_getter(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::DataPipeGetterInterfaceBase>>(
      in_data_pipe_getter,
      &fragment->data_pipe_getter,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->data_pipe_getter)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid data_pipe_getter in DataElementDataPipe struct");
  }

  static bool Deserialize(::network::mojom::internal::DataElementDataPipe_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::DataElementDataPipeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DataElementChunkedDataPipeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DataElementChunkedDataPipeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DataElementChunkedDataPipe_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::data_pipe_getter(input)) in_data_pipe_getter = Traits::data_pipe_getter(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::ChunkedDataPipeGetterInterfaceBase>>(
      in_data_pipe_getter,
      &fragment->data_pipe_getter,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->data_pipe_getter)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid data_pipe_getter in DataElementChunkedDataPipe struct");

    fragment->read_only_once = Traits::read_only_once(input);
  }

  static bool Deserialize(::network::mojom::internal::DataElementChunkedDataPipe_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::DataElementChunkedDataPipeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SocketTagDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SocketTagDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SocketTag_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }

  static bool Deserialize(::network::mojom::internal::SocketTag_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SocketTagDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DataElementDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::network::mojom::DataElementDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::network::mojom::internal::DataElement_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::network::mojom::DataElementDataView::Tag::kBytes: {
    decltype(Traits::bytes(input))
    in_bytes = Traits::bytes(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_bytes)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::network::mojom::DataElementBytesDataView>(
  in_bytes,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null bytes in DataElement union");
    fragment->data.f_bytes.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::network::mojom::DataElementDataView::Tag::kFile: {
    decltype(Traits::file(input))
    in_file = Traits::file(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_file)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::network::mojom::DataElementFileDataView>(
  in_file,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null file in DataElement union");
    fragment->data.f_file.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::network::mojom::DataElementDataView::Tag::kDataPipe: {
    decltype(Traits::data_pipe(input))
    in_data_pipe = Traits::data_pipe(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_data_pipe)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::network::mojom::DataElementDataPipeDataView>(
  in_data_pipe,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null data_pipe in DataElement union");
    fragment->data.f_data_pipe.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::network::mojom::DataElementDataView::Tag::kChunkedDataPipe: {
    decltype(Traits::chunked_data_pipe(input))
    in_chunked_data_pipe = Traits::chunked_data_pipe(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_chunked_data_pipe)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::network::mojom::DataElementChunkedDataPipeDataView>(
  in_chunked_data_pipe,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null chunked_data_pipe in DataElement union");
    fragment->data.f_chunked_data_pipe.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::network::mojom::internal::DataElement_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::DataElementDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void EnabledClientHintsDataView::GetOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void EnabledClientHintsDataView::GetHintsDataView(
    mojo::ArrayDataView<::network::mojom::WebClientHintsType>* output) {
  auto pointer = data_->hints.Get();
  *output = mojo::ArrayDataView<::network::mojom::WebClientHintsType>(pointer, message_);
}
inline void EnabledClientHintsDataView::GetNotAllowedHintsDataView(
    mojo::ArrayDataView<::network::mojom::WebClientHintsType>* output) {
  auto pointer = data_->not_allowed_hints.Get();
  *output = mojo::ArrayDataView<::network::mojom::WebClientHintsType>(pointer, message_);
}


inline void TrustedUrlRequestParamsDataView::GetIsolationInfoDataView(
    ::network::mojom::IsolationInfoDataView* output) {
  auto pointer = data_->isolation_info.Get();
  *output = ::network::mojom::IsolationInfoDataView(pointer, message_);
}
inline void TrustedUrlRequestParamsDataView::GetEnabledClientHintsDataView(
    EnabledClientHintsDataView* output) {
  auto pointer = data_->enabled_client_hints.Get();
  *output = EnabledClientHintsDataView(pointer, message_);
}
inline void TrustedUrlRequestParamsDataView::GetClientSecurityStateDataView(
    ::network::mojom::ClientSecurityStateDataView* output) {
  auto pointer = data_->client_security_state.Get();
  *output = ::network::mojom::ClientSecurityStateDataView(pointer, message_);
}


inline void WebBundleTokenParamsDataView::GetBundleUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->bundle_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void WebBundleTokenParamsDataView::GetTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}


inline void URLRequestDataView::GetMethodDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->method.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void URLRequestDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void URLRequestDataView::GetSiteForCookiesDataView(
    ::network::mojom::SiteForCookiesDataView* output) {
  auto pointer = data_->site_for_cookies.Get();
  *output = ::network::mojom::SiteForCookiesDataView(pointer, message_);
}
inline void URLRequestDataView::GetRequestInitiatorDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->request_initiator.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void URLRequestDataView::GetNavigationRedirectChainDataView(
    mojo::ArrayDataView<::url::mojom::UrlDataView>* output) {
  auto pointer = data_->navigation_redirect_chain.Get();
  *output = mojo::ArrayDataView<::url::mojom::UrlDataView>(pointer, message_);
}
inline void URLRequestDataView::GetIsolatedWorldOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->isolated_world_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void URLRequestDataView::GetReferrerDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->referrer.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void URLRequestDataView::GetHeadersDataView(
    ::network::mojom::HttpRequestHeadersDataView* output) {
  auto pointer = data_->headers.Get();
  *output = ::network::mojom::HttpRequestHeadersDataView(pointer, message_);
}
inline void URLRequestDataView::GetCorsExemptHeadersDataView(
    ::network::mojom::HttpRequestHeadersDataView* output) {
  auto pointer = data_->cors_exempt_headers.Get();
  *output = ::network::mojom::HttpRequestHeadersDataView(pointer, message_);
}
inline void URLRequestDataView::GetFetchIntegrityDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->fetch_integrity.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void URLRequestDataView::GetExpectedPublicKeysDataView(
    mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>* output) {
  auto pointer = data_->expected_public_keys.Get();
  *output = mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>(pointer, message_);
}
inline void URLRequestDataView::GetRequestBodyDataView(
    URLRequestBodyDataView* output) {
  auto pointer = data_->request_body.Get();
  *output = URLRequestBodyDataView(pointer, message_);
}
inline void URLRequestDataView::GetThrottlingProfileIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->throttling_profile_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void URLRequestDataView::GetFetchWindowIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->fetch_window_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void URLRequestDataView::GetDevtoolsRequestIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->devtools_request_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void URLRequestDataView::GetDevtoolsStackIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->devtools_stack_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void URLRequestDataView::GetTrustedParamsDataView(
    TrustedUrlRequestParamsDataView* output) {
  auto pointer = data_->trusted_params.Get();
  *output = TrustedUrlRequestParamsDataView(pointer, message_);
}
inline void URLRequestDataView::GetRecursivePrefetchTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->recursive_prefetch_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void URLRequestDataView::GetTrustTokenParamsDataView(
    ::network::mojom::TrustTokenParamsDataView* output) {
  auto pointer = data_->trust_token_params.Get();
  *output = ::network::mojom::TrustTokenParamsDataView(pointer, message_);
}
inline void URLRequestDataView::GetWebBundleTokenParamsDataView(
    WebBundleTokenParamsDataView* output) {
  auto pointer = data_->web_bundle_token_params.Get();
  *output = WebBundleTokenParamsDataView(pointer, message_);
}
inline void URLRequestDataView::GetDevtoolsAcceptedStreamTypesDataView(
    mojo::ArrayDataView<::network::mojom::SourceType>* output) {
  auto pointer = data_->devtools_accepted_stream_types.Get();
  *output = mojo::ArrayDataView<::network::mojom::SourceType>(pointer, message_);
}
inline void URLRequestDataView::GetNetLogCreateInfoDataView(
    ::network::mojom::NetLogSourceDataView* output) {
  auto pointer = data_->net_log_create_info.Get();
  *output = ::network::mojom::NetLogSourceDataView(pointer, message_);
}
inline void URLRequestDataView::GetNetLogReferenceInfoDataView(
    ::network::mojom::NetLogSourceDataView* output) {
  auto pointer = data_->net_log_reference_info.Get();
  *output = ::network::mojom::NetLogSourceDataView(pointer, message_);
}
inline void URLRequestDataView::GetAttributionReportingSrcTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->attribution_reporting_src_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void URLRequestDataView::GetKeepaliveTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->keepalive_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void URLRequestDataView::GetSocketTagDataView(
    SocketTagDataView* output) {
  auto pointer = data_->socket_tag.Get();
  *output = SocketTagDataView(pointer, message_);
}
inline void URLRequestDataView::GetPermissionsPolicyDataView(
    ::network::mojom::PermissionsPolicyDataView* output) {
  auto pointer = data_->permissions_policy.Get();
  *output = ::network::mojom::PermissionsPolicyDataView(pointer, message_);
}
inline void URLRequestDataView::GetFetchRetryOptionsDataView(
    ::network::mojom::FetchRetryOptionsDataView* output) {
  auto pointer = data_->fetch_retry_options.Get();
  *output = ::network::mojom::FetchRetryOptionsDataView(pointer, message_);
}


inline void URLRequestBodyDataView::GetElementsDataView(
    mojo::ArrayDataView<DataElementDataView>* output) {
  auto pointer = data_->elements.Get();
  *output = mojo::ArrayDataView<DataElementDataView>(pointer, message_);
}


inline void DataElementBytesDataView::GetDataDataView(
    ::mojo_base::mojom::BigBufferDataView* output) {
  auto pointer = &data_->data;
  *output = ::mojo_base::mojom::BigBufferDataView(pointer, message_);
}


inline void DataElementFileDataView::GetPathDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->path.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}
inline void DataElementFileDataView::GetExpectedModificationTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->expected_modification_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}








inline void DataElementDataView::GetBytesDataView(
    DataElementBytesDataView* output) const {
  CHECK(is_bytes());
  *output = DataElementBytesDataView(data_->data.f_bytes.Get(), message_);
}
inline void DataElementDataView::GetFileDataView(
    DataElementFileDataView* output) const {
  CHECK(is_file());
  *output = DataElementFileDataView(data_->data.f_file.Get(), message_);
}
inline void DataElementDataView::GetDataPipeDataView(
    DataElementDataPipeDataView* output) const {
  CHECK(is_data_pipe());
  *output = DataElementDataPipeDataView(data_->data.f_data_pipe.Get(), message_);
}
inline void DataElementDataView::GetChunkedDataPipeDataView(
    DataElementChunkedDataPipeDataView* output) const {
  CHECK(is_chunked_data_pipe());
  *output = DataElementChunkedDataPipeDataView(data_->data.f_chunked_data_pipe.Get(), message_);
}


}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_URL_REQUEST_MOJOM_SHARED_H_