// services/network/public/mojom/url_loader_network_service_observer.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_NETWORK_SERVICE_OBSERVER_MOJOM_TEST_UTILS_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_NETWORK_SERVICE_OBSERVER_MOJOM_TEST_UTILS_H_

#include "services/network/public/mojom/url_loader_network_service_observer.mojom.h"


namespace network::mojom {


class  ClientCertificateResponderInterceptorForTesting : public ClientCertificateResponder {
  virtual ClientCertificateResponder* GetForwardingInterface() = 0;
  void ContinueWithCertificate(const ::scoped_refptr<::net::X509Certificate>& x509_certificate, const std::string& provider_name, const std::vector<uint16_t>& algorithm_preferences, ::mojo::PendingRemote<SSLPrivateKey> ssl_private_key) override;
  void ContinueWithoutCertificate() override;
  void CancelRequest() override;
};
class  ClientCertificateResponderAsyncWaiter {
 public:
  explicit ClientCertificateResponderAsyncWaiter(ClientCertificateResponder* proxy);

  ClientCertificateResponderAsyncWaiter(const ClientCertificateResponderAsyncWaiter&) = delete;
  ClientCertificateResponderAsyncWaiter& operator=(const ClientCertificateResponderAsyncWaiter&) = delete;

  ~ClientCertificateResponderAsyncWaiter();

 private:
  ClientCertificateResponder* const proxy_;
};


class  SSLPrivateKeyInterceptorForTesting : public SSLPrivateKey {
  virtual SSLPrivateKey* GetForwardingInterface() = 0;
  void Sign(uint16_t algorithm, const std::vector<uint8_t>& input, SignCallback callback) override;
};
class  SSLPrivateKeyAsyncWaiter {
 public:
  explicit SSLPrivateKeyAsyncWaiter(SSLPrivateKey* proxy);

  SSLPrivateKeyAsyncWaiter(const SSLPrivateKeyAsyncWaiter&) = delete;
  SSLPrivateKeyAsyncWaiter& operator=(const SSLPrivateKeyAsyncWaiter&) = delete;

  ~SSLPrivateKeyAsyncWaiter();
  void Sign(
      uint16_t algorithm, const std::vector<uint8_t>& input, int32_t* out_net_error, std::vector<uint8_t>* out_signature);
  

 private:
  SSLPrivateKey* const proxy_;
};


class  AuthChallengeResponderInterceptorForTesting : public AuthChallengeResponder {
  virtual AuthChallengeResponder* GetForwardingInterface() = 0;
  void OnAuthCredentials(const std::optional<::net::AuthCredentials>& credentials) override;
};
class  AuthChallengeResponderAsyncWaiter {
 public:
  explicit AuthChallengeResponderAsyncWaiter(AuthChallengeResponder* proxy);

  AuthChallengeResponderAsyncWaiter(const AuthChallengeResponderAsyncWaiter&) = delete;
  AuthChallengeResponderAsyncWaiter& operator=(const AuthChallengeResponderAsyncWaiter&) = delete;

  ~AuthChallengeResponderAsyncWaiter();

 private:
  AuthChallengeResponder* const proxy_;
};


class  URLLoaderNetworkServiceObserverInterceptorForTesting : public URLLoaderNetworkServiceObserver {
  virtual URLLoaderNetworkServiceObserver* GetForwardingInterface() = 0;
  void OnSSLCertificateError(const ::GURL& url, int32_t net_error, const ::net::SSLInfo& ssl_info, bool fatal, OnSSLCertificateErrorCallback callback) override;
  void OnCertificateRequested(const std::optional<::base::UnguessableToken>& window_id, const ::scoped_refptr<::net::SSLCertRequestInfo>& cert_info, ::mojo::PendingRemote<ClientCertificateResponder> cert_responder) override;
  void OnAuthRequired(const std::optional<::base::UnguessableToken>& window_id, int32_t request_id, const ::GURL& url, bool first_auth_attempt, const ::net::AuthChallengeInfo& auth_info, const ::scoped_refptr<::net::HttpResponseHeaders>& head_headers, ::mojo::PendingRemote<AuthChallengeResponder> auth_challenge_responder) override;
  void OnLocalNetworkAccessPermissionRequired(OnLocalNetworkAccessPermissionRequiredCallback callback) override;
  void OnClearSiteData(const ::GURL& url, const std::string& header_value, int32_t load_flags, const std::optional<::net::CookiePartitionKey>& cookie_partition_key, bool partitioned_state_allowed_only, OnClearSiteDataCallback callback) override;
  void OnLoadingStateUpdate(LoadInfoPtr info, OnLoadingStateUpdateCallback callback) override;
  void OnDataUseUpdate(int32_t network_traffic_annotation_id_hash, int64_t recv_bytes, int64_t sent_bytes) override;
  void OnSharedStorageHeaderReceived(const ::url::Origin& request_origin, ::std::vector<::network::mojom::SharedStorageModifierMethodWithOptionsPtr> methods_with_options, const std::optional<::std::string>& with_lock, OnSharedStorageHeaderReceivedCallback callback) override;
  void OnAdAuctionEventRecordHeaderReceived(::network::AdAuctionEventRecord ad_auction_event_record, const std::optional<::url::Origin>& top_frame_origin) override;
  void Clone(::mojo::PendingReceiver<URLLoaderNetworkServiceObserver> listener) override;
  void OnWebSocketConnectedToPrivateNetwork(const ::GURL& request_url, ::network::mojom::IPAddressSpace ip_address_space) override;
  void OnUrlLoaderConnectedToPrivateNetwork(const ::GURL& request_url, ::network::mojom::IPAddressSpace response_address_space, ::network::mojom::IPAddressSpace client_address_space, ::network::mojom::IPAddressSpace target_address_space) override;
};
class  URLLoaderNetworkServiceObserverAsyncWaiter {
 public:
  explicit URLLoaderNetworkServiceObserverAsyncWaiter(URLLoaderNetworkServiceObserver* proxy);

  URLLoaderNetworkServiceObserverAsyncWaiter(const URLLoaderNetworkServiceObserverAsyncWaiter&) = delete;
  URLLoaderNetworkServiceObserverAsyncWaiter& operator=(const URLLoaderNetworkServiceObserverAsyncWaiter&) = delete;

  ~URLLoaderNetworkServiceObserverAsyncWaiter();
  void OnSSLCertificateError(
      const ::GURL& url, int32_t net_error, const ::net::SSLInfo& ssl_info, bool fatal, int32_t* out_net_error);
  int32_t OnSSLCertificateError(const ::GURL& url, int32_t net_error, const ::net::SSLInfo& ssl_info, bool fatal);
  void OnLocalNetworkAccessPermissionRequired(
      bool* out_permission_granted);
  bool OnLocalNetworkAccessPermissionRequired();
  void OnClearSiteData(
      const ::GURL& url, const std::string& header_value, int32_t load_flags, const std::optional<::net::CookiePartitionKey>& cookie_partition_key, bool partitioned_state_allowed_only);
  
  void OnLoadingStateUpdate(
      LoadInfoPtr info);
  
  void OnSharedStorageHeaderReceived(
      const ::url::Origin& request_origin, ::std::vector<::network::mojom::SharedStorageModifierMethodWithOptionsPtr> methods_with_options, const std::optional<::std::string>& with_lock);
  

 private:
  URLLoaderNetworkServiceObserver* const proxy_;
};




}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_NETWORK_SERVICE_OBSERVER_MOJOM_TEST_UTILS_H_