// services/network/public/mojom/url_loader_completion_status.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/url_loader_completion_status.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var network_param$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/network_param.mojom', 'network_param.mojom.js');
  }
  var blocked_by_response_reason$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/blocked_by_response_reason.mojom', 'blocked_by_response_reason.mojom.js');
  }
  var cors$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/cors.mojom', 'cors.mojom.js');
  }
  var trust_tokens$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/trust_tokens.mojom', 'trust_tokens.mojom.js');
  }



  function BlockedByResponseReasonWrapper(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BlockedByResponseReasonWrapper.prototype.initDefaults_ = function() {
    this.reason = 0;
  };
  BlockedByResponseReasonWrapper.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BlockedByResponseReasonWrapper.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BlockedByResponseReasonWrapper.reason
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, blocked_by_response_reason$.BlockedByResponseReason);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BlockedByResponseReasonWrapper.encodedSize = codec.kStructHeaderSize + 8;

  BlockedByResponseReasonWrapper.decode = function(decoder) {
    var packed;
    var val = new BlockedByResponseReasonWrapper();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.reason =
        decoder.decodeStruct(new codec.Enum(blocked_by_response_reason$.BlockedByResponseReason));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  BlockedByResponseReasonWrapper.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BlockedByResponseReasonWrapper.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.reason);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function URLLoaderCompletionStatus(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLLoaderCompletionStatus.prototype.initDefaults_ = function() {
    this.errorCode = 0;
    this.extendedErrorCode = 0;
    this.existsInCache = false;
    this.shouldReportOrbBlocking = false;
    this.shouldCollapseInitiator = false;
    this.trustTokenOperationStatus = trust_tokens$.TrustTokenOperationStatus.kOk;
    this.completionTime = null;
    this.encodedDataLength = 0;
    this.encodedBodyLength = 0;
    this.decodedBodyLength = 0;
    this.corsErrorStatus = null;
    this.sslInfo = null;
    this.blockedByResponseReason = null;
    this.resolveErrorInfo = null;
  };
  URLLoaderCompletionStatus.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLLoaderCompletionStatus.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 88}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;





    // validate URLLoaderCompletionStatus.completionTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;





    // validate URLLoaderCompletionStatus.corsErrorStatus
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, cors$.CorsErrorStatus, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderCompletionStatus.trustTokenOperationStatus
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, trust_tokens$.TrustTokenOperationStatus);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderCompletionStatus.sslInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, network_param$.SSLInfo, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderCompletionStatus.blockedByResponseReason
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, BlockedByResponseReasonWrapper, true);
    if (err !== validator.validationError.NONE)
        return err;



    // validate URLLoaderCompletionStatus.resolveErrorInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 72, network_param$.ResolveErrorInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  URLLoaderCompletionStatus.encodedSize = codec.kStructHeaderSize + 80;

  URLLoaderCompletionStatus.decode = function(decoder) {
    var packed;
    var val = new URLLoaderCompletionStatus();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.errorCode =
        decoder.decodeStruct(codec.Int32);
    val.extendedErrorCode =
        decoder.decodeStruct(codec.Int32);
    packed = decoder.readUint8();
    val.existsInCache = (packed >> 0) & 1 ? true : false;
    val.shouldReportOrbBlocking = (packed >> 1) & 1 ? true : false;
    val.shouldCollapseInitiator = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.trustTokenOperationStatus =
        decoder.decodeStruct(new codec.Enum(trust_tokens$.TrustTokenOperationStatus));
    val.completionTime =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.encodedDataLength =
        decoder.decodeStruct(codec.Int64);
    val.encodedBodyLength =
        decoder.decodeStruct(codec.Int64);
    val.decodedBodyLength =
        decoder.decodeStruct(codec.Int64);
    val.corsErrorStatus =
        decoder.decodeStructPointer(cors$.CorsErrorStatus);
    val.sslInfo =
        decoder.decodeStructPointer(network_param$.SSLInfo);
    val.blockedByResponseReason =
        decoder.decodeStructPointer(BlockedByResponseReasonWrapper);
    val.resolveErrorInfo =
        decoder.decodeStructPointer(network_param$.ResolveErrorInfo);
    return val;
  };

  URLLoaderCompletionStatus.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLLoaderCompletionStatus.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.errorCode);
    encoder.encodeStruct(codec.Int32, val.extendedErrorCode);
    packed = 0;
    packed |= (val.existsInCache & 1) << 0
    packed |= (val.shouldReportOrbBlocking & 1) << 1
    packed |= (val.shouldCollapseInitiator & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.trustTokenOperationStatus);
    encoder.encodeStructPointer(time$.TimeTicks, val.completionTime);
    encoder.encodeStruct(codec.Int64, val.encodedDataLength);
    encoder.encodeStruct(codec.Int64, val.encodedBodyLength);
    encoder.encodeStruct(codec.Int64, val.decodedBodyLength);
    encoder.encodeStructPointer(cors$.CorsErrorStatus, val.corsErrorStatus);
    encoder.encodeStructPointer(network_param$.SSLInfo, val.sslInfo);
    encoder.encodeStructPointer(BlockedByResponseReasonWrapper, val.blockedByResponseReason);
    encoder.encodeStructPointer(network_param$.ResolveErrorInfo, val.resolveErrorInfo);
  };
  exports.BlockedByResponseReasonWrapper = BlockedByResponseReasonWrapper;
  exports.URLLoaderCompletionStatus = URLLoaderCompletionStatus;
})();