// services/network/public/mojom/url_loader_completion_status.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_COMPLETION_STATUS_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_COMPLETION_STATUS_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/url_loader_completion_status.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/blocked_by_response_reason.mojom-shared.h"
#include "services/network/public/mojom/cors.mojom-shared.h"
#include "services/network/public/mojom/trust_tokens.mojom-shared.h"

#include "services/network/public/mojom/url_loader_completion_status.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::BlockedByResponseReasonWrapperDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::BlockedByResponseReasonWrapperDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::BlockedByResponseReasonWrapper_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::network::mojom::BlockedByResponseReason>(
        Traits::reason(input),
        &fragment->reason);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::URLLoaderCompletionStatusDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::URLLoaderCompletionStatusDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::URLLoaderCompletionStatus_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->error_code = Traits::error_code(input);

      fragment->extended_error_code = Traits::extended_error_code(input);

      fragment->exists_in_cache = Traits::exists_in_cache(input);

      decltype(Traits::completion_time(input)) in_completion_time = Traits::completion_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->completion_time)::BaseType> completion_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_completion_time,
        completion_time_fragment);

      fragment->completion_time.Set(
          completion_time_fragment.is_null() ? nullptr : completion_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->completion_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null completion_time in URLLoaderCompletionStatus struct");

      fragment->encoded_data_length = Traits::encoded_data_length(input);

      fragment->encoded_body_length = Traits::encoded_body_length(input);

      fragment->decoded_body_length = Traits::decoded_body_length(input);

      decltype(Traits::cors_error_status(input)) in_cors_error_status = Traits::cors_error_status(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cors_error_status)::BaseType> cors_error_status_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::CorsErrorStatusDataView, send_validation>(
        in_cors_error_status,
        cors_error_status_fragment);

      fragment->cors_error_status.Set(
          cors_error_status_fragment.is_null() ? nullptr : cors_error_status_fragment.data());

      
      mojo::internal::Serialize<::network::mojom::TrustTokenOperationStatus>(
        Traits::trust_token_operation_status(input),
        &fragment->trust_token_operation_status);

      decltype(Traits::ssl_info(input)) in_ssl_info = Traits::ssl_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->ssl_info)::BaseType> ssl_info_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::SSLInfoDataView, send_validation>(
        in_ssl_info,
        ssl_info_fragment);

      fragment->ssl_info.Set(
          ssl_info_fragment.is_null() ? nullptr : ssl_info_fragment.data());

      decltype(Traits::blocked_by_response_reason(input)) in_blocked_by_response_reason = Traits::blocked_by_response_reason(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->blocked_by_response_reason)::BaseType> blocked_by_response_reason_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::BlockedByResponseReasonWrapperDataView, send_validation>(
        in_blocked_by_response_reason,
        blocked_by_response_reason_fragment);

      fragment->blocked_by_response_reason.Set(
          blocked_by_response_reason_fragment.is_null() ? nullptr : blocked_by_response_reason_fragment.data());

      fragment->should_report_orb_blocking = Traits::should_report_orb_blocking(input);

      decltype(Traits::resolve_error_info(input)) in_resolve_error_info = Traits::resolve_error_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->resolve_error_info)::BaseType> resolve_error_info_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::ResolveErrorInfoDataView, send_validation>(
        in_resolve_error_info,
        resolve_error_info_fragment);

      fragment->resolve_error_info.Set(
          resolve_error_info_fragment.is_null() ? nullptr : resolve_error_info_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->resolve_error_info.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null resolve_error_info in URLLoaderCompletionStatus struct");

      fragment->should_collapse_initiator = Traits::should_collapse_initiator(input);
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_COMPLETION_STATUS_MOJOM_SEND_VALIDATION_H_