// services/network/public/mojom/url_loader_completion_status.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_COMPLETION_STATUS_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_COMPLETION_STATUS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/network/public/mojom/url_loader_completion_status.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/blocked_by_response_reason.mojom-shared.h"
#include "services/network/public/mojom/cors.mojom-shared.h"
#include "services/network/public/mojom/trust_tokens.mojom-shared.h"


namespace network::mojom {
class BlockedByResponseReasonWrapperDataView;

class URLLoaderCompletionStatusDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::BlockedByResponseReasonWrapperDataView> {
  using Data = ::network::mojom::internal::BlockedByResponseReasonWrapper_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::URLLoaderCompletionStatusDataView> {
  using Data = ::network::mojom::internal::URLLoaderCompletionStatus_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


class BlockedByResponseReasonWrapperDataView {
 public:
  BlockedByResponseReasonWrapperDataView() = default;

  BlockedByResponseReasonWrapperDataView(
      internal::BlockedByResponseReasonWrapper_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadReason(UserType* output) const {
    auto data_value = data_->reason;
    return mojo::internal::Deserialize<::network::mojom::BlockedByResponseReason>(
        data_value, output);
  }
  ::network::mojom::BlockedByResponseReason reason() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::BlockedByResponseReason>(data_->reason));
  }
 private:
  internal::BlockedByResponseReasonWrapper_Data* data_ = nullptr;
};


class URLLoaderCompletionStatusDataView {
 public:
  URLLoaderCompletionStatusDataView() = default;

  URLLoaderCompletionStatusDataView(
      internal::URLLoaderCompletionStatus_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t error_code() const {
    return data_->error_code;
  }
  int32_t extended_error_code() const {
    return data_->extended_error_code;
  }
  bool exists_in_cache() const {
    return data_->exists_in_cache;
  }
  inline void GetCompletionTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCompletionTime(UserType* output) {
    
    auto* pointer = data_->completion_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  int64_t encoded_data_length() const {
    return data_->encoded_data_length;
  }
  int64_t encoded_body_length() const {
    return data_->encoded_body_length;
  }
  int64_t decoded_body_length() const {
    return data_->decoded_body_length;
  }
  inline void GetCorsErrorStatusDataView(
      ::network::mojom::CorsErrorStatusDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCorsErrorStatus(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::CorsErrorStatusDataView, UserType>(),
    "Attempting to read the optional `cors_error_status` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCorsErrorStatus` instead "
    "of `ReadCorsErrorStatus if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->cors_error_status.Get();
    return mojo::internal::Deserialize<::network::mojom::CorsErrorStatusDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTrustTokenOperationStatus(UserType* output) const {
    auto data_value = data_->trust_token_operation_status;
    return mojo::internal::Deserialize<::network::mojom::TrustTokenOperationStatus>(
        data_value, output);
  }
  ::network::mojom::TrustTokenOperationStatus trust_token_operation_status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::TrustTokenOperationStatus>(data_->trust_token_operation_status));
  }
  inline void GetSslInfoDataView(
      ::network::mojom::SSLInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSslInfo(UserType* output) {
    
    auto* pointer = data_->ssl_info.Get();
    return mojo::internal::Deserialize<::network::mojom::SSLInfoDataView>(
        pointer, output, message_);
  }
  inline void GetBlockedByResponseReasonDataView(
      BlockedByResponseReasonWrapperDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBlockedByResponseReason(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::BlockedByResponseReasonWrapperDataView, UserType>(),
    "Attempting to read the optional `blocked_by_response_reason` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBlockedByResponseReason` instead "
    "of `ReadBlockedByResponseReason if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->blocked_by_response_reason.Get();
    return mojo::internal::Deserialize<::network::mojom::BlockedByResponseReasonWrapperDataView>(
        pointer, output, message_);
  }
  bool should_report_orb_blocking() const {
    return data_->should_report_orb_blocking;
  }
  inline void GetResolveErrorInfoDataView(
      ::network::mojom::ResolveErrorInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResolveErrorInfo(UserType* output) {
    
    auto* pointer = data_->resolve_error_info.Get();
    return mojo::internal::Deserialize<::network::mojom::ResolveErrorInfoDataView>(
        pointer, output, message_);
  }
  bool should_collapse_initiator() const {
    return data_->should_collapse_initiator;
  }
 private:
  internal::URLLoaderCompletionStatus_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_COMPLETION_STATUS_MOJOM_DATA_VIEW_H_