// services/network/public/mojom/url_loader_completion_status.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_COMPLETION_STATUS_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_COMPLETION_STATUS_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/url_loader_completion_status.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/url_loader_completion_status.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/url_loader_completion_status.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "services/network/public/mojom/network_param.mojom-blink.h"
#include "services/network/public/mojom/blocked_by_response_reason.mojom-blink-forward.h"
#include "services/network/public/mojom/cors.mojom-blink.h"
#include "services/network/public/mojom/trust_tokens.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "services/network/public/cpp/url_loader_completion_status_mojom_traits.h"
#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {





class BLINK_PLATFORM_EXPORT BlockedByResponseReasonWrapper {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BlockedByResponseReasonWrapper, T>::value>;
  using DataView = BlockedByResponseReasonWrapperDataView;
  using Data_ = internal::BlockedByResponseReasonWrapper_Data;

  template <typename... Args>
  static BlockedByResponseReasonWrapperPtr New(Args&&... args) {
    return BlockedByResponseReasonWrapperPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BlockedByResponseReasonWrapperPtr From(const U& u) {
    return mojo::TypeConverter<BlockedByResponseReasonWrapperPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BlockedByResponseReasonWrapper>::Convert(*this);
  }


  BlockedByResponseReasonWrapper();

  explicit BlockedByResponseReasonWrapper(
      ::network::mojom::blink::BlockedByResponseReason reason);


  ~BlockedByResponseReasonWrapper();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BlockedByResponseReasonWrapperPtr>
  BlockedByResponseReasonWrapperPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BlockedByResponseReasonWrapper::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BlockedByResponseReasonWrapper::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BlockedByResponseReasonWrapper::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BlockedByResponseReasonWrapper::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BlockedByResponseReasonWrapper::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BlockedByResponseReasonWrapper::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BlockedByResponseReasonWrapper_UnserializedMessageContext<
            UserType, BlockedByResponseReasonWrapper::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BlockedByResponseReasonWrapper::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BlockedByResponseReasonWrapper::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BlockedByResponseReasonWrapper_UnserializedMessageContext<
            UserType, BlockedByResponseReasonWrapper::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BlockedByResponseReasonWrapper::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::network::mojom::blink::BlockedByResponseReason reason;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BlockedByResponseReasonWrapper::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BlockedByResponseReasonWrapper::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BlockedByResponseReasonWrapper::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BlockedByResponseReasonWrapper::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class BLINK_PLATFORM_EXPORT URLLoaderCompletionStatus {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<URLLoaderCompletionStatus, T>::value>;
  using DataView = URLLoaderCompletionStatusDataView;
  using Data_ = internal::URLLoaderCompletionStatus_Data;

  template <typename... Args>
  static URLLoaderCompletionStatusPtr New(Args&&... args) {
    return URLLoaderCompletionStatusPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static URLLoaderCompletionStatusPtr From(const U& u) {
    return mojo::TypeConverter<URLLoaderCompletionStatusPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, URLLoaderCompletionStatus>::Convert(*this);
  }


  URLLoaderCompletionStatus();

  URLLoaderCompletionStatus(
      int32_t error_code,
      int32_t extended_error_code,
      bool exists_in_cache,
      ::base::TimeTicks completion_time,
      int64_t encoded_data_length,
      int64_t encoded_body_length,
      int64_t decoded_body_length,
      ::network::mojom::blink::CorsErrorStatusPtr cors_error_status,
      ::network::mojom::blink::TrustTokenOperationStatus trust_token_operation_status,
      ::network::mojom::blink::SSLInfoPtr ssl_info,
      BlockedByResponseReasonWrapperPtr blocked_by_response_reason,
      bool should_report_orb_blocking,
      ::network::mojom::blink::ResolveErrorInfoPtr resolve_error_info,
      bool should_collapse_initiator);

URLLoaderCompletionStatus(const URLLoaderCompletionStatus&) = delete;
URLLoaderCompletionStatus& operator=(const URLLoaderCompletionStatus&) = delete;

  ~URLLoaderCompletionStatus();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = URLLoaderCompletionStatusPtr>
  URLLoaderCompletionStatusPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, URLLoaderCompletionStatus::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, URLLoaderCompletionStatus::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, URLLoaderCompletionStatus::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        URLLoaderCompletionStatus::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        URLLoaderCompletionStatus::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        URLLoaderCompletionStatus::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::URLLoaderCompletionStatus_UnserializedMessageContext<
            UserType, URLLoaderCompletionStatus::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<URLLoaderCompletionStatus::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return URLLoaderCompletionStatus::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::URLLoaderCompletionStatus_UnserializedMessageContext<
            UserType, URLLoaderCompletionStatus::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<URLLoaderCompletionStatus::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t error_code;
  
  int32_t extended_error_code;
  
  bool exists_in_cache;
  
  ::base::TimeTicks completion_time;
  
  int64_t encoded_data_length;
  
  int64_t encoded_body_length;
  
  int64_t decoded_body_length;
  
  ::network::mojom::blink::CorsErrorStatusPtr cors_error_status;
  
  ::network::mojom::blink::TrustTokenOperationStatus trust_token_operation_status;
  
  ::network::mojom::blink::SSLInfoPtr ssl_info;
  
  BlockedByResponseReasonWrapperPtr blocked_by_response_reason;
  
  bool should_report_orb_blocking;
  
  ::network::mojom::blink::ResolveErrorInfoPtr resolve_error_info;
  
  bool should_collapse_initiator;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, URLLoaderCompletionStatus::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, URLLoaderCompletionStatus::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, URLLoaderCompletionStatus::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, URLLoaderCompletionStatus::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
BlockedByResponseReasonWrapperPtr BlockedByResponseReasonWrapper::Clone() const {
  return New(
      mojo::Clone(reason)
  );
}

template <typename T, BlockedByResponseReasonWrapper::EnableIfSame<T>*>
bool BlockedByResponseReasonWrapper::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->reason, other_struct.reason))
    return false;
  return true;
}

template <typename T, BlockedByResponseReasonWrapper::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.reason < rhs.reason)
    return true;
  if (rhs.reason < lhs.reason)
    return false;
  return false;
}
template <typename StructPtrType>
URLLoaderCompletionStatusPtr URLLoaderCompletionStatus::Clone() const {
  return New(
      mojo::Clone(error_code),
      mojo::Clone(extended_error_code),
      mojo::Clone(exists_in_cache),
      mojo::Clone(completion_time),
      mojo::Clone(encoded_data_length),
      mojo::Clone(encoded_body_length),
      mojo::Clone(decoded_body_length),
      mojo::Clone(cors_error_status),
      mojo::Clone(trust_token_operation_status),
      mojo::Clone(ssl_info),
      mojo::Clone(blocked_by_response_reason),
      mojo::Clone(should_report_orb_blocking),
      mojo::Clone(resolve_error_info),
      mojo::Clone(should_collapse_initiator)
  );
}

template <typename T, URLLoaderCompletionStatus::EnableIfSame<T>*>
bool URLLoaderCompletionStatus::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->error_code, other_struct.error_code))
    return false;
  if (!mojo::Equals(this->extended_error_code, other_struct.extended_error_code))
    return false;
  if (!mojo::Equals(this->exists_in_cache, other_struct.exists_in_cache))
    return false;
  if (!mojo::Equals(this->completion_time, other_struct.completion_time))
    return false;
  if (!mojo::Equals(this->encoded_data_length, other_struct.encoded_data_length))
    return false;
  if (!mojo::Equals(this->encoded_body_length, other_struct.encoded_body_length))
    return false;
  if (!mojo::Equals(this->decoded_body_length, other_struct.decoded_body_length))
    return false;
  if (!mojo::Equals(this->cors_error_status, other_struct.cors_error_status))
    return false;
  if (!mojo::Equals(this->trust_token_operation_status, other_struct.trust_token_operation_status))
    return false;
  if (!mojo::Equals(this->ssl_info, other_struct.ssl_info))
    return false;
  if (!mojo::Equals(this->blocked_by_response_reason, other_struct.blocked_by_response_reason))
    return false;
  if (!mojo::Equals(this->should_report_orb_blocking, other_struct.should_report_orb_blocking))
    return false;
  if (!mojo::Equals(this->resolve_error_info, other_struct.resolve_error_info))
    return false;
  if (!mojo::Equals(this->should_collapse_initiator, other_struct.should_collapse_initiator))
    return false;
  return true;
}

template <typename T, URLLoaderCompletionStatus::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.error_code < rhs.error_code)
    return true;
  if (rhs.error_code < lhs.error_code)
    return false;
  if (lhs.extended_error_code < rhs.extended_error_code)
    return true;
  if (rhs.extended_error_code < lhs.extended_error_code)
    return false;
  if (lhs.exists_in_cache < rhs.exists_in_cache)
    return true;
  if (rhs.exists_in_cache < lhs.exists_in_cache)
    return false;
  if (lhs.completion_time < rhs.completion_time)
    return true;
  if (rhs.completion_time < lhs.completion_time)
    return false;
  if (lhs.encoded_data_length < rhs.encoded_data_length)
    return true;
  if (rhs.encoded_data_length < lhs.encoded_data_length)
    return false;
  if (lhs.encoded_body_length < rhs.encoded_body_length)
    return true;
  if (rhs.encoded_body_length < lhs.encoded_body_length)
    return false;
  if (lhs.decoded_body_length < rhs.decoded_body_length)
    return true;
  if (rhs.decoded_body_length < lhs.decoded_body_length)
    return false;
  if (lhs.cors_error_status < rhs.cors_error_status)
    return true;
  if (rhs.cors_error_status < lhs.cors_error_status)
    return false;
  if (lhs.trust_token_operation_status < rhs.trust_token_operation_status)
    return true;
  if (rhs.trust_token_operation_status < lhs.trust_token_operation_status)
    return false;
  if (lhs.ssl_info < rhs.ssl_info)
    return true;
  if (rhs.ssl_info < lhs.ssl_info)
    return false;
  if (lhs.blocked_by_response_reason < rhs.blocked_by_response_reason)
    return true;
  if (rhs.blocked_by_response_reason < lhs.blocked_by_response_reason)
    return false;
  if (lhs.should_report_orb_blocking < rhs.should_report_orb_blocking)
    return true;
  if (rhs.should_report_orb_blocking < lhs.should_report_orb_blocking)
    return false;
  if (lhs.resolve_error_info < rhs.resolve_error_info)
    return true;
  if (rhs.resolve_error_info < lhs.resolve_error_info)
    return false;
  if (lhs.should_collapse_initiator < rhs.should_collapse_initiator)
    return true;
  if (rhs.should_collapse_initiator < lhs.should_collapse_initiator)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::BlockedByResponseReasonWrapper::DataView,
                                         ::network::mojom::blink::BlockedByResponseReasonWrapperPtr> {
  static bool IsNull(const ::network::mojom::blink::BlockedByResponseReasonWrapperPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::BlockedByResponseReasonWrapperPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::BlockedByResponseReasonWrapper::reason) reason(
      const ::network::mojom::blink::BlockedByResponseReasonWrapperPtr& input) {
    return input->reason;
  }

  static bool Read(::network::mojom::blink::BlockedByResponseReasonWrapper::DataView input, ::network::mojom::blink::BlockedByResponseReasonWrapperPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::URLLoaderCompletionStatus::DataView,
                                         ::network::mojom::blink::URLLoaderCompletionStatusPtr> {
  static bool IsNull(const ::network::mojom::blink::URLLoaderCompletionStatusPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::URLLoaderCompletionStatusPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::URLLoaderCompletionStatus::error_code) error_code(
      const ::network::mojom::blink::URLLoaderCompletionStatusPtr& input) {
    return input->error_code;
  }

  static decltype(::network::mojom::blink::URLLoaderCompletionStatus::extended_error_code) extended_error_code(
      const ::network::mojom::blink::URLLoaderCompletionStatusPtr& input) {
    return input->extended_error_code;
  }

  static decltype(::network::mojom::blink::URLLoaderCompletionStatus::exists_in_cache) exists_in_cache(
      const ::network::mojom::blink::URLLoaderCompletionStatusPtr& input) {
    return input->exists_in_cache;
  }

  static const decltype(::network::mojom::blink::URLLoaderCompletionStatus::completion_time)& completion_time(
      const ::network::mojom::blink::URLLoaderCompletionStatusPtr& input) {
    return input->completion_time;
  }

  static decltype(::network::mojom::blink::URLLoaderCompletionStatus::encoded_data_length) encoded_data_length(
      const ::network::mojom::blink::URLLoaderCompletionStatusPtr& input) {
    return input->encoded_data_length;
  }

  static decltype(::network::mojom::blink::URLLoaderCompletionStatus::encoded_body_length) encoded_body_length(
      const ::network::mojom::blink::URLLoaderCompletionStatusPtr& input) {
    return input->encoded_body_length;
  }

  static decltype(::network::mojom::blink::URLLoaderCompletionStatus::decoded_body_length) decoded_body_length(
      const ::network::mojom::blink::URLLoaderCompletionStatusPtr& input) {
    return input->decoded_body_length;
  }

  static const decltype(::network::mojom::blink::URLLoaderCompletionStatus::cors_error_status)& cors_error_status(
      const ::network::mojom::blink::URLLoaderCompletionStatusPtr& input) {
    return input->cors_error_status;
  }

  static decltype(::network::mojom::blink::URLLoaderCompletionStatus::trust_token_operation_status) trust_token_operation_status(
      const ::network::mojom::blink::URLLoaderCompletionStatusPtr& input) {
    return input->trust_token_operation_status;
  }

  static const decltype(::network::mojom::blink::URLLoaderCompletionStatus::ssl_info)& ssl_info(
      const ::network::mojom::blink::URLLoaderCompletionStatusPtr& input) {
    return input->ssl_info;
  }

  static const decltype(::network::mojom::blink::URLLoaderCompletionStatus::blocked_by_response_reason)& blocked_by_response_reason(
      const ::network::mojom::blink::URLLoaderCompletionStatusPtr& input) {
    return input->blocked_by_response_reason;
  }

  static decltype(::network::mojom::blink::URLLoaderCompletionStatus::should_report_orb_blocking) should_report_orb_blocking(
      const ::network::mojom::blink::URLLoaderCompletionStatusPtr& input) {
    return input->should_report_orb_blocking;
  }

  static const decltype(::network::mojom::blink::URLLoaderCompletionStatus::resolve_error_info)& resolve_error_info(
      const ::network::mojom::blink::URLLoaderCompletionStatusPtr& input) {
    return input->resolve_error_info;
  }

  static decltype(::network::mojom::blink::URLLoaderCompletionStatus::should_collapse_initiator) should_collapse_initiator(
      const ::network::mojom::blink::URLLoaderCompletionStatusPtr& input) {
    return input->should_collapse_initiator;
  }

  static bool Read(::network::mojom::blink::URLLoaderCompletionStatus::DataView input, ::network::mojom::blink::URLLoaderCompletionStatusPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_COMPLETION_STATUS_MOJOM_BLINK_H_