// services/network/public/mojom/url_loader.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  BigBuffer as mojoBase_mojom_BigBuffer,
  BigBufferSpec as mojoBase_mojom_BigBufferSpec
} from '../../../../mojo/public/mojom/base/big_buffer.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../url/mojom/url.mojom.m.js';

import {
  EarlyHints as network_mojom_EarlyHints,
  EarlyHintsSpec as network_mojom_EarlyHintsSpec
} from './early_hints.mojom.m.js';

import {
  HttpRequestHeaders as network_mojom_HttpRequestHeaders,
  HttpRequestHeadersSpec as network_mojom_HttpRequestHeadersSpec
} from './http_request_headers.mojom.m.js';

import {
  RequestPriority as network_mojom_RequestPriority,
  RequestPrioritySpec as network_mojom_RequestPrioritySpec
} from './request_priority.mojom.m.js';

import {
  URLLoaderCompletionStatus as network_mojom_URLLoaderCompletionStatus,
  URLLoaderCompletionStatusSpec as network_mojom_URLLoaderCompletionStatusSpec
} from './url_loader_completion_status.mojom.m.js';

import {
  URLResponseHead as network_mojom_URLResponseHead,
  URLResponseHeadSpec as network_mojom_URLResponseHeadSpec
} from './url_response_head.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class URLLoaderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.URLLoader', scope);
  }
}

/** @interface */
export class URLLoaderInterface {
  
  /**
   * @param { !Array<!string> } removedHeaders
   * @param { !network_mojom_HttpRequestHeaders } modifiedHeaders
   * @param { !network_mojom_HttpRequestHeaders } modifiedCorsExemptHeaders
   * @param { ?url_mojom_Url } newUrl
   */

  followRedirect(removedHeaders, modifiedHeaders, modifiedCorsExemptHeaders, newUrl) {}
  
  /**
   * @param { !network_mojom_RequestPriority } priority
   * @param { !number } intraPriorityValue
   */

  setPriority(priority, intraPriorityValue) {}
}

/**
 * @implements { URLLoaderInterface }
 */
export class URLLoaderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!URLLoaderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          URLLoaderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!URLLoaderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!string> } removedHeaders
   * @param { !network_mojom_HttpRequestHeaders } modifiedHeaders
   * @param { !network_mojom_HttpRequestHeaders } modifiedCorsExemptHeaders
   * @param { ?url_mojom_Url } newUrl
   */

  followRedirect(
      removedHeaders,
      modifiedHeaders,
      modifiedCorsExemptHeaders,
      newUrl) {
    this.proxy.sendMessage(
        0,
        URLLoader_FollowRedirect_ParamsSpec.$,
        null,
        [
          removedHeaders,
          modifiedHeaders,
          modifiedCorsExemptHeaders,
          newUrl
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_RequestPriority } priority
   * @param { !number } intraPriorityValue
   */

  setPriority(
      priority,
      intraPriorityValue) {
    this.proxy.sendMessage(
        1,
        URLLoader_SetPriority_ParamsSpec.$,
        null,
        [
          priority,
          intraPriorityValue
        ],
        false);
  }
}

/**
 * An object which receives request messages for the URLLoader
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class URLLoaderReceiver {
  /**
   * @param {!URLLoaderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!URLLoaderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        URLLoaderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!URLLoaderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        URLLoader_FollowRedirect_ParamsSpec.$,
        null,
        impl.followRedirect.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        URLLoader_SetPriority_ParamsSpec.$,
        null,
        impl.setPriority.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class URLLoader {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.URLLoader";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!URLLoaderRemote}
   */
  static getRemote() {
    let remote = new URLLoaderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the URLLoader
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class URLLoaderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      URLLoaderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!URLLoaderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.followRedirect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        URLLoader_FollowRedirect_ParamsSpec.$,
        null,
        this.followRedirect.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPriority =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        URLLoader_SetPriority_ParamsSpec.$,
        null,
        this.setPriority.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class URLLoaderClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.URLLoaderClient', scope);
  }
}

/** @interface */
export class URLLoaderClientInterface {
  
  /**
   * @param { !network_mojom_EarlyHints } earlyHints
   */

  onReceiveEarlyHints(earlyHints) {}
  
  /**
   * @param { !network_mojom_URLResponseHead } head
   * @param { ?MojoHandle } body
   * @param { ?mojoBase_mojom_BigBuffer } cachedMetadata
   */

  onReceiveResponse(head, body, cachedMetadata) {}
  
  /**
   * @param { !URLRequestRedirectInfo } redirectInfo
   * @param { !network_mojom_URLResponseHead } head
   */

  onReceiveRedirect(redirectInfo, head) {}
  
  /**
   * @param { !bigint } currentPosition
   * @param { !bigint } totalSize
   * @return {!Promise}
   */

  onUploadProgress(currentPosition, totalSize) {}
  
  /**
   * @param { !number } transferSizeDiff
   */

  onTransferSizeUpdated(transferSizeDiff) {}
  
  /**
   * @param { !network_mojom_URLLoaderCompletionStatus } status
   */

  onComplete(status) {}
}

/**
 * @implements { URLLoaderClientInterface }
 */
export class URLLoaderClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!URLLoaderClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          URLLoaderClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!URLLoaderClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network_mojom_EarlyHints } earlyHints
   */

  onReceiveEarlyHints(
      earlyHints) {
    this.proxy.sendMessage(
        0,
        URLLoaderClient_OnReceiveEarlyHints_ParamsSpec.$,
        null,
        [
          earlyHints
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_URLResponseHead } head
   * @param { ?MojoHandle } body
   * @param { ?mojoBase_mojom_BigBuffer } cachedMetadata
   */

  onReceiveResponse(
      head,
      body,
      cachedMetadata) {
    this.proxy.sendMessage(
        1,
        URLLoaderClient_OnReceiveResponse_ParamsSpec.$,
        null,
        [
          head,
          body,
          cachedMetadata
        ],
        false);
  }

  
  /**
   * @param { !URLRequestRedirectInfo } redirectInfo
   * @param { !network_mojom_URLResponseHead } head
   */

  onReceiveRedirect(
      redirectInfo,
      head) {
    this.proxy.sendMessage(
        2,
        URLLoaderClient_OnReceiveRedirect_ParamsSpec.$,
        null,
        [
          redirectInfo,
          head
        ],
        false);
  }

  
  /**
   * @param { !bigint } currentPosition
   * @param { !bigint } totalSize
   * @return {!Promise}
   */

  onUploadProgress(
      currentPosition,
      totalSize) {
    return this.proxy.sendMessage(
        3,
        URLLoaderClient_OnUploadProgress_ParamsSpec.$,
        URLLoaderClient_OnUploadProgress_ResponseParamsSpec.$,
        [
          currentPosition,
          totalSize
        ],
        false);
  }

  
  /**
   * @param { !number } transferSizeDiff
   */

  onTransferSizeUpdated(
      transferSizeDiff) {
    this.proxy.sendMessage(
        4,
        URLLoaderClient_OnTransferSizeUpdated_ParamsSpec.$,
        null,
        [
          transferSizeDiff
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_URLLoaderCompletionStatus } status
   */

  onComplete(
      status) {
    this.proxy.sendMessage(
        5,
        URLLoaderClient_OnComplete_ParamsSpec.$,
        null,
        [
          status
        ],
        false);
  }
}

/**
 * An object which receives request messages for the URLLoaderClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class URLLoaderClientReceiver {
  /**
   * @param {!URLLoaderClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!URLLoaderClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        URLLoaderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!URLLoaderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        URLLoaderClient_OnReceiveEarlyHints_ParamsSpec.$,
        null,
        impl.onReceiveEarlyHints.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        URLLoaderClient_OnReceiveResponse_ParamsSpec.$,
        null,
        impl.onReceiveResponse.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        URLLoaderClient_OnReceiveRedirect_ParamsSpec.$,
        null,
        impl.onReceiveRedirect.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        URLLoaderClient_OnUploadProgress_ParamsSpec.$,
        URLLoaderClient_OnUploadProgress_ResponseParamsSpec.$,
        impl.onUploadProgress.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        URLLoaderClient_OnTransferSizeUpdated_ParamsSpec.$,
        null,
        impl.onTransferSizeUpdated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        URLLoaderClient_OnComplete_ParamsSpec.$,
        null,
        impl.onComplete.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class URLLoaderClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.URLLoaderClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!URLLoaderClientRemote}
   */
  static getRemote() {
    let remote = new URLLoaderClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the URLLoaderClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class URLLoaderClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      URLLoaderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!URLLoaderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReceiveEarlyHints =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        URLLoaderClient_OnReceiveEarlyHints_ParamsSpec.$,
        null,
        this.onReceiveEarlyHints.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReceiveResponse =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        URLLoaderClient_OnReceiveResponse_ParamsSpec.$,
        null,
        this.onReceiveResponse.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReceiveRedirect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        URLLoaderClient_OnReceiveRedirect_ParamsSpec.$,
        null,
        this.onReceiveRedirect.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onUploadProgress =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        URLLoaderClient_OnUploadProgress_ParamsSpec.$,
        URLLoaderClient_OnUploadProgress_ResponseParamsSpec.$,
        this.onUploadProgress.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onTransferSizeUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        URLLoaderClient_OnTransferSizeUpdated_ParamsSpec.$,
        null,
        this.onTransferSizeUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onComplete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        URLLoaderClient_OnComplete_ParamsSpec.$,
        null,
        this.onComplete.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLRequestRedirectInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLLoaderClientEndpointsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLLoader_FollowRedirect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLLoader_SetPriority_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLLoaderClient_OnReceiveEarlyHints_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLLoaderClient_OnReceiveResponse_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLLoaderClient_OnReceiveRedirect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLLoaderClient_OnUploadProgress_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLLoaderClient_OnUploadProgress_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLLoaderClient_OnTransferSizeUpdated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLLoaderClient_OnComplete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    URLRequestRedirectInfoSpec.$,
    'URLRequestRedirectInfo',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class URLRequestRedirectInfo {
  constructor() {
  }
}



mojo.internal.Struct(
    URLLoaderClientEndpointsSpec.$,
    'URLLoaderClientEndpoints',
    [
      mojo.internal.StructField(
        'urlLoader', 0,
        0,
        mojo.internal.InterfaceProxy(URLLoaderRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'urlLoaderClient', 8,
        0,
        mojo.internal.InterfaceRequest(URLLoaderClientPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class URLLoaderClientEndpoints {
  constructor() {
    /** @type { !URLLoaderRemote } */
    this.urlLoader;
    /** @type { !URLLoaderClientPendingReceiver } */
    this.urlLoaderClient;
  }
}



mojo.internal.Struct(
    URLLoader_FollowRedirect_ParamsSpec.$,
    'URLLoader_FollowRedirect_Params',
    [
      mojo.internal.StructField(
        'removedHeaders', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'modifiedHeaders', 8,
        0,
        network_mojom_HttpRequestHeadersSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'modifiedCorsExemptHeaders', 16,
        0,
        network_mojom_HttpRequestHeadersSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'newUrl', 24,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class URLLoader_FollowRedirect_Params {
  constructor() {
    /** @type { !Array<!string> } */
    this.removedHeaders;
    /** @type { !network_mojom_HttpRequestHeaders } */
    this.modifiedHeaders;
    /** @type { !network_mojom_HttpRequestHeaders } */
    this.modifiedCorsExemptHeaders;
    /** @type { (url_mojom_Url|undefined) } */
    this.newUrl;
  }
}



mojo.internal.Struct(
    URLLoader_SetPriority_ParamsSpec.$,
    'URLLoader_SetPriority_Params',
    [
      mojo.internal.StructField(
        'priority', 0,
        0,
        network_mojom_RequestPrioritySpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'intraPriorityValue', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class URLLoader_SetPriority_Params {
  constructor() {
    /** @type { !network_mojom_RequestPriority } */
    this.priority;
    /** @type { !number } */
    this.intraPriorityValue;
  }
}



mojo.internal.Struct(
    URLLoaderClient_OnReceiveEarlyHints_ParamsSpec.$,
    'URLLoaderClient_OnReceiveEarlyHints_Params',
    [
      mojo.internal.StructField(
        'earlyHints', 0,
        0,
        network_mojom_EarlyHintsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class URLLoaderClient_OnReceiveEarlyHints_Params {
  constructor() {
    /** @type { !network_mojom_EarlyHints } */
    this.earlyHints;
  }
}



mojo.internal.Struct(
    URLLoaderClient_OnReceiveResponse_ParamsSpec.$,
    'URLLoaderClient_OnReceiveResponse_Params',
    [
      mojo.internal.StructField(
        'head', 0,
        0,
        network_mojom_URLResponseHeadSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'body', 8,
        0,
        mojo.internal.Handle,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cachedMetadata', 16,
        0,
        mojoBase_mojom_BigBufferSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class URLLoaderClient_OnReceiveResponse_Params {
  constructor() {
    /** @type { !network_mojom_URLResponseHead } */
    this.head;
    /** @type { (MojoHandle|undefined) } */
    this.body;
    /** @type { (mojoBase_mojom_BigBuffer|undefined) } */
    this.cachedMetadata;
  }
}



mojo.internal.Struct(
    URLLoaderClient_OnReceiveRedirect_ParamsSpec.$,
    'URLLoaderClient_OnReceiveRedirect_Params',
    [
      mojo.internal.StructField(
        'redirectInfo', 0,
        0,
        URLRequestRedirectInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'head', 8,
        0,
        network_mojom_URLResponseHeadSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class URLLoaderClient_OnReceiveRedirect_Params {
  constructor() {
    /** @type { !URLRequestRedirectInfo } */
    this.redirectInfo;
    /** @type { !network_mojom_URLResponseHead } */
    this.head;
  }
}



mojo.internal.Struct(
    URLLoaderClient_OnUploadProgress_ParamsSpec.$,
    'URLLoaderClient_OnUploadProgress_Params',
    [
      mojo.internal.StructField(
        'currentPosition', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'totalSize', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class URLLoaderClient_OnUploadProgress_Params {
  constructor() {
    /** @type { !bigint } */
    this.currentPosition;
    /** @type { !bigint } */
    this.totalSize;
  }
}



mojo.internal.Struct(
    URLLoaderClient_OnUploadProgress_ResponseParamsSpec.$,
    'URLLoaderClient_OnUploadProgress_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class URLLoaderClient_OnUploadProgress_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    URLLoaderClient_OnTransferSizeUpdated_ParamsSpec.$,
    'URLLoaderClient_OnTransferSizeUpdated_Params',
    [
      mojo.internal.StructField(
        'transferSizeDiff', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class URLLoaderClient_OnTransferSizeUpdated_Params {
  constructor() {
    /** @type { !number } */
    this.transferSizeDiff;
  }
}



mojo.internal.Struct(
    URLLoaderClient_OnComplete_ParamsSpec.$,
    'URLLoaderClient_OnComplete_Params',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        network_mojom_URLLoaderCompletionStatusSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class URLLoaderClient_OnComplete_Params {
  constructor() {
    /** @type { !network_mojom_URLLoaderCompletionStatus } */
    this.status;
  }
}

