// services/network/public/mojom/url_loader.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_MOJOM_PARAMS_DATA_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace network::mojom {
namespace internal {
class  URLLoader_FollowRedirect_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> removed_headers;
  mojo::internal::Pointer<::network::mojom::internal::HttpRequestHeaders_Data> modified_headers;
  mojo::internal::Pointer<::network::mojom::internal::HttpRequestHeaders_Data> modified_cors_exempt_headers;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> new_url;

 private:
  friend class mojo::internal::MessageFragment<URLLoader_FollowRedirect_Params_Data>;

  URLLoader_FollowRedirect_Params_Data();
  ~URLLoader_FollowRedirect_Params_Data() = delete;
};
static_assert(sizeof(URLLoader_FollowRedirect_Params_Data) == 40,
              "Bad sizeof(URLLoader_FollowRedirect_Params_Data)");
class  URLLoader_SetPriority_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t priority;
  int32_t intra_priority_value;

 private:
  friend class mojo::internal::MessageFragment<URLLoader_SetPriority_Params_Data>;

  URLLoader_SetPriority_Params_Data();
  ~URLLoader_SetPriority_Params_Data() = delete;
};
static_assert(sizeof(URLLoader_SetPriority_Params_Data) == 16,
              "Bad sizeof(URLLoader_SetPriority_Params_Data)");
class  URLLoaderClient_OnReceiveEarlyHints_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::network::mojom::internal::EarlyHints_Data> early_hints;

 private:
  friend class mojo::internal::MessageFragment<URLLoaderClient_OnReceiveEarlyHints_Params_Data>;

  URLLoaderClient_OnReceiveEarlyHints_Params_Data();
  ~URLLoaderClient_OnReceiveEarlyHints_Params_Data() = delete;
};
static_assert(sizeof(URLLoaderClient_OnReceiveEarlyHints_Params_Data) == 16,
              "Bad sizeof(URLLoaderClient_OnReceiveEarlyHints_Params_Data)");
class  URLLoaderClient_OnReceiveResponse_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::network::mojom::internal::URLResponseHead_Data> head;
  mojo::internal::Handle_Data body;
  uint8_t pad1_[4];
  ::mojo_base::mojom::internal::BigBuffer_Data cached_metadata;

 private:
  friend class mojo::internal::MessageFragment<URLLoaderClient_OnReceiveResponse_Params_Data>;

  URLLoaderClient_OnReceiveResponse_Params_Data();
  ~URLLoaderClient_OnReceiveResponse_Params_Data() = delete;
};
static_assert(sizeof(URLLoaderClient_OnReceiveResponse_Params_Data) == 40,
              "Bad sizeof(URLLoaderClient_OnReceiveResponse_Params_Data)");
class  URLLoaderClient_OnReceiveRedirect_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::URLRequestRedirectInfo_Data> redirect_info;
  mojo::internal::Pointer<::network::mojom::internal::URLResponseHead_Data> head;

 private:
  friend class mojo::internal::MessageFragment<URLLoaderClient_OnReceiveRedirect_Params_Data>;

  URLLoaderClient_OnReceiveRedirect_Params_Data();
  ~URLLoaderClient_OnReceiveRedirect_Params_Data() = delete;
};
static_assert(sizeof(URLLoaderClient_OnReceiveRedirect_Params_Data) == 24,
              "Bad sizeof(URLLoaderClient_OnReceiveRedirect_Params_Data)");
class  URLLoaderClient_OnUploadProgress_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int64_t current_position;
  int64_t total_size;

 private:
  friend class mojo::internal::MessageFragment<URLLoaderClient_OnUploadProgress_Params_Data>;

  URLLoaderClient_OnUploadProgress_Params_Data();
  ~URLLoaderClient_OnUploadProgress_Params_Data() = delete;
};
static_assert(sizeof(URLLoaderClient_OnUploadProgress_Params_Data) == 24,
              "Bad sizeof(URLLoaderClient_OnUploadProgress_Params_Data)");
class  URLLoaderClient_OnUploadProgress_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<URLLoaderClient_OnUploadProgress_ResponseParams_Data>;

  URLLoaderClient_OnUploadProgress_ResponseParams_Data();
  ~URLLoaderClient_OnUploadProgress_ResponseParams_Data() = delete;
};
static_assert(sizeof(URLLoaderClient_OnUploadProgress_ResponseParams_Data) == 8,
              "Bad sizeof(URLLoaderClient_OnUploadProgress_ResponseParams_Data)");
class  URLLoaderClient_OnTransferSizeUpdated_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t transfer_size_diff;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<URLLoaderClient_OnTransferSizeUpdated_Params_Data>;

  URLLoaderClient_OnTransferSizeUpdated_Params_Data();
  ~URLLoaderClient_OnTransferSizeUpdated_Params_Data() = delete;
};
static_assert(sizeof(URLLoaderClient_OnTransferSizeUpdated_Params_Data) == 16,
              "Bad sizeof(URLLoaderClient_OnTransferSizeUpdated_Params_Data)");
class  URLLoaderClient_OnComplete_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::network::mojom::internal::URLLoaderCompletionStatus_Data> status;

 private:
  friend class mojo::internal::MessageFragment<URLLoaderClient_OnComplete_Params_Data>;

  URLLoaderClient_OnComplete_Params_Data();
  ~URLLoaderClient_OnComplete_Params_Data() = delete;
};
static_assert(sizeof(URLLoaderClient_OnComplete_Params_Data) == 16,
              "Bad sizeof(URLLoaderClient_OnComplete_Params_Data)");

}  // namespace internal


class URLLoader_FollowRedirect_ParamsDataView {
 public:
  URLLoader_FollowRedirect_ParamsDataView() = default;

  URLLoader_FollowRedirect_ParamsDataView(
      internal::URLLoader_FollowRedirect_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRemovedHeadersDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRemovedHeaders(UserType* output) {
    
    auto* pointer = data_->removed_headers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetModifiedHeadersDataView(
      ::network::mojom::HttpRequestHeadersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadModifiedHeaders(UserType* output) {
    
    auto* pointer = data_->modified_headers.Get();
    return mojo::internal::Deserialize<::network::mojom::HttpRequestHeadersDataView>(
        pointer, output, message_);
  }
  inline void GetModifiedCorsExemptHeadersDataView(
      ::network::mojom::HttpRequestHeadersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadModifiedCorsExemptHeaders(UserType* output) {
    
    auto* pointer = data_->modified_cors_exempt_headers.Get();
    return mojo::internal::Deserialize<::network::mojom::HttpRequestHeadersDataView>(
        pointer, output, message_);
  }
  inline void GetNewUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNewUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `new_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNewUrl` instead "
    "of `ReadNewUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->new_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::URLLoader_FollowRedirect_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class URLLoader_SetPriority_ParamsDataView {
 public:
  URLLoader_SetPriority_ParamsDataView() = default;

  URLLoader_SetPriority_ParamsDataView(
      internal::URLLoader_SetPriority_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadPriority(UserType* output) const {
    auto data_value = data_->priority;
    return mojo::internal::Deserialize<::network::mojom::RequestPriority>(
        data_value, output);
  }
  ::network::mojom::RequestPriority priority() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::RequestPriority>(data_->priority));
  }
  int32_t intra_priority_value() const {
    return data_->intra_priority_value;
  }
 private:
  internal::URLLoader_SetPriority_Params_Data* data_ = nullptr;
};


class URLLoaderClient_OnReceiveEarlyHints_ParamsDataView {
 public:
  URLLoaderClient_OnReceiveEarlyHints_ParamsDataView() = default;

  URLLoaderClient_OnReceiveEarlyHints_ParamsDataView(
      internal::URLLoaderClient_OnReceiveEarlyHints_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetEarlyHintsDataView(
      ::network::mojom::EarlyHintsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEarlyHints(UserType* output) {
    
    auto* pointer = data_->early_hints.Get();
    return mojo::internal::Deserialize<::network::mojom::EarlyHintsDataView>(
        pointer, output, message_);
  }
 private:
  internal::URLLoaderClient_OnReceiveEarlyHints_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class URLLoaderClient_OnReceiveResponse_ParamsDataView {
 public:
  URLLoaderClient_OnReceiveResponse_ParamsDataView() = default;

  URLLoaderClient_OnReceiveResponse_ParamsDataView(
      internal::URLLoaderClient_OnReceiveResponse_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHeadDataView(
      ::network::mojom::URLResponseHeadDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHead(UserType* output) {
    
    auto* pointer = data_->head.Get();
    return mojo::internal::Deserialize<::network::mojom::URLResponseHeadDataView>(
        pointer, output, message_);
  }
  mojo::ScopedDataPipeConsumerHandle TakeBody() {
    mojo::ScopedDataPipeConsumerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeConsumerHandle>(
            &data_->body, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetCachedMetadataDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCachedMetadata(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::BigBufferDataView, UserType>(),
    "Attempting to read the optional `cached_metadata` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCachedMetadata` instead "
    "of `ReadCachedMetadata if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->cached_metadata.is_null() ? &data_->cached_metadata : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, message_);
  }
 private:
  internal::URLLoaderClient_OnReceiveResponse_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class URLLoaderClient_OnReceiveRedirect_ParamsDataView {
 public:
  URLLoaderClient_OnReceiveRedirect_ParamsDataView() = default;

  URLLoaderClient_OnReceiveRedirect_ParamsDataView(
      internal::URLLoaderClient_OnReceiveRedirect_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRedirectInfoDataView(
      URLRequestRedirectInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRedirectInfo(UserType* output) {
    
    auto* pointer = data_->redirect_info.Get();
    return mojo::internal::Deserialize<::network::mojom::URLRequestRedirectInfoDataView>(
        pointer, output, message_);
  }
  inline void GetHeadDataView(
      ::network::mojom::URLResponseHeadDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHead(UserType* output) {
    
    auto* pointer = data_->head.Get();
    return mojo::internal::Deserialize<::network::mojom::URLResponseHeadDataView>(
        pointer, output, message_);
  }
 private:
  internal::URLLoaderClient_OnReceiveRedirect_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class URLLoaderClient_OnUploadProgress_ParamsDataView {
 public:
  URLLoaderClient_OnUploadProgress_ParamsDataView() = default;

  URLLoaderClient_OnUploadProgress_ParamsDataView(
      internal::URLLoaderClient_OnUploadProgress_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int64_t current_position() const {
    return data_->current_position;
  }
  int64_t total_size() const {
    return data_->total_size;
  }
 private:
  internal::URLLoaderClient_OnUploadProgress_Params_Data* data_ = nullptr;
};


class URLLoaderClient_OnUploadProgress_ResponseParamsDataView {
 public:
  URLLoaderClient_OnUploadProgress_ResponseParamsDataView() = default;

  URLLoaderClient_OnUploadProgress_ResponseParamsDataView(
      internal::URLLoaderClient_OnUploadProgress_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::URLLoaderClient_OnUploadProgress_ResponseParams_Data* data_ = nullptr;
};


class URLLoaderClient_OnTransferSizeUpdated_ParamsDataView {
 public:
  URLLoaderClient_OnTransferSizeUpdated_ParamsDataView() = default;

  URLLoaderClient_OnTransferSizeUpdated_ParamsDataView(
      internal::URLLoaderClient_OnTransferSizeUpdated_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t transfer_size_diff() const {
    return data_->transfer_size_diff;
  }
 private:
  internal::URLLoaderClient_OnTransferSizeUpdated_Params_Data* data_ = nullptr;
};


class URLLoaderClient_OnComplete_ParamsDataView {
 public:
  URLLoaderClient_OnComplete_ParamsDataView() = default;

  URLLoaderClient_OnComplete_ParamsDataView(
      internal::URLLoaderClient_OnComplete_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStatusDataView(
      ::network::mojom::URLLoaderCompletionStatusDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) {
    
    auto* pointer = data_->status.Get();
    return mojo::internal::Deserialize<::network::mojom::URLLoaderCompletionStatusDataView>(
        pointer, output, message_);
  }
 private:
  internal::URLLoaderClient_OnComplete_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void URLLoader_FollowRedirect_ParamsDataView::GetRemovedHeadersDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->removed_headers.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void URLLoader_FollowRedirect_ParamsDataView::GetModifiedHeadersDataView(
    ::network::mojom::HttpRequestHeadersDataView* output) {
  auto pointer = data_->modified_headers.Get();
  *output = ::network::mojom::HttpRequestHeadersDataView(pointer, message_);
}
inline void URLLoader_FollowRedirect_ParamsDataView::GetModifiedCorsExemptHeadersDataView(
    ::network::mojom::HttpRequestHeadersDataView* output) {
  auto pointer = data_->modified_cors_exempt_headers.Get();
  *output = ::network::mojom::HttpRequestHeadersDataView(pointer, message_);
}
inline void URLLoader_FollowRedirect_ParamsDataView::GetNewUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->new_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}




inline void URLLoaderClient_OnReceiveEarlyHints_ParamsDataView::GetEarlyHintsDataView(
    ::network::mojom::EarlyHintsDataView* output) {
  auto pointer = data_->early_hints.Get();
  *output = ::network::mojom::EarlyHintsDataView(pointer, message_);
}


inline void URLLoaderClient_OnReceiveResponse_ParamsDataView::GetHeadDataView(
    ::network::mojom::URLResponseHeadDataView* output) {
  auto pointer = data_->head.Get();
  *output = ::network::mojom::URLResponseHeadDataView(pointer, message_);
}
inline void URLLoaderClient_OnReceiveResponse_ParamsDataView::GetCachedMetadataDataView(
    ::mojo_base::mojom::BigBufferDataView* output) {
  auto pointer = &data_->cached_metadata;
  *output = ::mojo_base::mojom::BigBufferDataView(pointer, message_);
}


inline void URLLoaderClient_OnReceiveRedirect_ParamsDataView::GetRedirectInfoDataView(
    URLRequestRedirectInfoDataView* output) {
  auto pointer = data_->redirect_info.Get();
  *output = URLRequestRedirectInfoDataView(pointer, message_);
}
inline void URLLoaderClient_OnReceiveRedirect_ParamsDataView::GetHeadDataView(
    ::network::mojom::URLResponseHeadDataView* output) {
  auto pointer = data_->head.Get();
  *output = ::network::mojom::URLResponseHeadDataView(pointer, message_);
}








inline void URLLoaderClient_OnComplete_ParamsDataView::GetStatusDataView(
    ::network::mojom::URLLoaderCompletionStatusDataView* output) {
  auto pointer = data_->status.Get();
  *output = ::network::mojom::URLLoaderCompletionStatusDataView(pointer, message_);
}



}  // network::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_MOJOM_PARAMS_DATA_H_