// services/network/public/mojom/url_loader.mojom-blink-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_MOJOM_BLINK_TEST_UTILS_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_MOJOM_BLINK_TEST_UTILS_H_

#include "services/network/public/mojom/url_loader.mojom-blink.h"
#include "third_party/blink/public/platform/web_common.h"


namespace network::mojom::blink {


class BLINK_PLATFORM_EXPORT URLLoaderInterceptorForTesting : public URLLoader {
  virtual URLLoader* GetForwardingInterface() = 0;
  void FollowRedirect(const ::blink::Vector<::blink::String>& removed_headers, const ::net::HttpRequestHeaders& modified_headers, const ::net::HttpRequestHeaders& modified_cors_exempt_headers, const std::optional<::blink::KURL>& new_url) override;
  void SetPriority(::net::RequestPriority priority, int32_t intra_priority_value) override;
};
class BLINK_PLATFORM_EXPORT URLLoaderAsyncWaiter {
 public:
  explicit URLLoaderAsyncWaiter(URLLoader* proxy);

  URLLoaderAsyncWaiter(const URLLoaderAsyncWaiter&) = delete;
  URLLoaderAsyncWaiter& operator=(const URLLoaderAsyncWaiter&) = delete;

  ~URLLoaderAsyncWaiter();

 private:
  URLLoader* const proxy_;
};


class BLINK_PLATFORM_EXPORT URLLoaderClientInterceptorForTesting : public URLLoaderClient {
  virtual URLLoaderClient* GetForwardingInterface() = 0;
  void OnReceiveEarlyHints(::network::mojom::blink::EarlyHintsPtr early_hints) override;
  void OnReceiveResponse(::network::mojom::blink::URLResponseHeadPtr head, ::mojo::ScopedDataPipeConsumerHandle body, std::optional<::mojo_base::BigBuffer> cached_metadata) override;
  void OnReceiveRedirect(URLRequestRedirectInfoPtr redirect_info, ::network::mojom::blink::URLResponseHeadPtr head) override;
  void OnUploadProgress(int64_t current_position, int64_t total_size, OnUploadProgressCallback callback) override;
  void OnTransferSizeUpdated(int32_t transfer_size_diff) override;
  void OnComplete(const ::network::URLLoaderCompletionStatus& status) override;
};
class BLINK_PLATFORM_EXPORT URLLoaderClientAsyncWaiter {
 public:
  explicit URLLoaderClientAsyncWaiter(URLLoaderClient* proxy);

  URLLoaderClientAsyncWaiter(const URLLoaderClientAsyncWaiter&) = delete;
  URLLoaderClientAsyncWaiter& operator=(const URLLoaderClientAsyncWaiter&) = delete;

  ~URLLoaderClientAsyncWaiter();
  void OnUploadProgress(
      int64_t current_position, int64_t total_size);
  

 private:
  URLLoaderClient* const proxy_;
};




}  // network::mojom::blink

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_MOJOM_BLINK_TEST_UTILS_H_