// services/network/public/mojom/unencoded_digest.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/unencoded_digest.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var integrity_metadata$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/integrity_metadata.mojom', 'integrity_metadata.mojom.js');
  }


  var UnencodedDigestIssue = {};
  UnencodedDigestIssue.kMalformedDictionary = 0;
  UnencodedDigestIssue.kUnknownAlgorithm = 1;
  UnencodedDigestIssue.kIncorrectDigestType = 2;
  UnencodedDigestIssue.kIncorrectDigestLength = 3;
  UnencodedDigestIssue.MIN_VALUE = 0;
  UnencodedDigestIssue.MAX_VALUE = 3;

  UnencodedDigestIssue.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  UnencodedDigestIssue.toKnownEnumValue = function(value) {
    return value;
  };

  UnencodedDigestIssue.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function UnencodedDigests(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UnencodedDigests.prototype.initDefaults_ = function() {
    this.digests = null;
    this.issues = null;
  };
  UnencodedDigests.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UnencodedDigests.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UnencodedDigests.digests
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(integrity_metadata$.IntegrityMetadata), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UnencodedDigests.issues
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 4, new codec.Enum(UnencodedDigestIssue), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  UnencodedDigests.encodedSize = codec.kStructHeaderSize + 16;

  UnencodedDigests.decode = function(decoder) {
    var packed;
    var val = new UnencodedDigests();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.digests =
        decoder.decodeArrayPointer(new codec.PointerTo(integrity_metadata$.IntegrityMetadata));
    val.issues =
        decoder.decodeArrayPointer(new codec.Enum(UnencodedDigestIssue));
    return val;
  };

  UnencodedDigests.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UnencodedDigests.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(integrity_metadata$.IntegrityMetadata), val.digests);
    encoder.encodeArrayPointer(new codec.Enum(UnencodedDigestIssue), val.issues);
  };
  exports.UnencodedDigestIssue = UnencodedDigestIssue;
  exports.UnencodedDigests = UnencodedDigests;
})();