// services/network/public/mojom/unencoded_digest.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_UNENCODED_DIGEST_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_UNENCODED_DIGEST_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/unencoded_digest.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/unencoded_digest.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/unencoded_digest.mojom-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/integrity_metadata.mojom.h"
#include <string>
#include <vector>








namespace network::mojom {








class  UnencodedDigests {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UnencodedDigests, T>::value>;
  using DataView = UnencodedDigestsDataView;
  using Data_ = internal::UnencodedDigests_Data;

  template <typename... Args>
  static UnencodedDigestsPtr New(Args&&... args) {
    return UnencodedDigestsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UnencodedDigestsPtr From(const U& u) {
    return mojo::TypeConverter<UnencodedDigestsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UnencodedDigests>::Convert(*this);
  }


  UnencodedDigests();

  UnencodedDigests(
      std::vector<::network::IntegrityMetadata> digests,
      std::vector<UnencodedDigestIssue> issues);

UnencodedDigests(const UnencodedDigests&) = delete;
UnencodedDigests& operator=(const UnencodedDigests&) = delete;

  ~UnencodedDigests();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UnencodedDigestsPtr>
  UnencodedDigestsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UnencodedDigests::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UnencodedDigests::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UnencodedDigests::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UnencodedDigests::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UnencodedDigests::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UnencodedDigests::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UnencodedDigests_UnserializedMessageContext<
            UserType, UnencodedDigests::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UnencodedDigests::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UnencodedDigests::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UnencodedDigests_UnserializedMessageContext<
            UserType, UnencodedDigests::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UnencodedDigests::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<::network::IntegrityMetadata> digests;
  
  std::vector<UnencodedDigestIssue> issues;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UnencodedDigests::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UnencodedDigests::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UnencodedDigests::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UnencodedDigests::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
UnencodedDigestsPtr UnencodedDigests::Clone() const {
  return New(
      mojo::Clone(digests),
      mojo::Clone(issues)
  );
}

template <typename T, UnencodedDigests::EnableIfSame<T>*>
bool UnencodedDigests::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->digests, other_struct.digests))
    return false;
  if (!mojo::Equals(this->issues, other_struct.issues))
    return false;
  return true;
}

template <typename T, UnencodedDigests::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.digests < rhs.digests)
    return true;
  if (rhs.digests < lhs.digests)
    return false;
  if (lhs.issues < rhs.issues)
    return true;
  if (rhs.issues < lhs.issues)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::UnencodedDigests::DataView,
                                         ::network::mojom::UnencodedDigestsPtr> {
  static bool IsNull(const ::network::mojom::UnencodedDigestsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::UnencodedDigestsPtr* output) { output->reset(); }

  static const decltype(::network::mojom::UnencodedDigests::digests)& digests(
      const ::network::mojom::UnencodedDigestsPtr& input) {
    return input->digests;
  }

  static const decltype(::network::mojom::UnencodedDigests::issues)& issues(
      const ::network::mojom::UnencodedDigestsPtr& input) {
    return input->issues;
  }

  static bool Read(::network::mojom::UnencodedDigests::DataView input, ::network::mojom::UnencodedDigestsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_UNENCODED_DIGEST_MOJOM_H_