// services/network/public/mojom/unencoded_digest.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_UNENCODED_DIGEST_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_UNENCODED_DIGEST_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/unencoded_digest.mojom-shared-internal.h"
#include "services/network/public/mojom/integrity_metadata.mojom-shared.h"




#include "services/network/public/mojom/unencoded_digest.mojom-data-view.h"




namespace std {

template <>
struct hash<::network::mojom::UnencodedDigestIssue>
    : public mojo::internal::EnumHashImpl<::network::mojom::UnencodedDigestIssue> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::UnencodedDigestIssue, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::UnencodedDigestIssue, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::UnencodedDigestIssue>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::UnencodedDigestsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::UnencodedDigestsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::UnencodedDigests_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::digests(input)) in_digests = Traits::digests(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->digests)::BaseType>
        digests_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& digests_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::IntegrityMetadataDataView>>(
      in_digests,
      digests_fragment,
      &digests_validate_params);

    fragment->digests.Set(
        digests_fragment.is_null() ? nullptr : digests_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->digests.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null digests in UnencodedDigests struct");

    decltype(Traits::issues(input)) in_issues = Traits::issues(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->issues)::BaseType>
        issues_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& issues_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::UnencodedDigestIssue_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::UnencodedDigestIssue>>(
      in_issues,
      issues_fragment,
      &issues_validate_params);

    fragment->issues.Set(
        issues_fragment.is_null() ? nullptr : issues_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->issues.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null issues in UnencodedDigests struct");
  }

  static bool Deserialize(::network::mojom::internal::UnencodedDigests_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::UnencodedDigestsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void UnencodedDigestsDataView::GetDigestsDataView(
    mojo::ArrayDataView<::network::mojom::IntegrityMetadataDataView>* output) {
  auto pointer = data_->digests.Get();
  *output = mojo::ArrayDataView<::network::mojom::IntegrityMetadataDataView>(pointer, message_);
}
inline void UnencodedDigestsDataView::GetIssuesDataView(
    mojo::ArrayDataView<UnencodedDigestIssue>* output) {
  auto pointer = data_->issues.Get();
  *output = mojo::ArrayDataView<UnencodedDigestIssue>(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::UnencodedDigestIssue> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::UnencodedDigestIssue value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_UNENCODED_DIGEST_MOJOM_SHARED_H_