// services/network/public/mojom/unencoded_digest.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_UNENCODED_DIGEST_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_UNENCODED_DIGEST_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/network/public/mojom/unencoded_digest.mojom-shared-internal.h"
#include "services/network/public/mojom/integrity_metadata.mojom-shared.h"


namespace network::mojom {
class UnencodedDigestsDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::UnencodedDigestsDataView> {
  using Data = ::network::mojom::internal::UnencodedDigests_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class UnencodedDigestIssue : int32_t {
  
  kMalformedDictionary = 0,
  
  kUnknownAlgorithm = 1,
  
  kIncorrectDigestType = 2,
  
  kIncorrectDigestLength = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, UnencodedDigestIssue value);
inline bool IsKnownEnumValue(UnencodedDigestIssue value) {
  return internal::UnencodedDigestIssue_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class UnencodedDigestsDataView {
 public:
  UnencodedDigestsDataView() = default;

  UnencodedDigestsDataView(
      internal::UnencodedDigests_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDigestsDataView(
      mojo::ArrayDataView<::network::mojom::IntegrityMetadataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDigests(UserType* output) {
    
    auto* pointer = data_->digests.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::IntegrityMetadataDataView>>(
        pointer, output, message_);
  }
  inline void GetIssuesDataView(
      mojo::ArrayDataView<UnencodedDigestIssue>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIssues(UserType* output) {
    
    auto* pointer = data_->issues.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::UnencodedDigestIssue>>(
        pointer, output, message_);
  }
 private:
  internal::UnencodedDigests_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_UNENCODED_DIGEST_MOJOM_DATA_VIEW_H_