// services/network/public/mojom/udp_socket.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_UDP_SOCKET_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_UDP_SOCKET_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/udp_socket.mojom-shared-internal.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom-shared.h"
#include "services/network/public/mojom/ip_address.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/network/public/mojom/udp_socket.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::UDPSocketOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::UDPSocketOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::UDPSocketOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->allow_address_reuse = Traits::allow_address_reuse(input);

    fragment->allow_broadcast = Traits::allow_broadcast(input);

    fragment->allow_address_sharing_for_multicast = Traits::allow_address_sharing_for_multicast(input);

    fragment->multicast_interface = Traits::multicast_interface(input);

    fragment->multicast_time_to_live = Traits::multicast_time_to_live(input);

    fragment->multicast_loopback_mode = Traits::multicast_loopback_mode(input);

    fragment->send_buffer_size = Traits::send_buffer_size(input);

    fragment->receive_buffer_size = Traits::receive_buffer_size(input);
    fragment->ipv6_only_$flag = Traits::ipv6_only(input).has_value();
    if (Traits::ipv6_only(input).has_value()) {
      fragment->ipv6_only_$value = Traits::ipv6_only(input).value();
    }
  }

  static bool Deserialize(::network::mojom::internal::UDPSocketOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::UDPSocketOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {




}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_UDP_SOCKET_MOJOM_SHARED_H_