// services/network/public/mojom/udp_socket.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_UDP_SOCKET_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_UDP_SOCKET_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/network/public/mojom/udp_socket.mojom-shared-internal.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom-shared.h"
#include "services/network/public/mojom/ip_address.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom-shared.h"


namespace network::mojom {
class UDPSocketOptionsDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::UDPSocketOptionsDataView> {
  using Data = ::network::mojom::internal::UDPSocketOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {
// Interface base classes. They are used for type safety check.
class UDPSocketInterfaceBase {};

using UDPSocketPtrDataView =
    mojo::InterfacePtrDataView<UDPSocketInterfaceBase>;
using UDPSocketRequestDataView =
    mojo::InterfaceRequestDataView<UDPSocketInterfaceBase>;
using UDPSocketAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<UDPSocketInterfaceBase>;
using UDPSocketAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<UDPSocketInterfaceBase>;
class UDPSocketListenerInterfaceBase {};

using UDPSocketListenerPtrDataView =
    mojo::InterfacePtrDataView<UDPSocketListenerInterfaceBase>;
using UDPSocketListenerRequestDataView =
    mojo::InterfaceRequestDataView<UDPSocketListenerInterfaceBase>;
using UDPSocketListenerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<UDPSocketListenerInterfaceBase>;
using UDPSocketListenerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<UDPSocketListenerInterfaceBase>;


class UDPSocketOptionsDataView {
 public:
  UDPSocketOptionsDataView() = default;

  UDPSocketOptionsDataView(
      internal::UDPSocketOptions_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool allow_address_reuse() const {
    return data_->allow_address_reuse;
  }
  bool allow_broadcast() const {
    return data_->allow_broadcast;
  }
  bool allow_address_sharing_for_multicast() const {
    return data_->allow_address_sharing_for_multicast;
  }
  uint32_t multicast_interface() const {
    return data_->multicast_interface;
  }
  uint32_t multicast_time_to_live() const {
    return data_->multicast_time_to_live;
  }
  bool multicast_loopback_mode() const {
    return data_->multicast_loopback_mode;
  }
  int32_t send_buffer_size() const {
    return data_->send_buffer_size;
  }
  int32_t receive_buffer_size() const {
    return data_->receive_buffer_size;
  }
  std::optional<bool> ipv6_only() const {

    return data_->ipv6_only_$flag
        ? std::make_optional(!!data_->ipv6_only_$value)
        : std::nullopt;
  }
 private:
  internal::UDPSocketOptions_Data* data_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_UDP_SOCKET_MOJOM_DATA_VIEW_H_