// services/network/public/mojom/trust_tokens.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKENS_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKENS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/trust_tokens.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/trust_tokens.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/trust_tokens.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/origin.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace network::mojom {

class TrustTokenQueryAnswererProxy;

template <typename ImplRefTraits>
class TrustTokenQueryAnswererStub;

class TrustTokenQueryAnswererRequestValidator;
class TrustTokenQueryAnswererResponseValidator;


class TrustTokenQueryAnswerer
    : public TrustTokenQueryAnswererInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.TrustTokenQueryAnswerer";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = TrustTokenQueryAnswererInterfaceBase;
  using Proxy_ = TrustTokenQueryAnswererProxy;

  template <typename ImplRefTraits>
  using Stub_ = TrustTokenQueryAnswererStub<ImplRefTraits>;

  using RequestValidator_ = TrustTokenQueryAnswererRequestValidator;
  using ResponseValidator_ = TrustTokenQueryAnswererResponseValidator;
  enum MethodMinVersions : uint32_t {
    kHasTrustTokensMinVersion = 0,
    kHasRedemptionRecordMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct HasTrustTokens_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HasRedemptionRecord_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~TrustTokenQueryAnswerer() = default;

  using HasTrustTokensCallback = base::OnceCallback<void(HasTrustTokensResultPtr)>;
  using HasTrustTokensMojoCallback = base::OnceCallback<void(HasTrustTokensResultPtr)>;

  virtual void HasTrustTokens(const ::url::Origin& issuer, HasTrustTokensCallback callback) = 0;

  using HasRedemptionRecordCallback = base::OnceCallback<void(HasRedemptionRecordResultPtr)>;
  using HasRedemptionRecordMojoCallback = base::OnceCallback<void(HasRedemptionRecordResultPtr)>;

  virtual void HasRedemptionRecord(const ::url::Origin& issuer, HasRedemptionRecordCallback callback) = 0;
};



class  TrustTokenQueryAnswererProxy
    : public TrustTokenQueryAnswerer {
 public:
  using InterfaceType = TrustTokenQueryAnswerer;

  explicit TrustTokenQueryAnswererProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void HasTrustTokens(const ::url::Origin& issuer, HasTrustTokensCallback callback) final;
  
  void HasRedemptionRecord(const ::url::Origin& issuer, HasRedemptionRecordCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  TrustTokenQueryAnswererStubDispatch {
 public:
  static bool Accept(TrustTokenQueryAnswerer* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      TrustTokenQueryAnswerer* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<TrustTokenQueryAnswerer>>
class TrustTokenQueryAnswererStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  TrustTokenQueryAnswererStub() = default;
  ~TrustTokenQueryAnswererStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TrustTokenQueryAnswererStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TrustTokenQueryAnswererStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  TrustTokenQueryAnswererRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  TrustTokenQueryAnswererResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class  HasTrustTokensResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HasTrustTokensResult, T>::value>;
  using DataView = HasTrustTokensResultDataView;
  using Data_ = internal::HasTrustTokensResult_Data;

  template <typename... Args>
  static HasTrustTokensResultPtr New(Args&&... args) {
    return HasTrustTokensResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HasTrustTokensResultPtr From(const U& u) {
    return mojo::TypeConverter<HasTrustTokensResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HasTrustTokensResult>::Convert(*this);
  }


  HasTrustTokensResult();

  HasTrustTokensResult(
      TrustTokenOperationStatus status,
      bool has_trust_tokens);


  ~HasTrustTokensResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HasTrustTokensResultPtr>
  HasTrustTokensResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HasTrustTokensResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HasTrustTokensResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HasTrustTokensResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HasTrustTokensResult::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HasTrustTokensResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HasTrustTokensResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HasTrustTokensResult_UnserializedMessageContext<
            UserType, HasTrustTokensResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HasTrustTokensResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HasTrustTokensResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HasTrustTokensResult_UnserializedMessageContext<
            UserType, HasTrustTokensResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HasTrustTokensResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  TrustTokenOperationStatus status;
  
  bool has_trust_tokens;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HasTrustTokensResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HasTrustTokensResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HasTrustTokensResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HasTrustTokensResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  HasRedemptionRecordResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HasRedemptionRecordResult, T>::value>;
  using DataView = HasRedemptionRecordResultDataView;
  using Data_ = internal::HasRedemptionRecordResult_Data;

  template <typename... Args>
  static HasRedemptionRecordResultPtr New(Args&&... args) {
    return HasRedemptionRecordResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HasRedemptionRecordResultPtr From(const U& u) {
    return mojo::TypeConverter<HasRedemptionRecordResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HasRedemptionRecordResult>::Convert(*this);
  }


  HasRedemptionRecordResult();

  HasRedemptionRecordResult(
      TrustTokenOperationStatus status,
      bool has_redemption_record);


  ~HasRedemptionRecordResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HasRedemptionRecordResultPtr>
  HasRedemptionRecordResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HasRedemptionRecordResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HasRedemptionRecordResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HasRedemptionRecordResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HasRedemptionRecordResult::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HasRedemptionRecordResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HasRedemptionRecordResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HasRedemptionRecordResult_UnserializedMessageContext<
            UserType, HasRedemptionRecordResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HasRedemptionRecordResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HasRedemptionRecordResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HasRedemptionRecordResult_UnserializedMessageContext<
            UserType, HasRedemptionRecordResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HasRedemptionRecordResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  TrustTokenOperationStatus status;
  
  bool has_redemption_record;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HasRedemptionRecordResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HasRedemptionRecordResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HasRedemptionRecordResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HasRedemptionRecordResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class  FulfillTrustTokenIssuanceAnswer {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FulfillTrustTokenIssuanceAnswer, T>::value>;
  using DataView = FulfillTrustTokenIssuanceAnswerDataView;
  using Data_ = internal::FulfillTrustTokenIssuanceAnswer_Data;
  using Status = FulfillTrustTokenIssuanceAnswer_Status;

  template <typename... Args>
  static FulfillTrustTokenIssuanceAnswerPtr New(Args&&... args) {
    return FulfillTrustTokenIssuanceAnswerPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FulfillTrustTokenIssuanceAnswerPtr From(const U& u) {
    return mojo::TypeConverter<FulfillTrustTokenIssuanceAnswerPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FulfillTrustTokenIssuanceAnswer>::Convert(*this);
  }


  FulfillTrustTokenIssuanceAnswer();

  FulfillTrustTokenIssuanceAnswer(
      FulfillTrustTokenIssuanceAnswer::Status status,
      const std::string& response);


  ~FulfillTrustTokenIssuanceAnswer();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FulfillTrustTokenIssuanceAnswerPtr>
  FulfillTrustTokenIssuanceAnswerPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FulfillTrustTokenIssuanceAnswer::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FulfillTrustTokenIssuanceAnswer::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FulfillTrustTokenIssuanceAnswer::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FulfillTrustTokenIssuanceAnswer::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FulfillTrustTokenIssuanceAnswer::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FulfillTrustTokenIssuanceAnswer::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FulfillTrustTokenIssuanceAnswer_UnserializedMessageContext<
            UserType, FulfillTrustTokenIssuanceAnswer::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FulfillTrustTokenIssuanceAnswer::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FulfillTrustTokenIssuanceAnswer::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FulfillTrustTokenIssuanceAnswer_UnserializedMessageContext<
            UserType, FulfillTrustTokenIssuanceAnswer::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FulfillTrustTokenIssuanceAnswer::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  FulfillTrustTokenIssuanceAnswer::Status status;
  
  std::string response;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FulfillTrustTokenIssuanceAnswer::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FulfillTrustTokenIssuanceAnswer::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FulfillTrustTokenIssuanceAnswer::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FulfillTrustTokenIssuanceAnswer::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class  TrustTokenParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TrustTokenParams, T>::value>;
  using DataView = TrustTokenParamsDataView;
  using Data_ = internal::TrustTokenParams_Data;

  template <typename... Args>
  static TrustTokenParamsPtr New(Args&&... args) {
    return TrustTokenParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TrustTokenParamsPtr From(const U& u) {
    return mojo::TypeConverter<TrustTokenParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TrustTokenParams>::Convert(*this);
  }


  TrustTokenParams();

  TrustTokenParams(
      TrustTokenOperationType operation,
      TrustTokenRefreshPolicy refresh_policy,
      const std::optional<std::string>& custom_key_commitment,
      const std::optional<::url::Origin>& custom_issuer,
      TrustTokenSignRequestData sign_request_data,
      bool include_timestamp_header,
      std::vector<::url::Origin> issuers,
      std::vector<std::string> additional_signed_headers,
      const std::optional<std::string>& possibly_unsafe_additional_signing_data);


  ~TrustTokenParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TrustTokenParamsPtr>
  TrustTokenParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TrustTokenParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TrustTokenParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TrustTokenParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TrustTokenParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TrustTokenParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TrustTokenParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TrustTokenParams_UnserializedMessageContext<
            UserType, TrustTokenParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TrustTokenParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TrustTokenParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TrustTokenParams_UnserializedMessageContext<
            UserType, TrustTokenParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TrustTokenParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  TrustTokenOperationType operation;
  
  TrustTokenRefreshPolicy refresh_policy;
  
  std::optional<std::string> custom_key_commitment;
  
  std::optional<::url::Origin> custom_issuer;
  
  TrustTokenSignRequestData sign_request_data;
  
  bool include_timestamp_header;
  
  std::vector<::url::Origin> issuers;
  
  std::vector<std::string> additional_signed_headers;
  
  std::optional<std::string> possibly_unsafe_additional_signing_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TrustTokenParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TrustTokenParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TrustTokenParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TrustTokenParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  TrustTokenVerificationKey {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TrustTokenVerificationKey, T>::value>;
  using DataView = TrustTokenVerificationKeyDataView;
  using Data_ = internal::TrustTokenVerificationKey_Data;

  template <typename... Args>
  static TrustTokenVerificationKeyPtr New(Args&&... args) {
    return TrustTokenVerificationKeyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TrustTokenVerificationKeyPtr From(const U& u) {
    return mojo::TypeConverter<TrustTokenVerificationKeyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TrustTokenVerificationKey>::Convert(*this);
  }


  TrustTokenVerificationKey();

  TrustTokenVerificationKey(
      const std::string& body,
      ::base::Time expiry);


  ~TrustTokenVerificationKey();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TrustTokenVerificationKeyPtr>
  TrustTokenVerificationKeyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TrustTokenVerificationKey::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TrustTokenVerificationKey::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TrustTokenVerificationKey::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TrustTokenVerificationKey::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TrustTokenVerificationKey::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TrustTokenVerificationKey::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TrustTokenVerificationKey_UnserializedMessageContext<
            UserType, TrustTokenVerificationKey::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TrustTokenVerificationKey::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TrustTokenVerificationKey::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TrustTokenVerificationKey_UnserializedMessageContext<
            UserType, TrustTokenVerificationKey::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TrustTokenVerificationKey::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string body;
  
  ::base::Time expiry;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TrustTokenVerificationKey::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TrustTokenVerificationKey::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TrustTokenVerificationKey::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TrustTokenVerificationKey::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TrustTokenKeyCommitmentResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TrustTokenKeyCommitmentResult, T>::value>;
  using DataView = TrustTokenKeyCommitmentResultDataView;
  using Data_ = internal::TrustTokenKeyCommitmentResult_Data;
  using Os = TrustTokenKeyCommitmentResult_Os;
  using UnavailableLocalOperationFallback = TrustTokenKeyCommitmentResult_UnavailableLocalOperationFallback;

  template <typename... Args>
  static TrustTokenKeyCommitmentResultPtr New(Args&&... args) {
    return TrustTokenKeyCommitmentResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TrustTokenKeyCommitmentResultPtr From(const U& u) {
    return mojo::TypeConverter<TrustTokenKeyCommitmentResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TrustTokenKeyCommitmentResult>::Convert(*this);
  }


  TrustTokenKeyCommitmentResult();

  TrustTokenKeyCommitmentResult(
      TrustTokenProtocolVersion protocol_version,
      int32_t id,
      int32_t batch_size,
      std::vector<TrustTokenVerificationKeyPtr> keys,
      std::vector<TrustTokenKeyCommitmentResult::Os> request_issuance_locally_on,
      TrustTokenKeyCommitmentResult::UnavailableLocalOperationFallback unavailable_local_operation_fallback);

TrustTokenKeyCommitmentResult(const TrustTokenKeyCommitmentResult&) = delete;
TrustTokenKeyCommitmentResult& operator=(const TrustTokenKeyCommitmentResult&) = delete;

  ~TrustTokenKeyCommitmentResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TrustTokenKeyCommitmentResultPtr>
  TrustTokenKeyCommitmentResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TrustTokenKeyCommitmentResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TrustTokenKeyCommitmentResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TrustTokenKeyCommitmentResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TrustTokenKeyCommitmentResult::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TrustTokenKeyCommitmentResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TrustTokenKeyCommitmentResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TrustTokenKeyCommitmentResult_UnserializedMessageContext<
            UserType, TrustTokenKeyCommitmentResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TrustTokenKeyCommitmentResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TrustTokenKeyCommitmentResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TrustTokenKeyCommitmentResult_UnserializedMessageContext<
            UserType, TrustTokenKeyCommitmentResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TrustTokenKeyCommitmentResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  TrustTokenProtocolVersion protocol_version;
  
  int32_t id;
  
  int32_t batch_size;
  
  std::vector<TrustTokenVerificationKeyPtr> keys;
  
  std::vector<TrustTokenKeyCommitmentResult::Os> request_issuance_locally_on;
  
  TrustTokenKeyCommitmentResult::UnavailableLocalOperationFallback unavailable_local_operation_fallback;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TrustTokenKeyCommitmentResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TrustTokenKeyCommitmentResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TrustTokenKeyCommitmentResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TrustTokenKeyCommitmentResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  FulfillTrustTokenIssuanceRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FulfillTrustTokenIssuanceRequest, T>::value>;
  using DataView = FulfillTrustTokenIssuanceRequestDataView;
  using Data_ = internal::FulfillTrustTokenIssuanceRequest_Data;

  template <typename... Args>
  static FulfillTrustTokenIssuanceRequestPtr New(Args&&... args) {
    return FulfillTrustTokenIssuanceRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FulfillTrustTokenIssuanceRequestPtr From(const U& u) {
    return mojo::TypeConverter<FulfillTrustTokenIssuanceRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FulfillTrustTokenIssuanceRequest>::Convert(*this);
  }


  FulfillTrustTokenIssuanceRequest();

  FulfillTrustTokenIssuanceRequest(
      const ::url::Origin& issuer,
      const std::string& request);


  ~FulfillTrustTokenIssuanceRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FulfillTrustTokenIssuanceRequestPtr>
  FulfillTrustTokenIssuanceRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FulfillTrustTokenIssuanceRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FulfillTrustTokenIssuanceRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FulfillTrustTokenIssuanceRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FulfillTrustTokenIssuanceRequest::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FulfillTrustTokenIssuanceRequest::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FulfillTrustTokenIssuanceRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FulfillTrustTokenIssuanceRequest_UnserializedMessageContext<
            UserType, FulfillTrustTokenIssuanceRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FulfillTrustTokenIssuanceRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FulfillTrustTokenIssuanceRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FulfillTrustTokenIssuanceRequest_UnserializedMessageContext<
            UserType, FulfillTrustTokenIssuanceRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FulfillTrustTokenIssuanceRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::url::Origin issuer;
  
  std::string request;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FulfillTrustTokenIssuanceRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FulfillTrustTokenIssuanceRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FulfillTrustTokenIssuanceRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FulfillTrustTokenIssuanceRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  TrustTokenOperationResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TrustTokenOperationResult, T>::value>;
  using DataView = TrustTokenOperationResultDataView;
  using Data_ = internal::TrustTokenOperationResult_Data;

  template <typename... Args>
  static TrustTokenOperationResultPtr New(Args&&... args) {
    return TrustTokenOperationResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TrustTokenOperationResultPtr From(const U& u) {
    return mojo::TypeConverter<TrustTokenOperationResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TrustTokenOperationResult>::Convert(*this);
  }


  TrustTokenOperationResult();

  TrustTokenOperationResult(
      TrustTokenOperationType operation,
      TrustTokenOperationStatus status,
      const std::optional<::url::Origin>& issuer,
      const std::optional<::url::Origin>& top_level_origin,
      int32_t issued_token_count);


  ~TrustTokenOperationResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TrustTokenOperationResultPtr>
  TrustTokenOperationResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TrustTokenOperationResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TrustTokenOperationResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TrustTokenOperationResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TrustTokenOperationResult::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TrustTokenOperationResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TrustTokenOperationResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TrustTokenOperationResult_UnserializedMessageContext<
            UserType, TrustTokenOperationResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TrustTokenOperationResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TrustTokenOperationResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TrustTokenOperationResult_UnserializedMessageContext<
            UserType, TrustTokenOperationResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TrustTokenOperationResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  TrustTokenOperationType operation;
  
  TrustTokenOperationStatus status;
  
  std::optional<::url::Origin> issuer;
  
  std::optional<::url::Origin> top_level_origin;
  
  int32_t issued_token_count;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TrustTokenOperationResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TrustTokenOperationResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TrustTokenOperationResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TrustTokenOperationResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  StoredTrustTokensForIssuer {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<StoredTrustTokensForIssuer, T>::value>;
  using DataView = StoredTrustTokensForIssuerDataView;
  using Data_ = internal::StoredTrustTokensForIssuer_Data;

  template <typename... Args>
  static StoredTrustTokensForIssuerPtr New(Args&&... args) {
    return StoredTrustTokensForIssuerPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static StoredTrustTokensForIssuerPtr From(const U& u) {
    return mojo::TypeConverter<StoredTrustTokensForIssuerPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, StoredTrustTokensForIssuer>::Convert(*this);
  }


  StoredTrustTokensForIssuer();

  StoredTrustTokensForIssuer(
      const ::url::Origin& issuer,
      int32_t count);


  ~StoredTrustTokensForIssuer();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = StoredTrustTokensForIssuerPtr>
  StoredTrustTokensForIssuerPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, StoredTrustTokensForIssuer::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, StoredTrustTokensForIssuer::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, StoredTrustTokensForIssuer::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StoredTrustTokensForIssuer::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StoredTrustTokensForIssuer::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        StoredTrustTokensForIssuer::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::StoredTrustTokensForIssuer_UnserializedMessageContext<
            UserType, StoredTrustTokensForIssuer::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<StoredTrustTokensForIssuer::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return StoredTrustTokensForIssuer::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::StoredTrustTokensForIssuer_UnserializedMessageContext<
            UserType, StoredTrustTokensForIssuer::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<StoredTrustTokensForIssuer::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::url::Origin issuer;
  
  int32_t count;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, StoredTrustTokensForIssuer::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, StoredTrustTokensForIssuer::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, StoredTrustTokensForIssuer::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, StoredTrustTokensForIssuer::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ToplevelRedemptionRecord {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ToplevelRedemptionRecord, T>::value>;
  using DataView = ToplevelRedemptionRecordDataView;
  using Data_ = internal::ToplevelRedemptionRecord_Data;

  template <typename... Args>
  static ToplevelRedemptionRecordPtr New(Args&&... args) {
    return ToplevelRedemptionRecordPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ToplevelRedemptionRecordPtr From(const U& u) {
    return mojo::TypeConverter<ToplevelRedemptionRecordPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ToplevelRedemptionRecord>::Convert(*this);
  }


  ToplevelRedemptionRecord();

  ToplevelRedemptionRecord(
      const ::url::Origin& toplevel_origin,
      ::base::Time last_redemption);


  ~ToplevelRedemptionRecord();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ToplevelRedemptionRecordPtr>
  ToplevelRedemptionRecordPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ToplevelRedemptionRecord::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ToplevelRedemptionRecord::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ToplevelRedemptionRecord::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ToplevelRedemptionRecord::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ToplevelRedemptionRecord::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ToplevelRedemptionRecord::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ToplevelRedemptionRecord_UnserializedMessageContext<
            UserType, ToplevelRedemptionRecord::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ToplevelRedemptionRecord::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ToplevelRedemptionRecord::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ToplevelRedemptionRecord_UnserializedMessageContext<
            UserType, ToplevelRedemptionRecord::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ToplevelRedemptionRecord::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::url::Origin toplevel_origin;
  
  ::base::Time last_redemption;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ToplevelRedemptionRecord::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ToplevelRedemptionRecord::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ToplevelRedemptionRecord::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ToplevelRedemptionRecord::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
TrustTokenParamsPtr TrustTokenParams::Clone() const {
  return New(
      mojo::Clone(operation),
      mojo::Clone(refresh_policy),
      mojo::Clone(custom_key_commitment),
      mojo::Clone(custom_issuer),
      mojo::Clone(sign_request_data),
      mojo::Clone(include_timestamp_header),
      mojo::Clone(issuers),
      mojo::Clone(additional_signed_headers),
      mojo::Clone(possibly_unsafe_additional_signing_data)
  );
}

template <typename T, TrustTokenParams::EnableIfSame<T>*>
bool TrustTokenParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->operation, other_struct.operation))
    return false;
  if (!mojo::Equals(this->refresh_policy, other_struct.refresh_policy))
    return false;
  if (!mojo::Equals(this->custom_key_commitment, other_struct.custom_key_commitment))
    return false;
  if (!mojo::Equals(this->custom_issuer, other_struct.custom_issuer))
    return false;
  if (!mojo::Equals(this->sign_request_data, other_struct.sign_request_data))
    return false;
  if (!mojo::Equals(this->include_timestamp_header, other_struct.include_timestamp_header))
    return false;
  if (!mojo::Equals(this->issuers, other_struct.issuers))
    return false;
  if (!mojo::Equals(this->additional_signed_headers, other_struct.additional_signed_headers))
    return false;
  if (!mojo::Equals(this->possibly_unsafe_additional_signing_data, other_struct.possibly_unsafe_additional_signing_data))
    return false;
  return true;
}

template <typename T, TrustTokenParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.operation < rhs.operation)
    return true;
  if (rhs.operation < lhs.operation)
    return false;
  if (lhs.refresh_policy < rhs.refresh_policy)
    return true;
  if (rhs.refresh_policy < lhs.refresh_policy)
    return false;
  if (lhs.custom_key_commitment < rhs.custom_key_commitment)
    return true;
  if (rhs.custom_key_commitment < lhs.custom_key_commitment)
    return false;
  if (lhs.custom_issuer < rhs.custom_issuer)
    return true;
  if (rhs.custom_issuer < lhs.custom_issuer)
    return false;
  if (lhs.sign_request_data < rhs.sign_request_data)
    return true;
  if (rhs.sign_request_data < lhs.sign_request_data)
    return false;
  if (lhs.include_timestamp_header < rhs.include_timestamp_header)
    return true;
  if (rhs.include_timestamp_header < lhs.include_timestamp_header)
    return false;
  if (lhs.issuers < rhs.issuers)
    return true;
  if (rhs.issuers < lhs.issuers)
    return false;
  if (lhs.additional_signed_headers < rhs.additional_signed_headers)
    return true;
  if (rhs.additional_signed_headers < lhs.additional_signed_headers)
    return false;
  if (lhs.possibly_unsafe_additional_signing_data < rhs.possibly_unsafe_additional_signing_data)
    return true;
  if (rhs.possibly_unsafe_additional_signing_data < lhs.possibly_unsafe_additional_signing_data)
    return false;
  return false;
}
template <typename StructPtrType>
HasTrustTokensResultPtr HasTrustTokensResult::Clone() const {
  return New(
      mojo::Clone(status),
      mojo::Clone(has_trust_tokens)
  );
}

template <typename T, HasTrustTokensResult::EnableIfSame<T>*>
bool HasTrustTokensResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->status, other_struct.status))
    return false;
  if (!mojo::Equals(this->has_trust_tokens, other_struct.has_trust_tokens))
    return false;
  return true;
}

template <typename T, HasTrustTokensResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.status < rhs.status)
    return true;
  if (rhs.status < lhs.status)
    return false;
  if (lhs.has_trust_tokens < rhs.has_trust_tokens)
    return true;
  if (rhs.has_trust_tokens < lhs.has_trust_tokens)
    return false;
  return false;
}
template <typename StructPtrType>
HasRedemptionRecordResultPtr HasRedemptionRecordResult::Clone() const {
  return New(
      mojo::Clone(status),
      mojo::Clone(has_redemption_record)
  );
}

template <typename T, HasRedemptionRecordResult::EnableIfSame<T>*>
bool HasRedemptionRecordResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->status, other_struct.status))
    return false;
  if (!mojo::Equals(this->has_redemption_record, other_struct.has_redemption_record))
    return false;
  return true;
}

template <typename T, HasRedemptionRecordResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.status < rhs.status)
    return true;
  if (rhs.status < lhs.status)
    return false;
  if (lhs.has_redemption_record < rhs.has_redemption_record)
    return true;
  if (rhs.has_redemption_record < lhs.has_redemption_record)
    return false;
  return false;
}
template <typename StructPtrType>
TrustTokenVerificationKeyPtr TrustTokenVerificationKey::Clone() const {
  return New(
      mojo::Clone(body),
      mojo::Clone(expiry)
  );
}

template <typename T, TrustTokenVerificationKey::EnableIfSame<T>*>
bool TrustTokenVerificationKey::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->body, other_struct.body))
    return false;
  if (!mojo::Equals(this->expiry, other_struct.expiry))
    return false;
  return true;
}

template <typename T, TrustTokenVerificationKey::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.body < rhs.body)
    return true;
  if (rhs.body < lhs.body)
    return false;
  if (lhs.expiry < rhs.expiry)
    return true;
  if (rhs.expiry < lhs.expiry)
    return false;
  return false;
}
template <typename StructPtrType>
TrustTokenKeyCommitmentResultPtr TrustTokenKeyCommitmentResult::Clone() const {
  return New(
      mojo::Clone(protocol_version),
      mojo::Clone(id),
      mojo::Clone(batch_size),
      mojo::Clone(keys),
      mojo::Clone(request_issuance_locally_on),
      mojo::Clone(unavailable_local_operation_fallback)
  );
}

template <typename T, TrustTokenKeyCommitmentResult::EnableIfSame<T>*>
bool TrustTokenKeyCommitmentResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->protocol_version, other_struct.protocol_version))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->batch_size, other_struct.batch_size))
    return false;
  if (!mojo::Equals(this->keys, other_struct.keys))
    return false;
  if (!mojo::Equals(this->request_issuance_locally_on, other_struct.request_issuance_locally_on))
    return false;
  if (!mojo::Equals(this->unavailable_local_operation_fallback, other_struct.unavailable_local_operation_fallback))
    return false;
  return true;
}

template <typename T, TrustTokenKeyCommitmentResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.protocol_version < rhs.protocol_version)
    return true;
  if (rhs.protocol_version < lhs.protocol_version)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.batch_size < rhs.batch_size)
    return true;
  if (rhs.batch_size < lhs.batch_size)
    return false;
  if (lhs.keys < rhs.keys)
    return true;
  if (rhs.keys < lhs.keys)
    return false;
  if (lhs.request_issuance_locally_on < rhs.request_issuance_locally_on)
    return true;
  if (rhs.request_issuance_locally_on < lhs.request_issuance_locally_on)
    return false;
  if (lhs.unavailable_local_operation_fallback < rhs.unavailable_local_operation_fallback)
    return true;
  if (rhs.unavailable_local_operation_fallback < lhs.unavailable_local_operation_fallback)
    return false;
  return false;
}
template <typename StructPtrType>
FulfillTrustTokenIssuanceRequestPtr FulfillTrustTokenIssuanceRequest::Clone() const {
  return New(
      mojo::Clone(issuer),
      mojo::Clone(request)
  );
}

template <typename T, FulfillTrustTokenIssuanceRequest::EnableIfSame<T>*>
bool FulfillTrustTokenIssuanceRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->issuer, other_struct.issuer))
    return false;
  if (!mojo::Equals(this->request, other_struct.request))
    return false;
  return true;
}

template <typename T, FulfillTrustTokenIssuanceRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.issuer < rhs.issuer)
    return true;
  if (rhs.issuer < lhs.issuer)
    return false;
  if (lhs.request < rhs.request)
    return true;
  if (rhs.request < lhs.request)
    return false;
  return false;
}
template <typename StructPtrType>
FulfillTrustTokenIssuanceAnswerPtr FulfillTrustTokenIssuanceAnswer::Clone() const {
  return New(
      mojo::Clone(status),
      mojo::Clone(response)
  );
}

template <typename T, FulfillTrustTokenIssuanceAnswer::EnableIfSame<T>*>
bool FulfillTrustTokenIssuanceAnswer::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->status, other_struct.status))
    return false;
  if (!mojo::Equals(this->response, other_struct.response))
    return false;
  return true;
}

template <typename T, FulfillTrustTokenIssuanceAnswer::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.status < rhs.status)
    return true;
  if (rhs.status < lhs.status)
    return false;
  if (lhs.response < rhs.response)
    return true;
  if (rhs.response < lhs.response)
    return false;
  return false;
}
template <typename StructPtrType>
TrustTokenOperationResultPtr TrustTokenOperationResult::Clone() const {
  return New(
      mojo::Clone(operation),
      mojo::Clone(status),
      mojo::Clone(issuer),
      mojo::Clone(top_level_origin),
      mojo::Clone(issued_token_count)
  );
}

template <typename T, TrustTokenOperationResult::EnableIfSame<T>*>
bool TrustTokenOperationResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->operation, other_struct.operation))
    return false;
  if (!mojo::Equals(this->status, other_struct.status))
    return false;
  if (!mojo::Equals(this->issuer, other_struct.issuer))
    return false;
  if (!mojo::Equals(this->top_level_origin, other_struct.top_level_origin))
    return false;
  if (!mojo::Equals(this->issued_token_count, other_struct.issued_token_count))
    return false;
  return true;
}

template <typename T, TrustTokenOperationResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.operation < rhs.operation)
    return true;
  if (rhs.operation < lhs.operation)
    return false;
  if (lhs.status < rhs.status)
    return true;
  if (rhs.status < lhs.status)
    return false;
  if (lhs.issuer < rhs.issuer)
    return true;
  if (rhs.issuer < lhs.issuer)
    return false;
  if (lhs.top_level_origin < rhs.top_level_origin)
    return true;
  if (rhs.top_level_origin < lhs.top_level_origin)
    return false;
  if (lhs.issued_token_count < rhs.issued_token_count)
    return true;
  if (rhs.issued_token_count < lhs.issued_token_count)
    return false;
  return false;
}
template <typename StructPtrType>
StoredTrustTokensForIssuerPtr StoredTrustTokensForIssuer::Clone() const {
  return New(
      mojo::Clone(issuer),
      mojo::Clone(count)
  );
}

template <typename T, StoredTrustTokensForIssuer::EnableIfSame<T>*>
bool StoredTrustTokensForIssuer::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->issuer, other_struct.issuer))
    return false;
  if (!mojo::Equals(this->count, other_struct.count))
    return false;
  return true;
}

template <typename T, StoredTrustTokensForIssuer::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.issuer < rhs.issuer)
    return true;
  if (rhs.issuer < lhs.issuer)
    return false;
  if (lhs.count < rhs.count)
    return true;
  if (rhs.count < lhs.count)
    return false;
  return false;
}
template <typename StructPtrType>
ToplevelRedemptionRecordPtr ToplevelRedemptionRecord::Clone() const {
  return New(
      mojo::Clone(toplevel_origin),
      mojo::Clone(last_redemption)
  );
}

template <typename T, ToplevelRedemptionRecord::EnableIfSame<T>*>
bool ToplevelRedemptionRecord::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->toplevel_origin, other_struct.toplevel_origin))
    return false;
  if (!mojo::Equals(this->last_redemption, other_struct.last_redemption))
    return false;
  return true;
}

template <typename T, ToplevelRedemptionRecord::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.toplevel_origin < rhs.toplevel_origin)
    return true;
  if (rhs.toplevel_origin < lhs.toplevel_origin)
    return false;
  if (lhs.last_redemption < rhs.last_redemption)
    return true;
  if (rhs.last_redemption < lhs.last_redemption)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::TrustTokenParams::DataView,
                                         ::network::mojom::TrustTokenParamsPtr> {
  static bool IsNull(const ::network::mojom::TrustTokenParamsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::TrustTokenParamsPtr* output) { output->reset(); }

  static decltype(::network::mojom::TrustTokenParams::operation) operation(
      const ::network::mojom::TrustTokenParamsPtr& input) {
    return input->operation;
  }

  static decltype(::network::mojom::TrustTokenParams::refresh_policy) refresh_policy(
      const ::network::mojom::TrustTokenParamsPtr& input) {
    return input->refresh_policy;
  }

  static const decltype(::network::mojom::TrustTokenParams::custom_key_commitment)& custom_key_commitment(
      const ::network::mojom::TrustTokenParamsPtr& input) {
    return input->custom_key_commitment;
  }

  static const decltype(::network::mojom::TrustTokenParams::custom_issuer)& custom_issuer(
      const ::network::mojom::TrustTokenParamsPtr& input) {
    return input->custom_issuer;
  }

  static decltype(::network::mojom::TrustTokenParams::sign_request_data) sign_request_data(
      const ::network::mojom::TrustTokenParamsPtr& input) {
    return input->sign_request_data;
  }

  static decltype(::network::mojom::TrustTokenParams::include_timestamp_header) include_timestamp_header(
      const ::network::mojom::TrustTokenParamsPtr& input) {
    return input->include_timestamp_header;
  }

  static const decltype(::network::mojom::TrustTokenParams::issuers)& issuers(
      const ::network::mojom::TrustTokenParamsPtr& input) {
    return input->issuers;
  }

  static const decltype(::network::mojom::TrustTokenParams::additional_signed_headers)& additional_signed_headers(
      const ::network::mojom::TrustTokenParamsPtr& input) {
    return input->additional_signed_headers;
  }

  static const decltype(::network::mojom::TrustTokenParams::possibly_unsafe_additional_signing_data)& possibly_unsafe_additional_signing_data(
      const ::network::mojom::TrustTokenParamsPtr& input) {
    return input->possibly_unsafe_additional_signing_data;
  }

  static bool Read(::network::mojom::TrustTokenParams::DataView input, ::network::mojom::TrustTokenParamsPtr* output);
};


template <>
struct  StructTraits<::network::mojom::HasTrustTokensResult::DataView,
                                         ::network::mojom::HasTrustTokensResultPtr> {
  static bool IsNull(const ::network::mojom::HasTrustTokensResultPtr& input) { return !input; }
  static void SetToNull(::network::mojom::HasTrustTokensResultPtr* output) { output->reset(); }

  static decltype(::network::mojom::HasTrustTokensResult::status) status(
      const ::network::mojom::HasTrustTokensResultPtr& input) {
    return input->status;
  }

  static decltype(::network::mojom::HasTrustTokensResult::has_trust_tokens) has_trust_tokens(
      const ::network::mojom::HasTrustTokensResultPtr& input) {
    return input->has_trust_tokens;
  }

  static bool Read(::network::mojom::HasTrustTokensResult::DataView input, ::network::mojom::HasTrustTokensResultPtr* output);
};


template <>
struct  StructTraits<::network::mojom::HasRedemptionRecordResult::DataView,
                                         ::network::mojom::HasRedemptionRecordResultPtr> {
  static bool IsNull(const ::network::mojom::HasRedemptionRecordResultPtr& input) { return !input; }
  static void SetToNull(::network::mojom::HasRedemptionRecordResultPtr* output) { output->reset(); }

  static decltype(::network::mojom::HasRedemptionRecordResult::status) status(
      const ::network::mojom::HasRedemptionRecordResultPtr& input) {
    return input->status;
  }

  static decltype(::network::mojom::HasRedemptionRecordResult::has_redemption_record) has_redemption_record(
      const ::network::mojom::HasRedemptionRecordResultPtr& input) {
    return input->has_redemption_record;
  }

  static bool Read(::network::mojom::HasRedemptionRecordResult::DataView input, ::network::mojom::HasRedemptionRecordResultPtr* output);
};


template <>
struct  StructTraits<::network::mojom::TrustTokenVerificationKey::DataView,
                                         ::network::mojom::TrustTokenVerificationKeyPtr> {
  static bool IsNull(const ::network::mojom::TrustTokenVerificationKeyPtr& input) { return !input; }
  static void SetToNull(::network::mojom::TrustTokenVerificationKeyPtr* output) { output->reset(); }

  static const decltype(::network::mojom::TrustTokenVerificationKey::body)& body(
      const ::network::mojom::TrustTokenVerificationKeyPtr& input) {
    return input->body;
  }

  static const decltype(::network::mojom::TrustTokenVerificationKey::expiry)& expiry(
      const ::network::mojom::TrustTokenVerificationKeyPtr& input) {
    return input->expiry;
  }

  static bool Read(::network::mojom::TrustTokenVerificationKey::DataView input, ::network::mojom::TrustTokenVerificationKeyPtr* output);
};


template <>
struct  StructTraits<::network::mojom::TrustTokenKeyCommitmentResult::DataView,
                                         ::network::mojom::TrustTokenKeyCommitmentResultPtr> {
  static bool IsNull(const ::network::mojom::TrustTokenKeyCommitmentResultPtr& input) { return !input; }
  static void SetToNull(::network::mojom::TrustTokenKeyCommitmentResultPtr* output) { output->reset(); }

  static decltype(::network::mojom::TrustTokenKeyCommitmentResult::protocol_version) protocol_version(
      const ::network::mojom::TrustTokenKeyCommitmentResultPtr& input) {
    return input->protocol_version;
  }

  static decltype(::network::mojom::TrustTokenKeyCommitmentResult::id) id(
      const ::network::mojom::TrustTokenKeyCommitmentResultPtr& input) {
    return input->id;
  }

  static decltype(::network::mojom::TrustTokenKeyCommitmentResult::batch_size) batch_size(
      const ::network::mojom::TrustTokenKeyCommitmentResultPtr& input) {
    return input->batch_size;
  }

  static const decltype(::network::mojom::TrustTokenKeyCommitmentResult::keys)& keys(
      const ::network::mojom::TrustTokenKeyCommitmentResultPtr& input) {
    return input->keys;
  }

  static const decltype(::network::mojom::TrustTokenKeyCommitmentResult::request_issuance_locally_on)& request_issuance_locally_on(
      const ::network::mojom::TrustTokenKeyCommitmentResultPtr& input) {
    return input->request_issuance_locally_on;
  }

  static decltype(::network::mojom::TrustTokenKeyCommitmentResult::unavailable_local_operation_fallback) unavailable_local_operation_fallback(
      const ::network::mojom::TrustTokenKeyCommitmentResultPtr& input) {
    return input->unavailable_local_operation_fallback;
  }

  static bool Read(::network::mojom::TrustTokenKeyCommitmentResult::DataView input, ::network::mojom::TrustTokenKeyCommitmentResultPtr* output);
};


template <>
struct  StructTraits<::network::mojom::FulfillTrustTokenIssuanceRequest::DataView,
                                         ::network::mojom::FulfillTrustTokenIssuanceRequestPtr> {
  static bool IsNull(const ::network::mojom::FulfillTrustTokenIssuanceRequestPtr& input) { return !input; }
  static void SetToNull(::network::mojom::FulfillTrustTokenIssuanceRequestPtr* output) { output->reset(); }

  static const decltype(::network::mojom::FulfillTrustTokenIssuanceRequest::issuer)& issuer(
      const ::network::mojom::FulfillTrustTokenIssuanceRequestPtr& input) {
    return input->issuer;
  }

  static const decltype(::network::mojom::FulfillTrustTokenIssuanceRequest::request)& request(
      const ::network::mojom::FulfillTrustTokenIssuanceRequestPtr& input) {
    return input->request;
  }

  static bool Read(::network::mojom::FulfillTrustTokenIssuanceRequest::DataView input, ::network::mojom::FulfillTrustTokenIssuanceRequestPtr* output);
};


template <>
struct  StructTraits<::network::mojom::FulfillTrustTokenIssuanceAnswer::DataView,
                                         ::network::mojom::FulfillTrustTokenIssuanceAnswerPtr> {
  static bool IsNull(const ::network::mojom::FulfillTrustTokenIssuanceAnswerPtr& input) { return !input; }
  static void SetToNull(::network::mojom::FulfillTrustTokenIssuanceAnswerPtr* output) { output->reset(); }

  static decltype(::network::mojom::FulfillTrustTokenIssuanceAnswer::status) status(
      const ::network::mojom::FulfillTrustTokenIssuanceAnswerPtr& input) {
    return input->status;
  }

  static const decltype(::network::mojom::FulfillTrustTokenIssuanceAnswer::response)& response(
      const ::network::mojom::FulfillTrustTokenIssuanceAnswerPtr& input) {
    return input->response;
  }

  static bool Read(::network::mojom::FulfillTrustTokenIssuanceAnswer::DataView input, ::network::mojom::FulfillTrustTokenIssuanceAnswerPtr* output);
};


template <>
struct  StructTraits<::network::mojom::TrustTokenOperationResult::DataView,
                                         ::network::mojom::TrustTokenOperationResultPtr> {
  static bool IsNull(const ::network::mojom::TrustTokenOperationResultPtr& input) { return !input; }
  static void SetToNull(::network::mojom::TrustTokenOperationResultPtr* output) { output->reset(); }

  static decltype(::network::mojom::TrustTokenOperationResult::operation) operation(
      const ::network::mojom::TrustTokenOperationResultPtr& input) {
    return input->operation;
  }

  static decltype(::network::mojom::TrustTokenOperationResult::status) status(
      const ::network::mojom::TrustTokenOperationResultPtr& input) {
    return input->status;
  }

  static const decltype(::network::mojom::TrustTokenOperationResult::issuer)& issuer(
      const ::network::mojom::TrustTokenOperationResultPtr& input) {
    return input->issuer;
  }

  static const decltype(::network::mojom::TrustTokenOperationResult::top_level_origin)& top_level_origin(
      const ::network::mojom::TrustTokenOperationResultPtr& input) {
    return input->top_level_origin;
  }

  static decltype(::network::mojom::TrustTokenOperationResult::issued_token_count) issued_token_count(
      const ::network::mojom::TrustTokenOperationResultPtr& input) {
    return input->issued_token_count;
  }

  static bool Read(::network::mojom::TrustTokenOperationResult::DataView input, ::network::mojom::TrustTokenOperationResultPtr* output);
};


template <>
struct  StructTraits<::network::mojom::StoredTrustTokensForIssuer::DataView,
                                         ::network::mojom::StoredTrustTokensForIssuerPtr> {
  static bool IsNull(const ::network::mojom::StoredTrustTokensForIssuerPtr& input) { return !input; }
  static void SetToNull(::network::mojom::StoredTrustTokensForIssuerPtr* output) { output->reset(); }

  static const decltype(::network::mojom::StoredTrustTokensForIssuer::issuer)& issuer(
      const ::network::mojom::StoredTrustTokensForIssuerPtr& input) {
    return input->issuer;
  }

  static decltype(::network::mojom::StoredTrustTokensForIssuer::count) count(
      const ::network::mojom::StoredTrustTokensForIssuerPtr& input) {
    return input->count;
  }

  static bool Read(::network::mojom::StoredTrustTokensForIssuer::DataView input, ::network::mojom::StoredTrustTokensForIssuerPtr* output);
};


template <>
struct  StructTraits<::network::mojom::ToplevelRedemptionRecord::DataView,
                                         ::network::mojom::ToplevelRedemptionRecordPtr> {
  static bool IsNull(const ::network::mojom::ToplevelRedemptionRecordPtr& input) { return !input; }
  static void SetToNull(::network::mojom::ToplevelRedemptionRecordPtr* output) { output->reset(); }

  static const decltype(::network::mojom::ToplevelRedemptionRecord::toplevel_origin)& toplevel_origin(
      const ::network::mojom::ToplevelRedemptionRecordPtr& input) {
    return input->toplevel_origin;
  }

  static const decltype(::network::mojom::ToplevelRedemptionRecord::last_redemption)& last_redemption(
      const ::network::mojom::ToplevelRedemptionRecordPtr& input) {
    return input->last_redemption;
  }

  static bool Read(::network::mojom::ToplevelRedemptionRecord::DataView input, ::network::mojom::ToplevelRedemptionRecordPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKENS_MOJOM_H_