// services/network/public/mojom/trust_tokens.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('network.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.TrustTokenProtocolVersionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.TrustTokenProtocolVersion = {
  
  kTrustTokenV3Pmb: 0,
  kTrustTokenV3Voprf: 1,
  kPrivateStateTokenV1Pmb: 2,
  kPrivateStateTokenV1Voprf: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.TrustTokenOperationStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.TrustTokenOperationStatus = {
  
  kOk: 0,
  kInvalidArgument: 1,
  kMissingIssuerKeys: 2,
  kFailedPrecondition: 3,
  kResourceExhausted: 4,
  kAlreadyExists: 5,
  kResourceLimited: 6,
  kUnauthorized: 7,
  kBadResponse: 8,
  kInternalError: 9,
  kUnknownError: 10,
  kOperationSuccessfullyFulfilledLocally: 11,
  kSiteIssuerLimit: 12,
  MIN_VALUE: 0,
  MAX_VALUE: 12,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.TrustTokenOperationTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.TrustTokenOperationType = {
  
  kIssuance: 0,
  kRedemption: 1,
  kSigning: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.TrustTokenRefreshPolicySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.TrustTokenRefreshPolicy = {
  
  kUseCached: 0,
  kRefresh: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.TrustTokenSignRequestDataSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.TrustTokenSignRequestData = {
  
  kOmit: 0,
  kHeadersOnly: 1,
  kInclude: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.DeleteStoredTrustTokensStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.DeleteStoredTrustTokensStatus = {
  
  kSuccessTokensDeleted: 0,
  kSuccessNoTokensDeleted: 1,
  kFailureFeatureDisabled: 2,
  kFailureInvalidOrigin: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.TrustTokenQueryAnswererPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.TrustTokenQueryAnswerer.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.TrustTokenQueryAnswererInterface }
 */
network.mojom.TrustTokenQueryAnswererRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.TrustTokenQueryAnswererPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.TrustTokenQueryAnswererPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.TrustTokenQueryAnswererPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url.mojom.Origin } issuer
   * @return {!Promise<{
        result: !network.mojom.HasTrustTokensResult,
   *  }>}
   */

  hasTrustTokens(
      issuer) {
    return this.proxy.sendMessage(
        0,
        network.mojom.TrustTokenQueryAnswerer_HasTrustTokens_ParamsSpec.$,
        network.mojom.TrustTokenQueryAnswerer_HasTrustTokens_ResponseParamsSpec.$,
        [
          issuer
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Origin } issuer
   * @return {!Promise<{
        result: !network.mojom.HasRedemptionRecordResult,
   *  }>}
   */

  hasRedemptionRecord(
      issuer) {
    return this.proxy.sendMessage(
        1,
        network.mojom.TrustTokenQueryAnswerer_HasRedemptionRecord_ParamsSpec.$,
        network.mojom.TrustTokenQueryAnswerer_HasRedemptionRecord_ResponseParamsSpec.$,
        [
          issuer
        ],
        false);
  }
};

/**
 * An object which receives request messages for the TrustTokenQueryAnswerer
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.TrustTokenQueryAnswererReceiver = class {
  /**
   * @param {!network.mojom.TrustTokenQueryAnswererInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.TrustTokenQueryAnswererRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.TrustTokenQueryAnswererRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.TrustTokenQueryAnswererRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.TrustTokenQueryAnswerer_HasTrustTokens_ParamsSpec.$,
        network.mojom.TrustTokenQueryAnswerer_HasTrustTokens_ResponseParamsSpec.$,
        impl.hasTrustTokens.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.TrustTokenQueryAnswerer_HasRedemptionRecord_ParamsSpec.$,
        network.mojom.TrustTokenQueryAnswerer_HasRedemptionRecord_ResponseParamsSpec.$,
        impl.hasRedemptionRecord.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.TrustTokenQueryAnswerer = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.TrustTokenQueryAnswerer";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.TrustTokenQueryAnswererRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.TrustTokenQueryAnswererRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the TrustTokenQueryAnswerer
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.TrustTokenQueryAnswererCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.TrustTokenQueryAnswererRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.TrustTokenQueryAnswererRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.hasTrustTokens =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.TrustTokenQueryAnswerer_HasTrustTokens_ParamsSpec.$,
        network.mojom.TrustTokenQueryAnswerer_HasTrustTokens_ResponseParamsSpec.$,
        this.hasTrustTokens.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.hasRedemptionRecord =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.TrustTokenQueryAnswerer_HasRedemptionRecord_ParamsSpec.$,
        network.mojom.TrustTokenQueryAnswerer_HasRedemptionRecord_ResponseParamsSpec.$,
        this.hasRedemptionRecord.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TrustTokenParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.HasTrustTokensResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.HasRedemptionRecordResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TrustTokenVerificationKeySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TrustTokenKeyCommitmentResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.FulfillTrustTokenIssuanceRequestSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.FulfillTrustTokenIssuanceAnswerSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TrustTokenOperationResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.StoredTrustTokensForIssuerSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.ToplevelRedemptionRecordSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TrustTokenQueryAnswerer_HasTrustTokens_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TrustTokenQueryAnswerer_HasTrustTokens_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TrustTokenQueryAnswerer_HasRedemptionRecord_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TrustTokenQueryAnswerer_HasRedemptionRecord_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.TrustTokenParamsSpec.$,
    'TrustTokenParams',
    [
      mojo.internal.StructField(
        'operation', 0,
        0,
        network.mojom.TrustTokenOperationTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'refreshPolicy', 4,
        0,
        network.mojom.TrustTokenRefreshPolicySpec.$,
        network.mojom.TrustTokenRefreshPolicy.kUseCached,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'customKeyCommitment', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'customIssuer', 16,
        0,
        url.mojom.OriginSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'signRequestData', 24,
        0,
        network.mojom.TrustTokenSignRequestDataSpec.$,
        network.mojom.TrustTokenSignRequestData.kOmit,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'includeTimestampHeader', 28,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'issuers', 32,
        0,
        mojo.internal.Array(url.mojom.OriginSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'additionalSignedHeaders', 40,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'possiblyUnsafeAdditionalSigningData', 48,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 64],]);





/** @record */
network.mojom.TrustTokenParams = class {
  constructor() {
    /** @export { !network.mojom.TrustTokenOperationType } */
    this.operation;
    /** @export { !network.mojom.TrustTokenRefreshPolicy } */
    this.refreshPolicy;
    /** @export { (string|undefined) } */
    this.customKeyCommitment;
    /** @export { (url.mojom.Origin|undefined) } */
    this.customIssuer;
    /** @export { !network.mojom.TrustTokenSignRequestData } */
    this.signRequestData;
    /** @export { !boolean } */
    this.includeTimestampHeader;
    /** @export { !Array<!url.mojom.Origin> } */
    this.issuers;
    /** @export { !Array<!string> } */
    this.additionalSignedHeaders;
    /** @export { (string|undefined) } */
    this.possiblyUnsafeAdditionalSigningData;
  }
};



mojo.internal.Struct(
    network.mojom.HasTrustTokensResultSpec.$,
    'HasTrustTokensResult',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        network.mojom.TrustTokenOperationStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasTrustTokens', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.HasTrustTokensResult = class {
  constructor() {
    /** @export { !network.mojom.TrustTokenOperationStatus } */
    this.status;
    /** @export { !boolean } */
    this.hasTrustTokens;
  }
};



mojo.internal.Struct(
    network.mojom.HasRedemptionRecordResultSpec.$,
    'HasRedemptionRecordResult',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        network.mojom.TrustTokenOperationStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasRedemptionRecord', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.HasRedemptionRecordResult = class {
  constructor() {
    /** @export { !network.mojom.TrustTokenOperationStatus } */
    this.status;
    /** @export { !boolean } */
    this.hasRedemptionRecord;
  }
};



mojo.internal.Struct(
    network.mojom.TrustTokenVerificationKeySpec.$,
    'TrustTokenVerificationKey',
    [
      mojo.internal.StructField(
        'body', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'expiry', 8,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.TrustTokenVerificationKey = class {
  constructor() {
    /** @export { !string } */
    this.body;
    /** @export { !mojoBase.mojom.Time } */
    this.expiry;
  }
};



/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.TrustTokenKeyCommitmentResultSpec.OsSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.TrustTokenKeyCommitmentResult_Os = {
  
  kAndroid: 0,
  MIN_VALUE: 0,
  MAX_VALUE: 0,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.TrustTokenKeyCommitmentResultSpec.UnavailableLocalOperationFallbackSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.TrustTokenKeyCommitmentResult_UnavailableLocalOperationFallback = {
  
  kWebIssuance: 0,
  kReturnWithError: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


mojo.internal.Struct(
    network.mojom.TrustTokenKeyCommitmentResultSpec.$,
    'TrustTokenKeyCommitmentResult',
    [
      mojo.internal.StructField(
        'protocolVersion', 0,
        0,
        network.mojom.TrustTokenProtocolVersionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'id', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'batchSize', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'keys', 16,
        0,
        mojo.internal.Array(network.mojom.TrustTokenVerificationKeySpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestIssuanceLocallyOn', 24,
        0,
        mojo.internal.Array(network.mojom.TrustTokenKeyCommitmentResultSpec.OsSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'unavailableLocalOperationFallback', 12,
        0,
        network.mojom.TrustTokenKeyCommitmentResultSpec.UnavailableLocalOperationFallbackSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
network.mojom.TrustTokenKeyCommitmentResult = class {
  constructor() {
    /** @export { !network.mojom.TrustTokenProtocolVersion } */
    this.protocolVersion;
    /** @export { !number } */
    this.id;
    /** @export { !number } */
    this.batchSize;
    /** @export { !Array<!network.mojom.TrustTokenVerificationKey> } */
    this.keys;
    /** @export { !Array<!network.mojom.TrustTokenKeyCommitmentResult_Os> } */
    this.requestIssuanceLocallyOn;
    /** @export { !network.mojom.TrustTokenKeyCommitmentResult_UnavailableLocalOperationFallback } */
    this.unavailableLocalOperationFallback;
  }
};



mojo.internal.Struct(
    network.mojom.FulfillTrustTokenIssuanceRequestSpec.$,
    'FulfillTrustTokenIssuanceRequest',
    [
      mojo.internal.StructField(
        'issuer', 0,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'request', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.FulfillTrustTokenIssuanceRequest = class {
  constructor() {
    /** @export { !url.mojom.Origin } */
    this.issuer;
    /** @export { !string } */
    this.request;
  }
};



/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.FulfillTrustTokenIssuanceAnswerSpec.StatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.FulfillTrustTokenIssuanceAnswer_Status = {
  
  kOk: 0,
  kNotFound: 1,
  kUnknownError: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


mojo.internal.Struct(
    network.mojom.FulfillTrustTokenIssuanceAnswerSpec.$,
    'FulfillTrustTokenIssuanceAnswer',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        network.mojom.FulfillTrustTokenIssuanceAnswerSpec.StatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'response', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.FulfillTrustTokenIssuanceAnswer = class {
  constructor() {
    /** @export { !network.mojom.FulfillTrustTokenIssuanceAnswer_Status } */
    this.status;
    /** @export { !string } */
    this.response;
  }
};



mojo.internal.Struct(
    network.mojom.TrustTokenOperationResultSpec.$,
    'TrustTokenOperationResult',
    [
      mojo.internal.StructField(
        'operation', 0,
        0,
        network.mojom.TrustTokenOperationTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'status', 4,
        0,
        network.mojom.TrustTokenOperationStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'issuer', 8,
        0,
        url.mojom.OriginSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'topLevelOrigin', 16,
        0,
        url.mojom.OriginSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'issuedTokenCount', 24,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
network.mojom.TrustTokenOperationResult = class {
  constructor() {
    /** @export { !network.mojom.TrustTokenOperationType } */
    this.operation;
    /** @export { !network.mojom.TrustTokenOperationStatus } */
    this.status;
    /** @export { (url.mojom.Origin|undefined) } */
    this.issuer;
    /** @export { (url.mojom.Origin|undefined) } */
    this.topLevelOrigin;
    /** @export { !number } */
    this.issuedTokenCount;
  }
};



mojo.internal.Struct(
    network.mojom.StoredTrustTokensForIssuerSpec.$,
    'StoredTrustTokensForIssuer',
    [
      mojo.internal.StructField(
        'issuer', 0,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'count', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.StoredTrustTokensForIssuer = class {
  constructor() {
    /** @export { !url.mojom.Origin } */
    this.issuer;
    /** @export { !number } */
    this.count;
  }
};



mojo.internal.Struct(
    network.mojom.ToplevelRedemptionRecordSpec.$,
    'ToplevelRedemptionRecord',
    [
      mojo.internal.StructField(
        'toplevelOrigin', 0,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'lastRedemption', 8,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.ToplevelRedemptionRecord = class {
  constructor() {
    /** @export { !url.mojom.Origin } */
    this.toplevelOrigin;
    /** @export { !mojoBase.mojom.Time } */
    this.lastRedemption;
  }
};



mojo.internal.Struct(
    network.mojom.TrustTokenQueryAnswerer_HasTrustTokens_ParamsSpec.$,
    'TrustTokenQueryAnswerer_HasTrustTokens_Params',
    [
      mojo.internal.StructField(
        'issuer', 0,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.TrustTokenQueryAnswerer_HasTrustTokens_Params = class {
  constructor() {
    /** @export { !url.mojom.Origin } */
    this.issuer;
  }
};



mojo.internal.Struct(
    network.mojom.TrustTokenQueryAnswerer_HasTrustTokens_ResponseParamsSpec.$,
    'TrustTokenQueryAnswerer_HasTrustTokens_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        network.mojom.HasTrustTokensResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.TrustTokenQueryAnswerer_HasTrustTokens_ResponseParams = class {
  constructor() {
    /** @export { !network.mojom.HasTrustTokensResult } */
    this.result;
  }
};



mojo.internal.Struct(
    network.mojom.TrustTokenQueryAnswerer_HasRedemptionRecord_ParamsSpec.$,
    'TrustTokenQueryAnswerer_HasRedemptionRecord_Params',
    [
      mojo.internal.StructField(
        'issuer', 0,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.TrustTokenQueryAnswerer_HasRedemptionRecord_Params = class {
  constructor() {
    /** @export { !url.mojom.Origin } */
    this.issuer;
  }
};



mojo.internal.Struct(
    network.mojom.TrustTokenQueryAnswerer_HasRedemptionRecord_ResponseParamsSpec.$,
    'TrustTokenQueryAnswerer_HasRedemptionRecord_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        network.mojom.HasRedemptionRecordResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.TrustTokenQueryAnswerer_HasRedemptionRecord_ResponseParams = class {
  constructor() {
    /** @export { !network.mojom.HasRedemptionRecordResult } */
    this.result;
  }
};

