// services/network/public/mojom/trust_tokens.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKENS_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKENS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/network/public/mojom/trust_tokens.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"


namespace network::mojom {
class TrustTokenParamsDataView;

class HasTrustTokensResultDataView;

class HasRedemptionRecordResultDataView;

class TrustTokenVerificationKeyDataView;

class TrustTokenKeyCommitmentResultDataView;

class FulfillTrustTokenIssuanceRequestDataView;

class FulfillTrustTokenIssuanceAnswerDataView;

class TrustTokenOperationResultDataView;

class StoredTrustTokensForIssuerDataView;

class ToplevelRedemptionRecordDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::TrustTokenParamsDataView> {
  using Data = ::network::mojom::internal::TrustTokenParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::HasTrustTokensResultDataView> {
  using Data = ::network::mojom::internal::HasTrustTokensResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::HasRedemptionRecordResultDataView> {
  using Data = ::network::mojom::internal::HasRedemptionRecordResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::TrustTokenVerificationKeyDataView> {
  using Data = ::network::mojom::internal::TrustTokenVerificationKey_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::TrustTokenKeyCommitmentResultDataView> {
  using Data = ::network::mojom::internal::TrustTokenKeyCommitmentResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::FulfillTrustTokenIssuanceRequestDataView> {
  using Data = ::network::mojom::internal::FulfillTrustTokenIssuanceRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::FulfillTrustTokenIssuanceAnswerDataView> {
  using Data = ::network::mojom::internal::FulfillTrustTokenIssuanceAnswer_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::TrustTokenOperationResultDataView> {
  using Data = ::network::mojom::internal::TrustTokenOperationResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::StoredTrustTokensForIssuerDataView> {
  using Data = ::network::mojom::internal::StoredTrustTokensForIssuer_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::ToplevelRedemptionRecordDataView> {
  using Data = ::network::mojom::internal::ToplevelRedemptionRecord_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class TrustTokenProtocolVersion : int32_t {
  
  kTrustTokenV3Pmb = 0,
  
  kTrustTokenV3Voprf = 1,
  
  kPrivateStateTokenV1Pmb = 2,
  
  kPrivateStateTokenV1Voprf = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, TrustTokenProtocolVersion value);
inline bool IsKnownEnumValue(TrustTokenProtocolVersion value) {
  return internal::TrustTokenProtocolVersion_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TrustTokenOperationStatus : int32_t {
  
  kOk = 0,
  
  kInvalidArgument = 1,
  
  kMissingIssuerKeys = 2,
  
  kFailedPrecondition = 3,
  
  kResourceExhausted = 4,
  
  kAlreadyExists = 5,
  
  kResourceLimited = 6,
  
  kUnauthorized = 7,
  
  kBadResponse = 8,
  
  kInternalError = 9,
  
  kUnknownError = 10,
  
  kOperationSuccessfullyFulfilledLocally = 11,
  
  kSiteIssuerLimit = 12,
  kMinValue = 0,
  kMaxValue = 12,
};

 std::ostream& operator<<(std::ostream& os, TrustTokenOperationStatus value);
inline bool IsKnownEnumValue(TrustTokenOperationStatus value) {
  return internal::TrustTokenOperationStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TrustTokenOperationType : int32_t {
  
  kIssuance = 0,
  
  kRedemption = 1,
  
  kSigning = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, TrustTokenOperationType value);
inline bool IsKnownEnumValue(TrustTokenOperationType value) {
  return internal::TrustTokenOperationType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TrustTokenRefreshPolicy : int32_t {
  
  kUseCached = 0,
  
  kRefresh = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, TrustTokenRefreshPolicy value);
inline bool IsKnownEnumValue(TrustTokenRefreshPolicy value) {
  return internal::TrustTokenRefreshPolicy_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TrustTokenSignRequestData : int32_t {
  
  kOmit = 0,
  
  kHeadersOnly = 1,
  
  kInclude = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, TrustTokenSignRequestData value);
inline bool IsKnownEnumValue(TrustTokenSignRequestData value) {
  return internal::TrustTokenSignRequestData_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class DeleteStoredTrustTokensStatus : int32_t {
  
  kSuccessTokensDeleted = 0,
  
  kSuccessNoTokensDeleted = 1,
  
  kFailureFeatureDisabled = 2,
  
  kFailureInvalidOrigin = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, DeleteStoredTrustTokensStatus value);
inline bool IsKnownEnumValue(DeleteStoredTrustTokensStatus value) {
  return internal::DeleteStoredTrustTokensStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TrustTokenKeyCommitmentResult_Os : int32_t {
  
  kAndroid = 0,
  kMinValue = 0,
  kMaxValue = 0,
};

 std::ostream& operator<<(std::ostream& os, TrustTokenKeyCommitmentResult_Os value);
inline bool IsKnownEnumValue(TrustTokenKeyCommitmentResult_Os value) {
  return internal::TrustTokenKeyCommitmentResult_Os_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TrustTokenKeyCommitmentResult_UnavailableLocalOperationFallback : int32_t {
  
  kWebIssuance = 0,
  
  kReturnWithError = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, TrustTokenKeyCommitmentResult_UnavailableLocalOperationFallback value);
inline bool IsKnownEnumValue(TrustTokenKeyCommitmentResult_UnavailableLocalOperationFallback value) {
  return internal::TrustTokenKeyCommitmentResult_UnavailableLocalOperationFallback_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FulfillTrustTokenIssuanceAnswer_Status : int32_t {
  
  kOk = 0,
  
  kNotFound = 1,
  
  kUnknownError = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, FulfillTrustTokenIssuanceAnswer_Status value);
inline bool IsKnownEnumValue(FulfillTrustTokenIssuanceAnswer_Status value) {
  return internal::FulfillTrustTokenIssuanceAnswer_Status_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class TrustTokenQueryAnswererInterfaceBase {};

using TrustTokenQueryAnswererPtrDataView =
    mojo::InterfacePtrDataView<TrustTokenQueryAnswererInterfaceBase>;
using TrustTokenQueryAnswererRequestDataView =
    mojo::InterfaceRequestDataView<TrustTokenQueryAnswererInterfaceBase>;
using TrustTokenQueryAnswererAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<TrustTokenQueryAnswererInterfaceBase>;
using TrustTokenQueryAnswererAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<TrustTokenQueryAnswererInterfaceBase>;


class TrustTokenParamsDataView {
 public:
  TrustTokenParamsDataView() = default;

  TrustTokenParamsDataView(
      internal::TrustTokenParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadOperation(UserType* output) const {
    auto data_value = data_->operation;
    return mojo::internal::Deserialize<::network::mojom::TrustTokenOperationType>(
        data_value, output);
  }
  TrustTokenOperationType operation() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::TrustTokenOperationType>(data_->operation));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRefreshPolicy(UserType* output) const {
    auto data_value = data_->refresh_policy;
    return mojo::internal::Deserialize<::network::mojom::TrustTokenRefreshPolicy>(
        data_value, output);
  }
  TrustTokenRefreshPolicy refresh_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::TrustTokenRefreshPolicy>(data_->refresh_policy));
  }
  inline void GetCustomKeyCommitmentDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCustomKeyCommitment(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `custom_key_commitment` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCustomKeyCommitment` instead "
    "of `ReadCustomKeyCommitment if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->custom_key_commitment.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCustomIssuerDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCustomIssuer(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `custom_issuer` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCustomIssuer` instead "
    "of `ReadCustomIssuer if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->custom_issuer.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSignRequestData(UserType* output) const {
    auto data_value = data_->sign_request_data;
    return mojo::internal::Deserialize<::network::mojom::TrustTokenSignRequestData>(
        data_value, output);
  }
  TrustTokenSignRequestData sign_request_data() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::TrustTokenSignRequestData>(data_->sign_request_data));
  }
  bool include_timestamp_header() const {
    return data_->include_timestamp_header;
  }
  inline void GetIssuersDataView(
      mojo::ArrayDataView<::url::mojom::OriginDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIssuers(UserType* output) {
    
    auto* pointer = data_->issuers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::OriginDataView>>(
        pointer, output, message_);
  }
  inline void GetAdditionalSignedHeadersDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdditionalSignedHeaders(UserType* output) {
    
    auto* pointer = data_->additional_signed_headers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetPossiblyUnsafeAdditionalSigningDataDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPossiblyUnsafeAdditionalSigningData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `possibly_unsafe_additional_signing_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPossiblyUnsafeAdditionalSigningData` instead "
    "of `ReadPossiblyUnsafeAdditionalSigningData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->possibly_unsafe_additional_signing_data.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::TrustTokenParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class HasTrustTokensResultDataView {
 public:
  HasTrustTokensResultDataView() = default;

  HasTrustTokensResultDataView(
      internal::HasTrustTokensResult_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::network::mojom::TrustTokenOperationStatus>(
        data_value, output);
  }
  TrustTokenOperationStatus status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::TrustTokenOperationStatus>(data_->status));
  }
  bool has_trust_tokens() const {
    return data_->has_trust_tokens;
  }
 private:
  internal::HasTrustTokensResult_Data* data_ = nullptr;
};


class HasRedemptionRecordResultDataView {
 public:
  HasRedemptionRecordResultDataView() = default;

  HasRedemptionRecordResultDataView(
      internal::HasRedemptionRecordResult_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::network::mojom::TrustTokenOperationStatus>(
        data_value, output);
  }
  TrustTokenOperationStatus status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::TrustTokenOperationStatus>(data_->status));
  }
  bool has_redemption_record() const {
    return data_->has_redemption_record;
  }
 private:
  internal::HasRedemptionRecordResult_Data* data_ = nullptr;
};


class TrustTokenVerificationKeyDataView {
 public:
  TrustTokenVerificationKeyDataView() = default;

  TrustTokenVerificationKeyDataView(
      internal::TrustTokenVerificationKey_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBodyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBody(UserType* output) {
    
    auto* pointer = data_->body.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetExpiryDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExpiry(UserType* output) {
    
    auto* pointer = data_->expiry.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::TrustTokenVerificationKey_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TrustTokenKeyCommitmentResultDataView {
 public:
  TrustTokenKeyCommitmentResultDataView() = default;

  TrustTokenKeyCommitmentResultDataView(
      internal::TrustTokenKeyCommitmentResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadProtocolVersion(UserType* output) const {
    auto data_value = data_->protocol_version;
    return mojo::internal::Deserialize<::network::mojom::TrustTokenProtocolVersion>(
        data_value, output);
  }
  TrustTokenProtocolVersion protocol_version() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::TrustTokenProtocolVersion>(data_->protocol_version));
  }
  int32_t id() const {
    return data_->id;
  }
  int32_t batch_size() const {
    return data_->batch_size;
  }
  inline void GetKeysDataView(
      mojo::ArrayDataView<TrustTokenVerificationKeyDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeys(UserType* output) {
    
    auto* pointer = data_->keys.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::TrustTokenVerificationKeyDataView>>(
        pointer, output, message_);
  }
  inline void GetRequestIssuanceLocallyOnDataView(
      mojo::ArrayDataView<TrustTokenKeyCommitmentResult_Os>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestIssuanceLocallyOn(UserType* output) {
    
    auto* pointer = data_->request_issuance_locally_on.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::TrustTokenKeyCommitmentResult_Os>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadUnavailableLocalOperationFallback(UserType* output) const {
    auto data_value = data_->unavailable_local_operation_fallback;
    return mojo::internal::Deserialize<::network::mojom::TrustTokenKeyCommitmentResult_UnavailableLocalOperationFallback>(
        data_value, output);
  }
  TrustTokenKeyCommitmentResult_UnavailableLocalOperationFallback unavailable_local_operation_fallback() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::TrustTokenKeyCommitmentResult_UnavailableLocalOperationFallback>(data_->unavailable_local_operation_fallback));
  }
 private:
  internal::TrustTokenKeyCommitmentResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FulfillTrustTokenIssuanceRequestDataView {
 public:
  FulfillTrustTokenIssuanceRequestDataView() = default;

  FulfillTrustTokenIssuanceRequestDataView(
      internal::FulfillTrustTokenIssuanceRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIssuerDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIssuer(UserType* output) {
    
    auto* pointer = data_->issuer.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetRequestDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequest(UserType* output) {
    
    auto* pointer = data_->request.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::FulfillTrustTokenIssuanceRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FulfillTrustTokenIssuanceAnswerDataView {
 public:
  FulfillTrustTokenIssuanceAnswerDataView() = default;

  FulfillTrustTokenIssuanceAnswerDataView(
      internal::FulfillTrustTokenIssuanceAnswer_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::network::mojom::FulfillTrustTokenIssuanceAnswer_Status>(
        data_value, output);
  }
  FulfillTrustTokenIssuanceAnswer_Status status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::FulfillTrustTokenIssuanceAnswer_Status>(data_->status));
  }
  inline void GetResponseDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResponse(UserType* output) {
    
    auto* pointer = data_->response.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::FulfillTrustTokenIssuanceAnswer_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TrustTokenOperationResultDataView {
 public:
  TrustTokenOperationResultDataView() = default;

  TrustTokenOperationResultDataView(
      internal::TrustTokenOperationResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadOperation(UserType* output) const {
    auto data_value = data_->operation;
    return mojo::internal::Deserialize<::network::mojom::TrustTokenOperationType>(
        data_value, output);
  }
  TrustTokenOperationType operation() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::TrustTokenOperationType>(data_->operation));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::network::mojom::TrustTokenOperationStatus>(
        data_value, output);
  }
  TrustTokenOperationStatus status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::TrustTokenOperationStatus>(data_->status));
  }
  inline void GetIssuerDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIssuer(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `issuer` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadIssuer` instead "
    "of `ReadIssuer if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->issuer.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetTopLevelOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTopLevelOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `top_level_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTopLevelOrigin` instead "
    "of `ReadTopLevelOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->top_level_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  int32_t issued_token_count() const {
    return data_->issued_token_count;
  }
 private:
  internal::TrustTokenOperationResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StoredTrustTokensForIssuerDataView {
 public:
  StoredTrustTokensForIssuerDataView() = default;

  StoredTrustTokensForIssuerDataView(
      internal::StoredTrustTokensForIssuer_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIssuerDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIssuer(UserType* output) {
    
    auto* pointer = data_->issuer.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  int32_t count() const {
    return data_->count;
  }
 private:
  internal::StoredTrustTokensForIssuer_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ToplevelRedemptionRecordDataView {
 public:
  ToplevelRedemptionRecordDataView() = default;

  ToplevelRedemptionRecordDataView(
      internal::ToplevelRedemptionRecord_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetToplevelOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadToplevelOrigin(UserType* output) {
    
    auto* pointer = data_->toplevel_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetLastRedemptionDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastRedemption(UserType* output) {
    
    auto* pointer = data_->last_redemption.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::ToplevelRedemptionRecord_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKENS_MOJOM_DATA_VIEW_H_