// services/network/public/mojom/trust_token_access_observer.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKEN_ACCESS_OBSERVER_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKEN_ACCESS_OBSERVER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/trust_token_access_observer.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/network/public/mojom/trust_token_access_observer.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::TrustTokenIssuanceDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::TrustTokenIssuanceDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::TrustTokenIssuanceDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::origin(input)) in_origin = Traits::origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origin)::BaseType> origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin,
      origin_fragment);

    fragment->origin.Set(
        origin_fragment.is_null() ? nullptr : origin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->origin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in TrustTokenIssuanceDetails struct");

    decltype(Traits::issuer(input)) in_issuer = Traits::issuer(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->issuer)::BaseType> issuer_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_issuer,
      issuer_fragment);

    fragment->issuer.Set(
        issuer_fragment.is_null() ? nullptr : issuer_fragment.data());

    fragment->blocked = Traits::blocked(input);
  }

  static bool Deserialize(::network::mojom::internal::TrustTokenIssuanceDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::TrustTokenIssuanceDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::TrustTokenRedemptionDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::TrustTokenRedemptionDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::TrustTokenRedemptionDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::origin(input)) in_origin = Traits::origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origin)::BaseType> origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin,
      origin_fragment);

    fragment->origin.Set(
        origin_fragment.is_null() ? nullptr : origin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->origin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in TrustTokenRedemptionDetails struct");

    decltype(Traits::issuer(input)) in_issuer = Traits::issuer(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->issuer)::BaseType> issuer_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_issuer,
      issuer_fragment);

    fragment->issuer.Set(
        issuer_fragment.is_null() ? nullptr : issuer_fragment.data());

    fragment->blocked = Traits::blocked(input);
  }

  static bool Deserialize(::network::mojom::internal::TrustTokenRedemptionDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::TrustTokenRedemptionDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::TrustTokenSigningDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::TrustTokenSigningDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::TrustTokenSigningDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::origin(input)) in_origin = Traits::origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origin)::BaseType> origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin,
      origin_fragment);

    fragment->origin.Set(
        origin_fragment.is_null() ? nullptr : origin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->origin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in TrustTokenSigningDetails struct");

    fragment->blocked = Traits::blocked(input);
  }

  static bool Deserialize(::network::mojom::internal::TrustTokenSigningDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::TrustTokenSigningDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::TrustTokenAccessDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::network::mojom::TrustTokenAccessDetailsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::network::mojom::internal::TrustTokenAccessDetails_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::network::mojom::TrustTokenAccessDetailsDataView::Tag::kIssuance: {
    decltype(Traits::issuance(input))
    in_issuance = Traits::issuance(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_issuance)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::network::mojom::TrustTokenIssuanceDetailsDataView>(
  in_issuance,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null issuance in TrustTokenAccessDetails union");
    fragment->data.f_issuance.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::network::mojom::TrustTokenAccessDetailsDataView::Tag::kRedemption: {
    decltype(Traits::redemption(input))
    in_redemption = Traits::redemption(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_redemption)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::network::mojom::TrustTokenRedemptionDetailsDataView>(
  in_redemption,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null redemption in TrustTokenAccessDetails union");
    fragment->data.f_redemption.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::network::mojom::TrustTokenAccessDetailsDataView::Tag::kSigning: {
    decltype(Traits::signing(input))
    in_signing = Traits::signing(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_signing)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::network::mojom::TrustTokenSigningDetailsDataView>(
  in_signing,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null signing in TrustTokenAccessDetails union");
    fragment->data.f_signing.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::network::mojom::internal::TrustTokenAccessDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::TrustTokenAccessDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void TrustTokenIssuanceDetailsDataView::GetOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void TrustTokenIssuanceDetailsDataView::GetIssuerDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->issuer.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}


inline void TrustTokenRedemptionDetailsDataView::GetOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void TrustTokenRedemptionDetailsDataView::GetIssuerDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->issuer.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}


inline void TrustTokenSigningDetailsDataView::GetOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}


inline void TrustTokenAccessDetailsDataView::GetIssuanceDataView(
    TrustTokenIssuanceDetailsDataView* output) const {
  CHECK(is_issuance());
  *output = TrustTokenIssuanceDetailsDataView(data_->data.f_issuance.Get(), message_);
}
inline void TrustTokenAccessDetailsDataView::GetRedemptionDataView(
    TrustTokenRedemptionDetailsDataView* output) const {
  CHECK(is_redemption());
  *output = TrustTokenRedemptionDetailsDataView(data_->data.f_redemption.Get(), message_);
}
inline void TrustTokenAccessDetailsDataView::GetSigningDataView(
    TrustTokenSigningDetailsDataView* output) const {
  CHECK(is_signing());
  *output = TrustTokenSigningDetailsDataView(data_->data.f_signing.Get(), message_);
}


}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKEN_ACCESS_OBSERVER_MOJOM_SHARED_H_