// services/network/public/mojom/trust_token_access_observer.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('network.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.TrustTokenAccessObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.TrustTokenAccessObserver.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.TrustTokenAccessObserverInterface }
 */
network.mojom.TrustTokenAccessObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.TrustTokenAccessObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.TrustTokenAccessObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.TrustTokenAccessObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.TrustTokenAccessDetails } details
   */

  onTrustTokensAccessed(
      details) {
    this.proxy.sendMessage(
        0,
        network.mojom.TrustTokenAccessObserver_OnTrustTokensAccessed_ParamsSpec.$,
        null,
        [
          details
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.TrustTokenAccessObserverPendingReceiver } listener
   */

  clone(
      listener) {
    this.proxy.sendMessage(
        1,
        network.mojom.TrustTokenAccessObserver_Clone_ParamsSpec.$,
        null,
        [
          listener
        ],
        false);
  }
};

/**
 * An object which receives request messages for the TrustTokenAccessObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.TrustTokenAccessObserverReceiver = class {
  /**
   * @param {!network.mojom.TrustTokenAccessObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.TrustTokenAccessObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.TrustTokenAccessObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.TrustTokenAccessObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.TrustTokenAccessObserver_OnTrustTokensAccessed_ParamsSpec.$,
        null,
        impl.onTrustTokensAccessed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.TrustTokenAccessObserver_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.TrustTokenAccessObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.TrustTokenAccessObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.TrustTokenAccessObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.TrustTokenAccessObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the TrustTokenAccessObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.TrustTokenAccessObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.TrustTokenAccessObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.TrustTokenAccessObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onTrustTokensAccessed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.TrustTokenAccessObserver_OnTrustTokensAccessed_ParamsSpec.$,
        null,
        this.onTrustTokensAccessed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.TrustTokenAccessObserver_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TrustTokenIssuanceDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TrustTokenRedemptionDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TrustTokenSigningDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TrustTokenAccessObserver_OnTrustTokensAccessed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TrustTokenAccessObserver_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
network.mojom.TrustTokenAccessDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.TrustTokenIssuanceDetailsSpec.$,
    'TrustTokenIssuanceDetails',
    [
      mojo.internal.StructField(
        'origin', 0,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'issuer', 8,
        0,
        url.mojom.OriginSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'blocked', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
network.mojom.TrustTokenIssuanceDetails = class {
  constructor() {
    /** @export { !url.mojom.Origin } */
    this.origin;
    /** @export { (url.mojom.Origin|undefined) } */
    this.issuer;
    /** @export { !boolean } */
    this.blocked;
  }
};



mojo.internal.Struct(
    network.mojom.TrustTokenRedemptionDetailsSpec.$,
    'TrustTokenRedemptionDetails',
    [
      mojo.internal.StructField(
        'origin', 0,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'issuer', 8,
        0,
        url.mojom.OriginSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'blocked', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
network.mojom.TrustTokenRedemptionDetails = class {
  constructor() {
    /** @export { !url.mojom.Origin } */
    this.origin;
    /** @export { (url.mojom.Origin|undefined) } */
    this.issuer;
    /** @export { !boolean } */
    this.blocked;
  }
};



mojo.internal.Struct(
    network.mojom.TrustTokenSigningDetailsSpec.$,
    'TrustTokenSigningDetails',
    [
      mojo.internal.StructField(
        'origin', 0,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'blocked', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.TrustTokenSigningDetails = class {
  constructor() {
    /** @export { !url.mojom.Origin } */
    this.origin;
    /** @export { !boolean } */
    this.blocked;
  }
};



mojo.internal.Struct(
    network.mojom.TrustTokenAccessObserver_OnTrustTokensAccessed_ParamsSpec.$,
    'TrustTokenAccessObserver_OnTrustTokensAccessed_Params',
    [
      mojo.internal.StructField(
        'details', 0,
        0,
        network.mojom.TrustTokenAccessDetailsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.TrustTokenAccessObserver_OnTrustTokensAccessed_Params = class {
  constructor() {
    /** @export { !network.mojom.TrustTokenAccessDetails } */
    this.details;
  }
};



mojo.internal.Struct(
    network.mojom.TrustTokenAccessObserver_Clone_ParamsSpec.$,
    'TrustTokenAccessObserver_Clone_Params',
    [
      mojo.internal.StructField(
        'listener', 0,
        0,
        mojo.internal.InterfaceRequest(network.mojom.TrustTokenAccessObserverPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.TrustTokenAccessObserver_Clone_Params = class {
  constructor() {
    /** @export { !network.mojom.TrustTokenAccessObserverPendingReceiver } */
    this.listener;
  }
};



mojo.internal.Union(
    network.mojom.TrustTokenAccessDetailsSpec.$, 'TrustTokenAccessDetails',
    {
      'issuance': {
        'ordinal': 0,
        'type': network.mojom.TrustTokenIssuanceDetailsSpec.$,
      },
      'redemption': {
        'ordinal': 1,
        'type': network.mojom.TrustTokenRedemptionDetailsSpec.$,
      },
      'signing': {
        'ordinal': 2,
        'type': network.mojom.TrustTokenSigningDetailsSpec.$,
      },
    });

/**
 * @typedef { {
 *   issuance: (!network.mojom.TrustTokenIssuanceDetails|undefined),
 *   redemption: (!network.mojom.TrustTokenRedemptionDetails|undefined),
 *   signing: (!network.mojom.TrustTokenSigningDetails|undefined),
 * } }
 */
network.mojom.TrustTokenAccessDetails;
