// services/network/public/mojom/transferable_directory.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/transferable_directory.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var file_path$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file_path.mojom', '../../../../mojo/public/mojom/base/file_path.mojom.js');
  }




  function TransferableDirectory(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  TransferableDirectory.Tags = {
    handleForIpc: 0,
    path: 1,
  };

  TransferableDirectory.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  TransferableDirectory.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "handleForIpc",
        "path",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a TransferableDirectory member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(TransferableDirectory.prototype, "handleForIpc", {
    get: function() {
      if (this.$tag != TransferableDirectory.Tags.handleForIpc) {
        throw new ReferenceError(
            "TransferableDirectory.handleForIpc is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = TransferableDirectory.Tags.handleForIpc;
      this.$data = value;
    }
  });
  Object.defineProperty(TransferableDirectory.prototype, "path", {
    get: function() {
      if (this.$tag != TransferableDirectory.Tags.path) {
        throw new ReferenceError(
            "TransferableDirectory.path is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = TransferableDirectory.Tags.path;
      this.$data = value;
    }
  });


    TransferableDirectory.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case TransferableDirectory.Tags.handleForIpc:
          encoder.encodeStruct(codec.Handle, val.handleForIpc);
          break;
        case TransferableDirectory.Tags.path:
          encoder.encodeStructPointer(file_path$.FilePath, val.path);
          break;
      }
      encoder.align();
    };


    TransferableDirectory.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new TransferableDirectory();
      var tag = decoder.readUint32();
      switch (tag) {
        case TransferableDirectory.Tags.handleForIpc:
          result.handleForIpc = decoder.decodeStruct(codec.Handle);
          break;
        case TransferableDirectory.Tags.path:
          result.path = decoder.decodeStructPointer(file_path$.FilePath);
          break;
      }
      decoder.align();

      return result;
    };


    TransferableDirectory.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case TransferableDirectory.Tags.handleForIpc:
          

    // validate TransferableDirectory.handleForIpc
    err = messageValidator.validateHandle(data_offset, false)
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case TransferableDirectory.Tags.path:
          

    // validate TransferableDirectory.path
    err = messageValidator.validateStructPointer(data_offset, file_path$.FilePath, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  TransferableDirectory.encodedSize = 16;
  exports.TransferableDirectory = TransferableDirectory;
})();