// services/network/public/mojom/transferable_directory.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_TRANSFERABLE_DIRECTORY_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_TRANSFERABLE_DIRECTORY_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/network/public/mojom/transferable_directory.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"


namespace network::mojom {
class TransferableDirectoryDataView;


}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::TransferableDirectoryDataView> {
  using Data = ::network::mojom::internal::TransferableDirectory_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


class TransferableDirectoryDataView {
 public:
  using Tag = internal::TransferableDirectory_Data::TransferableDirectory_Tag;

  TransferableDirectoryDataView() = default;

  TransferableDirectoryDataView(
      internal::TransferableDirectory_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_handle_for_ipc() const { return data_->tag == Tag::kHandleForIpc; }
  mojo::PlatformHandle TakeHandleForIpc() {
    CHECK(is_handle_for_ipc());
    mojo::PlatformHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::PlatformHandle>(
            &data_->data.f_handle_for_ipc, &result, message_);
    CHECK(ret);
    return result;
  }
  bool is_path() const { return data_->tag == Tag::kPath; }
  inline void GetPathDataView(
      ::mojo_base::mojom::FilePathDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) const {
    
    CHECK(is_path());
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        data_->data.f_path.Get(), output, message_);
  }

 private:
  internal::TransferableDirectory_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_TRANSFERABLE_DIRECTORY_MOJOM_DATA_VIEW_H_