// services/network/public/mojom/tls_socket.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  SSLVersion as network_mojom_SSLVersion,
  SSLVersionSpec as network_mojom_SSLVersionSpec
} from './ssl_config.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class TLSClientSocketPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.TLSClientSocket', scope);
  }
}

/** @interface */
export class TLSClientSocketInterface {
}

/**
 * @implements { TLSClientSocketInterface }
 */
export class TLSClientSocketRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!TLSClientSocketPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          TLSClientSocketPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!TLSClientSocketPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }
}

/**
 * An object which receives request messages for the TLSClientSocket
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TLSClientSocketReceiver {
  /**
   * @param {!TLSClientSocketInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!TLSClientSocketRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        TLSClientSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TLSClientSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class TLSClientSocket {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.TLSClientSocket";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!TLSClientSocketRemote}
   */
  static getRemote() {
    let remote = new TLSClientSocketRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the TLSClientSocket
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TLSClientSocketCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      TLSClientSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TLSClientSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TLSClientSocketOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    TLSClientSocketOptionsSpec.$,
    'TLSClientSocketOptions',
    [
      mojo.internal.StructField(
        'versionMin', 0,
        0,
        network_mojom_SSLVersionSpec.$,
        network_mojom_SSLVersion.kTLS12,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'versionMax', 4,
        0,
        network_mojom_SSLVersionSpec.$,
        network_mojom_SSLVersion.kTLS13,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sendSslInfo', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'unsafelySkipCertVerification', 8,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class TLSClientSocketOptions {
  constructor() {
    /** @type { !network_mojom_SSLVersion } */
    this.versionMin;
    /** @type { !network_mojom_SSLVersion } */
    this.versionMax;
    /** @type { !boolean } */
    this.sendSslInfo;
    /** @type { !boolean } */
    this.unsafelySkipCertVerification;
  }
}

