// services/network/public/mojom/tls_socket.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_TLS_SOCKET_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_TLS_SOCKET_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/network/public/mojom/tls_socket.mojom-shared-internal.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/ssl_config.mojom-shared.h"


namespace network::mojom {
class TLSClientSocketOptionsDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::TLSClientSocketOptionsDataView> {
  using Data = ::network::mojom::internal::TLSClientSocketOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {
// Interface base classes. They are used for type safety check.
class TLSClientSocketInterfaceBase {};

using TLSClientSocketPtrDataView =
    mojo::InterfacePtrDataView<TLSClientSocketInterfaceBase>;
using TLSClientSocketRequestDataView =
    mojo::InterfaceRequestDataView<TLSClientSocketInterfaceBase>;
using TLSClientSocketAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<TLSClientSocketInterfaceBase>;
using TLSClientSocketAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<TLSClientSocketInterfaceBase>;


class TLSClientSocketOptionsDataView {
 public:
  TLSClientSocketOptionsDataView() = default;

  TLSClientSocketOptionsDataView(
      internal::TLSClientSocketOptions_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadVersionMin(UserType* output) const {
    auto data_value = data_->version_min;
    return mojo::internal::Deserialize<::network::mojom::SSLVersion>(
        data_value, output);
  }
  ::network::mojom::SSLVersion version_min() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::SSLVersion>(data_->version_min));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadVersionMax(UserType* output) const {
    auto data_value = data_->version_max;
    return mojo::internal::Deserialize<::network::mojom::SSLVersion>(
        data_value, output);
  }
  ::network::mojom::SSLVersion version_max() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::SSLVersion>(data_->version_max));
  }
  bool send_ssl_info() const {
    return data_->send_ssl_info;
  }
  bool unsafely_skip_cert_verification() const {
    return data_->unsafely_skip_cert_verification;
  }
 private:
  internal::TLSClientSocketOptions_Data* data_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_TLS_SOCKET_MOJOM_DATA_VIEW_H_