// services/network/public/mojom/tcp_socket.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_TCP_SOCKET_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_TCP_SOCKET_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/tcp_socket.mojom-shared-internal.h"
#include "services/network/public/mojom/address_list.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/ssl_config.mojom-shared.h"
#include "services/network/public/mojom/tls_socket.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom-shared.h"
#include "services/network/public/mojom/socket_connection_tracker.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/network/public/mojom/tcp_socket.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::TCPKeepAliveOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::TCPKeepAliveOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::TCPKeepAliveOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->enable = Traits::enable(input);

    fragment->delay = Traits::delay(input);
  }

  static bool Deserialize(::network::mojom::internal::TCPKeepAliveOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::TCPKeepAliveOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::TCPConnectedSocketOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::TCPConnectedSocketOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::TCPConnectedSocketOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->send_buffer_size = Traits::send_buffer_size(input);

    fragment->receive_buffer_size = Traits::receive_buffer_size(input);

    fragment->no_delay = Traits::no_delay(input);

    decltype(Traits::keep_alive_options(input)) in_keep_alive_options = Traits::keep_alive_options(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->keep_alive_options)::BaseType> keep_alive_options_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::TCPKeepAliveOptionsDataView>(
      in_keep_alive_options,
      keep_alive_options_fragment);

    fragment->keep_alive_options.Set(
        keep_alive_options_fragment.is_null() ? nullptr : keep_alive_options_fragment.data());
  }

  static bool Deserialize(::network::mojom::internal::TCPConnectedSocketOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::TCPConnectedSocketOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::TCPServerSocketOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::TCPServerSocketOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::TCPServerSocketOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->backlog = Traits::backlog(input);
    fragment->ipv6_only_$flag = Traits::ipv6_only(input).has_value();
    if (Traits::ipv6_only(input).has_value()) {
      fragment->ipv6_only_$value = Traits::ipv6_only(input).value();
    }
  }

  static bool Deserialize(::network::mojom::internal::TCPServerSocketOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::TCPServerSocketOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {



inline void TCPConnectedSocketOptionsDataView::GetKeepAliveOptionsDataView(
    TCPKeepAliveOptionsDataView* output) {
  auto pointer = data_->keep_alive_options.Get();
  *output = TCPKeepAliveOptionsDataView(pointer, message_);
}





}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_TCP_SOCKET_MOJOM_SHARED_H_