// services/network/public/mojom/system_dns_resolution.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SYSTEM_DNS_RESOLUTION_MOJOM_PARAMS_DATA_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SYSTEM_DNS_RESOLUTION_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace network::mojom {
namespace internal {
class  SystemDnsResolver_Resolve_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> hostname;
  int32_t addr_family;
  int32_t flags;
  uint64_t network;

 private:
  friend class mojo::internal::MessageFragment<SystemDnsResolver_Resolve_Params_Data>;

  SystemDnsResolver_Resolve_Params_Data();
  ~SystemDnsResolver_Resolve_Params_Data() = delete;
};
static_assert(sizeof(SystemDnsResolver_Resolve_Params_Data) == 32,
              "Bad sizeof(SystemDnsResolver_Resolve_Params_Data)");
class  SystemDnsResolver_Resolve_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::network::mojom::internal::AddressList_Data> addr_list;
  int32_t os_error;
  int32_t net_error;

 private:
  friend class mojo::internal::MessageFragment<SystemDnsResolver_Resolve_ResponseParams_Data>;

  SystemDnsResolver_Resolve_ResponseParams_Data();
  ~SystemDnsResolver_Resolve_ResponseParams_Data() = delete;
};
static_assert(sizeof(SystemDnsResolver_Resolve_ResponseParams_Data) == 24,
              "Bad sizeof(SystemDnsResolver_Resolve_ResponseParams_Data)");

}  // namespace internal


class SystemDnsResolver_Resolve_ParamsDataView {
 public:
  SystemDnsResolver_Resolve_ParamsDataView() = default;

  SystemDnsResolver_Resolve_ParamsDataView(
      internal::SystemDnsResolver_Resolve_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHostnameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHostname(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `hostname` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHostname` instead "
    "of `ReadHostname if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->hostname.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAddrFamily(UserType* output) const {
    auto data_value = data_->addr_family;
    return mojo::internal::Deserialize<::network::mojom::AddressFamily>(
        data_value, output);
  }
  ::network::mojom::AddressFamily addr_family() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::AddressFamily>(data_->addr_family));
  }
  int32_t flags() const {
    return data_->flags;
  }
  uint64_t network() const {
    return data_->network;
  }
 private:
  internal::SystemDnsResolver_Resolve_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SystemDnsResolver_Resolve_ResponseParamsDataView {
 public:
  SystemDnsResolver_Resolve_ResponseParamsDataView() = default;

  SystemDnsResolver_Resolve_ResponseParamsDataView(
      internal::SystemDnsResolver_Resolve_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAddrListDataView(
      ::network::mojom::AddressListDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAddrList(UserType* output) {
    
    auto* pointer = data_->addr_list.Get();
    return mojo::internal::Deserialize<::network::mojom::AddressListDataView>(
        pointer, output, message_);
  }
  int32_t os_error() const {
    return data_->os_error;
  }
  int32_t net_error() const {
    return data_->net_error;
  }
 private:
  internal::SystemDnsResolver_Resolve_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void SystemDnsResolver_Resolve_ParamsDataView::GetHostnameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->hostname.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void SystemDnsResolver_Resolve_ResponseParamsDataView::GetAddrListDataView(
    ::network::mojom::AddressListDataView* output) {
  auto pointer = data_->addr_list.Get();
  *output = ::network::mojom::AddressListDataView(pointer, message_);
}



}  // network::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SYSTEM_DNS_RESOLUTION_MOJOM_PARAMS_DATA_H_