// services/network/public/mojom/structured_headers.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_STRUCTURED_HEADERS_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_STRUCTURED_HEADERS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/structured_headers.mojom-shared-internal.h"
#include "mojo/public/mojom/base/byte_string.mojom-shared.h"




#include "services/network/public/mojom/structured_headers.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::StructuredHeadersParameterDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::StructuredHeadersParameterDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::StructuredHeadersParameter_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::key(input)) in_key = Traits::key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->key)::BaseType> key_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_key,
      key_fragment);

    fragment->key.Set(
        key_fragment.is_null() ? nullptr : key_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->key.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key in StructuredHeadersParameter struct");

    decltype(Traits::item(input)) in_item = Traits::item(input);
    mojo::internal::MessageFragment<decltype(fragment->item)>
        item_fragment(fragment.message());
    item_fragment.Claim(&fragment->item);
    
    mojo::internal::Serialize<::network::mojom::StructuredHeadersItemDataView>(
      in_item,
      item_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->item.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null item in StructuredHeadersParameter struct");
  }

  static bool Deserialize(::network::mojom::internal::StructuredHeadersParameter_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::StructuredHeadersParameterDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::StructuredHeadersParameterizedItemDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::StructuredHeadersParameterizedItemDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::StructuredHeadersParameterizedItem_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::item(input)) in_item = Traits::item(input);
    mojo::internal::MessageFragment<decltype(fragment->item)>
        item_fragment(fragment.message());
    item_fragment.Claim(&fragment->item);
    
    mojo::internal::Serialize<::network::mojom::StructuredHeadersItemDataView>(
      in_item,
      item_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->item.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null item in StructuredHeadersParameterizedItem struct");

    decltype(Traits::parameters(input)) in_parameters = Traits::parameters(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->parameters)::BaseType>
        parameters_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& parameters_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::StructuredHeadersParameterDataView>>(
      in_parameters,
      parameters_fragment,
      &parameters_validate_params);

    fragment->parameters.Set(
        parameters_fragment.is_null() ? nullptr : parameters_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->parameters.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null parameters in StructuredHeadersParameterizedItem struct");
  }

  static bool Deserialize(::network::mojom::internal::StructuredHeadersParameterizedItem_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::StructuredHeadersParameterizedItemDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::StructuredHeadersParameterizedMemberDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::StructuredHeadersParameterizedMemberDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::StructuredHeadersParameterizedMember_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::member(input)) in_member = Traits::member(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->member)::BaseType>
        member_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& member_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::StructuredHeadersParameterizedItemDataView>>(
      in_member,
      member_fragment,
      &member_validate_params);

    fragment->member.Set(
        member_fragment.is_null() ? nullptr : member_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->member.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null member in StructuredHeadersParameterizedMember struct");

    fragment->member_is_inner_list = Traits::member_is_inner_list(input);

    decltype(Traits::parameters(input)) in_parameters = Traits::parameters(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->parameters)::BaseType>
        parameters_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& parameters_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::StructuredHeadersParameterDataView>>(
      in_parameters,
      parameters_fragment,
      &parameters_validate_params);

    fragment->parameters.Set(
        parameters_fragment.is_null() ? nullptr : parameters_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->parameters.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null parameters in StructuredHeadersParameterizedMember struct");
  }

  static bool Deserialize(::network::mojom::internal::StructuredHeadersParameterizedMember_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::StructuredHeadersParameterizedMemberDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::StructuredHeadersDictionaryMemberDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::StructuredHeadersDictionaryMemberDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::StructuredHeadersDictionaryMember_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::key(input)) in_key = Traits::key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->key)::BaseType> key_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_key,
      key_fragment);

    fragment->key.Set(
        key_fragment.is_null() ? nullptr : key_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->key.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key in StructuredHeadersDictionaryMember struct");

    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->value)::BaseType> value_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::StructuredHeadersParameterizedMemberDataView>(
      in_value,
      value_fragment);

    fragment->value.Set(
        value_fragment.is_null() ? nullptr : value_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->value.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in StructuredHeadersDictionaryMember struct");
  }

  static bool Deserialize(::network::mojom::internal::StructuredHeadersDictionaryMember_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::StructuredHeadersDictionaryMemberDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::StructuredHeadersDictionaryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::StructuredHeadersDictionaryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::StructuredHeadersDictionary_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::members(input)) in_members = Traits::members(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->members)::BaseType>
        members_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& members_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::StructuredHeadersDictionaryMemberDataView>>(
      in_members,
      members_fragment,
      &members_validate_params);

    fragment->members.Set(
        members_fragment.is_null() ? nullptr : members_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->members.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null members in StructuredHeadersDictionary struct");
  }

  static bool Deserialize(::network::mojom::internal::StructuredHeadersDictionary_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::StructuredHeadersDictionaryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::StructuredHeadersItemDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::network::mojom::StructuredHeadersItemDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::network::mojom::internal::StructuredHeadersItem_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::network::mojom::StructuredHeadersItemDataView::Tag::kNullValue: {
    decltype(Traits::null_value(input))
    in_null_value = Traits::null_value(input);
    fragment->data.f_null_value = in_null_value;
    break;
  }
  case ::network::mojom::StructuredHeadersItemDataView::Tag::kIntegerValue: {
    decltype(Traits::integer_value(input))
    in_integer_value = Traits::integer_value(input);
    fragment->data.f_integer_value = in_integer_value;
    break;
  }
  case ::network::mojom::StructuredHeadersItemDataView::Tag::kDecimalValue: {
    decltype(Traits::decimal_value(input))
    in_decimal_value = Traits::decimal_value(input);
    fragment->data.f_decimal_value = in_decimal_value;
    break;
  }
  case ::network::mojom::StructuredHeadersItemDataView::Tag::kStringValue: {
    decltype(Traits::string_value(input))
    in_string_value = Traits::string_value(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_string_value)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView>(
  in_string_value,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null string_value in StructuredHeadersItem union");
    fragment->data.f_string_value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::network::mojom::StructuredHeadersItemDataView::Tag::kTokenValue: {
    decltype(Traits::token_value(input))
    in_token_value = Traits::token_value(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_token_value)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView>(
  in_token_value,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null token_value in StructuredHeadersItem union");
    fragment->data.f_token_value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::network::mojom::StructuredHeadersItemDataView::Tag::kByteSequenceValue: {
    decltype(Traits::byte_sequence_value(input))
    in_byte_sequence_value = Traits::byte_sequence_value(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_byte_sequence_value)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView>(
  in_byte_sequence_value,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null byte_sequence_value in StructuredHeadersItem union");
    fragment->data.f_byte_sequence_value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::network::mojom::StructuredHeadersItemDataView::Tag::kBooleanValue: {
    decltype(Traits::boolean_value(input))
    in_boolean_value = Traits::boolean_value(input);
    fragment->data.f_boolean_value = in_boolean_value;
    break;
  }
}
  }

  static bool Deserialize(::network::mojom::internal::StructuredHeadersItem_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::StructuredHeadersItemDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void StructuredHeadersParameterDataView::GetKeyDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->key.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void StructuredHeadersParameterDataView::GetItemDataView(
    StructuredHeadersItemDataView* output) {
  auto pointer = &data_->item;
  *output = StructuredHeadersItemDataView(pointer, message_);
}


inline void StructuredHeadersParameterizedItemDataView::GetItemDataView(
    StructuredHeadersItemDataView* output) {
  auto pointer = &data_->item;
  *output = StructuredHeadersItemDataView(pointer, message_);
}
inline void StructuredHeadersParameterizedItemDataView::GetParametersDataView(
    mojo::ArrayDataView<StructuredHeadersParameterDataView>* output) {
  auto pointer = data_->parameters.Get();
  *output = mojo::ArrayDataView<StructuredHeadersParameterDataView>(pointer, message_);
}


inline void StructuredHeadersParameterizedMemberDataView::GetMemberDataView(
    mojo::ArrayDataView<StructuredHeadersParameterizedItemDataView>* output) {
  auto pointer = data_->member.Get();
  *output = mojo::ArrayDataView<StructuredHeadersParameterizedItemDataView>(pointer, message_);
}
inline void StructuredHeadersParameterizedMemberDataView::GetParametersDataView(
    mojo::ArrayDataView<StructuredHeadersParameterDataView>* output) {
  auto pointer = data_->parameters.Get();
  *output = mojo::ArrayDataView<StructuredHeadersParameterDataView>(pointer, message_);
}


inline void StructuredHeadersDictionaryMemberDataView::GetKeyDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->key.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void StructuredHeadersDictionaryMemberDataView::GetValueDataView(
    StructuredHeadersParameterizedMemberDataView* output) {
  auto pointer = data_->value.Get();
  *output = StructuredHeadersParameterizedMemberDataView(pointer, message_);
}


inline void StructuredHeadersDictionaryDataView::GetMembersDataView(
    mojo::ArrayDataView<StructuredHeadersDictionaryMemberDataView>* output) {
  auto pointer = data_->members.Get();
  *output = mojo::ArrayDataView<StructuredHeadersDictionaryMemberDataView>(pointer, message_);
}


inline void StructuredHeadersItemDataView::GetStringValueDataView(
    mojo::StringDataView* output) const {
  CHECK(is_string_value());
  *output = mojo::StringDataView(data_->data.f_string_value.Get(), message_);
}
inline void StructuredHeadersItemDataView::GetTokenValueDataView(
    mojo::StringDataView* output) const {
  CHECK(is_token_value());
  *output = mojo::StringDataView(data_->data.f_token_value.Get(), message_);
}
inline void StructuredHeadersItemDataView::GetByteSequenceValueDataView(
    ::mojo_base::mojom::ByteStringDataView* output) const {
  CHECK(is_byte_sequence_value());
  *output = ::mojo_base::mojom::ByteStringDataView(data_->data.f_byte_sequence_value.Get(), message_);
}


}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_STRUCTURED_HEADERS_MOJOM_SHARED_H_