// services/network/public/mojom/ssl_config.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SSLVersionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SSLVersion = {
  
  kTLS12: 0,
  kTLS13: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SSLNamedGroupsPresetSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SSLNamedGroupsPreset = {
  
  kDefault: 0,
  kCnsa2: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SSLConfigClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.SSLConfigClient', scope);
  }
}

/** @interface */
export class SSLConfigClientInterface {
  
  /**
   * @param { !SSLConfig } sslConfig
   */

  onSSLConfigUpdated(sslConfig) {}
}

/**
 * @implements { SSLConfigClientInterface }
 */
export class SSLConfigClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SSLConfigClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SSLConfigClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SSLConfigClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !SSLConfig } sslConfig
   */

  onSSLConfigUpdated(
      sslConfig) {
    this.proxy.sendMessage(
        0,
        SSLConfigClient_OnSSLConfigUpdated_ParamsSpec.$,
        null,
        [
          sslConfig
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SSLConfigClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SSLConfigClientReceiver {
  /**
   * @param {!SSLConfigClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SSLConfigClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SSLConfigClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SSLConfigClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SSLConfigClient_OnSSLConfigUpdated_ParamsSpec.$,
        null,
        impl.onSSLConfigUpdated.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SSLConfigClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.SSLConfigClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SSLConfigClientRemote}
   */
  static getRemote() {
    let remote = new SSLConfigClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SSLConfigClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SSLConfigClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SSLConfigClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SSLConfigClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSSLConfigUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SSLConfigClient_OnSSLConfigUpdated_ParamsSpec.$,
        null,
        this.onSSLConfigUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SSLConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SSLConfigClient_OnSSLConfigUpdated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    SSLConfigSpec.$,
    'SSLConfig',
    [
      mojo.internal.StructField(
        'revCheckingEnabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'revCheckingRequiredLocalAnchors', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sha1LocalAnchorsEnabled', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'versionMin', 4,
        0,
        SSLVersionSpec.$,
        SSLVersion.kTLS12,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'versionMax', 8,
        0,
        SSLVersionSpec.$,
        SSLVersion.kTLS13,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'disabledCipherSuites', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint16, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tls13CipherPreferAes256', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'clientCertPoolingPolicy', 24,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'namedGroupsPreset', 12,
        0,
        SSLNamedGroupsPresetSpec.$,
        SSLNamedGroupsPreset.kDefault,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'postQuantumKeyAgreementEnabled', 0,
        4,
        mojo.internal.Bool,
        true,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'echEnabled', 0,
        5,
        mojo.internal.Bool,
        true,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trustAnchorIds', 32,
        0,
        mojo.internal.Array(mojo.internal.Array(mojo.internal.Uint8, false), false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mtcTrustAnchorIds', 40,
        0,
        mojo.internal.Array(mojo.internal.Array(mojo.internal.Uint8, false), false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class SSLConfig {
  constructor() {
    /** @type { !boolean } */
    this.revCheckingEnabled;
    /** @type { !boolean } */
    this.revCheckingRequiredLocalAnchors;
    /** @type { !boolean } */
    this.sha1LocalAnchorsEnabled;
    /** @type { !SSLVersion } */
    this.versionMin;
    /** @type { !SSLVersion } */
    this.versionMax;
    /** @type { !Array<!number> } */
    this.disabledCipherSuites;
    /** @type { !boolean } */
    this.tls13CipherPreferAes256;
    /** @type { !Array<!string> } */
    this.clientCertPoolingPolicy;
    /** @type { !SSLNamedGroupsPreset } */
    this.namedGroupsPreset;
    /** @type { !boolean } */
    this.postQuantumKeyAgreementEnabled;
    /** @type { !boolean } */
    this.echEnabled;
    /** @type { !Array<!Array<!number>> } */
    this.trustAnchorIds;
    /** @type { !Array<!Array<!number>> } */
    this.mtcTrustAnchorIds;
  }
}



mojo.internal.Struct(
    SSLConfigClient_OnSSLConfigUpdated_ParamsSpec.$,
    'SSLConfigClient_OnSSLConfigUpdated_Params',
    [
      mojo.internal.StructField(
        'sslConfig', 0,
        0,
        SSLConfigSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SSLConfigClient_OnSSLConfigUpdated_Params {
  constructor() {
    /** @type { !SSLConfig } */
    this.sslConfig;
  }
}

