// services/network/public/mojom/sri_message_signature.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/sri_message_signature.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');


  var SRIMessageSignatureError = {};
  SRIMessageSignatureError.kMissingSignatureHeader = 0;
  SRIMessageSignatureError.kMissingSignatureInputHeader = 1;
  SRIMessageSignatureError.kInvalidSignatureHeader = 2;
  SRIMessageSignatureError.kInvalidSignatureInputHeader = 3;
  SRIMessageSignatureError.kSignatureHeaderValueIsNotByteSequence = 4;
  SRIMessageSignatureError.kSignatureHeaderValueIsParameterized = 5;
  SRIMessageSignatureError.kSignatureHeaderValueIsIncorrectLength = 6;
  SRIMessageSignatureError.kSignatureInputHeaderMissingLabel = 7;
  SRIMessageSignatureError.kSignatureInputHeaderValueNotInnerList = 8;
  SRIMessageSignatureError.kSignatureInputHeaderValueMissingComponents = 9;
  SRIMessageSignatureError.kSignatureInputHeaderInvalidComponentType = 10;
  SRIMessageSignatureError.kSignatureInputHeaderInvalidComponentName = 11;
  SRIMessageSignatureError.kSignatureInputHeaderInvalidHeaderComponentParameter = 12;
  SRIMessageSignatureError.kSignatureInputHeaderInvalidDerivedComponentParameter = 13;
  SRIMessageSignatureError.kSignatureInputHeaderKeyIdLength = 14;
  SRIMessageSignatureError.kSignatureInputHeaderInvalidParameter = 15;
  SRIMessageSignatureError.kSignatureInputHeaderMissingRequiredParameters = 16;
  SRIMessageSignatureError.kValidationFailedSignatureExpired = 17;
  SRIMessageSignatureError.kValidationFailedInvalidLength = 18;
  SRIMessageSignatureError.kValidationFailedSignatureMismatch = 19;
  SRIMessageSignatureError.kValidationFailedIntegrityMismatch = 20;
  SRIMessageSignatureError.MIN_VALUE = 0;
  SRIMessageSignatureError.MAX_VALUE = 20;

  SRIMessageSignatureError.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
      return true;
    }
    return false;
  };

  SRIMessageSignatureError.toKnownEnumValue = function(value) {
    return value;
  };

  SRIMessageSignatureError.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function SRIMessageSignatureComponentParameter(values) {
    this.initDefaults_();
    this.initFields_(values);
  }

  SRIMessageSignatureComponentParameter.Type = {};
  SRIMessageSignatureComponentParameter.Type.kName = 0;
  SRIMessageSignatureComponentParameter.Type.kRequest = 1;
  SRIMessageSignatureComponentParameter.Type.kStrictStructuredFieldSerialization = 2;
  SRIMessageSignatureComponentParameter.Type.kBinaryRepresentation = 3;
  SRIMessageSignatureComponentParameter.Type.MIN_VALUE = 0;
  SRIMessageSignatureComponentParameter.Type.MAX_VALUE = 3;

  SRIMessageSignatureComponentParameter.Type.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  SRIMessageSignatureComponentParameter.Type.toKnownEnumValue = function(value) {
    return value;
  };

  SRIMessageSignatureComponentParameter.Type.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  SRIMessageSignatureComponentParameter.prototype.initDefaults_ = function() {
    this.type = 0;
    this.value = null;
  };
  SRIMessageSignatureComponentParameter.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SRIMessageSignatureComponentParameter.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SRIMessageSignatureComponentParameter.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, SRIMessageSignatureComponentParameter.Type);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SRIMessageSignatureComponentParameter.value
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SRIMessageSignatureComponentParameter.encodedSize = codec.kStructHeaderSize + 16;

  SRIMessageSignatureComponentParameter.decode = function(decoder) {
    var packed;
    var val = new SRIMessageSignatureComponentParameter();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(SRIMessageSignatureComponentParameter.Type));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.value =
        decoder.decodeStruct(codec.String);
    return val;
  };

  SRIMessageSignatureComponentParameter.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SRIMessageSignatureComponentParameter.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.value);
  };
  function SRIMessageSignatureComponent(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SRIMessageSignatureComponent.prototype.initDefaults_ = function() {
    this.name = null;
    this.params = null;
  };
  SRIMessageSignatureComponent.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SRIMessageSignatureComponent.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SRIMessageSignatureComponent.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SRIMessageSignatureComponent.params
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(SRIMessageSignatureComponentParameter), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SRIMessageSignatureComponent.encodedSize = codec.kStructHeaderSize + 16;

  SRIMessageSignatureComponent.decode = function(decoder) {
    var packed;
    var val = new SRIMessageSignatureComponent();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    val.params =
        decoder.decodeArrayPointer(new codec.PointerTo(SRIMessageSignatureComponentParameter));
    return val;
  };

  SRIMessageSignatureComponent.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SRIMessageSignatureComponent.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeArrayPointer(new codec.PointerTo(SRIMessageSignatureComponentParameter), val.params);
  };
  function SRIMessageSignature(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SRIMessageSignature.prototype.initDefaults_ = function() {
    this.label = null;
    this.signature = null;
    this.components = null;
    this.created_$flag = false;
    this.expires_$flag = false;
    this.created_$value = 0;
    this.expires_$value = 0;
    this.keyid = null;
    this.nonce = null;
    this.tag = null;
    this.serializedSignatureParams = null;
  };
  SRIMessageSignature.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SRIMessageSignature.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 88}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SRIMessageSignature.label
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SRIMessageSignature.signature
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SRIMessageSignature.components
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(SRIMessageSignatureComponent), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;






    // validate SRIMessageSignature.keyid
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 48, 1, codec.Uint8, true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SRIMessageSignature.nonce
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 56, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SRIMessageSignature.tag
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 64, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SRIMessageSignature.serializedSignatureParams
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 72, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SRIMessageSignature.encodedSize = codec.kStructHeaderSize + 80;

  SRIMessageSignature.decode = function(decoder) {
    var packed;
    var val = new SRIMessageSignature();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.label =
        decoder.decodeStruct(codec.String);
    val.signature =
        decoder.decodeArrayPointer(codec.Uint8);
    val.components =
        decoder.decodeArrayPointer(new codec.PointerTo(SRIMessageSignatureComponent));
    packed = decoder.readUint8();
    val.created_$flag = (packed >> 0) & 1 ? true : false;
    val.expires_$flag = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.created_$value =
        decoder.decodeStruct(codec.Int64);
    val.expires_$value =
        decoder.decodeStruct(codec.Int64);
    val.keyid =
        decoder.decodeArrayPointer(codec.Uint8);
    val.nonce =
        decoder.decodeStruct(codec.String);
    val.tag =
        decoder.decodeStruct(codec.String);
    val.serializedSignatureParams =
        decoder.decodeStruct(codec.String);
    return val;
  };

  SRIMessageSignature.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SRIMessageSignature.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.label);
    encoder.encodeArrayPointer(codec.Uint8, val.signature);
    encoder.encodeArrayPointer(new codec.PointerTo(SRIMessageSignatureComponent), val.components);
    packed = 0;
    packed |= (val.created_$flag & 1) << 0
    packed |= (val.expires_$flag & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int64, val.created_$value);
    encoder.encodeStruct(codec.Int64, val.expires_$value);
    encoder.encodeArrayPointer(codec.Uint8, val.keyid);
    encoder.encodeStruct(codec.String, val.nonce);
    encoder.encodeStruct(codec.String, val.tag);
    encoder.encodeStruct(codec.String, val.serializedSignatureParams);
  };
  function SRIMessageSignatureIssue(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SRIMessageSignatureIssue.prototype.initDefaults_ = function() {
    this.error = 0;
    this.signatureBase = null;
    this.integrityAssertions = null;
  };
  SRIMessageSignatureIssue.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SRIMessageSignatureIssue.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SRIMessageSignatureIssue.error
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, SRIMessageSignatureError);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SRIMessageSignatureIssue.signatureBase
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SRIMessageSignatureIssue.integrityAssertions
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, codec.String, true, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SRIMessageSignatureIssue.encodedSize = codec.kStructHeaderSize + 24;

  SRIMessageSignatureIssue.decode = function(decoder) {
    var packed;
    var val = new SRIMessageSignatureIssue();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.error =
        decoder.decodeStruct(new codec.Enum(SRIMessageSignatureError));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.signatureBase =
        decoder.decodeStruct(codec.String);
    val.integrityAssertions =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  SRIMessageSignatureIssue.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SRIMessageSignatureIssue.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.error);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.signatureBase);
    encoder.encodeArrayPointer(codec.String, val.integrityAssertions);
  };
  function SRIMessageSignatures(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SRIMessageSignatures.prototype.initDefaults_ = function() {
    this.signatures = null;
    this.issues = null;
  };
  SRIMessageSignatures.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SRIMessageSignatures.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SRIMessageSignatures.signatures
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(SRIMessageSignature), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SRIMessageSignatures.issues
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(SRIMessageSignatureIssue), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SRIMessageSignatures.encodedSize = codec.kStructHeaderSize + 16;

  SRIMessageSignatures.decode = function(decoder) {
    var packed;
    var val = new SRIMessageSignatures();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.signatures =
        decoder.decodeArrayPointer(new codec.PointerTo(SRIMessageSignature));
    val.issues =
        decoder.decodeArrayPointer(new codec.PointerTo(SRIMessageSignatureIssue));
    return val;
  };

  SRIMessageSignatures.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SRIMessageSignatures.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(SRIMessageSignature), val.signatures);
    encoder.encodeArrayPointer(new codec.PointerTo(SRIMessageSignatureIssue), val.issues);
  };
  exports.SRIMessageSignatureError = SRIMessageSignatureError;
  exports.SRIMessageSignatureComponentParameter = SRIMessageSignatureComponentParameter;
  exports.SRIMessageSignatureComponent = SRIMessageSignatureComponent;
  exports.SRIMessageSignature = SRIMessageSignature;
  exports.SRIMessageSignatureIssue = SRIMessageSignatureIssue;
  exports.SRIMessageSignatures = SRIMessageSignatures;
})();