// services/network/public/mojom/sri_message_signature.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SRI_MESSAGE_SIGNATURE_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SRI_MESSAGE_SIGNATURE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/sri_message_signature.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/sri_message_signature.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/sri_message_signature.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {





class BLINK_PLATFORM_EXPORT SRIMessageSignatureComponentParameter {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SRIMessageSignatureComponentParameter, T>::value>;
  using DataView = SRIMessageSignatureComponentParameterDataView;
  using Data_ = internal::SRIMessageSignatureComponentParameter_Data;
  using Type = SRIMessageSignatureComponentParameter_Type;

  template <typename... Args>
  static SRIMessageSignatureComponentParameterPtr New(Args&&... args) {
    return SRIMessageSignatureComponentParameterPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SRIMessageSignatureComponentParameterPtr From(const U& u) {
    return mojo::TypeConverter<SRIMessageSignatureComponentParameterPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SRIMessageSignatureComponentParameter>::Convert(*this);
  }


  SRIMessageSignatureComponentParameter();

  SRIMessageSignatureComponentParameter(
      SRIMessageSignatureComponentParameter::Type type,
      const ::blink::String& value);


  ~SRIMessageSignatureComponentParameter();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SRIMessageSignatureComponentParameterPtr>
  SRIMessageSignatureComponentParameterPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SRIMessageSignatureComponentParameter::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SRIMessageSignatureComponentParameter::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SRIMessageSignatureComponentParameter::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SRIMessageSignatureComponentParameter::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SRIMessageSignatureComponentParameter::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SRIMessageSignatureComponentParameter::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SRIMessageSignatureComponentParameter_UnserializedMessageContext<
            UserType, SRIMessageSignatureComponentParameter::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SRIMessageSignatureComponentParameter::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SRIMessageSignatureComponentParameter::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SRIMessageSignatureComponentParameter_UnserializedMessageContext<
            UserType, SRIMessageSignatureComponentParameter::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SRIMessageSignatureComponentParameter::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  SRIMessageSignatureComponentParameter::Type type;
  
  ::blink::String value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SRIMessageSignatureComponentParameter::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SRIMessageSignatureComponentParameter::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SRIMessageSignatureComponentParameter::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SRIMessageSignatureComponentParameter::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}












class BLINK_PLATFORM_EXPORT SRIMessageSignatureComponent {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SRIMessageSignatureComponent, T>::value>;
  using DataView = SRIMessageSignatureComponentDataView;
  using Data_ = internal::SRIMessageSignatureComponent_Data;

  template <typename... Args>
  static SRIMessageSignatureComponentPtr New(Args&&... args) {
    return SRIMessageSignatureComponentPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SRIMessageSignatureComponentPtr From(const U& u) {
    return mojo::TypeConverter<SRIMessageSignatureComponentPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SRIMessageSignatureComponent>::Convert(*this);
  }


  SRIMessageSignatureComponent();

  SRIMessageSignatureComponent(
      const ::blink::String& name,
      ::blink::Vector<SRIMessageSignatureComponentParameterPtr> params);

SRIMessageSignatureComponent(const SRIMessageSignatureComponent&) = delete;
SRIMessageSignatureComponent& operator=(const SRIMessageSignatureComponent&) = delete;

  ~SRIMessageSignatureComponent();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SRIMessageSignatureComponentPtr>
  SRIMessageSignatureComponentPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SRIMessageSignatureComponent::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SRIMessageSignatureComponent::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SRIMessageSignatureComponent::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SRIMessageSignatureComponent::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SRIMessageSignatureComponent::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SRIMessageSignatureComponent::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SRIMessageSignatureComponent_UnserializedMessageContext<
            UserType, SRIMessageSignatureComponent::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SRIMessageSignatureComponent::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SRIMessageSignatureComponent::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SRIMessageSignatureComponent_UnserializedMessageContext<
            UserType, SRIMessageSignatureComponent::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SRIMessageSignatureComponent::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String name;
  
  ::blink::Vector<SRIMessageSignatureComponentParameterPtr> params;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SRIMessageSignatureComponent::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SRIMessageSignatureComponent::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SRIMessageSignatureComponent::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SRIMessageSignatureComponent::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT SRIMessageSignature {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SRIMessageSignature, T>::value>;
  using DataView = SRIMessageSignatureDataView;
  using Data_ = internal::SRIMessageSignature_Data;

  template <typename... Args>
  static SRIMessageSignaturePtr New(Args&&... args) {
    return SRIMessageSignaturePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SRIMessageSignaturePtr From(const U& u) {
    return mojo::TypeConverter<SRIMessageSignaturePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SRIMessageSignature>::Convert(*this);
  }


  SRIMessageSignature();

  SRIMessageSignature(
      const ::blink::String& label,
      ::blink::Vector<uint8_t> signature,
      ::blink::Vector<SRIMessageSignatureComponentPtr> components,
      std::optional<int64_t> created,
      std::optional<int64_t> expires,
      std::optional<::blink::Vector<uint8_t>> keyid,
      const ::blink::String& nonce,
      const ::blink::String& tag,
      const ::blink::String& serialized_signature_params);

SRIMessageSignature(const SRIMessageSignature&) = delete;
SRIMessageSignature& operator=(const SRIMessageSignature&) = delete;

  ~SRIMessageSignature();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SRIMessageSignaturePtr>
  SRIMessageSignaturePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SRIMessageSignature::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SRIMessageSignature::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SRIMessageSignature::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SRIMessageSignature::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SRIMessageSignature::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SRIMessageSignature::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SRIMessageSignature_UnserializedMessageContext<
            UserType, SRIMessageSignature::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SRIMessageSignature::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SRIMessageSignature::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SRIMessageSignature_UnserializedMessageContext<
            UserType, SRIMessageSignature::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SRIMessageSignature::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String label;
  
  ::blink::Vector<uint8_t> signature;
  
  ::blink::Vector<SRIMessageSignatureComponentPtr> components;
  
  std::optional<int64_t> created;
  
  std::optional<int64_t> expires;
  
  std::optional<::blink::Vector<uint8_t>> keyid;
  
  ::blink::String nonce;
  
  ::blink::String tag;
  
  ::blink::String serialized_signature_params;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SRIMessageSignature::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SRIMessageSignature::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SRIMessageSignature::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SRIMessageSignature::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT SRIMessageSignatureIssue {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SRIMessageSignatureIssue, T>::value>;
  using DataView = SRIMessageSignatureIssueDataView;
  using Data_ = internal::SRIMessageSignatureIssue_Data;

  template <typename... Args>
  static SRIMessageSignatureIssuePtr New(Args&&... args) {
    return SRIMessageSignatureIssuePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SRIMessageSignatureIssuePtr From(const U& u) {
    return mojo::TypeConverter<SRIMessageSignatureIssuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SRIMessageSignatureIssue>::Convert(*this);
  }


  SRIMessageSignatureIssue();

  SRIMessageSignatureIssue(
      SRIMessageSignatureError error,
      const ::blink::String& signature_base,
      std::optional<::blink::Vector<::blink::String>> integrity_assertions);


  ~SRIMessageSignatureIssue();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SRIMessageSignatureIssuePtr>
  SRIMessageSignatureIssuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SRIMessageSignatureIssue::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SRIMessageSignatureIssue::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SRIMessageSignatureIssue::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SRIMessageSignatureIssue::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SRIMessageSignatureIssue::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SRIMessageSignatureIssue::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SRIMessageSignatureIssue_UnserializedMessageContext<
            UserType, SRIMessageSignatureIssue::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SRIMessageSignatureIssue::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SRIMessageSignatureIssue::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SRIMessageSignatureIssue_UnserializedMessageContext<
            UserType, SRIMessageSignatureIssue::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SRIMessageSignatureIssue::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  SRIMessageSignatureError error;
  
  ::blink::String signature_base;
  
  std::optional<::blink::Vector<::blink::String>> integrity_assertions;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SRIMessageSignatureIssue::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SRIMessageSignatureIssue::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SRIMessageSignatureIssue::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SRIMessageSignatureIssue::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT SRIMessageSignatures {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SRIMessageSignatures, T>::value>;
  using DataView = SRIMessageSignaturesDataView;
  using Data_ = internal::SRIMessageSignatures_Data;

  template <typename... Args>
  static SRIMessageSignaturesPtr New(Args&&... args) {
    return SRIMessageSignaturesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SRIMessageSignaturesPtr From(const U& u) {
    return mojo::TypeConverter<SRIMessageSignaturesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SRIMessageSignatures>::Convert(*this);
  }


  SRIMessageSignatures();

  SRIMessageSignatures(
      ::blink::Vector<SRIMessageSignaturePtr> signatures,
      ::blink::Vector<SRIMessageSignatureIssuePtr> issues);

SRIMessageSignatures(const SRIMessageSignatures&) = delete;
SRIMessageSignatures& operator=(const SRIMessageSignatures&) = delete;

  ~SRIMessageSignatures();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SRIMessageSignaturesPtr>
  SRIMessageSignaturesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SRIMessageSignatures::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SRIMessageSignatures::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SRIMessageSignatures::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SRIMessageSignatures::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SRIMessageSignatures::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SRIMessageSignatures::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SRIMessageSignatures_UnserializedMessageContext<
            UserType, SRIMessageSignatures::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SRIMessageSignatures::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SRIMessageSignatures::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SRIMessageSignatures_UnserializedMessageContext<
            UserType, SRIMessageSignatures::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SRIMessageSignatures::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<SRIMessageSignaturePtr> signatures;
  
  ::blink::Vector<SRIMessageSignatureIssuePtr> issues;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SRIMessageSignatures::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SRIMessageSignatures::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SRIMessageSignatures::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SRIMessageSignatures::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SRIMessageSignatureComponentParameterPtr SRIMessageSignatureComponentParameter::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(value)
  );
}

template <typename T, SRIMessageSignatureComponentParameter::EnableIfSame<T>*>
bool SRIMessageSignatureComponentParameter::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, SRIMessageSignatureComponentParameter::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
SRIMessageSignatureComponentPtr SRIMessageSignatureComponent::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(params)
  );
}

template <typename T, SRIMessageSignatureComponent::EnableIfSame<T>*>
bool SRIMessageSignatureComponent::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->params, other_struct.params))
    return false;
  return true;
}

template <typename T, SRIMessageSignatureComponent::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.params < rhs.params)
    return true;
  if (rhs.params < lhs.params)
    return false;
  return false;
}
template <typename StructPtrType>
SRIMessageSignaturePtr SRIMessageSignature::Clone() const {
  return New(
      mojo::Clone(label),
      mojo::Clone(signature),
      mojo::Clone(components),
      mojo::Clone(created),
      mojo::Clone(expires),
      mojo::Clone(keyid),
      mojo::Clone(nonce),
      mojo::Clone(tag),
      mojo::Clone(serialized_signature_params)
  );
}

template <typename T, SRIMessageSignature::EnableIfSame<T>*>
bool SRIMessageSignature::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  if (!mojo::Equals(this->signature, other_struct.signature))
    return false;
  if (!mojo::Equals(this->components, other_struct.components))
    return false;
  if (!mojo::Equals(this->created, other_struct.created))
    return false;
  if (!mojo::Equals(this->expires, other_struct.expires))
    return false;
  if (!mojo::Equals(this->keyid, other_struct.keyid))
    return false;
  if (!mojo::Equals(this->nonce, other_struct.nonce))
    return false;
  if (!mojo::Equals(this->tag, other_struct.tag))
    return false;
  if (!mojo::Equals(this->serialized_signature_params, other_struct.serialized_signature_params))
    return false;
  return true;
}

template <typename T, SRIMessageSignature::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  if (lhs.signature < rhs.signature)
    return true;
  if (rhs.signature < lhs.signature)
    return false;
  if (lhs.components < rhs.components)
    return true;
  if (rhs.components < lhs.components)
    return false;
  if (lhs.created < rhs.created)
    return true;
  if (rhs.created < lhs.created)
    return false;
  if (lhs.expires < rhs.expires)
    return true;
  if (rhs.expires < lhs.expires)
    return false;
  if (lhs.keyid < rhs.keyid)
    return true;
  if (rhs.keyid < lhs.keyid)
    return false;
  if (lhs.nonce < rhs.nonce)
    return true;
  if (rhs.nonce < lhs.nonce)
    return false;
  if (lhs.tag < rhs.tag)
    return true;
  if (rhs.tag < lhs.tag)
    return false;
  if (lhs.serialized_signature_params < rhs.serialized_signature_params)
    return true;
  if (rhs.serialized_signature_params < lhs.serialized_signature_params)
    return false;
  return false;
}
template <typename StructPtrType>
SRIMessageSignatureIssuePtr SRIMessageSignatureIssue::Clone() const {
  return New(
      mojo::Clone(error),
      mojo::Clone(signature_base),
      mojo::Clone(integrity_assertions)
  );
}

template <typename T, SRIMessageSignatureIssue::EnableIfSame<T>*>
bool SRIMessageSignatureIssue::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->error, other_struct.error))
    return false;
  if (!mojo::Equals(this->signature_base, other_struct.signature_base))
    return false;
  if (!mojo::Equals(this->integrity_assertions, other_struct.integrity_assertions))
    return false;
  return true;
}

template <typename T, SRIMessageSignatureIssue::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.error < rhs.error)
    return true;
  if (rhs.error < lhs.error)
    return false;
  if (lhs.signature_base < rhs.signature_base)
    return true;
  if (rhs.signature_base < lhs.signature_base)
    return false;
  if (lhs.integrity_assertions < rhs.integrity_assertions)
    return true;
  if (rhs.integrity_assertions < lhs.integrity_assertions)
    return false;
  return false;
}
template <typename StructPtrType>
SRIMessageSignaturesPtr SRIMessageSignatures::Clone() const {
  return New(
      mojo::Clone(signatures),
      mojo::Clone(issues)
  );
}

template <typename T, SRIMessageSignatures::EnableIfSame<T>*>
bool SRIMessageSignatures::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->signatures, other_struct.signatures))
    return false;
  if (!mojo::Equals(this->issues, other_struct.issues))
    return false;
  return true;
}

template <typename T, SRIMessageSignatures::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.signatures < rhs.signatures)
    return true;
  if (rhs.signatures < lhs.signatures)
    return false;
  if (lhs.issues < rhs.issues)
    return true;
  if (rhs.issues < lhs.issues)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::SRIMessageSignatureComponentParameter::DataView,
                                         ::network::mojom::blink::SRIMessageSignatureComponentParameterPtr> {
  static bool IsNull(const ::network::mojom::blink::SRIMessageSignatureComponentParameterPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::SRIMessageSignatureComponentParameterPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::SRIMessageSignatureComponentParameter::type) type(
      const ::network::mojom::blink::SRIMessageSignatureComponentParameterPtr& input) {
    return input->type;
  }

  static const decltype(::network::mojom::blink::SRIMessageSignatureComponentParameter::value)& value(
      const ::network::mojom::blink::SRIMessageSignatureComponentParameterPtr& input) {
    return input->value;
  }

  static bool Read(::network::mojom::blink::SRIMessageSignatureComponentParameter::DataView input, ::network::mojom::blink::SRIMessageSignatureComponentParameterPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::SRIMessageSignatureComponent::DataView,
                                         ::network::mojom::blink::SRIMessageSignatureComponentPtr> {
  static bool IsNull(const ::network::mojom::blink::SRIMessageSignatureComponentPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::SRIMessageSignatureComponentPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::SRIMessageSignatureComponent::name)& name(
      const ::network::mojom::blink::SRIMessageSignatureComponentPtr& input) {
    return input->name;
  }

  static const decltype(::network::mojom::blink::SRIMessageSignatureComponent::params)& params(
      const ::network::mojom::blink::SRIMessageSignatureComponentPtr& input) {
    return input->params;
  }

  static bool Read(::network::mojom::blink::SRIMessageSignatureComponent::DataView input, ::network::mojom::blink::SRIMessageSignatureComponentPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::SRIMessageSignature::DataView,
                                         ::network::mojom::blink::SRIMessageSignaturePtr> {
  static bool IsNull(const ::network::mojom::blink::SRIMessageSignaturePtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::SRIMessageSignaturePtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::SRIMessageSignature::label)& label(
      const ::network::mojom::blink::SRIMessageSignaturePtr& input) {
    return input->label;
  }

  static const decltype(::network::mojom::blink::SRIMessageSignature::signature)& signature(
      const ::network::mojom::blink::SRIMessageSignaturePtr& input) {
    return input->signature;
  }

  static const decltype(::network::mojom::blink::SRIMessageSignature::components)& components(
      const ::network::mojom::blink::SRIMessageSignaturePtr& input) {
    return input->components;
  }

  static decltype(::network::mojom::blink::SRIMessageSignature::created) created(
      const ::network::mojom::blink::SRIMessageSignaturePtr& input) {
    return input->created;
  }

  static decltype(::network::mojom::blink::SRIMessageSignature::expires) expires(
      const ::network::mojom::blink::SRIMessageSignaturePtr& input) {
    return input->expires;
  }

  static const decltype(::network::mojom::blink::SRIMessageSignature::keyid)& keyid(
      const ::network::mojom::blink::SRIMessageSignaturePtr& input) {
    return input->keyid;
  }

  static const decltype(::network::mojom::blink::SRIMessageSignature::nonce)& nonce(
      const ::network::mojom::blink::SRIMessageSignaturePtr& input) {
    return input->nonce;
  }

  static const decltype(::network::mojom::blink::SRIMessageSignature::tag)& tag(
      const ::network::mojom::blink::SRIMessageSignaturePtr& input) {
    return input->tag;
  }

  static const decltype(::network::mojom::blink::SRIMessageSignature::serialized_signature_params)& serialized_signature_params(
      const ::network::mojom::blink::SRIMessageSignaturePtr& input) {
    return input->serialized_signature_params;
  }

  static bool Read(::network::mojom::blink::SRIMessageSignature::DataView input, ::network::mojom::blink::SRIMessageSignaturePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::SRIMessageSignatureIssue::DataView,
                                         ::network::mojom::blink::SRIMessageSignatureIssuePtr> {
  static bool IsNull(const ::network::mojom::blink::SRIMessageSignatureIssuePtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::SRIMessageSignatureIssuePtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::SRIMessageSignatureIssue::error) error(
      const ::network::mojom::blink::SRIMessageSignatureIssuePtr& input) {
    return input->error;
  }

  static const decltype(::network::mojom::blink::SRIMessageSignatureIssue::signature_base)& signature_base(
      const ::network::mojom::blink::SRIMessageSignatureIssuePtr& input) {
    return input->signature_base;
  }

  static const decltype(::network::mojom::blink::SRIMessageSignatureIssue::integrity_assertions)& integrity_assertions(
      const ::network::mojom::blink::SRIMessageSignatureIssuePtr& input) {
    return input->integrity_assertions;
  }

  static bool Read(::network::mojom::blink::SRIMessageSignatureIssue::DataView input, ::network::mojom::blink::SRIMessageSignatureIssuePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::SRIMessageSignatures::DataView,
                                         ::network::mojom::blink::SRIMessageSignaturesPtr> {
  static bool IsNull(const ::network::mojom::blink::SRIMessageSignaturesPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::SRIMessageSignaturesPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::SRIMessageSignatures::signatures)& signatures(
      const ::network::mojom::blink::SRIMessageSignaturesPtr& input) {
    return input->signatures;
  }

  static const decltype(::network::mojom::blink::SRIMessageSignatures::issues)& issues(
      const ::network::mojom::blink::SRIMessageSignaturesPtr& input) {
    return input->issues;
  }

  static bool Read(::network::mojom::blink::SRIMessageSignatures::DataView input, ::network::mojom::blink::SRIMessageSignaturesPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SRI_MESSAGE_SIGNATURE_MOJOM_BLINK_H_