// services/network/public/mojom/shared_dictionary_usage_info.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/shared_dictionary_usage_info.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var shared_dictionary_isolation_key$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/shared_dictionary_isolation_key.mojom', 'shared_dictionary_isolation_key.mojom.js');
  }



  function SharedDictionaryUsageInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedDictionaryUsageInfo.prototype.initDefaults_ = function() {
    this.isolationKey = null;
    this.totalSizeBytes = 0;
  };
  SharedDictionaryUsageInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedDictionaryUsageInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedDictionaryUsageInfo.isolationKey
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, shared_dictionary_isolation_key$.SharedDictionaryIsolationKey, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SharedDictionaryUsageInfo.encodedSize = codec.kStructHeaderSize + 16;

  SharedDictionaryUsageInfo.decode = function(decoder) {
    var packed;
    var val = new SharedDictionaryUsageInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.isolationKey =
        decoder.decodeStructPointer(shared_dictionary_isolation_key$.SharedDictionaryIsolationKey);
    val.totalSizeBytes =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  SharedDictionaryUsageInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedDictionaryUsageInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(shared_dictionary_isolation_key$.SharedDictionaryIsolationKey, val.isolationKey);
    encoder.encodeStruct(codec.Uint64, val.totalSizeBytes);
  };
  exports.SharedDictionaryUsageInfo = SharedDictionaryUsageInfo;
})();