// services/network/public/mojom/shared_dictionary_access_observer.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SHARED_DICTIONARY_ACCESS_OBSERVER_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SHARED_DICTIONARY_ACCESS_OBSERVER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/shared_dictionary_access_observer.mojom-shared-internal.h"
#include "services/network/public/mojom/shared_dictionary_isolation_key.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/network/public/mojom/shared_dictionary_access_observer.mojom-data-view.h"




namespace std {

template <>
struct hash<::network::mojom::SharedDictionaryAccessDetails_Type>
    : public mojo::internal::EnumHashImpl<::network::mojom::SharedDictionaryAccessDetails_Type> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SharedDictionaryAccessDetails_Type, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::SharedDictionaryAccessDetails_Type, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::SharedDictionaryAccessDetails_Type>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SharedDictionaryAccessDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SharedDictionaryAccessDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SharedDictionaryAccessDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::network::mojom::SharedDictionaryAccessDetails_Type>(
      Traits::type(input),
      &fragment->type);

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in SharedDictionaryAccessDetails struct");

    decltype(Traits::isolation_key(input)) in_isolation_key = Traits::isolation_key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->isolation_key)::BaseType> isolation_key_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::SharedDictionaryIsolationKeyDataView>(
      in_isolation_key,
      isolation_key_fragment);

    fragment->isolation_key.Set(
        isolation_key_fragment.is_null() ? nullptr : isolation_key_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->isolation_key.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null isolation_key in SharedDictionaryAccessDetails struct");

    fragment->is_blocked = Traits::is_blocked(input);
  }

  static bool Deserialize(::network::mojom::internal::SharedDictionaryAccessDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SharedDictionaryAccessDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void SharedDictionaryAccessDetailsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void SharedDictionaryAccessDetailsDataView::GetIsolationKeyDataView(
    ::network::mojom::SharedDictionaryIsolationKeyDataView* output) {
  auto pointer = data_->isolation_key.Get();
  *output = ::network::mojom::SharedDictionaryIsolationKeyDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::SharedDictionaryAccessDetails_Type> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::SharedDictionaryAccessDetails_Type value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SHARED_DICTIONARY_ACCESS_OBSERVER_MOJOM_SHARED_H_