// services/network/public/mojom/shared_dictionary_access_observer.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('network.mojom.SharedDictionaryIsolationKey');
goog.require('url.mojom.Url');






goog.provide('network.mojom.SharedDictionaryAccessObserver');
goog.provide('network.mojom.SharedDictionaryAccessObserverReceiver');
goog.provide('network.mojom.SharedDictionaryAccessObserverCallbackRouter');
goog.provide('network.mojom.SharedDictionaryAccessObserverInterface');
goog.provide('network.mojom.SharedDictionaryAccessObserverRemote');
goog.provide('network.mojom.SharedDictionaryAccessObserverPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.SharedDictionaryAccessObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.SharedDictionaryAccessObserver.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.SharedDictionaryAccessObserverInterface = class {
  
  /**
   * @param { !network.mojom.SharedDictionaryAccessDetails } details
   */

  onSharedDictionaryAccessed(details) {}
  
  /**
   * @param { !network.mojom.SharedDictionaryAccessObserverPendingReceiver } observer
   */

  clone(observer) {}
};

/**
 * @export
 * @implements { network.mojom.SharedDictionaryAccessObserverInterface }
 */
network.mojom.SharedDictionaryAccessObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.SharedDictionaryAccessObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.SharedDictionaryAccessObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.SharedDictionaryAccessObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.SharedDictionaryAccessDetails } details
   */

  onSharedDictionaryAccessed(
      details) {
    this.proxy.sendMessage(
        0,
        network.mojom.SharedDictionaryAccessObserver_OnSharedDictionaryAccessed_ParamsSpec.$,
        null,
        [
          details
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.SharedDictionaryAccessObserverPendingReceiver } observer
   */

  clone(
      observer) {
    this.proxy.sendMessage(
        1,
        network.mojom.SharedDictionaryAccessObserver_Clone_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SharedDictionaryAccessObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.SharedDictionaryAccessObserverReceiver = class {
  /**
   * @param {!network.mojom.SharedDictionaryAccessObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.SharedDictionaryAccessObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.SharedDictionaryAccessObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.SharedDictionaryAccessObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.SharedDictionaryAccessObserver_OnSharedDictionaryAccessed_ParamsSpec.$,
        null,
        impl.onSharedDictionaryAccessed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.SharedDictionaryAccessObserver_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.SharedDictionaryAccessObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.SharedDictionaryAccessObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.SharedDictionaryAccessObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.SharedDictionaryAccessObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SharedDictionaryAccessObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.SharedDictionaryAccessObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.SharedDictionaryAccessObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.SharedDictionaryAccessObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSharedDictionaryAccessed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.SharedDictionaryAccessObserver_OnSharedDictionaryAccessed_ParamsSpec.$,
        null,
        this.onSharedDictionaryAccessed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.SharedDictionaryAccessObserver_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.SharedDictionaryAccessDetailsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SharedDictionaryAccessDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SharedDictionaryAccessObserver_OnSharedDictionaryAccessed_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SharedDictionaryAccessObserver_OnSharedDictionaryAccessed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SharedDictionaryAccessObserver_Clone_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SharedDictionaryAccessObserver_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };



goog.provide('network.mojom.SharedDictionaryAccessDetails_Type');
goog.provide('network.mojom.SharedDictionaryAccessDetailsSpec.TypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.SharedDictionaryAccessDetailsSpec.TypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.SharedDictionaryAccessDetails_Type = {
  
  kRead: 0,
  kWrite: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


mojo.internal.Struct(
    network.mojom.SharedDictionaryAccessDetailsSpec.$,
    'SharedDictionaryAccessDetails',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        network.mojom.SharedDictionaryAccessDetailsSpec.TypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isolationKey', 16,
        0,
        network.mojom.SharedDictionaryIsolationKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isBlocked', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.SharedDictionaryAccessDetails');

/** @record */
network.mojom.SharedDictionaryAccessDetails = class {
  constructor() {
    /** @export { !network.mojom.SharedDictionaryAccessDetails_Type } */
    this.type;
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !network.mojom.SharedDictionaryIsolationKey } */
    this.isolationKey;
    /** @export { !boolean } */
    this.isBlocked;
  }
};



mojo.internal.Struct(
    network.mojom.SharedDictionaryAccessObserver_OnSharedDictionaryAccessed_ParamsSpec.$,
    'SharedDictionaryAccessObserver_OnSharedDictionaryAccessed_Params',
    [
      mojo.internal.StructField(
        'details', 0,
        0,
        network.mojom.SharedDictionaryAccessDetailsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.SharedDictionaryAccessObserver_OnSharedDictionaryAccessed_Params');

/** @record */
network.mojom.SharedDictionaryAccessObserver_OnSharedDictionaryAccessed_Params = class {
  constructor() {
    /** @export { !network.mojom.SharedDictionaryAccessDetails } */
    this.details;
  }
};



mojo.internal.Struct(
    network.mojom.SharedDictionaryAccessObserver_Clone_ParamsSpec.$,
    'SharedDictionaryAccessObserver_Clone_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceRequest(network.mojom.SharedDictionaryAccessObserverPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.SharedDictionaryAccessObserver_Clone_Params');

/** @record */
network.mojom.SharedDictionaryAccessObserver_Clone_Params = class {
  constructor() {
    /** @export { !network.mojom.SharedDictionaryAccessObserverPendingReceiver } */
    this.observer;
  }
};

