// services/network/public/mojom/shared_dictionary_access_observer.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SHARED_DICTIONARY_ACCESS_OBSERVER_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SHARED_DICTIONARY_ACCESS_OBSERVER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/network/public/mojom/shared_dictionary_access_observer.mojom-shared-internal.h"
#include "services/network/public/mojom/shared_dictionary_isolation_key.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace network::mojom {
class SharedDictionaryAccessDetailsDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::SharedDictionaryAccessDetailsDataView> {
  using Data = ::network::mojom::internal::SharedDictionaryAccessDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class SharedDictionaryAccessDetails_Type : int32_t {
  
  kRead = 0,
  
  kWrite = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, SharedDictionaryAccessDetails_Type value);
inline bool IsKnownEnumValue(SharedDictionaryAccessDetails_Type value) {
  return internal::SharedDictionaryAccessDetails_Type_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class SharedDictionaryAccessObserverInterfaceBase {};

using SharedDictionaryAccessObserverPtrDataView =
    mojo::InterfacePtrDataView<SharedDictionaryAccessObserverInterfaceBase>;
using SharedDictionaryAccessObserverRequestDataView =
    mojo::InterfaceRequestDataView<SharedDictionaryAccessObserverInterfaceBase>;
using SharedDictionaryAccessObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SharedDictionaryAccessObserverInterfaceBase>;
using SharedDictionaryAccessObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SharedDictionaryAccessObserverInterfaceBase>;


class SharedDictionaryAccessDetailsDataView {
 public:
  SharedDictionaryAccessDetailsDataView() = default;

  SharedDictionaryAccessDetailsDataView(
      internal::SharedDictionaryAccessDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::network::mojom::SharedDictionaryAccessDetails_Type>(
        data_value, output);
  }
  SharedDictionaryAccessDetails_Type type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::SharedDictionaryAccessDetails_Type>(data_->type));
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetIsolationKeyDataView(
      ::network::mojom::SharedDictionaryIsolationKeyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIsolationKey(UserType* output) {
    
    auto* pointer = data_->isolation_key.Get();
    return mojo::internal::Deserialize<::network::mojom::SharedDictionaryIsolationKeyDataView>(
        pointer, output, message_);
  }
  bool is_blocked() const {
    return data_->is_blocked;
  }
 private:
  internal::SharedDictionaryAccessDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SHARED_DICTIONARY_ACCESS_OBSERVER_MOJOM_DATA_VIEW_H_