// services/network/public/mojom/service_worker_router_info.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SERVICE_WORKER_ROUTER_INFO_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SERVICE_WORKER_ROUTER_INFO_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/service_worker_router_info.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/service_worker_router_info.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/service_worker_router_info.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include <string>
#include <vector>








namespace network::mojom {








class  ServiceWorkerRouterInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceWorkerRouterInfo, T>::value>;
  using DataView = ServiceWorkerRouterInfoDataView;
  using Data_ = internal::ServiceWorkerRouterInfo_Data;

  template <typename... Args>
  static ServiceWorkerRouterInfoPtr New(Args&&... args) {
    return ServiceWorkerRouterInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceWorkerRouterInfoPtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerRouterInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerRouterInfo>::Convert(*this);
  }


  ServiceWorkerRouterInfo();

  ServiceWorkerRouterInfo(
      std::optional<uint32_t> rule_id_matched,
      std::optional<ServiceWorkerRouterSourceType> matched_source_type,
      std::optional<ServiceWorkerRouterSourceType> actual_source_type,
      uint64_t route_rule_num,
      ::base::TimeDelta router_evaluation_time,
      ::base::TimeDelta cache_lookup_time,
      std::optional<ServiceWorkerStatus> evaluation_worker_status);


  ~ServiceWorkerRouterInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceWorkerRouterInfoPtr>
  ServiceWorkerRouterInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceWorkerRouterInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ServiceWorkerRouterInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ServiceWorkerRouterInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerRouterInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerRouterInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerRouterInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceWorkerRouterInfo_UnserializedMessageContext<
            UserType, ServiceWorkerRouterInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ServiceWorkerRouterInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ServiceWorkerRouterInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceWorkerRouterInfo_UnserializedMessageContext<
            UserType, ServiceWorkerRouterInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceWorkerRouterInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<uint32_t> rule_id_matched;
  
  std::optional<ServiceWorkerRouterSourceType> matched_source_type;
  
  std::optional<ServiceWorkerRouterSourceType> actual_source_type;
  
  uint64_t route_rule_num;
  
  ::base::TimeDelta router_evaluation_time;
  
  ::base::TimeDelta cache_lookup_time;
  
  std::optional<ServiceWorkerStatus> evaluation_worker_status;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceWorkerRouterInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceWorkerRouterInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceWorkerRouterInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceWorkerRouterInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ServiceWorkerRouterInfoPtr ServiceWorkerRouterInfo::Clone() const {
  return New(
      mojo::Clone(rule_id_matched),
      mojo::Clone(matched_source_type),
      mojo::Clone(actual_source_type),
      mojo::Clone(route_rule_num),
      mojo::Clone(router_evaluation_time),
      mojo::Clone(cache_lookup_time),
      mojo::Clone(evaluation_worker_status)
  );
}

template <typename T, ServiceWorkerRouterInfo::EnableIfSame<T>*>
bool ServiceWorkerRouterInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->rule_id_matched, other_struct.rule_id_matched))
    return false;
  if (!mojo::Equals(this->matched_source_type, other_struct.matched_source_type))
    return false;
  if (!mojo::Equals(this->actual_source_type, other_struct.actual_source_type))
    return false;
  if (!mojo::Equals(this->route_rule_num, other_struct.route_rule_num))
    return false;
  if (!mojo::Equals(this->router_evaluation_time, other_struct.router_evaluation_time))
    return false;
  if (!mojo::Equals(this->cache_lookup_time, other_struct.cache_lookup_time))
    return false;
  if (!mojo::Equals(this->evaluation_worker_status, other_struct.evaluation_worker_status))
    return false;
  return true;
}

template <typename T, ServiceWorkerRouterInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.rule_id_matched < rhs.rule_id_matched)
    return true;
  if (rhs.rule_id_matched < lhs.rule_id_matched)
    return false;
  if (lhs.matched_source_type < rhs.matched_source_type)
    return true;
  if (rhs.matched_source_type < lhs.matched_source_type)
    return false;
  if (lhs.actual_source_type < rhs.actual_source_type)
    return true;
  if (rhs.actual_source_type < lhs.actual_source_type)
    return false;
  if (lhs.route_rule_num < rhs.route_rule_num)
    return true;
  if (rhs.route_rule_num < lhs.route_rule_num)
    return false;
  if (lhs.router_evaluation_time < rhs.router_evaluation_time)
    return true;
  if (rhs.router_evaluation_time < lhs.router_evaluation_time)
    return false;
  if (lhs.cache_lookup_time < rhs.cache_lookup_time)
    return true;
  if (rhs.cache_lookup_time < lhs.cache_lookup_time)
    return false;
  if (lhs.evaluation_worker_status < rhs.evaluation_worker_status)
    return true;
  if (rhs.evaluation_worker_status < lhs.evaluation_worker_status)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::ServiceWorkerRouterInfo::DataView,
                                         ::network::mojom::ServiceWorkerRouterInfoPtr> {
  static bool IsNull(const ::network::mojom::ServiceWorkerRouterInfoPtr& input) { return !input; }
  static void SetToNull(::network::mojom::ServiceWorkerRouterInfoPtr* output) { output->reset(); }

  static decltype(::network::mojom::ServiceWorkerRouterInfo::rule_id_matched) rule_id_matched(
      const ::network::mojom::ServiceWorkerRouterInfoPtr& input) {
    return input->rule_id_matched;
  }

  static decltype(::network::mojom::ServiceWorkerRouterInfo::matched_source_type) matched_source_type(
      const ::network::mojom::ServiceWorkerRouterInfoPtr& input) {
    return input->matched_source_type;
  }

  static decltype(::network::mojom::ServiceWorkerRouterInfo::actual_source_type) actual_source_type(
      const ::network::mojom::ServiceWorkerRouterInfoPtr& input) {
    return input->actual_source_type;
  }

  static decltype(::network::mojom::ServiceWorkerRouterInfo::route_rule_num) route_rule_num(
      const ::network::mojom::ServiceWorkerRouterInfoPtr& input) {
    return input->route_rule_num;
  }

  static const decltype(::network::mojom::ServiceWorkerRouterInfo::router_evaluation_time)& router_evaluation_time(
      const ::network::mojom::ServiceWorkerRouterInfoPtr& input) {
    return input->router_evaluation_time;
  }

  static const decltype(::network::mojom::ServiceWorkerRouterInfo::cache_lookup_time)& cache_lookup_time(
      const ::network::mojom::ServiceWorkerRouterInfoPtr& input) {
    return input->cache_lookup_time;
  }

  static decltype(::network::mojom::ServiceWorkerRouterInfo::evaluation_worker_status) evaluation_worker_status(
      const ::network::mojom::ServiceWorkerRouterInfoPtr& input) {
    return input->evaluation_worker_status;
  }

  static bool Read(::network::mojom::ServiceWorkerRouterInfo::DataView input, ::network::mojom::ServiceWorkerRouterInfoPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SERVICE_WORKER_ROUTER_INFO_MOJOM_H_